DF-ISE text

Info {
  version   = 1.0
  type      = xyplot
  datasets  = [
    "time"
    "Source OuterVoltage" "Source InnerVoltage" "Source QuasiFermiPotential" "Source DisplacementCurrent" "Source eCurrent"
    "Source hCurrent" "Source TotalCurrent" "Source Charge" "Gate OuterVoltage" "Gate InnerVoltage"
    "Gate QuasiFermiPotential" "Gate DisplacementCurrent" "Gate eCurrent" "Gate hCurrent" "Gate TotalCurrent"
    "Gate Charge" "Drain OuterVoltage" "Drain InnerVoltage" "Drain QuasiFermiPotential" "Drain DisplacementCurrent"
    "Drain eCurrent" "Drain hCurrent" "Drain TotalCurrent" "Drain Charge" ]
  functions = [
    Time
    OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent eCurrent
    hCurrent TotalCurrent Charge OuterVoltage InnerVoltage
    QuasiFermiPotential DisplacementCurrent eCurrent hCurrent TotalCurrent
    Charge OuterVoltage InnerVoltage QuasiFermiPotential DisplacementCurrent
    eCurrent hCurrent TotalCurrent Charge ]
}

Data {
      5.00000000000000E-13
      0.00000000000000E+00  -1.34963085984344E-11   0.00000000000000E+00   1.31938183509668E-10   1.64411234925084E-22
      1.33643758479054E-08   1.34963140314152E-08  -7.90356667088165E-19  -2.50371042858463E-01  -2.50371042857039E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42386139855529E-09   0.00000000000000E+00  -1.42386139855529E-09
      3.70001668496812E-18  -2.50371042858463E-01  -2.46567585215325E-01   0.00000000000000E+00  -4.28244497644794E-12
     -9.83405481596995E-23  -1.20681701878840E-08  -1.20724526328605E-08  -2.90966001787995E-18
      1.17500000000000E-12
      0.00000000000000E+00  -1.34927266536833E-11   0.00000000000000E+00   8.88167128367014E-12   1.65785630605387E-22
      1.34838990896212E-08   1.34927807609051E-08  -7.89530143318336E-19  -2.50727023102218E-01  -2.50727023100879E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.33966529009530E-09   0.00000000000000E+00  -1.33966529009530E-09
      3.69911241089731E-18  -2.50727023102220E-01  -2.46898160230400E-01   0.00000000000000E+00  -5.90624900599514E-12
     -9.83451993306338E-23  -1.21472092218061E-08  -1.21531154708122E-08  -2.90958226757897E-18
      2.08625000000000E-12
      0.00000000000000E+00  -1.34885936405090E-11   0.00000000000000E+00   2.89542680600490E-13   1.68053894679808E-22
      1.34883042186259E-08   1.34885937613067E-08  -7.88547512361129E-19  -2.51140737930656E-01  -2.51140737929447E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20884850237488E-09   0.00000000000000E+00  -1.20884850237488E-09
      3.69801084769952E-18  -2.51140737930657E-01  -2.47271964092225E-01   0.00000000000000E+00  -6.68041321651496E-12
     -9.83514500034814E-23  -1.22730648457136E-08  -1.22797452589302E-08  -2.90946333533839E-18
      2.24002343750000E-12
      0.00000000000000E+00  -1.34879507273485E-11   0.00000000000000E+00  -6.06630515567238E-14   1.68445245519100E-22
      1.34879716867868E-08   1.34879110237354E-08  -7.88385412305812E-19  -2.51208897626913E-01  -2.51208897625727E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18639459359569E-09   0.00000000000000E+00  -1.18639459359569E-09
      3.69782841172463E-18  -2.51208897626914E-01  -2.47333264338896E-01   0.00000000000000E+00  -6.78363042603044E-12
     -9.83524989823920E-23  -1.22947327997088E-08  -1.23015164301349E-08  -2.90944299941882E-18
      2.34382050781250E-12
      0.00000000000000E+00  -1.34874915036625E-11   0.00000000000000E+00  -1.35309078046362E-13   1.68712344248260E-22
      1.34875934050378E-08   1.34874580959599E-08  -7.88277660858142E-19  -2.51254190404008E-01  -2.51254190402836E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17110270113435E-09   0.00000000000000E+00  -1.17110270113435E-09
      3.69770685469522E-18  -2.51254190404008E-01  -2.47373882048186E-01   0.00000000000000E+00  -6.83801240858913E-12
     -9.83532030308930E-23  -1.23095173824253E-08  -1.23163553948340E-08  -2.90942919383707E-18
      2.48394655273438E-12
      0.00000000000000E+00  -1.34868485905021E-11   0.00000000000000E+00  -1.59238897197666E-13   1.69076028044681E-22
      1.34870184417735E-08   1.34868592028765E-08  -7.88135167692094E-19  -2.51314079711671E-01  -2.51314079710520E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15030364376536E-09   0.00000000000000E+00  -1.15030364376536E-09
      3.69754566719516E-18  -2.51314079711671E-01  -2.47427407227715E-01   0.00000000000000E+00  -6.88278514223006E-12
     -9.83541408683442E-23  -1.23296727739748E-08  -1.23365555591172E-08  -2.90941049950306E-18
      2.67311671337891E-12
      0.00000000000000E+00  -1.34860219878672E-11   0.00000000000000E+00  -1.62344955044789E-13   1.69568035689013E-22
      1.34862352680825E-08   1.34860729231276E-08  -7.87948069701084E-19  -2.51392713007247E-01  -2.51392713006125E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12214698948111E-09   0.00000000000000E+00  -1.12214698948111E-09
      3.69733339046889E-18  -2.51392713007245E-01  -2.47497417427964E-01   0.00000000000000E+00  -6.89484549683750E-12
     -9.83553873517908E-23  -1.23570310881421E-08  -1.23639259336390E-08  -2.90938532076781E-18
      2.92849643024902E-12
      0.00000000000000E+00  -1.34850116957579E-11   0.00000000000000E+00  -1.57962484585624E-13   1.70225981028946E-22
      1.34852084109119E-08   1.34850504484275E-08  -7.87704747234828E-19  -2.51494971481778E-01  -2.51494971480693E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08438999352307E-09   0.00000000000000E+00  -1.08438999352307E-09
      3.69705645925936E-18  -2.51494971481781E-01  -2.47588102642138E-01   0.00000000000000E+00  -6.84274113428862E-12
     -9.83570195156974E-23  -1.23938177137709E-08  -1.24006604549053E-08  -2.90935171202454E-18
      3.27325904802368E-12
      0.00000000000000E+00  -1.34837258694370E-11   0.00000000000000E+00  -1.50204804811448E-13   1.71090763735371E-22
      1.34838882139848E-08   1.34837380091802E-08  -7.87392345403326E-19  -2.51626248116219E-01  -2.51626248115185E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03452921937981E-09   0.00000000000000E+00  -1.03452921937981E-09
      3.69669979225753E-18  -2.51626248116227E-01  -2.47704084135618E-01   0.00000000000000E+00  -6.68932715535862E-12
     -9.83591270748637E-23  -1.24425194626421E-08  -1.24492087897975E-08  -2.90930744685420E-18
      3.73868858201947E-12
      0.00000000000000E+00  -1.34820726641673E-11   0.00000000000000E+00  -1.39507826975492E-13   1.72201601825597E-22
      1.34822220117389E-08   1.34820825039121E-08  -7.86998084914798E-19  -2.51791892979962E-01  -2.51791892978992E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70090135506645E-10   0.00000000000000E+00  -9.70090135506645E-10
      3.69624828365782E-18  -2.51791892979947E-01  -2.47849949232119E-01   0.00000000000000E+00  -6.40206250506173E-12
     -9.83618014438460E-23  -1.25055903059038E-08  -1.25119923684090E-08  -2.90925019874303E-18
      4.36701845291379E-12
      0.00000000000000E+00  -1.34800520799487E-11   0.00000000000000E+00  -1.28633748169012E-13   1.73588219313221E-22
      1.34801672377353E-08   1.34800386039873E-08  -7.86511767429381E-19  -2.51996156322878E-01  -2.51996156321989E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.89102657097125E-10   0.00000000000000E+00  -8.89102657097125E-10
      3.69568963390008E-18  -2.51996156322868E-01  -2.48029340899467E-01   0.00000000000000E+00  -5.95824355335191E-12
     -9.83651217191381E-23  -1.25849777033374E-08  -1.25909359468909E-08  -2.90917786647070E-18
      4.79114111576745E-12
      0.00000000000000E+00  -1.34787662536278E-11   0.00000000000000E+00  -1.21089594870692E-13   1.74472549510622E-22
      1.34788646407469E-08   1.34787435511522E-08  -7.86203247139799E-19  -2.52125706583945E-01  -2.52125706583107E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.37238486838972E-10   0.00000000000000E+00  -8.37238486838972E-10
      3.69533454208360E-18  -2.52125706434050E-01  -2.48142959065242E-01   0.00000000000000E+00  -5.65287016926102E-12
     -9.83671846059048E-23  -1.26358521941435E-08  -1.26415050643129E-08  -2.90913129494380E-18
      4.93428251448056E-12
      0.00000000000000E+00  -1.34783070299418E-11   0.00000000000000E+00  -1.18420062075169E-13   1.74765144486973E-22
      1.34784343963076E-08   1.34783159762457E-08  -7.86101327963358E-19  -2.52168497865794E-01  -2.52168497864974E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.20053774486344E-10   0.00000000000000E+00  -8.20053774486344E-10
      3.69521715843930E-18  -2.52168497661404E-01  -2.48180470967313E-01   0.00000000000000E+00  -5.54994179474635E-12
     -9.83682122845414E-23  -1.26527122599669E-08  -1.26582622017617E-08  -2.90911583047594E-18
      5.12752340274326E-12
      0.00000000000000E+00  -1.34777559615185E-11   0.00000000000000E+00  -1.15891396114929E-13   1.75149643010488E-22
      1.34778699171532E-08   1.34777540257572E-08  -7.85967645872922E-19  -2.52224618647510E-01  -2.52224618646713E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.97433705024894E-10   0.00000000000000E+00  -7.97433705024894E-10
      3.69506306164181E-18  -2.52224618400290E-01  -2.48229642026073E-01   0.00000000000000E+00  -5.41078793501064E-12
     -9.83676420696648E-23  -1.26749095328012E-08  -1.26803203207363E-08  -2.90909541576889E-18
      5.38839860189791E-12
      0.00000000000000E+00  -1.34770212036209E-11   0.00000000000000E+00  -1.10761226015065E-13   1.75649894891785E-22
      1.34771363852711E-08   1.34770256240453E-08  -7.85794034781816E-19  -2.52297492545294E-01  -2.52297492544526E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.67940128717668E-10   0.00000000000000E+00  -7.67940128717668E-10
      3.69486272510779E-18  -2.52297492292678E-01  -2.48293453689962E-01   0.00000000000000E+00  -5.22718318849229E-12
     -9.83704409676820E-23  -1.27038583121369E-08  -1.27090854953255E-08  -2.90906869032597E-18
      5.74058012075668E-12
      0.00000000000000E+00  -1.34761027562488E-11   0.00000000000000E+00  -1.04936045359012E-13   1.76292021287215E-22
      1.34761967165580E-08   1.34760917805128E-08  -7.85571545763067E-19  -2.52390867766853E-01  -2.52390867766123E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.29981365019430E-10   0.00000000000000E+00  -7.29981365019430E-10
      3.69460563916192E-18  -2.52390867519211E-01  -2.48375164231398E-01   0.00000000000000E+00  -4.98452615366142E-12
     -9.83718475487937E-23  -1.27411258893414E-08  -1.27461104154952E-08  -2.90903409339885E-18
      6.21602517121602E-12
      0.00000000000000E+00  -1.34749087746651E-11   0.00000000000000E+00  -9.73159463352672E-14   1.77101364912789E-22
      1.34750141603038E-08   1.34749168443577E-08  -7.85291427367182E-19  -2.52508403503518E-01  -2.52508403502836E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.81977235357070E-10   0.00000000000000E+00  -6.81977235357070E-10
      3.69428139646084E-18  -2.52508403257023E-01  -2.48477946543432E-01   0.00000000000000E+00  -4.67146093959770E-12
     -9.83736317362483E-23  -1.27882681480658E-08  -1.27929396090055E-08  -2.90898996909366E-18
      6.85787598933613E-12
      0.00000000000000E+00  -1.34734392588698E-11   0.00000000000000E+00  -8.92693210843198E-14   1.78097105986408E-22
      1.34735604370819E-08   1.34734711677610E-08  -7.84946952887376E-19  -2.52652900960421E-01  -2.52652900959798E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.22673686835703E-10   0.00000000000000E+00  -6.22673686835703E-10
      3.69388173284553E-18  -2.52652900707427E-01  -2.48604215591332E-01   0.00000000000000E+00  -4.27662509958493E-12
     -9.83759902206935E-23  -1.28465208558261E-08  -1.28507974809258E-08  -2.90893477995815E-18
      7.29112529156720E-12
      0.00000000000000E+00  -1.34725208114977E-11   0.00000000000000E+00  -8.35322042995783E-14   1.78727579979793E-22
      1.34726403275171E-08   1.34725567953130E-08  -7.84728863469488E-19  -2.52744361468369E-01  -2.52744361467784E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.85019054062898E-10   0.00000000000000E+00  -5.85019054062898E-10
      3.69362827374856E-18  -2.52744361200145E-01  -2.48684101087480E-01   0.00000000000000E+00  -4.02467691190738E-12
     -9.83775114401451E-23  -1.28835130643391E-08  -1.28875377412511E-08  -2.90889941027907E-18
      7.36423611131870E-12
      0.00000000000000E+00  -1.34724289667605E-11   0.00000000000000E+00  -8.29252876976205E-14   1.78832793932429E-22
      1.34724867298492E-08   1.34724038045617E-08  -7.84692468034271E-19  -2.52759623632125E-01  -2.52759623631546E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.78731705808684E-10   0.00000000000000E+00  -5.78731705808684E-10
      3.69358596219913E-18  -2.52759623367747E-01  -2.48697430530348E-01   0.00000000000000E+00  -3.98227766537238E-12
     -9.83777578276984E-23  -1.28896898210877E-08  -1.28936720987531E-08  -2.90889349416486E-18
      7.46293571798321E-12
      0.00000000000000E+00  -1.34722452772861E-11   0.00000000000000E+00  -8.16955426939382E-14   1.78972725158755E-22
      1.34722824658103E-08   1.34722007702678E-08  -7.84644065048644E-19  -2.52779919760423E-01  -2.52779919759853E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.70364225025080E-10   0.00000000000000E+00  -5.70364225025080E-10
      3.69352966747447E-18  -2.52779919503487E-01  -2.48715154448851E-01   0.00000000000000E+00  -3.92618492426977E-12
     -9.83780995886629E-23  -1.28979103603184E-08  -1.29018365452428E-08  -2.90888560242583E-18
      7.59618018698031E-12
      0.00000000000000E+00  -1.34719697430744E-11   0.00000000000000E+00  -8.00515485844326E-14   1.79157870858851E-22
      1.34720122816399E-08   1.34719322300915E-08  -7.84580026545059E-19  -2.52806770285474E-01  -2.52806770284915E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.59283662279874E-10   0.00000000000000E+00  -5.59283662279874E-10
      3.69345514601987E-18  -2.52806770036212E-01  -2.48738598642305E-01   0.00000000000000E+00  -3.85182194671202E-12
     -9.83785553803794E-23  -1.29087967458584E-08  -1.29126485678052E-08  -2.90887511947481E-18
      7.77606022012639E-12
      0.00000000000000E+00  -1.34716023641256E-11   0.00000000000000E+00  -7.78750285442570E-14   1.79401133396785E-22
      1.34716574214981E-08   1.34715795464697E-08  -7.84495890960254E-19  -2.52842044418267E-01  -2.52842044417723E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.44708595548285E-10   0.00000000000000E+00  -5.44708595548285E-10
      3.69335716381965E-18  -2.52842044170921E-01  -2.48769392004445E-01   0.00000000000000E+00  -3.75378946923607E-12
     -9.83791593020289E-23  -1.29231171614522E-08  -1.29268709509215E-08  -2.90886127285939E-18
      8.01889826487360E-12
      0.00000000000000E+00  -1.34711431404396E-11   0.00000000000000E+00  -7.50606765840112E-14   1.79717741632044E-22
      1.34711956083007E-08   1.34711205476243E-08  -7.84386380541902E-19  -2.52887952266514E-01  -2.52887952265989E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.25710142485402E-10   0.00000000000000E+00  -5.25710142485402E-10
      3.69322950139654E-18  -2.52887952015843E-01  -2.48809458982319E-01   0.00000000000000E+00  -3.62549964180405E-12
     -9.83799426478633E-23  -1.29417849055089E-08  -1.29454104051508E-08  -2.90884312085464E-18
      8.34672962528234E-12
      0.00000000000000E+00  -1.34705002272791E-11   0.00000000000000E+00  -7.14132254097769E-14   1.80124568856269E-22
      1.34706020427396E-08   1.34705306295144E-08  -7.84245614293577E-19  -2.52946954726796E-01  -2.52946954726295E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.01247470473700E-10   0.00000000000000E+00  -5.01247470473700E-10
      3.69306517675640E-18  -2.52946954468968E-01  -2.48860940320592E-01   0.00000000000000E+00  -3.45942458980868E-12
     -9.83809500013704E-23  -1.29658237344472E-08  -1.29692831590372E-08  -2.90881956246282E-18
      8.78930196183413E-12
      0.00000000000000E+00  -1.34698573141187E-11   0.00000000000000E+00  -6.66929971612451E-14   1.80638420199302E-22
      1.34698517791345E-08   1.34697850861375E-08  -7.84067662279279E-19  -2.53021529951807E-01  -2.53021529951337E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.70263033776121E-10   0.00000000000000E+00  -4.70263033776121E-10
      3.69285705134674E-18  -2.53021529683708E-01  -2.48925988800052E-01   0.00000000000000E+00  -3.24782922101361E-12
     -9.83822290979981E-23  -1.29962742231449E-08  -1.29995220523660E-08  -2.90878938906746E-18
      9.38677461617904E-12
      0.00000000000000E+00  -1.34688470220094E-11   0.00000000000000E+00  -6.05714721261696E-14   1.81272763041224E-22
      1.34689242511818E-08   1.34688636797098E-08  -7.83847619175743E-19  -2.53113721918672E-01  -2.53113721918240E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.31869712908466E-10   0.00000000000000E+00  -4.31869712908466E-10
      3.69259902100304E-18  -2.53113721636957E-01  -2.49006375348516E-01   0.00000000000000E+00  -2.98421661567591E-12
     -9.83838212899582E-23  -1.30340097501843E-08  -1.30369939668000E-08  -2.90875140182730E-18
      1.01933626995447E-11
      0.00000000000000E+00  -1.34677448851629E-11   0.00000000000000E+00  -5.45047775805783E-14   1.82032474207203E-22
      1.34678105972918E-08   1.34677560925144E-08  -7.83583339888902E-19  -2.53224411498280E-01  -2.53224411497894E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.85657259093377E-10   0.00000000000000E+00  -3.85657259093377E-10
      3.69228795445359E-18  -2.53224411198643E-01  -2.49102854360528E-01   0.00000000000000E+00  -2.66364728432739E-12
     -9.83857513377068E-23  -1.30794351861389E-08  -1.30820988334233E-08  -2.90870461456469E-18
      1.07378096558165E-11
      0.00000000000000E+00  -1.34671019720024E-11   0.00000000000000E+00  -5.17566610789055E-14   1.82504722985810E-22
      1.34671216134182E-08   1.34670698567573E-08  -7.83418747793913E-19  -2.53293330964076E-01  -2.53293330963719E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.56840734371820E-10   0.00000000000000E+00  -3.56840734371820E-10
      3.69209367360189E-18  -2.53293329812076E-01  -2.49162909918311E-01   0.00000000000000E+00  -2.46173071325083E-12
     -9.83878814605809E-23  -1.31077673916722E-08  -1.31102291223855E-08  -2.90867492580798E-18
      1.09215605035582E-11
      0.00000000000000E+00  -1.34668264377908E-11   0.00000000000000E+00  -4.53096925968027E-14   1.82659620026919E-22
      1.34669069209973E-08   1.34668616113048E-08  -7.83364724642194E-19  -2.53315950218639E-01  -2.53315950218292E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.47395367676175E-10   0.00000000000000E+00  -3.47395367676175E-10
      3.69202983940858E-18  -2.53315947158343E-01  -2.49182617728295E-01   0.00000000000000E+00  -2.39731403935162E-12
     -9.83884722194174E-23  -1.31170689295761E-08  -1.31194662436156E-08  -2.90866511476638E-18
      1.11696241480096E-11
      0.00000000000000E+00  -1.34665509035792E-11   0.00000000000000E+00  -4.69501472420347E-14   1.82860794726554E-22
      1.34666122865207E-08   1.34665653363736E-08  -7.83294479273334E-19  -2.53345357372791E-01  -2.53345357372456E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.35078722313497E-10   0.00000000000000E+00  -3.35078722313497E-10
      3.69194671855954E-18  -2.53345352907119E-01  -2.49208236372378E-01   0.00000000000000E+00  -2.31201609394893E-12
     -9.83885612591011E-23  -1.31291745979638E-08  -1.31314866140578E-08  -2.90865223928621E-18
      1.15045100680189E-11
      0.00000000000000E+00  -1.34661835246304E-11   0.00000000000000E+00  -4.55700454589940E-14   1.83118588283114E-22
      1.34662279716353E-08   1.34661824015900E-08  -7.83204303899045E-19  -2.53383102190127E-01  -2.53383102189808E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.19249849038600E-10   0.00000000000000E+00  -3.19249849038600E-10
      3.69183980628014E-18  -2.53383096806835E-01  -2.49241114010553E-01   0.00000000000000E+00  -2.20221393211832E-12
     -9.83887596971004E-23  -1.31447303386203E-08  -1.31469325525525E-08  -2.90863550238109E-18
      1.19566060600314E-11
      0.00000000000000E+00  -1.34656324562071E-11   0.00000000000000E+00  -4.24895229795478E-14   1.83443111475920E-22
      1.34657429023782E-08   1.34657004128554E-08  -7.83090499800821E-19  -2.53430728313995E-01  -2.53430728313695E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.99257239112056E-10   0.00000000000000E+00  -2.99257239112056E-10
      3.69170451328175E-18  -2.53430722470445E-01  -2.49282592876175E-01   0.00000000000000E+00  -2.06282444617530E-12
     -9.83894408175137E-23  -1.31643803492975E-08  -1.31664431737438E-08  -2.90861401348093E-18
      1.25669356492484E-11
      0.00000000000000E+00  -1.34651732325211E-11   0.00000000000000E+00  -3.83345319533343E-14   1.83842089365428E-22
      1.34651480312420E-08   1.34651096967102E-08  -7.82950075939352E-19  -2.53489479760256E-01  -2.53489479759981E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.74575531105575E-10   0.00000000000000E+00  -2.74575531105575E-10
      3.69153693171064E-18  -2.53489473621049E-01  -2.49333754205089E-01   0.00000000000000E+00  -1.88982210975616E-12
     -9.83904660085332E-23  -1.31886443434963E-08  -1.31905341656062E-08  -2.90858685577129E-18
      1.33908805946913E-11
      0.00000000000000E+00  -1.34644384746234E-11   0.00000000000000E+00  -3.32887081167324E-14   1.84317414370993E-22
      1.34644382701894E-08   1.34644049814815E-08  -7.82781860863094E-19  -2.53559834156589E-01  -2.53559834156344E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.45001008319347E-10   0.00000000000000E+00  -2.45001008319347E-10
      3.69133506436821E-18  -2.53559827791153E-01  -2.49395013087074E-01   0.00000000000000E+00  -1.68189802759949E-12
     -9.83917428909254E-23  -1.32177220751339E-08  -1.32194039731616E-08  -2.90855320350512E-18
      1.45032062710393E-11
      0.00000000000000E+00  -1.34636118719886E-11   0.00000000000000E+00  -2.90212127955580E-14   1.84860701232222E-22
      1.34636220442016E-08   1.34635930229890E-08  -7.82587971184242E-19  -2.53640887341183E-01  -2.53640887340972E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.10922493829251E-10   0.00000000000000E+00  -2.10922493829251E-10
      3.69110044986261E-18  -2.53640880726518E-01  -2.49465585117867E-01   0.00000000000000E+00  -1.43995891531337E-12
     -9.83932455534699E-23  -1.32512305702452E-08  -1.32526705291607E-08  -2.90851247867836E-18
      1.60048459341090E-11
      0.00000000000000E+00  -1.34626934246165E-11   0.00000000000000E+00   6.90305287240228E-15   1.85444585430950E-22
      1.34626861566416E-08   1.34626930596947E-08  -7.82375245281716E-19  -2.53729750326278E-01  -2.53729750326105E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.73588453712868E-10   0.00000000000000E+00  -1.73588453712868E-10
      3.69083978255546E-18  -2.53729751261064E-01  -2.49542987057993E-01   0.00000000000000E+00  -1.20569129150912E-12
     -9.21147881065574E-23  -1.32878989146895E-08  -1.32891046059811E-08  -2.90846453727374E-18
      1.62582476272520E-11
      0.00000000000000E+00  -1.34625097351421E-11   0.00000000000000E+00  -2.14490122743435E-14   1.85538688761608E-22
      1.34625477823943E-08   1.34625263333822E-08  -7.82340702642378E-19  -2.53744178440325E-01  -2.53744178440158E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.67531393775838E-10   0.00000000000000E+00  -1.67531393775838E-10
      3.69079732981662E-18  -2.53744182323033E-01  -2.49555552338377E-01   0.00000000000000E+00  -1.13265986494880E-12
     -9.81242264568936E-23  -1.32938622797411E-08  -1.32949949396062E-08  -2.90845662717424E-18
      1.66003399129950E-11
      0.00000000000000E+00  -1.34623260456676E-11   0.00000000000000E+00  -1.96168196931854E-14   1.85655810529350E-22
      1.34623755712643E-08   1.34623559544447E-08  -7.82296397314063E-19  -2.53762681322052E-01  -2.53762681321893E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59762400496700E-10   0.00000000000000E+00  -1.59762400496700E-10
      3.69074267633186E-18  -2.53762687039747E-01  -2.49571663107931E-01   0.00000000000000E+00  -1.07819061183442E-12
     -9.88578895357091E-23  -1.33015153633367E-08  -1.33025935539486E-08  -2.90844627901779E-18
      1.70621644987482E-11
      0.00000000000000E+00  -1.34621423561932E-11   0.00000000000000E+00  -1.89234849910014E-14   1.85803465473376E-22
      1.34621527224247E-08   1.34621337989399E-08  -7.82240537541260E-19  -2.53786003190464E-01  -2.53786003190314E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.49971986739548E-10   0.00000000000000E+00  -1.49971986739548E-10
      3.69067341558121E-18  -2.53786009595752E-01  -2.49591971182224E-01   0.00000000000000E+00  -1.00797745795011E-12
     -9.85295520558237E-23  -1.33111538347428E-08  -1.33121618122008E-08  -2.90843287803995E-18
      1.76856276895149E-11
      0.00000000000000E+00  -1.34618668219816E-11   0.00000000000000E+00  -1.78706273469830E-14   1.85986823952000E-22
      1.34618700503102E-08   1.34618521796831E-08  -7.82171692434498E-19  -2.53814735813504E-01  -2.53814735813366E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37921442026237E-10   0.00000000000000E+00  -1.37921442026237E-10
      3.69058742663889E-18  -2.53814742187345E-01  -2.49616995980548E-01   0.00000000000000E+00  -9.21444021488430E-13
     -9.84208949550935E-23  -1.33230092936368E-08  -1.33239307376584E-08  -2.90841573420439E-18
      1.85273029970500E-11
      0.00000000000000E+00  -1.34614994430328E-11   0.00000000000000E+00  -1.62222684397324E-14   1.86207161815821E-22
      1.34615269032141E-08   1.34615106809458E-08  -7.82089327902962E-19  -2.53849093446334E-01  -2.53849093446210E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23539773650870E-10   0.00000000000000E+00  -1.23539773650870E-10
      3.69048344626191E-18  -2.53849099389078E-01  -2.49646929788597E-01   0.00000000000000E+00  -8.18190051506403E-13
     -9.84009549853320E-23  -1.33371527172440E-08  -1.33379709072956E-08  -2.90839411835894E-18
      1.96635646622224E-11
      0.00000000000000E+00  -1.34611320640840E-11   0.00000000000000E+00  -1.39414789330771E-14   1.86459116541896E-22
      1.34611299610009E-08   1.34611160195222E-08  -7.81994500446955E-19  -2.53888621887580E-01  -2.53888621887473E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07051359500513E-10   0.00000000000000E+00  -1.07051359500513E-10
      3.69036180790590E-18  -2.53888627139744E-01  -2.49681387188891E-01   0.00000000000000E+00  -6.99891605860694E-13
     -9.83985411443771E-23  -1.33533647684171E-08  -1.33540646600231E-08  -2.90836730745895E-18
      2.04305412862137E-11
      0.00000000000000E+00  -1.34608565298723E-11   0.00000000000000E+00  -1.25207981406522E-14   1.86610035689333E-22
      1.34608897101498E-08   1.34608771893518E-08  -7.81937149116069E-19  -2.53912515562175E-01  -2.53912515562078E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.71132818077150E-11   0.00000000000000E+00  -9.71132818077150E-11
      3.69028732428888E-18  -2.53912520346096E-01  -2.49702224639264E-01   0.00000000000000E+00  -6.28573603848639E-13
     -9.83986748787833E-23  -1.33631353339382E-08  -1.33637639075422E-08  -2.90835017517280E-18
      2.14659597286021E-11
      0.00000000000000E+00  -1.34605809956607E-11   0.00000000000000E+00  -1.06405988414826E-14   1.86783167520404E-22
      1.34606091667388E-08   1.34605985261402E-08  -7.81870160752281E-19  -2.53940403142240E-01  -2.53940403142154E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.55682053510995E-11   0.00000000000000E+00  -8.55682053510995E-11
      3.69019872539097E-18  -2.53940407316852E-01  -2.49726562183868E-01   0.00000000000000E+00  -5.45832166718107E-13
     -9.83992129947759E-23  -1.33744844886207E-08  -1.33750303207875E-08  -2.90832856463869E-18
      2.28637746258263E-11
      0.00000000000000E+00  -1.34603054614491E-11   0.00000000000000E+00  -8.52666528895030E-15   1.86970864364405E-22
      1.34602960299193E-08   1.34602875032542E-08  -7.81795321348255E-19  -2.53971525139868E-01  -2.53971525139796E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.27834952661244E-11   0.00000000000000E+00  -7.27834952661244E-11
      3.69009698753702E-18  -2.53971528546634E-01  -2.49753753650712E-01   0.00000000000000E+00  -4.54106357451549E-13
     -9.83999081600430E-23  -1.33870499016318E-08  -1.33875040079893E-08  -2.90830166618876E-18
      2.47508247370791E-11
      0.00000000000000E+00  -1.34599380825003E-11   0.00000000000000E+00  -6.13568280804169E-15   1.87159683527742E-22
      1.34599655165342E-08   1.34599593808516E-08  -7.81716207694126E-19  -2.54004371681607E-01  -2.54004371681547E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.94664879946645E-11   0.00000000000000E+00  -5.94664879946645E-11
      3.68998477129423E-18  -2.54004374157329E-01  -2.49782507248358E-01   0.00000000000000E+00  -3.58642802855528E-13
     -9.84006997807611E-23  -1.34001342500529E-08  -1.34004928928559E-08  -2.90826856360010E-18
      2.72983423872703E-11
      0.00000000000000E+00  -1.34595707035514E-11   0.00000000000000E+00  -3.63053215171470E-15   1.87331134347502E-22
      1.34596392478826E-08   1.34596356173506E-08  -7.81637927773276E-19  -2.54036793937734E-01  -2.54036793937688E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.66225145942781E-11   0.00000000000000E+00  -4.66225145942781E-11
      3.68986599961541E-18  -2.54036795344543E-01  -2.49810984137863E-01   0.00000000000000E+00  -2.66709034152279E-13
     -9.84015616329617E-23  -1.34127463937218E-08  -1.34130131027560E-08  -2.90822807184213E-18
      3.07374912150284E-11
      0.00000000000000E+00  -1.34592951693398E-11   0.00000000000000E+00  -3.45275832344376E-15   1.87464894208631E-22
      1.34593405073051E-08   1.34593370545470E-08  -7.81565999547500E-19  -2.54066478494329E-01  -2.54066478494294E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.53558214153787E-11   0.00000000000000E+00  -3.53558214153787E-11
      3.68974440568363E-18  -2.54066478769813E-01  -2.49837211590111E-01   0.00000000000000E+00  -1.84064516749392E-13
     -9.84024759042025E-23  -1.34237971686150E-08  -1.34239812331318E-08  -2.90817840613613E-18
      3.30589166737651E-11
      0.00000000000000E+00  -1.34592033246026E-11   0.00000000000000E+00  -2.76799535503289E-15   1.87522841711850E-22
      1.34591861062990E-08   1.34591833383038E-08  -7.81528718627514E-19  -2.54081818102225E-01  -2.54081818102195E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.97772004717246E-11   0.00000000000000E+00  -2.97772004717246E-11
      3.68967528013237E-18  -2.54081817761881E-01  -2.49850841425616E-01   0.00000000000000E+00  -1.43768237089643E-13
     -9.84030093207414E-23  -1.34292623695947E-08  -1.34294061378318E-08  -2.90814656150485E-18
      3.38423977660888E-11
      0.00000000000000E+00  -1.34591114798654E-11   0.00000000000000E+00  -4.69134614368730E-15   1.87539128952397E-22
      1.34591384616958E-08   1.34591337703499E-08  -7.81517280337158E-19  -2.54086518713717E-01  -2.54086518713689E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.80993718004508E-11   0.00000000000000E+00  -2.80993718004508E-11
      3.68965326480585E-18  -2.54086518374119E-01  -2.49855028375910E-01   0.00000000000000E+00  -1.29553766621985E-13
     -9.84032134246752E-23  -1.34309048447832E-08  -1.34310343985499E-08  -2.90813598446870E-18
      3.49000972407257E-11
      0.00000000000000E+00  -1.34591114798654E-11   0.00000000000000E+00  -2.23887659986984E-15   1.87556031527937E-22
      1.34590820036638E-08   1.34590797647874E-08  -7.81503625026908E-19  -2.54092121014365E-01  -2.54092121014339E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.61559333340271E-11   0.00000000000000E+00  -2.61559333340271E-11
      3.68962559968891E-18  -2.54092120500077E-01  -2.49860035916467E-01   0.00000000000000E+00  -1.17723239268590E-13
     -9.84034034807575E-23  -1.34328061082142E-08  -1.34329238314535E-08  -2.90812197466200E-18
      3.63279915314855E-11
      0.00000000000000E+00  -1.34590196351282E-11   0.00000000000000E+00  -1.90597240219969E-15   1.87571334796640E-22
      1.34590173814679E-08   1.34590154754957E-08  -7.81487852383121E-19  -2.54098577870179E-01  -2.54098577870155E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.40104958276015E-11   0.00000000000000E+00  -2.40104958276015E-11
      3.68959131523900E-18  -2.54098577037176E-01  -2.49865836790156E-01   0.00000000000000E+00  -1.02298773710486E-13
     -9.84036724914810E-23  -1.34349026808938E-08  -1.34350049796676E-08  -2.90810346285587E-18
      3.82556488240113E-11
      0.00000000000000E+00  -1.34589277903910E-11   0.00000000000000E+00  -1.58299648064956E-15   1.87581574010255E-22
      1.34589452839937E-08   1.34589437009974E-08  -7.81470289177371E-19  -2.54105747745772E-01  -2.54105747745750E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.17807581050199E-11   0.00000000000000E+00  -2.17807581050199E-11
      3.68954932940180E-18  -2.54105746584653E-01  -2.49872326475978E-01   0.00000000000000E+00  -8.63275994646885E-14
     -9.84040130705110E-23  -1.34370766152933E-08  -1.34371629428928E-08  -2.90807904022443E-18
      4.08579861689211E-11
      0.00000000000000E+00  -1.34588359456538E-11   0.00000000000000E+00  -1.25757907658995E-15   1.87582073023492E-22
      1.34588680701298E-08   1.34588668125509E-08  -7.81451420123091E-19  -2.54113426433137E-01  -2.54113426433118E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.96323600235649E-11   0.00000000000000E+00  -1.96323600235649E-11
      3.68949823937814E-18  -2.54113424920977E-01  -2.49879352190341E-01   0.00000000000000E+00  -7.10082553127926E-14
     -9.84044358146844E-23  -1.34391634442723E-08  -1.34392344525278E-08  -2.90804681925505E-18
      4.43711415845494E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -1.02837746826560E-15   1.87567348154455E-22
      1.34587875815242E-08   1.34587865531469E-08  -7.81431674290490E-19  -2.54121440889688E-01  -2.54121440889671E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.77422852291036E-11   0.00000000000000E+00  -1.77422852291036E-11
      3.68943590797270E-18  -2.54121438963898E-01  -2.49886796041029E-01   0.00000000000000E+00  -5.75833789833136E-14
     -9.84049611721252E-23  -1.34409866845384E-08  -1.34410442679175E-08  -2.90800423368222E-18
      4.55568315373239E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.54592701986228E-16   1.87560930834059E-22
      1.34587627007575E-08   1.34587617461650E-08  -7.81425562215006E-19  -2.54123919788156E-01  -2.54123919788138E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.72013162258142E-11   0.00000000000000E+00  -1.72013162258142E-11
      3.68941551254488E-18  -2.54123917726351E-01  -2.49889112186679E-01   0.00000000000000E+00  -5.37656869385055E-14
     -9.84051323468951E-23  -1.34415066642507E-08  -1.34415604299378E-08  -2.90798995032988E-18
      4.57569167168546E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.42101845385300E-16   1.87559806730548E-22
      1.34587585633492E-08   1.34587576212475E-08  -7.81424546058848E-19  -2.54124331861960E-01  -2.54124331861943E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.71127008010769E-11   0.00000000000000E+00  -1.71127008010769E-11
      3.68941208854707E-18  -2.54124329777515E-01  -2.49889497619401E-01   0.00000000000000E+00  -5.31418509848334E-14
     -9.84051602736754E-23  -1.34415917785963E-08  -1.34416449204474E-08  -2.90798754248822E-18
      4.60270317092211E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.25798155647757E-16   1.87558215104658E-22
      1.34587530896925E-08   1.34587521638945E-08  -7.81423200950540E-19  -2.54124877249852E-01  -2.54124877249835E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.69977495757496E-11   0.00000000000000E+00  -1.69977495757496E-11
      3.68940749720007E-18  -2.54124875134947E-01  -2.49890008480938E-01   0.00000000000000E+00  -5.23326325322139E-14
     -9.84051996279001E-23  -1.34417020816853E-08  -1.34417544143179E-08  -2.90798429624953E-18
      4.63916869489158E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -9.04689165264150E-16   1.87555940706275E-22
      1.34587458920079E-08   1.34587449873190E-08  -7.81421431154926E-19  -2.54125594708475E-01  -2.54125594708458E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.68506270750013E-11   0.00000000000000E+00  -1.68506270750013E-11
      3.68940135253062E-18  -2.54125592552441E-01  -2.49890681808821E-01   0.00000000000000E+00  -5.12989773961718E-14
     -9.84052530814959E-23  -1.34418430612624E-08  -1.34418943602399E-08  -2.90797992137569E-18
      4.68839715225036E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -8.78365107156331E-16   1.87552664758983E-22
      1.34587364980410E-08   1.34587356196760E-08  -7.81419120095551E-19  -2.54126531432740E-01  -2.54126531432723E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.66656435218074E-11   0.00000000000000E+00  -1.66656435218074E-11
      3.68939314829140E-18  -2.54126529220987E-01  -2.49891563150065E-01   0.00000000000000E+00  -5.00023040702683E-14
     -9.84053239045531E-23  -1.34420199738528E-08  -1.34420699761570E-08  -2.90797402819585E-18
      4.75485556968472E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -8.46227046101907E-16   1.87547909508599E-22
      1.34587243480328E-08   1.34587235018060E-08  -7.81416129586852E-19  -2.54127743417301E-01  -2.54127743417285E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.64384001416478E-11   0.00000000000000E+00  -1.64384001416478E-11
      3.68938222359082E-18  -2.54127741129701E-01  -2.49892707284170E-01   0.00000000000000E+00  -4.84147463430373E-14
     -9.84054176570455E-23  -1.34422366869174E-08  -1.34422851016638E-08  -2.90796609400396E-18
      4.84457443322111E-11
      0.00000000000000E+00  -1.34587441009166E-11   0.00000000000000E+00  -8.08016564169011E-16   1.87540961614888E-22
      1.34587087970949E-08   1.34587079890786E-08  -7.81412300179201E-19  -2.54129295475502E-01  -2.54129295475486E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.61675192148550E-11   0.00000000000000E+00  -1.61675192148550E-11
      3.68936771827631E-18  -2.54129293083221E-01  -2.49894178784899E-01   0.00000000000000E+00  -4.65317105019730E-14
     -9.84055421350943E-23  -1.34424939381526E-08  -1.34425404698632E-08  -2.90795541809711E-18
      4.96569489899523E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -7.64328840101397E-16   1.87530777710317E-22
      1.34586891128315E-08   1.34586883485029E-08  -7.81407451123727E-19  -2.54131261664843E-01  -2.54131261664827E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.58567628150175E-11   0.00000000000000E+00  -1.58567628150175E-11
      3.68934851249134E-18  -2.54131259123916E-01  -2.49896053110909E-01   0.00000000000000E+00  -4.43876792616414E-14
     -9.84057074151452E-23  -1.34427871980098E-08  -1.34428315856891E-08  -2.90794106136761E-18
      5.12920752779030E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -7.17210746922909E-16   1.87515876932807E-22
      1.34586644500869E-08   1.34586637328764E-08  -7.81401375741145E-19  -2.54133728107154E-01  -2.54133728107138E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.55168475139994E-11   0.00000000000000E+00  -1.55168475139994E-11
      3.68932314048606E-18  -2.54133725344451E-01  -2.49898419998075E-01   0.00000000000000E+00  -4.20695030172455E-14
     -9.84059265721066E-23  -1.34431048158589E-08  -1.34431468853620E-08  -2.90792176474491E-18
      5.18439304000863E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00   5.16254817503113E-15   1.87510810682492E-22
      1.34586580584939E-08   1.34586632210423E-08  -7.81399378180466E-19  -2.54134539567479E-01  -2.54134539567463E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.54090652227057E-11   0.00000000000000E+00  -1.54090652227057E-11
      3.68931463691449E-18  -2.54134536875352E-01  -2.49899199536566E-01   0.00000000000000E+00  -4.73214626792685E-14
     -9.84121639134721E-23  -1.34432068343545E-08  -1.34432541558173E-08  -2.90791525873402E-18
      5.19370559519547E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00   6.26924152202967E-16   1.87510294002120E-22
      1.34586592026049E-08   1.34586598295292E-08  -7.81399042215433E-19  -2.54134676300790E-01  -2.54134676300775E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53951912876009E-11   0.00000000000000E+00  -1.53951912876009E-11
      3.68931320322880E-18  -2.54134673342424E-01  -2.49899330898747E-01   0.00000000000000E+00  -4.12324482385628E-14
     -9.84170728081348E-23  -1.34432234057782E-08  -1.34432646382265E-08  -2.90791416101337E-18
      5.20627754469771E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00   1.88080566870828E-16   1.87509220117957E-22
      1.34586596240287E-08   1.34586598121095E-08  -7.81398590348099E-19  -2.54134860042254E-01  -2.54134860042239E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53739639417910E-11   0.00000000000000E+00  -1.53739639417910E-11
      3.68931127042182E-18  -2.54134856669784E-01  -2.49899507544141E-01   0.00000000000000E+00  -4.08915185528825E-14
     -9.84146078477155E-23  -1.34432449566522E-08  -1.34432858481708E-08  -2.90791268007372E-18
      5.22324967652574E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.65079611050951E-16   1.87507631799159E-22
      1.34586572577121E-08   1.34586565926327E-08  -7.81397984469993E-19  -2.54135106225815E-01  -2.54135106225799E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53427897728688E-11   0.00000000000000E+00  -1.53427897728688E-11
      3.68930866642331E-18  -2.54135102469478E-01  -2.49899744536927E-01   0.00000000000000E+00  -4.06448006437635E-14
     -9.84108215909907E-23  -1.34432731580617E-08  -1.34433138028625E-08  -2.90791068195333E-18
      5.24616205449357E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -1.07508639057433E-15   1.87505392980336E-22
      1.34586521672565E-08   1.34586510921703E-08  -7.81397174631410E-19  -2.54135435243296E-01  -2.54135435243280E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.53006497215395E-11   0.00000000000000E+00  -1.53006497215395E-11
      3.68930516068062E-18  -2.54135431234563E-01  -2.49900061758941E-01   0.00000000000000E+00  -4.04186719190955E-14
     -9.84081594766142E-23  -1.34433100237720E-08  -1.34433504424440E-08  -2.90790798604921E-18
      5.27709376475014E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -1.03619357556970E-15   1.87502287242568E-22
      1.34586455521724E-08   1.34586445159790E-08  -7.81396095571146E-19  -2.54135873816739E-01  -2.54135873816724E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.52465502560199E-11   0.00000000000000E+00  -1.52465502560199E-11
      3.68930044466187E-18  -2.54135869681977E-01  -2.49900485234471E-01   0.00000000000000E+00  -4.01337462731625E-14
     -9.84068481062298E-23  -1.34433578319783E-08  -1.34433979657247E-08  -2.90790434909072E-18
      5.31885157359651E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -8.60874622550752E-16   1.87498051563983E-22
      1.34586381235304E-08   1.34586372626559E-08  -7.81394662856892E-19  -2.54136456528431E-01  -2.54136456528416E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.51785968785612E-11   0.00000000000000E+00  -1.51785968785612E-11
      3.68929410641240E-18  -2.54136452338613E-01  -2.49901048768019E-01   0.00000000000000E+00  -3.97386457330871E-14
     -9.84063808660931E-23  -1.34434189271312E-08  -1.34434586657770E-08  -2.90789944355551E-18
      5.37522461553911E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -7.31268671443217E-16   1.87492315043386E-22
      1.34586296030463E-08   1.34586288717778E-08  -7.81392768622338E-19  -2.54137227631673E-01  -2.54137227631658E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.50943119298598E-11   0.00000000000000E+00  -1.50943119298598E-11
      3.68928559728961E-18  -2.54137223407860E-01  -2.49901795927494E-01   0.00000000000000E+00  -3.92105282257908E-14
     -9.84062968537445E-23  -1.34434953493204E-08  -1.34435345598488E-08  -2.90789282866726E-18
      5.45132822216163E-11
      0.00000000000000E+00  -1.34586522561793E-11   0.00000000000000E+00  -6.66304424262707E-16   1.87484511968101E-22
      1.34586191462541E-08   1.34586184799499E-08  -7.81390276654737E-19  -2.54138243280050E-01  -2.54138243280035E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.49915966730568E-11   0.00000000000000E+00  -1.49915966730568E-11
      3.68927418814385E-18  -2.54138239013696E-01  -2.49902782447738E-01   0.00000000000000E+00  -3.85470606561579E-14
     -9.84063587057274E-23  -1.34435883362202E-08  -1.34436268832809E-08  -2.90788391148911E-18
      5.55406809110202E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -6.34100454748066E-16   1.87473815970407E-22
      1.34586057683514E-08   1.34586051342511E-08  -7.81387016257052E-19  -2.54139574448590E-01  -2.54139574448575E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.48697135531149E-11   0.00000000000000E+00  -1.48697135531149E-11
      3.68925891101963E-18  -2.54139570110797E-01  -2.49904079351363E-01   0.00000000000000E+00  -3.77588554457805E-14
     -9.84064848180089E-23  -1.34436976618427E-08  -1.34437354206983E-08  -2.90787189476258E-18
      5.69276691417155E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -6.11772834528694E-16   1.87459078070388E-22
      1.34585884360339E-08   1.34585878242612E-08  -7.81382773630705E-19  -2.54141311212019E-01  -2.54141311212004E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.47300722814768E-11   0.00000000000000E+00  -1.47300722814768E-11
      3.68923848058274E-18  -2.54141306745792E-01  -2.49905777447582E-01   0.00000000000000E+00  -3.68697632913965E-14
     -9.84066619143573E-23  -1.34438208822151E-08  -1.34438577519785E-08  -2.90785570695203E-18
      5.88001032531541E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -5.90991275941614E-16   1.87438742384377E-22
      1.34585659627513E-08   1.34585653717602E-08  -7.81377278433704E-19  -2.54143569655844E-01  -2.54143569655829E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.45766011199533E-11   0.00000000000000E+00  -1.45766011199533E-11
      3.68921118685757E-18  -2.54143564947116E-01  -2.49907994373793E-01   0.00000000000000E+00  -3.59208307559609E-14
     -9.84069000842069E-23  -1.34439528498095E-08  -1.34439887706404E-08  -2.90783390842386E-18
      6.13278893035963E-11
      0.00000000000000E+00  -1.34585604114421E-11   0.00000000000000E+00  -5.70407830453524E-16   1.87410735661139E-22
      1.34585368473151E-08   1.34585362769075E-08  -7.81370182354806E-19  -2.54146503245520E-01  -2.54146503245505E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.44152263796865E-11   0.00000000000000E+00  -1.44152263796865E-11
      3.68917474824942E-18  -2.54146498057002E-01  -2.49910885812057E-01   0.00000000000000E+00  -3.49691352024642E-14
     -9.84072187571436E-23  -1.34440860813923E-08  -1.34441210505276E-08  -2.90780456589461E-18
      6.47404004716933E-11
      0.00000000000000E+00  -1.34584685667049E-11   0.00000000000000E+00  -5.50766615516849E-16   1.87372336149900E-22
      1.34584990827178E-08   1.34584985319514E-08  -7.81361027695009E-19  -2.54150320334876E-01  -2.54150320334862E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.42519978469764E-11   0.00000000000000E+00  -1.42519978469764E-11
      3.68912611314759E-18  -2.54150314164807E-01  -2.49914662390545E-01   0.00000000000000E+00  -3.40760229575441E-14
     -9.84076449268263E-23  -1.34442124580812E-08  -1.34442465341042E-08  -2.90776508545259E-18
      6.93472905486242E-11
      0.00000000000000E+00  -1.34584685667049E-11   0.00000000000000E+00  -5.32976225288078E-16   1.87320015550933E-22
      1.34584499225890E-08   1.34584493896130E-08  -7.81349208936899E-19  -2.54155307961185E-01  -2.54155307961171E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.40900383723051E-11   0.00000000000000E+00  -1.40900383723051E-11
      3.68906120188963E-18  -2.54155299754352E-01  -2.49919612442835E-01   0.00000000000000E+00  -3.32863114138624E-14
     -9.84082149538430E-23  -1.34443260649290E-08  -1.34443593512405E-08  -2.90771199295274E-18
      7.55665921524809E-11
      0.00000000000000E+00  -1.34583767219677E-11   0.00000000000000E+00  -5.17390359481330E-16   1.87249228387751E-22
      1.34583856125056E-08   1.34583850951155E-08  -7.81333938622537E-19  -2.54161859449296E-01  -2.54161859449282E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.39265863874260E-11   0.00000000000000E+00  -1.39265863874260E-11
      3.68897458824858E-18  -2.54161847044123E-01  -2.49926128500804E-01   0.00000000000000E+00  -3.26082075152702E-14
     -9.84089775911410E-23  -1.34444259005202E-08  -1.34444585087278E-08  -2.90764064962604E-18
      8.39626493176874E-11
      0.00000000000000E+00  -1.34582848772305E-11   0.00000000000000E+00  -5.03695147297703E-16   1.87154116864559E-22
      1.34583010973103E-08   1.34583005936153E-08  -7.81314235710312E-19  -2.54170501715210E-01  -2.54170501715196E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.37519547283539E-11   0.00000000000000E+00  -1.37519547283539E-11
      3.68885912605055E-18  -2.54170480903765E-01  -2.49934733975313E-01   0.00000000000000E+00  -3.20073890461351E-14
     -9.84099978504490E-23  -1.34445166314975E-08  -1.34445486388867E-08  -2.90754489034023E-18
      9.52973264907162E-11
      0.00000000000000E+00  -1.34581930324933E-11   0.00000000000000E+00  -4.91665518240362E-16   1.87027120809480E-22
      1.34581896050420E-08   1.34581891133767E-08  -7.81288954599539E-19  -2.54181919603665E-01  -2.54181919603652E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.35511848596626E-11   0.00000000000000E+00  -1.35511848596626E-11
      3.68870552774485E-18  -2.54181883047063E-01  -2.49946108001682E-01   0.00000000000000E+00  -3.14215650516321E-14
     -9.84113617796591E-23  -1.34446065069519E-08  -1.34446379285171E-08  -2.90741657314531E-18
      1.10599140674305E-10
      0.00000000000000E+00  -1.34580093430189E-11   0.00000000000000E+00  -4.83733739192768E-16   1.86858515372901E-22
      1.34580413561251E-08   1.34580408723916E-08  -7.81256870227774E-19  -2.54196976638074E-01  -2.54196976638060E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.33068586185394E-11   0.00000000000000E+00  -1.33068586185394E-11
      3.68850190866690E-18  -2.54196916127741E-01  -2.49961110828817E-01   0.00000000000000E+00  -3.07892812383679E-14
     -9.84131826079518E-23  -1.34447032244916E-08  -1.34447340137730E-08  -2.90724503843913E-18
      1.30599140674305E-10
      0.00000000000000E+00  -1.34578256535445E-11   0.00000000000000E+00  -4.89026619427573E-16   1.86642838775796E-22
      1.34578455027323E-08   1.34578450137058E-08  -7.81218024657580E-19  -2.54216114668392E-01  -2.54216114668379E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.30094205115100E-11   0.00000000000000E+00  -1.30094205115100E-11
      3.68824172025667E-18  -2.54216045914434E-01  -2.49980208635863E-01   0.00000000000000E+00  -3.01043843461898E-14
     -9.84155336591365E-23  -1.34448054888098E-08  -1.34448355931943E-08  -2.90702369559909E-18
      1.50599140674305E-10
      0.00000000000000E+00  -1.34576419640701E-11   0.00000000000000E+00  -5.04066550377570E-16   1.86431565253751E-22
      1.34576425182419E-08   1.34576420141755E-08  -7.81181985695461E-19  -2.54234739748435E-01  -2.54234739748422E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.27260579160199E-11   0.00000000000000E+00  -1.27260579160199E-11
      3.68798719909835E-18  -2.54234724036501E-01  -2.49998861463017E-01   0.00000000000000E+00  -2.95355751004017E-14
     -9.84178617169958E-23  -1.34448864206843E-08  -1.34449159562595E-08  -2.90680521340289E-18
      1.70599140674305E-10
      0.00000000000000E+00  -1.34574582745956E-11   0.00000000000000E+00  -5.16737752701634E-16   1.86224452170531E-22
      1.34574335123327E-08   1.34574329955952E-08  -7.81148491495048E-19  -2.54252882468943E-01  -2.54252882468931E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.24566414386446E-11   0.00000000000000E+00  -1.24566414386446E-11
      3.68773806626958E-18  -2.54253005623547E-01  -2.50017124044796E-01   0.00000000000000E+00  -2.90507576482115E-14
     -9.84201707377120E-23  -1.34449473033987E-08  -1.34449763541565E-08  -2.90658957477453E-18
      1.90599140674305E-10
      0.00000000000000E+00  -1.34571827403840E-11   0.00000000000000E+00  -4.95765610432589E-16   1.86021445745143E-22
      1.34572322317059E-08   1.34572317359404E-08  -7.81117238373819E-19  -2.54270601844850E-01  -2.54270601844838E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.22083456277842E-11   0.00000000000000E+00  -1.22083456277842E-11
      3.68749389935702E-18  -2.54270917785400E-01  -2.50035021410660E-01   0.00000000000000E+00  -2.85811773475865E-14
     -9.84224587014425E-23  -1.34449948091352E-08  -1.34450233903127E-08  -2.90637666098320E-18
      2.10599140674305E-10
      0.00000000000000E+00  -1.34570908956468E-11   0.00000000000000E+00  -4.20963359666488E-16   1.85822741482425E-22
      1.34570670778342E-08   1.34570666568710E-08  -7.81087849011044E-19  -2.54287999181723E-01  -2.54287999181711E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19937804011222E-11   0.00000000000000E+00  -1.19937804011222E-11
      3.68725402374900E-18  -2.54288432755574E-01  -2.50052520807518E-01   0.00000000000000E+00  -2.79971050627185E-14
     -9.84247134965055E-23  -1.34450448793647E-08  -1.34450728764698E-08  -2.90616617473795E-18
      2.30599140674305E-10
      0.00000000000000E+00  -1.34569990509096E-11   0.00000000000000E+00  -2.35149798394074E-16   1.85628668145655E-22
      1.34569706038594E-08   1.34569703687098E-08  -7.81059913552656E-19  -2.54305199223978E-01  -2.54305199223966E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18228746192093E-11   0.00000000000000E+00  -1.18228746192093E-11
      3.68701756625662E-18  -2.54305455523359E-01  -2.50069520093480E-01   0.00000000000000E+00  -2.72348296118694E-14
     -9.84269134848128E-23  -1.34451202592609E-08  -1.34451474940906E-08  -2.90595765270396E-18
      2.50599140674305E-10
      0.00000000000000E+00  -1.34569990509096E-11   0.00000000000000E+00  -6.49912320112580E-17   1.85439300501530E-22
      1.34569510082810E-08   1.34569509432899E-08  -7.81033145775945E-19  -2.54322278611470E-01  -2.54322278611458E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16875193724369E-11   0.00000000000000E+00  -1.16875193724369E-11
      3.68678381586917E-18  -2.54321861062587E-01  -2.50085889123456E-01   0.00000000000000E+00  -2.62324515205207E-14
     -9.84290385507356E-23  -1.34452371914658E-08  -1.34452634239174E-08  -2.90575067009322E-18
      2.70599140674305E-10
      0.00000000000000E+00  -1.34569990509096E-11   0.00000000000000E+00   9.29012465055499E-18   1.85253847853161E-22
      1.34569515851481E-08   1.34569515944384E-08  -7.81007638099360E-19  -2.54339147933847E-01  -2.54339147933835E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15450885240227E-11   0.00000000000000E+00  -1.15450885240227E-11
      3.68655291409869E-18  -2.54337608609423E-01  -2.50101591619889E-01   0.00000000000000E+00  -2.53291786208588E-14
     -9.84310937735216E-23  -1.34453811767356E-08  -1.34454065059144E-08  -2.90554527599933E-18
      2.90599140674305E-10
      0.00000000000000E+00  -1.34568153614352E-11   0.00000000000000E+00  -3.19533882482962E-16   1.85070156193909E-22
      1.34568244068254E-08   1.34568240872917E-08  -7.80984078054721E-19  -2.54355449329063E-01  -2.54355449329051E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13163032061427E-11   0.00000000000000E+00  -1.13163032061427E-11
      3.68632658803456E-18  -2.54352915815267E-01  -2.50116866933309E-01   0.00000000000000E+00  -2.50189519226334E-14
     -9.84331380001182E-23  -1.34454827651336E-08  -1.34455077840856E-08  -2.90534250997984E-18
      3.10599140674305E-10
      0.00000000000000E+00  -1.34563561377492E-11   0.00000000000000E+00  -1.11955425149400E-15   1.84884987796717E-22
      1.34563640062389E-08   1.34563628866849E-08  -7.80963649454415E-19  -2.54370596093324E-01  -2.54370596093314E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09183715299389E-11   0.00000000000000E+00  -1.09183715299389E-11
      3.68610822060396E-18  -2.54368391105438E-01  -2.50132362183614E-01   0.00000000000000E+00  -2.60792968961184E-14
     -9.84352939166045E-23  -1.34454184358580E-08  -1.34454445151549E-08  -2.90514457114955E-18
      3.30599140674305E-10
      0.00000000000000E+00  -1.34554376903771E-11   0.00000000000000E+00  -2.16418157334243E-15   1.84695796999804E-22
      1.34554446555922E-08   1.34554424914108E-08  -7.80947307051431E-19  -2.54384099149547E-01  -2.54384099149537E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03451411668432E-11   0.00000000000000E+00  -1.03451411668432E-11
      3.68590131778063E-18  -2.54384932855306E-01  -2.50149013357822E-01   0.00000000000000E+00  -2.88100220611781E-14
     -9.84377052367357E-23  -1.34450685402217E-08  -1.34450973502439E-08  -2.90495401072920E-18
      3.50599140674305E-10
      0.00000000000000E+00  -1.34543355535306E-11   0.00000000000000E+00  -2.91248091372764E-15   1.84504115396646E-22
      1.34542544890576E-08   1.34542515765768E-08  -7.80934355449428E-19  -2.54396217200504E-01  -2.54396217200494E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.77276219945993E-12   0.00000000000000E+00  -9.77276219945993E-12
      3.68570586253664E-18  -2.54403194924593E-01  -2.50167470296949E-01   0.00000000000000E+00  -3.19608617223186E-14
     -9.84404160694732E-23  -1.34444468535156E-08  -1.34444788143774E-08  -2.90477150708721E-18
      3.70599140674305E-10
      0.00000000000000E+00  -1.34535089508957E-11   0.00000000000000E+00  -1.76867300543482E-15   1.84319156457133E-22
      1.34535105791563E-08   1.34535088104835E-08  -7.80920890269986E-19  -2.54408681857121E-01  -2.54408681857111E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.61484553797324E-12   0.00000000000000E+00  -9.61484553797324E-12
      3.68551356562588E-18  -2.54422606582316E-01  -2.50187066251703E-01   0.00000000000000E+00  -3.28912071154794E-14
     -9.84431957932142E-23  -1.34438610737383E-08  -1.34438939649455E-08  -2.90459267535589E-18
      3.90599140674305E-10
      0.00000000000000E+00  -1.34543355535306E-11   0.00000000000000E+00   2.38891663346125E-15   1.84158172855417E-22
      1.34544076412314E-08   1.34544100301482E-08  -7.80899539078064E-19  -2.54424842954428E-01  -2.54424842954418E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04038275099669E-11   0.00000000000000E+00  -1.04038275099669E-11
      3.68530548907568E-18  -2.54440376673711E-01  -2.50204801040031E-01   0.00000000000000E+00  -2.72202333550638E-14
     -9.84454193261959E-23  -1.34439789824048E-08  -1.34440062026383E-08  -2.90440594999762E-18
      4.10599140674305E-10
      0.00000000000000E+00  -1.34580093430189E-11   0.00000000000000E+00   1.10935050057840E-14   1.84039002204877E-22
      1.34580053539101E-08   1.34580164474153E-08  -7.80862460788443E-19  -2.54448328958695E-01  -2.54448328958683E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23944586864032E-11   0.00000000000000E+00  -1.23944586864032E-11
      3.68505759990195E-18  -2.54451496823890E-01  -2.50215412790529E-01   0.00000000000000E+00  -1.37829804928574E-14
     -9.84461995188746E-23  -1.34456082057483E-08  -1.34456219887289E-08  -2.90419513911351E-18
      4.30599140674305E-10
      0.00000000000000E+00  -1.34639792509374E-11   0.00000000000000E+00   1.58484229592677E-14   1.83962312963952E-22
      1.34639550151704E-08   1.34639708635935E-08  -7.80808778230870E-19  -2.54479658709028E-01  -2.54479658709013E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.49361894138262E-11   0.00000000000000E+00  -1.49361894138262E-11
      3.68475887611368E-18  -2.54451033860250E-01  -2.50213874324007E-01   0.00000000000000E+00   9.40658537526077E-15
     -9.84449638417724E-23  -1.34490440807650E-08  -1.34490346741797E-08  -2.90395009788281E-18
      4.50599140674305E-10
      0.00000000000000E+00  -1.34690307114838E-11   0.00000000000000E+00   1.28698386837032E-14   1.83888371117130E-22
      1.34690208481134E-08   1.34690337179523E-08  -7.80754459062721E-19  -2.54511673609016E-01  -2.54511673609000E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.59669000540656E-11   0.00000000000000E+00  -1.59669000540656E-11
      3.68443953811259E-18  -2.54439353375890E-01  -2.50200923239063E-01   0.00000000000000E+00   2.51146338119248E-14
     -9.84424566713741E-23  -1.34530919325318E-08  -1.34530668178981E-08  -2.90368507904987E-18
      4.70599140674305E-10
      0.00000000000000E+00  -1.34666427483164E-11   0.00000000000000E+00  -5.67709303668982E-15   1.83725381502735E-22
      1.34666540685002E-08   1.34666483914073E-08  -7.80737753484397E-19  -2.54526912217870E-01  -2.54526912217858E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.22964661485100E-11   0.00000000000000E+00  -1.22964661485100E-11
      3.68419360878962E-18  -2.54428679096601E-01  -2.50189844006484E-01   0.00000000000000E+00   8.34539237032144E-15
     -9.84416927566071E-23  -1.34543602706511E-08  -1.34543519252588E-08  -2.90345585530523E-18
      4.90599140674305E-10
      0.00000000000000E+00  -1.34493759377214E-11   0.00000000000000E+00  -3.99326066210294E-14   1.83356488752868E-22
      1.34494464481905E-08   1.34494065155841E-08  -7.80808671796371E-19  -2.54502221226945E-01  -2.54502221226944E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.43674691074620E-12   0.00000000000000E+00  -1.43674691074620E-12
      3.68416487385141E-18  -2.54445940361404E-01  -2.50209116752928E-01   0.00000000000000E+00  -6.67394321349420E-14
     -9.84478042612798E-23  -1.34479030292411E-08  -1.34479697686733E-08  -2.90335620205503E-18
      5.00599140674305E-10
      0.00000000000000E+00  -1.34366095192495E-11   0.00000000000000E+00   4.93491998022204E-14   1.83109869706004E-22
      1.34366724713472E-08   1.34367218205472E-08  -7.80870873057456E-19  -2.54477611789683E-01  -2.54477611789689E-01
      0.00000000000000E+00   0.00000000000000E+00   5.66828767596663E-12   0.00000000000000E+00   5.66828767596663E-12
      3.68422155672817E-18  -2.54465637296141E-01  -2.50230606494486E-01   0.00000000000000E+00  -2.29719194746776E-13
     -9.84519883373822E-23  -1.34421603890283E-08  -1.34423901082232E-08  -2.90335068367071E-18
      5.03974140674305E-10
      0.00000000000000E+00  -1.34313743692287E-11   0.00000000000000E+00  -7.63489820227170E-14   1.83017391236049E-22
      1.34314730651633E-08   1.34313967161814E-08  -7.80895948840232E-19  -2.54467432650439E-01  -2.54467432650448E-01
      0.00000000000000E+00   0.00000000000000E+00   8.68724479130215E-12   0.00000000000000E+00   8.68724479130215E-12
      3.68425087617934E-18  -2.54473680620490E-01  -2.50239340590581E-01   0.00000000000000E+00  -1.36638498222441E-13
     -9.84554664867951E-23  -1.34399473224743E-08  -1.34400839609726E-08  -2.90335492733911E-18
      5.08530390674305E-10
      0.00000000000000E+00  -1.34235675665661E-11   0.00000000000000E+00  -8.54092983131772E-14   1.82875894310638E-22
      1.34236204745510E-08   1.34235350652529E-08  -7.80936710972311E-19  -2.54450523037833E-01  -2.54450523037846E-01
      0.00000000000000E+00   0.00000000000000E+00   1.28431482713743E-11   0.00000000000000E+00   1.28431482713743E-11
      3.68430939277365E-18  -2.54487679612097E-01  -2.50254507094192E-01   0.00000000000000E+00  -1.66209567066019E-13
     -9.84589742911859E-23  -1.34362120039573E-08  -1.34363782135245E-08  -2.90337268180134E-18
      5.14681328174305E-10
      0.00000000000000E+00  -1.34108929928314E-11   0.00000000000000E+00  -1.01260659802552E-13   1.82653657554398E-22
      1.34110165964333E-08   1.34109153357737E-08  -7.81005349562507E-19  -2.54421411292693E-01  -2.54421411292712E-01
      0.00000000000000E+00   0.00000000000000E+00   1.91223397417557E-11   0.00000000000000E+00   1.91223397417557E-11
      3.68442701309026E-18  -2.54513546402811E-01  -2.50282371587149E-01   0.00000000000000E+00  -2.14095428713238E-13
     -9.84651318086856E-23  -1.34298235800865E-08  -1.34300376755153E-08  -2.90342166352775E-18
      5.22985093799305E-10
      0.00000000000000E+00  -1.33902279269597E-11   0.00000000000000E+00  -1.22496963253298E-13   1.82293708476434E-22
      1.33903092965159E-08   1.33901867995529E-08  -7.81124332941083E-19  -2.54369882151469E-01  -2.54369882151498E-01
      0.00000000000000E+00   0.00000000000000E+00   2.86427393109009E-11   0.00000000000000E+00   2.86427393109009E-11
      3.68466485568435E-18  -2.54564261195989E-01  -2.50336617815466E-01   0.00000000000000E+00  -2.90611562272275E-13
     -9.84763342654415E-23  -1.34185389273016E-08  -1.34188295388640E-08  -2.90354052274327E-18
      5.34195177393055E-10
      0.00000000000000E+00  -1.33572556663022E-11   0.00000000000000E+00  -1.45481310379721E-13   1.81713694887857E-22
      1.33574235287962E-08   1.33572780474860E-08  -7.81327544730950E-19  -2.54280242476464E-01  -2.54280242476506E-01
      0.00000000000000E+00   0.00000000000000E+00   4.16811306673122E-11   0.00000000000000E+00   4.16811306673122E-11
      3.68513210464342E-18  -2.54667854792164E-01  -2.50446471342223E-01   0.00000000000000E+00  -4.02303992216928E-13
     -9.84971515369452E-23  -1.33985568741610E-08  -1.33989591781533E-08  -2.90380455991246E-18
      5.49328790244618E-10
      0.00000000000000E+00  -1.33177624293030E-11   0.00000000000000E+00  -1.29699157658458E-13   1.80927244532287E-22
      1.33178769396837E-08   1.33177472405262E-08  -7.81611063095880E-19  -2.54153237417139E-01  -2.54153237417190E-01
      0.00000000000000E+00   0.00000000000000E+00   5.07396243437999E-11   0.00000000000000E+00   5.07396243437999E-11
      3.68589997847447E-18  -2.54870289139064E-01  -2.50658506304614E-01   0.00000000000000E+00  -5.14214962274510E-13
     -9.85324649122408E-23  -1.33679726499077E-08  -1.33684868648701E-08  -2.90428891537859E-18
      5.69328790244618E-10
      0.00000000000000E+00  -1.33390704083351E-11   0.00000000000000E+00   6.60286436570323E-14   1.80784673071200E-22
      1.33389429270533E-08   1.33390089556971E-08  -7.81619996677974E-19  -2.54149050439028E-01  -2.54149050439044E-01
      0.00000000000000E+00   0.00000000000000E+00   1.60199336288358E-11   0.00000000000000E+00   1.60199336288358E-11
      3.68622037714704E-18  -2.55127102155147E-01  -2.50919564279439E-01   0.00000000000000E+00  -3.59679451833722E-13
     -9.85618590571901E-23  -1.33546692098740E-08  -1.33550288893259E-08  -2.90460038046907E-18
      5.79328790244618E-10
      0.00000000000000E+00  -1.33779207321739E-11   0.00000000000000E+00   1.91791701439100E-13   1.81081497645880E-22
      1.33776972197441E-08   1.33778890114458E-08  -7.81471687423427E-19  -2.54215994699647E-01  -2.54215994699629E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.72985543351323E-11   0.00000000000000E+00  -1.72985543351323E-11
      3.68604739160369E-18  -2.55228497559948E-01  -2.51019203366175E-01   0.00000000000000E+00  -1.45919405013923E-13
     -9.85668581321653E-23  -1.33604445377055E-08  -1.33605904571106E-08  -2.90457570418026E-18
      5.92828790244618E-10
      0.00000000000000E+00  -1.35090750169063E-11   0.00000000000000E+00   5.02087455872772E-13   1.82578527675508E-22
      1.35086548167283E-08   1.35091569041843E-08  -7.80811562833711E-19  -2.54516052765543E-01  -2.54516052765443E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00609022201908E-10   0.00000000000000E+00  -1.00609022201908E-10
      3.68468916980396E-18  -2.55220557008962E-01  -2.50996160904580E-01   0.00000000000000E+00   3.97329666773379E-13
     -9.85376141628168E-23  -1.34089452116491E-08  -1.34085478819824E-08  -2.90387760697025E-18
      6.11053790244618E-10
      0.00000000000000E+00  -1.38598300683018E-11   0.00000000000000E+00   1.08448639244461E-12   1.87283325071562E-22
      1.38589056303551E-08   1.38599901167477E-08  -7.78792246854699E-19  -2.55441674413463E-01  -2.55441674413188E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.75183263852191E-10   0.00000000000000E+00  -2.75183263852191E-10
      3.67967395482026E-18  -2.54635262754930E-01  -2.50355370581673E-01   0.00000000000000E+00   1.60924802638394E-12
     -9.83861374907244E-23  -1.35864161009220E-08  -1.35848068528957E-08  -2.90088170796556E-18
      6.31053790244618E-10
      0.00000000000000E+00  -1.43309017254392E-11   0.00000000000000E+00   1.24772609553629E-12   1.94443000499887E-22
      1.43297007798939E-08   1.43309485059896E-08  -7.75737155369287E-19  -2.56859052568705E-01  -2.56859052568262E-01
      0.00000000000000E+00   0.00000000000000E+00  -4.42828462089721E-10   0.00000000000000E+00  -4.42828462089721E-10
      3.67081738557847E-18  -2.53056399654613E-01  -2.48680930190061E-01   0.00000000000000E+00   3.16850668392881E-12
     -9.80818328689283E-23  -1.38912885505837E-08  -1.38881200438998E-08  -2.89508023020918E-18
      6.51053790244618E-10
      0.00000000000000E+00  -1.45115603235264E-11   0.00000000000000E+00   6.19573392330220E-13   1.98582820009093E-22
      1.45110903001005E-08   1.45117098734930E-08  -7.73847092509302E-19  -2.57772474325275E-01  -2.57772474324889E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.85581465597655E-10   0.00000000000000E+00  -3.85581465597655E-10
      3.66310575626651E-18  -2.50954598784040E-01  -2.46504168991089E-01   0.00000000000000E+00   3.21943442679652E-12
     -9.77728128206154E-23  -1.41293478423220E-08  -1.41261284078953E-08  -2.88925866375721E-18
      6.71053790244618E-10
      0.00000000000000E+00  -1.38207042102514E-11   0.00000000000000E+00  -1.70459837624255E-12   1.91116863975637E-22
      1.38223992059786E-08   1.38206946076026E-08  -7.76573392834402E-19  -2.56597941290154E-01  -2.56597941290297E-01
      0.00000000000000E+00   0.00000000000000E+00   1.42097284978758E-10   0.00000000000000E+00   1.42097284978758E-10
      3.66594770196609E-18  -2.49883927901351E-01  -2.45484900174194E-01   0.00000000000000E+00   2.56395722168333E-13
     -9.77757108166043E-23  -1.39630482883034E-08  -1.39627918925813E-08  -2.88937430913168E-18
      6.91053790244618E-10
      0.00000000000000E+00  -1.18532980945290E-11   0.00000000000000E+00  -4.86783418327428E-12   1.65118595203067E-22
      1.18581776862196E-08   1.18533098520365E-08  -7.87520631261353E-19  -2.51643314063327E-01  -2.51643314064556E-01
      0.00000000000000E+00   0.00000000000000E+00   1.22940196244251E-09   0.00000000000000E+00   1.22940196244251E-09
      3.69053574121494E-18  -2.52247638843331E-01  -2.48125880413467E-01   0.00000000000000E+00  -7.60476107497995E-12
     -9.85149875261243E-23  -1.30751070534040E-08  -1.30827118144791E-08  -2.90301510995358E-18
      7.11053790244618E-10
      0.00000000000000E+00  -9.09538432566137E-12   0.00000000000000E+00  -6.83795503752218E-12   1.25459355470560E-22
      9.10219114970189E-09   9.09535319466449E-09  -8.06935277728616E-19  -2.42711969429176E-01  -2.42711969431624E-01
      0.00000000000000E+00   0.00000000000000E+00   2.44809061809612E-09   0.00000000000000E+00   2.44809061809612E-09
      3.73949755357686E-18  -2.59458557895556E-01  -2.55821751188535E-01   0.00000000000000E+00  -1.87885961146220E-11
     -1.00180279069411E-22  -1.15246552166459E-08  -1.15434438127606E-08  -2.93256227584824E-18
      7.31053790244618E-10
      0.00000000000000E+00  -7.29945233430540E-12   0.00000000000000E+00  -4.47447491667403E-12   9.34282232477871E-23
      7.30393530069825E-09   7.29946082578167E-09  -8.25710088393744E-19  -2.33920236732381E-01  -2.33920236735034E-01
      0.00000000000000E+00   0.00000000000000E+00   2.65373949623269E-09   0.00000000000000E+00   2.65373949623269E-09
      3.79257234350151E-18  -2.69840268071962E-01  -2.66704479800388E-01   0.00000000000000E+00  -2.48979607147098E-11
     -1.02206512317736E-22  -9.92830236129948E-09  -9.95320032201429E-09  -2.96686225510777E-18
      7.51053790244618E-10
      0.00000000000000E+00  -8.61916936324035E-12   0.00000000000000E+00   3.24007347659589E-12   9.69946227203269E-23
      8.61599794158421E-09   8.61923801506090E-09  -8.24198449106839E-19  -2.34377068802238E-01  -2.34377068802924E-01
      0.00000000000000E+00   0.00000000000000E+00   6.86274170325786E-10   0.00000000000000E+00   6.86274170325786E-10
      3.80629782690803E-18  -2.78789568585850E-01  -2.75857858687994E-01   0.00000000000000E+00  -1.21146315940590E-11
     -1.03131513615897E-22  -9.29339755379246E-09  -9.30551218538662E-09  -2.98209937780119E-18
      7.71053790244618E-10
      0.00000000000000E+00  -1.41332518509686E-11   0.00000000000000E+00   1.36462218210500E-11   1.62007858814802E-22
      1.41195872875714E-08   1.41332335093926E-08  -7.91445645780816E-19  -2.49144123789879E-01  -2.49144123786967E-01
      0.00000000000000E+00   0.00000000000000E+00  -2.91275454583496E-09   0.00000000000000E+00  -2.91275454583496E-09
      3.74804273599133E-18  -2.79255234424711E-01  -2.75720239528906E-01   0.00000000000000E+00   1.75206255358559E-11
     -1.01642891012755E-22  -1.12379995890934E-08  -1.12204789635576E-08  -2.95659709021051E-18
      7.91053790244618E-10
      0.00000000000000E+00  -2.22813495570716E-11   0.00000000000000E+00   2.01875428343909E-11   2.87675302530967E-22
      2.22611587367464E-08   2.22813462795811E-08  -7.45620815300294E-19  -2.69938199258427E-01  -2.69938199252691E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.73589012661178E-09   0.00000000000000E+00  -5.73589012661178E-09
      3.63332493345909E-18  -2.63586259930901E-01  -2.58373607862959E-01   0.00000000000000E+00   3.91315047231041E-11
     -9.79324778002592E-23  -1.65845876576925E-08  -1.65454561529695E-08  -2.88770411815880E-18
      8.11053790244618E-10
      0.00000000000000E+00  -2.98721333977992E-11   0.00000000000000E+00   1.88296908016473E-11   4.24745060657797E-22
      2.98533296658772E-08   2.98721593566793E-08  -7.06574682320387E-19  -2.88185507451899E-01  -2.88185507444645E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.25379516755611E-09   0.00000000000000E+00  -7.25379516755611E-09
      3.48824903010797E-18  -2.28499491646061E-01  -2.21373474415753E-01   0.00000000000000E+00   4.83571438764698E-11
     -9.25738808027321E-23  -2.26667213329996E-08  -2.26183641891232E-08  -2.78167434778758E-18
      8.31053790244618E-10
      0.00000000000000E+00  -3.56678118498058E-11   0.00000000000000E+00   1.43966658185352E-11   5.35290931450879E-22
      3.56533906176038E-08   3.56677872834229E-08  -6.75220398433832E-19  -3.03813473147550E-01  -3.03813473138601E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.94941400553612E-09   0.00000000000000E+00  -8.94941400553612E-09
      3.30926074999725E-18  -1.74384564646488E-01  -1.65966710032797E-01   0.00000000000000E+00   5.21549136182912E-11
     -8.56265054974513E-23  -2.67705281915049E-08  -2.67183732778867E-08  -2.63404035156342E-18
      8.51053790244618E-10
      0.00000000000000E+00  -3.90294210763385E-11   0.00000000000000E+00   8.37862076698299E-12   5.96373700448843E-22
      3.90209797909164E-08   3.90293584116840E-08  -6.48206791695288E-19  -3.18319199005521E-01  -3.18319198994650E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08710213260684E-08   0.00000000000000E+00  -1.08710213260684E-08
      3.09184032347588E-18  -1.08762169673415E-01  -9.98905435217838E-02   0.00000000000000E+00   4.60280173735613E-11
     -5.75223276040853E-23  -2.82043651029890E-08  -2.81583370856155E-08  -2.44363353178059E-18
      8.71053790244618E-10
      0.00000000000000E+00  -3.83553725499725E-11   0.00000000000000E+00  -1.59660387683826E-12   6.07174195719614E-22
      3.83569201337982E-08   3.83553235299219E-08  -6.16081421721838E-19  -3.35007761448834E-01  -3.35007761436525E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.23098429894678E-08   0.00000000000000E+00  -1.23098429894678E-08
      2.84564346368653E-18  -5.30070065819099E-02  -4.48009984991775E-02   0.00000000000000E+00   3.45923184337309E-11
      1.89085414985251E-22  -2.60800728588881E-08  -2.60454805404541E-08  -2.22956204196469E-18
      8.91053790244618E-10
      0.00000000000000E+00  -3.34663853436786E-11   0.00000000000000E+00  -1.20023647417805E-11   6.36274062328383E-22
      3.34783295604057E-08   3.34663271956645E-08  -5.64328643395649E-19  -3.58330744298774E-01  -3.58330744286486E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.22882566792107E-08   0.00000000000000E+00  -1.22882566792107E-08
      2.59987833010231E-18  -2.69779161815816E-02  -2.03054312798309E-02   0.00000000000000E+00   2.51643516314629E-11
      5.76236866906445E-22  -2.12032348680859E-08  -2.11780705164538E-08  -2.03554968670666E-18
      9.11053790244618E-10
      0.00000000000000E+00  -2.92052487609354E-11   0.00000000000000E+00  -1.04856203164008E-11   6.21090083345692E-22
      2.92157238491226E-08   2.92052382288068E-08  -5.11129343009285E-19  -3.81496225006190E-01  -3.81496224995306E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08833950334210E-08   0.00000000000000E+00  -1.08833950334210E-08
      2.38221042943389E-18  -1.79517880646193E-02  -1.21791850680253E-02   0.00000000000000E+00   1.34476774956060E-11
      7.63853251514460E-22  -1.83352908728821E-08  -1.83218431953858E-08  -1.87108108642461E-18
      9.31053790244618E-10
      0.00000000000000E+00  -2.45466081555580E-11   0.00000000000000E+00  -1.14801827597966E-11   5.21278291730370E-22
      2.45581112561984E-08   2.45466310734392E-08  -4.79649458684216E-19  -3.95601015328334E-01  -3.95601015321173E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.16102729510006E-09   0.00000000000000E+00  -7.16102729510006E-09
      2.23898988353189E-18  -1.45881909836593E-02  -9.11055707319921E-03   0.00000000000000E+00   5.07597669423396E-12
      7.08473355601076E-22  -1.73906797550340E-08  -1.73856037783390E-08  -1.75934042484767E-18
      9.51053790244618E-10
      0.00000000000000E+00  -1.56355562174721E-11   0.00000000000000E+00  -2.20121682319732E-11   3.53208625759903E-22
      1.56575824685948E-08   1.56355703003632E-08  -5.02491024129770E-19  -3.87069819332747E-01  -3.87069819334512E-01
      0.00000000000000E+00   0.00000000000000E+00   1.76444970921782E-09   0.00000000000000E+00   1.76444970921782E-09
      2.27427887771625E-18  -1.34062262171535E-02  -7.92404167491102E-03   0.00000000000000E+00  -2.50597232321214E-12
      4.88733715664820E-22  -1.73975140372584E-08  -1.74000200095811E-08  -1.77178785358647E-18
      9.71053790244618E-10
      0.00000000000000E+00  -3.24074155236758E-12   0.00000000000000E+00  -3.06641559168753E-11   1.41526142728854E-22
      3.27139289889834E-09   3.24072874298161E-09  -6.11019943547402E-19  -3.43115826326318E-01  -3.43115826340314E-01
      0.00000000000000E+00   0.00000000000000E+00   1.39952480335705E-08   0.00000000000000E+00   1.39952480335705E-08
      2.55418383838766E-18  -1.48568581597617E-02  -9.42636539915000E-03   0.00000000000000E+00  -1.26344449038758E-11
      1.65389827143297E-22  -1.72233423316484E-08  -1.72359767765522E-08  -1.94316389484026E-18
      9.91053790244618E-10
      0.00000000000000E+00   5.88651289710480E-12   0.00000000000000E+00  -2.28055386363631E-11  -1.02771645078925E-23
     -5.86372331223548E-09  -5.88652885087185E-09  -7.88016177874512E-19  -2.67369420755166E-01  -2.67369420776540E-01
      0.00000000000000E+00   0.00000000000000E+00   2.13737102295690E-08   0.00000000000000E+00   2.13737102295690E-08
      2.98165804297904E-18  -2.79813517280078E-02  -2.31018531597262E-02   0.00000000000000E+00  -3.25942012017104E-11
     -6.41489231618190E-23  -1.54545871774954E-08  -1.54871813786971E-08  -2.19364186510453E-18
      1.01105379024462E-09
      0.00000000000000E+00   8.85585325102414E-12   0.00000000000000E+00  -7.80098800875867E-12  -4.24172994864471E-23
     -8.84796368118038E-09  -8.85576466918918E-09  -9.72074002011685E-19  -1.79437856962852E-01  -1.79437856984522E-01
      0.00000000000000E+00   0.00000000000000E+00   2.16701579531295E-08   0.00000000000000E+00   2.16701579531295E-08
      3.41506120204163E-18  -5.71720992170190E-02  -5.31347293691764E-02   0.00000000000000E+00  -7.48162280143629E-11
     -8.81841437853050E-23  -1.27395770559259E-08  -1.28143932839403E-08  -2.44298720002994E-18
      1.02105379024462E-09
      0.00000000000000E+00   8.27208810133310E-12   0.00000000000000E+00   2.14210024159388E-12  -4.48831756274937E-23
     -8.27423243253072E-09  -8.27209033228917E-09  -1.05569335324388E-18  -1.35962507058885E-01  -1.35962507078641E-01
      0.00000000000000E+00   0.00000000000000E+00   1.97560755750383E-08   0.00000000000000E+00   1.97560755750383E-08
      3.61262195779201E-18  -7.52206041928915E-02  -7.16023616849886E-02   0.00000000000000E+00  -1.21051000817598E-10
     -9.46817398338209E-23  -1.13629342419315E-08  -1.14839852427492E-08  -2.55692860454813E-18
      1.03455379024462E-09
      0.00000000000000E+00   6.78548918489208E-12   0.00000000000000E+00   4.69689377913550E-12  -4.61882520252776E-23
     -6.79015156125965E-09  -6.78545466748056E-09  -1.14693223869656E-18  -8.55165999470502E-02  -8.55165999638348E-02
      0.00000000000000E+00   0.00000000000000E+00   1.67846291588308E-08   0.00000000000000E+00   1.67846291588308E-08
      3.83921445143623E-18  -1.04138961237838E-01  -1.00988533197780E-01   0.00000000000000E+00  -1.59379784060949E-10
     -1.03677497648795E-22  -9.83979470728908E-09  -9.99917449135013E-09  -2.69228221273967E-18
      1.05277879024462E-09
      0.00000000000000E+00   3.90441162342917E-12   0.00000000000000E+00   7.26466031997177E-12  -4.72148071959705E-23
     -3.91165943736009E-09  -3.90439477704017E-09  -1.21714389270840E-18  -4.40435118965782E-02  -4.40435119081983E-02
      0.00000000000000E+00   0.00000000000000E+00   1.16201091639019E-08   0.00000000000000E+00   1.16201091639019E-08
      4.05099094094834E-18  -1.51243677537591E-01  -1.48812694834219E-01   0.00000000000000E+00  -1.83758411519211E-10
     -1.14486859849278E-22  -7.53195597534244E-09  -7.71571438686177E-09  -2.83384704823993E-18
      1.07277879024462E-09
      0.00000000000000E+00   1.48834396644797E-12   0.00000000000000E+00   5.74175359350667E-12  -4.75796562064833E-23
     -1.49409660519838E-09  -1.48835485160492E-09  -1.24583823214807E-18  -2.58338060626994E-02  -2.58338060696822E-02
      0.00000000000000E+00   0.00000000000000E+00   6.98277073382502E-09   0.00000000000000E+00   6.98277073382502E-09
      4.19064635562484E-18  -2.05578184150593E-01  -2.03847055930811E-01   0.00000000000000E+00  -1.86986430445342E-10
     -1.24320406865224E-22  -5.30742945177466E-09  -5.49441588222012E-09  -2.94480812347677E-18
      1.09277879024462E-09
      0.00000000000000E+00   5.71549799642439E-13   0.00000000000000E+00   2.19413421593386E-12  -4.76998524538687E-23
     -5.73747460506634E-10  -5.71553326290747E-10  -1.25622021604135E-18  -1.86761779400189E-02  -1.86761779444740E-02
      0.00000000000000E+00   0.00000000000000E+00   4.45507362007920E-09   0.00000000000000E+00   4.45507362007920E-09
      4.27974782802642E-18  -2.51404757053929E-01  -2.50181166033943E-01   0.00000000000000E+00  -1.72632356502069E-10
     -1.32122680940569E-22  -3.71088793728620E-09  -3.88352029378840E-09  -3.02352761198508E-18
      1.11277879024462E-09
      0.00000000000000E+00   3.02720253836008E-13   0.00000000000000E+00   6.36639509892091E-13  -4.77604630413984E-23
     -3.03375420673250E-10  -3.02738781163406E-10  -1.26124852447706E-18  -1.50960752247424E-02  -1.50960752276588E-02
      0.00000000000000E+00   0.00000000000000E+00   2.91631611132588E-09   0.00000000000000E+00   2.91631611132588E-09
      4.33807415025294E-18  -2.83901521724987E-01  -2.83078051111126E-01   0.00000000000000E+00  -1.36512055620332E-10
     -1.37704160347945E-22  -2.47706527454206E-09  -2.61357733016253E-09  -3.07682562577588E-18
      1.13277879024462E-09
      0.00000000000000E+00   2.11518429788934E-13   0.00000000000000E+00   2.11211652840549E-13  -4.77984888802066E-23
     -2.11714877919523E-10  -2.11503666266731E-10  -1.26446746873311E-18  -1.29417151167962E-02  -1.29417151186491E-02
      0.00000000000000E+00   0.00000000000000E+00   1.85290073509192E-09   0.00000000000000E+00   1.85290073509192E-09
      4.37513216495478E-18  -3.04033074679227E-01  -3.03515913676631E-01   0.00000000000000E+00  -9.11249955508234E-11
     -1.41217138686571E-22  -1.55027207327413E-09  -1.64139706882509E-09  -3.11066469622167E-18
      1.15277879024462E-09
      0.00000000000000E+00   1.63942855915435E-13   0.00000000000000E+00   1.10306579229250E-13  -4.78213706435935E-23
     -1.64093036665074E-10  -1.63982730085893E-10  -1.26674636155737E-18  -1.15791558044495E-02  -1.15791558056172E-02
      0.00000000000000E+00   0.00000000000000E+00   1.16772085132261E-09   0.00000000000000E+00   1.16772085132261E-09
      4.39848658198123E-18  -3.15627466853672E-01  -3.15311218649490E-01   0.00000000000000E+00  -5.38937662728852E-11
     -1.43234442373617E-22  -9.49844354963761E-10  -1.00373812123679E-09  -3.13174022042387E-18
      1.17277879024462E-09
      0.00000000000000E+00   1.24633308390614E-13   0.00000000000000E+00   9.62184491518597E-14  -4.78297665406894E-23
     -1.24716808872274E-10  -1.24620590423170E-10  -1.26824809158625E-18  -1.07496184959799E-02  -1.07496184968838E-02
      0.00000000000000E+00   0.00000000000000E+00   9.03882881786194E-10   0.00000000000000E+00   9.03882881786194E-10
      4.41656423961696E-18  -3.24538879952957E-01  -3.24293359413628E-01   0.00000000000000E+00  -4.09851831344523E-11
     -1.44729029187294E-22  -7.38277108228430E-10  -7.79262291363027E-10  -3.14831614803070E-18
      1.18277879024462E-09
      0.00000000000000E+00   1.08193100430467E-13   0.00000000000000E+00   8.26986755773528E-14  -4.78309580944712E-23
     -1.08290169784857E-10  -1.08207471109327E-10  -1.26883739554136E-18  -1.04395580833797E-02  -1.04395580842013E-02
      0.00000000000000E+00   0.00000000000000E+00   8.21617076422223E-10   0.00000000000000E+00   8.21617076422223E-10
      4.42478041038118E-18  -3.28626134931506E-01  -3.28401363105782E-01   0.00000000000000E+00  -3.73846017584281E-11
     -1.45399425926423E-22  -6.76025003554221E-10  -7.13409605312794E-10  -3.15594301483981E-18
      1.19627879024462E-09
      0.00000000000000E+00   7.92620082100956E-14   0.00000000000000E+00   1.11757769033570E-13  -4.78249144076752E-23
     -7.93984928941063E-11  -7.92867351251205E-11  -1.26924904943758E-18  -1.01882427071031E-02  -1.01882427080897E-02
      0.00000000000000E+00   0.00000000000000E+00   9.86550482304059E-10   0.00000000000000E+00   9.86550482304059E-10
      4.43809884189228E-18  -3.36432925343372E-01  -3.36147072728070E-01   0.00000000000000E+00  -5.41480703675412E-11
     -1.46673540186917E-22  -8.53115676811389E-10  -9.07263747179077E-10  -3.16884979245470E-18
      1.21450379024462E-09
      0.00000000000000E+00   5.29025686315354E-14   0.00000000000000E+00   8.16491262860788E-14  -4.78088148593341E-23
     -5.29661766569985E-11  -5.28845275307602E-11  -1.26934102599710E-18  -9.94771732671645E-03  -9.94771732811839E-03
      0.00000000000000E+00   0.00000000000000E+00   1.40193605267410E-09   0.00000000000000E+00   1.40193605267410E-09
      4.46364912645227E-18  -3.53428522217057E-01  -3.53003469028779E-01   0.00000000000000E+00  -9.23782793263862E-11
     -1.49518142443876E-22  -1.25667324581678E-09  -1.34905152514331E-09  -3.19430810045517E-18
      1.23450379024462E-09
      0.00000000000000E+00   7.11796713358332E-14   0.00000000000000E+00  -3.83386034020768E-14  -4.78008473326685E-23
     -7.10989291231118E-11  -7.11372677265617E-11  -1.26982916248143E-18  -9.34439288099095E-03  -9.34439288265433E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66338236317022E-09   0.00000000000000E+00   1.66338236317022E-09
      4.49691677371567E-18  -3.75662570649938E-01  -3.75160890357170E-01   0.00000000000000E+00  -1.19131324341331E-10
     -1.53403052278772E-22  -1.47311377110220E-09  -1.59224509544369E-09  -3.22708761123424E-18
      1.25450379024462E-09
      0.00000000000000E+00   1.22520879434841E-13   0.00000000000000E+00  -1.29462232051226E-13  -4.78135409217846E-23
     -1.22410758353210E-10  -1.22540220585309E-10  -1.27136349685712E-18  -8.10492004734987E-03  -8.10492004909392E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74404661738798E-09   0.00000000000000E+00   1.74404661738798E-09
      4.53179770606343E-18  -3.97926038236396E-01  -3.97415136814791E-01   0.00000000000000E+00  -1.30953604839718E-10
     -1.57515277882828E-22  -1.49055279196272E-09  -1.62150639680260E-09  -3.26043420920631E-18
      1.27450379024462E-09
      0.00000000000000E+00   1.47686337429703E-13   0.00000000000000E+00  -6.98794652852551E-14  -4.78336124563195E-23
     -1.47624295438970E-10  -1.47694174904303E-10  -1.27341610474836E-18  -6.57321674642928E-03  -6.57321674815579E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72651249930674E-09   0.00000000000000E+00   1.72651249930674E-09
      4.56632795604957E-18  -4.19445477735023E-01  -4.18948025190906E-01   0.00000000000000E+00  -1.36926217419682E-10
     -1.61665183897791E-22  -1.44189210698253E-09  -1.57881832440238E-09  -3.29291185130120E-18
      1.29450379024462E-09
      0.00000000000000E+00   1.10948442546692E-13   0.00000000000000E+00   8.83011045698626E-14  -4.78368193365310E-23
     -1.11041857523971E-10  -1.10953556419449E-10  -1.27475069377432E-18  -5.49107969561244E-03  -5.49107969722460E-03
      0.00000000000000E+00   0.00000000000000E+00   1.61216357848448E-09   0.00000000000000E+00   1.61216357848448E-09
      4.59857122761926E-18  -4.40348181541039E-01  -4.39875180916733E-01   0.00000000000000E+00  -1.38749263651780E-10
     -1.65737299857922E-22  -1.36246075841322E-09  -1.50121002206516E-09  -3.32382053384494E-18
      1.31450379024462E-09
      0.00000000000000E+00  -4.36905414896205E-13   0.00000000000000E+00   1.43665122259315E-12  -4.76143633341963E-23
      4.35436907345965E-10   4.36873558568511E-10  -1.26519130971718E-18  -1.09435263284798E-02  -1.09435263291683E-02
      0.00000000000000E+00   0.00000000000000E+00   6.88520740379537E-10   0.00000000000000E+00   6.88520740379537E-10
      4.61234164242684E-18  -4.61435623411157E-01  -4.61081038772488E-01   0.00000000000000E+00  -1.02782925037869E-10
     -1.68673219661205E-22  -1.02261137390998E-09  -1.12539429894801E-09  -3.34715033270967E-18
      1.33450379024462E-09
      0.00000000000000E+00  -2.17938376919740E-12   0.00000000000000E+00   4.63916386224623E-12  -4.67197591844285E-23
      2.17474627738240E-09   2.17938544124460E-09  -1.22114689586424E-18  -3.65026327377632E-02  -3.65026327356544E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.10874041428055E-09   0.00000000000000E+00  -2.10874041428055E-09
      4.57016683414124E-18  -4.84123798859272E-01  -4.84101564305343E-01   0.00000000000000E+00   2.34520668462199E-11
     -1.67981388511260E-22  -9.40970938101416E-11  -7.06450269640897E-11  -3.34901993827700E-18
      1.35450379024462E-09
      0.00000000000000E+00  -3.80613775461712E-12   0.00000000000000E+00   4.49561187558834E-12  -4.53658966739028E-23
      3.80160445203549E-09   3.80610006391103E-09  -1.14632091926033E-18  -7.81552908816876E-02  -7.81552908771291E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.55853200969800E-09   0.00000000000000E+00  -4.55853200969800E-09
      4.47899619394728E-18  -5.07543402706043E-01  -5.07780524403521E-01   0.00000000000000E+00   1.25018259896110E-10
     -1.64338645730616E-22   6.27413685891032E-10   7.52431945786977E-10  -3.33267527468694E-18
      1.35575379024462E-09
      0.00000000000000E+00  -4.15129027704300E-12   0.00000000000000E+00   1.37171395503044E-11  -4.52569918792215E-23
      4.13753605310514E-09   4.15125319265540E-09  -1.14122701106670E-18  -8.09284152764870E-02  -8.09284152714465E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.04057329082113E-09   0.00000000000000E+00  -5.04057329082113E-09
      4.47269547733375E-18  -5.08996279023708E-01  -5.09276533578438E-01   0.00000000000000E+00   1.40548542695290E-10
     -1.64082633966461E-22   7.48771555469999E-10   8.89320098165125E-10  -3.33146846626705E-18
      1.35744129024462E-09
      0.00000000000000E+00  -4.44170333609320E-12   0.00000000000000E+00   9.10759247873752E-12  -4.51176746749832E-23
      4.43260948207593E-09   4.44171707455462E-09  -1.13388892253371E-18  -8.48907944877109E-02  -8.48907944822437E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.46722451461654E-09   0.00000000000000E+00  -5.46722451461654E-09
      4.46346953596533E-18  -5.10975895938074E-01  -5.11299063246667E-01   0.00000000000000E+00   1.54950089269542E-10
     -1.63699730998750E-22   8.70557350792327E-10   1.02550744006171E-09  -3.32958061343162E-18
      1.35971941524462E-09
      0.00000000000000E+00  -4.76435389790324E-12   0.00000000000000E+00   7.52037335339074E-12  -4.49182823103007E-23
      4.75677476948342E-09   4.76429514283676E-09  -1.12331174348262E-18  -9.05607794823703E-02  -9.05607794764439E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.92635793001578E-09   0.00000000000000E+00  -5.92635793001578E-09
      4.44996855180602E-18  -5.13672465516612E-01  -5.14038662848148E-01   0.00000000000000E+00   1.70287100288571E-10
     -1.63128788597947E-22   9.91775686891291E-10   1.16206278717970E-09  -3.32665680832340E-18
      1.36279488399462E-09
      0.00000000000000E+00  -5.16727676003266E-12   0.00000000000000E+00   6.99031361059886E-12  -4.46163700247778E-23
      5.16024645824699E-09   5.16723677185754E-09  -1.10794624167013E-18  -9.87187789652056E-02  -9.87187789587322E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.47342700476440E-09   0.00000000000000E+00  -6.47342700476440E-09
      4.43005972934746E-18  -5.17337858950628E-01  -5.17749474504340E-01   0.00000000000000E+00   1.87881504472002E-10
     -1.62274240747597E-22   1.11830872843572E-09   1.30619023290756E-09  -3.32211348767733E-18
      1.36694676680712E-09
      0.00000000000000E+00  -5.67334126204613E-12   0.00000000000000E+00   6.54695748942759E-12  -4.41202000288905E-23
      5.66686377208197E-09   5.67341072957135E-09  -1.08550130115748E-18  -1.10471762228171E-01  -1.10471762221064E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.10739980946298E-09   0.00000000000000E+00  -7.10739980946298E-09
      4.40055063823698E-18  -5.22293353407753E-01  -5.22745245745226E-01   0.00000000000000E+00   2.06347783592536E-10
     -1.60999018573032E-22   1.22764129629956E-09   1.43398907989194E-09  -3.31504933707951E-18
      1.37255180860399E-09
      0.00000000000000E+00  -6.30459014087347E-12   0.00000000000000E+00   6.08125364575541E-12  -4.31381186434944E-23
      6.29850239634910E-09   6.30458364999481E-09  -1.05284086948465E-18  -1.27236840725604E-01  -1.27236840717840E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.76368223008496E-09   0.00000000000000E+00  -7.76368223008496E-09
      4.35703487483970E-18  -5.28902053527287E-01  -5.29361876717915E-01   0.00000000000000E+00   2.21705809490206E-10
     -1.59130496031023E-22   1.23739277059975E-09   1.45909858008979E-09  -3.30419400535505E-18
      1.38011861502977E-09
      0.00000000000000E+00  -7.18069708909606E-12   0.00000000000000E+00   6.20077453923838E-12  -4.04453737583803E-23
      7.17449079393994E-09   7.18069156847914E-09  -1.00612260600855E-18  -1.50560793842484E-01  -1.50560793834147E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.33664361129453E-09   0.00000000000000E+00  -8.33664361129453E-09
      4.29395310639231E-18  -5.37420589249260E-01  -5.37784941498553E-01   0.00000000000000E+00   2.29084021385442E-10
     -1.56482680628727E-22   9.26868021430099E-10   1.15595204281538E-09  -3.28783050038376E-18
      1.39033380370458E-09
      0.00000000000000E+00  -8.90453096174413E-12   0.00000000000000E+00   8.73801979746300E-12  -3.01747850474603E-23
      8.89576232367641E-09   8.90450034347384E-09  -9.41321097493012E-19  -1.81745204066278E-01  -1.81745204057507E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.77091004443106E-09   0.00000000000000E+00  -8.77091004443106E-09
      4.20435660543871E-18  -5.47350281944108E-01  -5.47308448720129E-01   0.00000000000000E+00   2.27765635280247E-10
     -1.52831882171896E-22  -3.61355934322832E-10  -1.33590299042738E-10  -3.26303550794570E-18
      1.40412430841556E-09
      0.00000000000000E+00  -1.37736797048012E-11   0.00000000000000E+00   1.77207026186388E-11   1.34587413677186E-23
      1.37560040433694E-08   1.37737247459881E-08  -8.56406491564618E-19  -2.20852169707997E-01  -2.20852169698837E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.15961461325805E-09   0.00000000000000E+00  -9.15961461325805E-09
      4.07804089696375E-18  -5.54479138596835E-01  -5.53025950775805E-01   0.00000000000000E+00   2.27508515740432E-10
     -1.47631788597080E-22  -4.84161864847025E-09  -4.61411013272996E-09  -3.22163440539913E-18
      1.42274148977540E-09
      0.00000000000000E+00  -2.72806422927517E-11   0.00000000000000E+00   3.60012482746159E-11   1.40772570250010E-22
      2.72446322067416E-08   2.72806334550163E-08  -7.59096167742161E-19  -2.64040312643257E-01  -2.64040312633511E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.74570708410531E-09   0.00000000000000E+00  -9.74570708410531E-09
      3.89660330069917E-18  -5.41116599571515E-01  -5.35593155248195E-01   0.00000000000000E+00   2.47809939266110E-10
     -1.38971294922963E-22  -1.77827363101771E-08  -1.75349263709111E-08  -3.13750713295701E-18
      1.44274148977540E-09
      0.00000000000000E+00  -4.62805630788727E-11   0.00000000000000E+00   4.71226332206651E-11   3.22195707707858E-22
      4.62335160165949E-08   4.62806386498159E-08  -6.84811345527891E-19  -2.97069354095211E-01  -2.97069354084722E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04887932746023E-08   0.00000000000000E+00  -1.04887932746023E-08
      3.68682743520712E-18  -4.90031613886265E-01  -4.78756434630478E-01   0.00000000000000E+00   2.62432267481664E-10
     -1.26548021338705E-22  -3.60542776426951E-08  -3.57918453752136E-08  -3.00201608967923E-18
      1.46274148977540E-09
      0.00000000000000E+00  -5.91557257195727E-11   0.00000000000000E+00   3.20487074805849E-11   4.48587411657132E-22
      5.91236486801541E-08   5.91556973876352E-08  -6.40394326945378E-19  -3.18147142077535E-01  -3.18147142066376E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11581774529103E-08   0.00000000000000E+00  -1.11581774529103E-08
      3.46366388614891E-18  -4.02861856588253E-01  -3.87740801273120E-01   0.00000000000000E+00   2.44893350025762E-10
     -1.11702614256721E-22  -4.82424132847506E-08  -4.79975199347250E-08  -2.82326955920354E-18
      1.48274148977540E-09
      0.00000000000000E+00  -5.89110513396518E-11   0.00000000000000E+00  -5.02568105488135E-13   4.57112566388369E-22
      5.89115087543045E-08   5.89110061861995E-08  -6.20934701427692E-19  -3.29523299077661E-01  -3.29523299065937E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17238485982890E-08   0.00000000000000E+00  -1.17238485982890E-08
      3.22918691418314E-18  -2.88563669710810E-01  -2.73697342894560E-01   0.00000000000000E+00   2.03630908097924E-10
     -9.65687511588600E-23  -4.73907884960082E-08  -4.71871575879104E-08  -2.60825221275545E-18
      1.50274148977539E-09
      0.00000000000000E+00  -5.24940432404363E-11   0.00000000000000E+00  -1.58821677987783E-11   4.02849581849520E-22
      5.25099066299285E-08   5.24940244621302E-08  -6.11156589884870E-19  -3.37199798328427E-01  -3.37199798316498E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19292856181496E-08   0.00000000000000E+00  -1.19292856181496E-08
      2.99060120182014E-18  -1.77466983643489E-01  -1.64686729195030E-01   0.00000000000000E+00   1.29335271684292E-10
     -8.31740413095634E-23  -4.06940741156648E-08  -4.05647388439806E-08  -2.37944461193528E-18
      1.52274148977539E-09
      0.00000000000000E+00  -4.67015793542320E-11   0.00000000000000E+00  -1.43553579004991E-11   3.43983432842019E-22
      4.67159790275341E-08   4.67016236696339E-08  -5.98659116289767E-19  -3.45925867238839E-01  -3.45925867227037E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18017585744066E-08   0.00000000000000E+00  -1.18017585744066E-08
      2.75456603033201E-18  -8.83916598234057E-02  -7.73960084494131E-02   0.00000000000000E+00   7.03504434282130E-11
     -4.24735326969874E-23  -3.49702155386554E-08  -3.48998650952272E-08  -2.15590691404224E-18
      1.52774148977539E-09
      0.00000000000000E+00  -4.39135405115604E-11   0.00000000000000E+00  -2.74928334141156E-11   3.27046287682274E-22
      4.39410335556982E-08   4.39135407222845E-08  -5.94960938609236E-19  -3.48249892614212E-01  -3.48249892602458E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17543040847048E-08   0.00000000000000E+00  -1.17543040847048E-08
      2.69579450990849E-18  -6.92669786373497E-02  -5.91347694566266E-02   0.00000000000000E+00   6.32474737802875E-11
      8.62626777545473E-25  -3.22224841113600E-08  -3.21592366375797E-08  -2.10083357129925E-18
      1.53449148977539E-09
      0.00000000000000E+00  -4.05446755507883E-11   0.00000000000000E+00  -2.47154878169989E-11   3.14959289470806E-22
      4.05694115750541E-08   4.05446960872374E-08  -5.85419787370982E-19  -3.52982686843571E-01  -3.52982686832133E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14388935402372E-08   0.00000000000000E+00  -1.14388935402372E-08
      2.61858197851189E-18  -5.03049494774094E-02  -4.11347409737699E-02   0.00000000000000E+00   4.83542692660803E-11
      8.26541558361426E-23  -2.91541568162665E-08  -2.91058025470004E-08  -2.03316219114091E-18
      1.53904773977540E-09
      0.00000000000000E+00  -3.81310877017117E-11   0.00000000000000E+00  -2.61735155772557E-11   3.13042516377367E-22
      3.81572875663828E-08   3.81311140508058E-08  -5.76515961797806E-19  -3.57003206766116E-01  -3.57003206754937E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11792817067337E-08   0.00000000000000E+00  -1.11792817067337E-08
      2.56764637623558E-18  -4.08226867194199E-02  -3.23311057671841E-02   0.00000000000000E+00   4.28250312377456E-11
      1.43945744781979E-22  -2.69946573753100E-08  -2.69518323440722E-08  -1.99113041443778E-18
      1.54519867727539E-09
      0.00000000000000E+00  -3.57098767394469E-11   0.00000000000000E+00  -1.94858264292623E-11   3.19942933571704E-22
      3.57293449979023E-08   3.57098591714734E-08  -5.61259925912901E-19  -3.63558016676677E-01  -3.63558016665804E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08736641904259E-08   0.00000000000000E+00  -1.08736641904259E-08
      2.50076314740428E-18  -3.24646413321055E-02  -2.46396105737439E-02   0.00000000000000E+00   3.15555454922070E-11
      2.21406494889977E-22  -2.48677505265399E-08  -2.48361949810474E-08  -1.93950322149138E-18
      1.55350244290040E-09
      0.00000000000000E+00  -3.36904865024650E-11   0.00000000000000E+00  -1.20192822278601E-11   3.36118461202040E-22
      3.37024812497695E-08   3.36904619675420E-08  -5.37854868530078E-19  -3.73389593937822E-01  -3.73389593927213E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06089454009079E-08   0.00000000000000E+00  -1.06089454009079E-08
      2.41266895126672E-18  -2.58917447772338E-02  -1.86195404855619E-02   0.00000000000000E+00   2.11742031104274E-11
      3.09010865819056E-22  -2.31026907697449E-08  -2.30815165666341E-08  -1.87481408273665E-18
      1.56471252649415E-09
      0.00000000000000E+00  -3.22068266176146E-11   0.00000000000000E+00  -6.51371359565207E-12   3.53671987636604E-22
      3.22132964117302E-08   3.22067826981349E-08  -5.05216639942059E-19  -3.87034758356167E-01  -3.87034758345749E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04179776653061E-08   0.00000000000000E+00  -1.04179776653061E-08
      2.29588255076082E-18  -2.10284022481237E-02  -1.41634767495780E-02   0.00000000000000E+00   1.37399045246763E-11
      3.93357962381659E-22  -2.18025449373539E-08  -2.17888050328288E-08  -1.79066591081876E-18
      1.57984613934571E-09
      0.00000000000000E+00  -3.10097223128517E-11   0.00000000000000E+00  -3.86868313361589E-12   3.53910722679715E-22
      3.10135832668516E-08   3.10097145837183E-08  -4.62642808265539E-19  -4.04967055534984E-01  -4.04967055524715E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02683188181544E-08   0.00000000000000E+00  -1.02683188181544E-08
      2.14048578913046E-18  -1.73806412997485E-02  -1.08457102094961E-02   0.00000000000000E+00   9.59152806467185E-12
      4.46956661258669E-22  -2.07509872936292E-08  -2.07413957655641E-08  -1.67784298086492E-18
      1.59984613934571E-09
      0.00000000000000E+00  -2.97063536471397E-11   0.00000000000000E+00  -3.17955236197707E-12   3.13442824791641E-22
      2.97095421205888E-08   2.97063625682271E-08  -4.10141707415512E-19  -4.27391313261859E-01  -4.27391313251754E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01043777893429E-08   0.00000000000000E+00  -1.01043777893429E-08
      1.93839823334360E-18  -1.45001166578917E-02  -8.32416849177515E-03   0.00000000000000E+00   7.66760063113578E-12
      4.30074510720348E-22  -1.96096523795157E-08  -1.96019847788842E-08  -1.52825652592809E-18
      1.61984613934571E-09
      0.00000000000000E+00  -2.84768281501425E-11   0.00000000000000E+00  -3.00133136669135E-12   2.45378059530917E-22
      2.84798722566833E-08   2.84768709253168E-08  -3.60868839271705E-19  -4.48679206106275E-01  -4.48679206096324E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.95093323509604E-09   0.00000000000000E+00  -9.95093323509604E-09
      1.73937956864168E-18  -1.25802467358928E-02  -6.74332019602999E-03   0.00000000000000E+00   6.66685551449874E-12
      3.50350719775248E-22  -1.85326045457356E-08  -1.85259376902207E-08  -1.37851072936997E-18
      1.63984613934571E-09
      0.00000000000000E+00  -2.74747102224712E-11   0.00000000000000E+00  -2.44425385257944E-12   1.70963785314112E-22
      2.74771958001772E-08   2.74747515463248E-08  -3.13846554843072E-19  -4.69145210986488E-01  -4.69145210976676E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.81130963229773E-09   0.00000000000000E+00  -9.81130963229773E-09
      1.54315337599572E-18  -1.12585170251541E-02  -5.69333038841964E-03   0.00000000000000E+00   5.60174787339362E-12
      2.47282162519494E-22  -1.76690436619007E-08  -1.76634419140271E-08  -1.22930682115265E-18
      1.65984613934571E-09
      0.00000000000000E+00  -2.67215833773695E-11   0.00000000000000E+00  -1.83223734336483E-12   1.06122994598549E-22
      2.67233981784673E-08   2.67215659411240E-08  -2.68431633470625E-19  -4.89038611176676E-01  -4.89038611166946E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.73009700923543E-09   0.00000000000000E+00  -9.73009700923543E-09
      1.34855143581101E-18  -1.03168361677366E-02  -4.96336281361263E-03   0.00000000000000E+00   4.75009790976000E-12
      1.51740069253405E-22  -1.69962190297985E-08  -1.69914689318886E-08  -1.08011980234039E-18
      1.67984613934571E-09
      0.00000000000000E+00  -2.71720818133724E-11   0.00000000000000E+00   1.13600027310996E-12   5.91456707918110E-23
      2.71709223632063E-08   2.71720583634795E-08  -2.20799784007651E-19  -5.10154089522213E-01  -5.10154089511724E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04892807750644E-08   0.00000000000000E+00  -1.04892807750644E-08
      1.13876582030973E-18  -9.79832290278332E-03  -4.54210476521637E-03   0.00000000000000E+00   3.76124113208644E-12
      8.02414282636714E-23  -1.66865388295472E-08  -1.66827775884150E-08  -9.17966036302077E-19
      1.69984613934571E-09
      0.00000000000000E+00  -2.79506496506806E-11   0.00000000000000E+00   1.95133656362706E-12   2.99948684274058E-23
      2.79487372925506E-08   2.79506886291143E-08  -1.72027574932172E-19  -5.32180405574303E-01  -5.32180405563061E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12416603685273E-08   0.00000000000000E+00  -1.12416603685273E-08
      9.13932612939181E-19  -9.53688207948624E-03  -4.27238967399968E-03   0.00000000000000E+00   2.80514778974470E-12
      3.54808024315767E-23  -1.67118334083767E-08  -1.67090282605869E-08  -7.41905038007008E-19
      1.70984613934571E-09
      0.00000000000000E+00  -2.86081661243493E-11   0.00000000000000E+00   3.27161469128425E-12   1.96112382017980E-23
      2.86049135709327E-08   2.86081851856240E-08  -1.47608815095593E-19  -5.43425830880808E-01  -5.43425830869075E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17324999784659E-08   0.00000000000000E+00  -1.17324999784659E-08
      7.96607613154522E-19  -9.51942174859140E-03  -4.20241936566064E-03   0.00000000000000E+00   1.92112462088017E-12
      1.94523851039264E-23  -1.68776063317791E-08  -1.68756852071582E-08  -6.48998798058930E-19
      1.71659613934571E-09
      0.00000000000000E+00  -2.91524380370411E-11   0.00000000000000E+00   4.00817391760324E-12   1.45608264834453E-23
      2.91484400127860E-08   2.91524481867036E-08  -1.31127124759493E-19  -5.51102926600602E-01  -5.51102926588596E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20060141173142E-08   0.00000000000000E+00  -1.20060141173142E-08
      7.15567017862651E-19  -9.58586737465079E-03  -4.18355921068891E-03   0.00000000000000E+00   7.01906389811330E-13
      1.17006513523558E-23  -1.71471359757792E-08  -1.71464340693894E-08  -5.84439893103158E-19
      1.72115238934571E-09
      0.00000000000000E+00  -2.94615874224816E-11   0.00000000000000E+00   3.38765860436591E-12   1.19299665800889E-23
      2.94581622291878E-08   2.94615498877921E-08  -1.20090868366902E-19  -5.56279307706060E-01  -5.56279307693951E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21096706941835E-08   0.00000000000000E+00  -1.21096706941835E-08
      6.60392330762277E-19  -9.63650443789339E-03  -4.16946621003444E-03   0.00000000000000E+00   3.91815311931831E-13
      7.70904246169853E-24  -1.73522710089204E-08  -1.73518791936084E-08  -5.40301462395374E-19
      1.72730332684571E-09
      0.00000000000000E+00  -2.95806182019026E-11   0.00000000000000E+00   1.00194868577332E-12   9.46281665572529E-24
      2.95795863482106E-08   2.95805882968964E-08  -1.05534382440935E-19  -5.63139365278363E-01  -5.63139365266334E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20283251803890E-08   0.00000000000000E+00  -1.20283251803890E-08
      5.86406854348028E-19  -9.65048828647036E-03  -4.12031469455330E-03   0.00000000000000E+00   9.15187961314618E-13
      4.10759458556415E-24  -1.75531783044687E-08  -1.75522631165074E-08  -4.80872471907092E-19
      1.73560709247071E-09
      0.00000000000000E+00  -2.91776953397731E-11   0.00000000000000E+00  -2.35516554606348E-12   7.35309200987949E-24
      2.91800135895295E-08   2.91776584239835E-08  -8.71441674456556E-20  -5.71857730603365E-01  -5.71857730591861E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15035007046770E-08   0.00000000000000E+00  -1.15035007046770E-08
      4.90884480629367E-19  -9.56971088343747E-03  -4.00113127389422E-03   0.00000000000000E+00   1.60727326516563E-12
      1.26555364385916E-24  -1.76757649925718E-08  -1.76741577193066E-08  -4.03740313183713E-19
      1.74681717606446E-09
      0.00000000000000E+00  -2.74341148486254E-11   0.00000000000000E+00  -7.64586813196694E-12   5.61694648394807E-24
      2.74417379057266E-08   2.74340920375946E-08  -6.67111749827664E-20  -5.81582491818523E-01  -5.81582491808798E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.72507841209541E-09   0.00000000000000E+00  -9.72507841209541E-09
      3.81865538674005E-19  -9.32821033396455E-03  -3.74864746975352E-03   0.00000000000000E+00   1.74524371071229E-12
     -6.56475785531122E-25  -1.77107588692099E-08  -1.77090136254992E-08  -3.15154363691238E-19
      1.76195078891602E-09
      0.00000000000000E+00  -2.15404380620185E-11   0.00000000000000E+00  -1.91953297884528E-11   3.83828652405934E-24
      2.15596928405112E-08   2.15404975107227E-08  -5.63072048074013E-20  -5.86298523805310E-01  -5.86298523801471E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.83926230629883E-09   0.00000000000000E+00  -3.83926230629883E-09
      3.23763629294881E-19  -8.73389307017427E-03  -3.15677923095935E-03   0.00000000000000E+00   7.66330735720122E-13
     -1.84982123451345E-24  -1.77020015351596E-08  -1.77012352044239E-08  -2.67456424487480E-19
      1.78195078891602E-09
      0.00000000000000E+00  -6.04705749774356E-12   0.00000000000000E+00  -3.81849636757186E-11   8.85556862192642E-25
      6.08526522908707E-09   6.04708026541135E-09  -1.01384066231654E-19  -5.63805349086448E-01  -5.63805349098098E-01
      0.00000000000000E+00   0.00000000000000E+00   1.16493105197651E-08   0.00000000000000E+00   1.16493105197651E-08
      5.56749839690182E-19  -7.39134692129287E-03  -1.81576146045193E-03   0.00000000000000E+00  -2.23038745054954E-12
     -3.18895565375755E-24  -1.76941603977258E-08  -1.76963907851764E-08  -4.55365773458527E-19
      1.80195078891602E-09
      0.00000000000000E+00   1.22869889436229E-11   0.00000000000000E+00  -4.52356612474359E-11  -4.63131192568497E-24
     -1.22417679719134E-08  -1.22870036331608E-08  -2.30327379663707E-19  -5.04171286700548E-01  -5.04171286730507E-01
      0.00000000000000E+00   0.00000000000000E+00   2.99589956816666E-08   0.00000000000000E+00   2.99589956816666E-08
      1.15592975332351E-18  -5.70193434089250E-03  -1.34034011316971E-04   0.00000000000000E+00  -6.99612945537584E-12
     -8.24840400207699E-24  -1.76649959190504E-08  -1.76719920485058E-08  -9.25602373659807E-19
      1.82195078891602E-09
      0.00000000000000E+00   2.26625052164828E-11   0.00000000000000E+00  -2.58253055786730E-11  -2.16872459645285E-23
     -2.26366532642476E-08  -2.26624785698263E-08  -4.57617386290480E-19  -4.09833819240016E-01  -4.09833819280295E-01
      0.00000000000000E+00   0.00000000000000E+00   4.02792636507093E-08   0.00000000000000E+00   4.02792636507093E-08
      1.96151502633770E-18  -4.00835113326150E-03   1.54214829480039E-03   0.00000000000000E+00  -1.58249174959677E-11
     -3.68301837660324E-23  -1.76009601633870E-08  -1.76167850808830E-08  -1.50389764004722E-18
      1.84195078891602E-09
      0.00000000000000E+00   1.88170579143409E-11   0.00000000000000E+00   9.00260941000108E-12  -4.03937662669404E-23
     -1.88260618308375E-08  -1.88170592214275E-08  -7.54436240660896E-19  -2.89437858636800E-01  -2.89437858673091E-01
      0.00000000000000E+00   0.00000000000000E+00   3.62908973050260E-08   0.00000000000000E+00   3.62908973050260E-08
      2.68733297243822E-18  -2.98940358844585E-03   2.51604300666315E-03   0.00000000000000E+00  -3.70812114462480E-11
     -7.42527883732585E-23  -1.74367568721521E-08  -1.74738380835984E-08  -1.93289673177732E-18
      1.86195078891602E-09
      0.00000000000000E+00   1.23151852779456E-11   0.00000000000000E+00   1.53385328800532E-11  -4.42399913834554E-23
     -1.23304825527421E-08  -1.23151440198621E-08  -9.97374987508461E-19  -1.74742111105117E-01  -1.74742111132121E-01
      0.00000000000000E+00   0.00000000000000E+00   2.70038729665299E-08   0.00000000000000E+00   2.70038729665299E-08
      3.22741043176882E-18  -2.10548992671285E-02  -1.64269625057244E-02   0.00000000000000E+00  -7.37236319164186E-11
     -8.68103043714783E-23  -1.46150053147513E-08  -1.46887289466678E-08  -2.23003544426036E-18
      1.88195078891602E-09
      0.00000000000000E+00   8.32177610416238E-12   0.00000000000000E+00   9.02107517864590E-12  -4.67253969990984E-23
     -8.33083428267221E-09  -8.32181320749362E-09  -1.16246116635072E-18  -8.48186235727311E-02  -8.48186235926248E-02
      0.00000000000000E+00   0.00000000000000E+00   1.98936755067935E-08   0.00000000000000E+00   1.98936755067935E-08
      3.62528394190469E-18  -5.81681867455330E-02  -5.45222720467167E-02   0.00000000000000E+00  -1.32587407499810E-10
     -9.99486841596040E-23  -1.14392748918000E-08  -1.15718622992999E-08  -2.46282277555396E-18
      1.89195078891602E-09
      0.00000000000000E+00   5.48331450076376E-12   0.00000000000000E+00   1.32155676595869E-11  -4.74853342728861E-23
     -5.49655073244673E-09  -5.48333516478719E-09  -1.21658511456510E-18  -5.28750258126454E-02  -5.28750258275282E-02
      0.00000000000000E+00   0.00000000000000E+00   1.48828265712247E-08   0.00000000000000E+00   1.48828265712247E-08
      3.77411220761694E-18  -8.29025803920205E-02  -7.99410873562983E-02   0.00000000000000E+00  -1.71680130043472E-10
     -1.06314279575039E-22  -9.22781127639387E-09  -9.39949140643745E-09  -2.55752709305184E-18
      1.89532578891602E-09
      0.00000000000000E+00   4.23789986422970E-12   0.00000000000000E+00   1.74840813461898E-11  -4.76540275348645E-23
     -4.25542697387963E-09  -4.23794289253349E-09  -1.23064494313736E-18  -4.43515174529623E-02  -4.43515174656819E-02
      0.00000000000000E+00   0.00000000000000E+00   1.27196556984615E-08   0.00000000000000E+00   1.27196556984615E-08
      3.81704104559924E-18  -9.20801493635450E-02  -8.94078085659275E-02   0.00000000000000E+00  -1.82207007272596E-10
     -1.08402015186400E-22  -8.29950579865508E-09  -8.48171280592779E-09  -2.58639610246188E-18
      1.89988203891602E-09
      0.00000000000000E+00   2.95795160650561E-12   0.00000000000000E+00   1.34301059550540E-11  -4.78051855316394E-23
     -2.97141272465144E-09  -2.95798261869643E-09  -1.24379034313940E-18  -3.61949508664580E-02  -3.61949508769712E-02
      0.00000000000000E+00   0.00000000000000E+00   1.05131202773247E-08   0.00000000000000E+00   1.05131202773247E-08
      3.86494144986280E-18  -1.05515942767826E-01  -1.03135536816406E-01   0.00000000000000E+00  -1.80922426033857E-10
     -1.11031458356070E-22  -7.37421523259382E-09  -7.55513765862778E-09  -2.62115110672340E-18
      1.90603297641602E-09
      0.00000000000000E+00   1.84093591258767E-12   0.00000000000000E+00   8.70218873784486E-12  -4.79221639462358E-23
     -1.84967118030302E-09  -1.84096899156523E-09  -1.25466588952770E-18  -2.92010383660884E-02  -2.92010383746032E-02
      0.00000000000000E+00   0.00000000000000E+00   8.51480466761775E-09   0.00000000000000E+00   8.51480466761775E-09
      3.91731548119803E-18  -1.24682461427867E-01  -1.22579726587220E-01   0.00000000000000E+00  -1.80411955036359E-10
     -1.14339135663617E-22  -6.49342372101630E-09  -6.67383567605277E-09  -2.66264959167033E-18
      1.91433674204102E-09
      0.00000000000000E+00   1.04023349361245E-12   0.00000000000000E+00   4.62312818657625E-12  -4.80033699291400E-23
     -1.04482158138882E-09  -1.04019845320229E-09  -1.26270537531673E-18  -2.37076494753593E-02  -2.37076494823092E-02
      0.00000000000000E+00   0.00000000000000E+00   6.94984825568260E-09   0.00000000000000E+00   6.94984825568260E-09
      3.97502539224253E-18  -1.51074952624359E-01  -1.49212988764188E-01   0.00000000000000E+00  -1.84026111224511E-10
     -1.18557507993680E-22  -5.72562369125567E-09  -5.90964980248030E-09  -2.71232001692581E-18
      1.92554682563477E-09
      0.00000000000000E+00   5.62732704870516E-13   0.00000000000000E+00   2.03855959409249E-12  -4.80554306140243E-23
     -5.64734735247061E-10  -5.62696175653016E-10  -1.26822423198740E-18  -1.95348113618390E-02  -1.95348113676369E-02
      0.00000000000000E+00   0.00000000000000E+00   5.79794238927869E-09   0.00000000000000E+00   5.79794238927869E-09
      4.04002081109809E-18  -1.85935097912844E-01  -1.84285616824918E-01   0.00000000000000E+00  -1.91994670880861E-10
     -1.23996285378572E-22  -5.04325154274474E-09  -5.23524621362573E-09  -2.77179657911070E-18
      1.94068043848633E-09
      0.00000000000000E+00   3.13741622300911E-13   0.00000000000000E+00   7.85976123972719E-13  -4.80858982519466E-23
     -3.14499222015867E-10  -3.13713245891943E-10  -1.27194011547433E-18  -1.62985444016795E-02  -1.62985444064892E-02
      0.00000000000000E+00   0.00000000000000E+00   4.80977596871518E-09   0.00000000000000E+00   4.80977596871518E-09
      4.11281009851138E-18  -2.29146983442080E-01  -2.27730394917824E-01   0.00000000000000E+00  -1.98428216030843E-10
     -1.30842966638433E-22  -4.29763450679224E-09  -4.49606272282321E-09  -2.84086998303704E-18
      1.96068043848633E-09
      0.00000000000000E+00   2.01599198170521E-13   0.00000000000000E+00   2.67506743637252E-13  -4.81030085675589E-23
     -2.01937671030730E-10  -2.01670164287141E-10  -1.27465611108966E-18  -1.37003472783358E-02  -1.37003472820200E-02
      0.00000000000000E+00   0.00000000000000E+00   3.68418356927705E-09   0.00000000000000E+00   3.68418356927705E-09
      4.18649376989692E-18  -2.75145917205942E-01  -2.74048666892862E-01   0.00000000000000E+00  -1.85094147960970E-10
     -1.38410664270794E-22  -3.29741925702884E-09  -3.48251340498994E-09  -2.91183765880726E-18
      1.98068043848633E-09
      0.00000000000000E+00   1.59350619055059E-13   0.00000000000000E+00   1.01639511139118E-13  -4.81110665933479E-23
     -1.59447655312437E-10  -1.59346015801346E-10  -1.27655805917575E-18  -1.19778108842664E-02  -1.19778108868839E-02
      0.00000000000000E+00   0.00000000000000E+00   2.61748274882196E-09   0.00000000000000E+00   2.61748274882196E-09
      4.23884342487336E-18  -3.07913232353140E-01  -3.07138733960052E-01   0.00000000000000E+00  -1.49339819899331E-10
     -1.44002440462080E-22  -2.30879691312120E-09  -2.45813673302067E-09  -2.96228536569761E-18
      2.00068043848633E-09
      0.00000000000000E+00   1.38226329497328E-13   0.00000000000000E+00   5.22568097283339E-14  -4.81138429657661E-23
     -1.38262542582349E-10  -1.38210285772668E-10  -1.27805940166884E-18  -1.08096713448093E-02  -1.08096713465797E-02
      0.00000000000000E+00   0.00000000000000E+00   1.77045501306657E-09   0.00000000000000E+00   1.77045501306657E-09
      4.27425252513469E-18  -3.29196532229124E-01  -3.28682253588461E-01   0.00000000000000E+00  -1.04289100616758E-10
     -1.47696503441514E-22  -1.52795562667697E-09  -1.63224472729387E-09  -2.99619312346585E-18
      2.02068043848633E-09
      0.00000000000000E+00   1.31062439995141E-13   0.00000000000000E+00   1.83842134628264E-14  -4.81155707409883E-23
     -1.31105354725213E-10  -1.31086970511798E-10  -1.27943224851796E-18  -9.97222455182503E-03  -9.97222455292080E-03
      0.00000000000000E+00   0.00000000000000E+00   1.09576514963647E-09   0.00000000000000E+00   1.09576514963647E-09
      4.29616782812741E-18  -3.40705800559231E-01  -3.40401860120111E-01   0.00000000000000E+00  -5.74249391316339E-11
     -1.49674801902881E-22  -9.07253239992886E-10  -9.64678179124670E-10  -3.01673557960946E-18
      2.04068043848633E-09
      0.00000000000000E+00   1.11591355707145E-13   0.00000000000000E+00   5.15722607325110E-14  -4.81100709427775E-23
     -1.11675294313631E-10  -1.11623722052947E-10  -1.28042624975555E-18  -9.48988030704142E-03  -9.48988030776346E-03
      0.00000000000000E+00   0.00000000000000E+00   7.22035203444319E-10   0.00000000000000E+00   7.22035203444319E-10
      4.31060853219630E-18  -3.47199422359205E-01  -3.47007105655623E-01   0.00000000000000E+00  -3.05985663987305E-11
     -1.50713888645563E-22  -5.79812914992440E-10  -6.10411481391321E-10  -3.03018228244075E-18
      2.06068043848633E-09
      0.00000000000000E+00   8.38542450704719E-14   0.00000000000000E+00   7.65287332429019E-14  -4.80946981456130E-23
     -8.39003921257661E-11  -8.38238633925713E-11  -1.28087621886722E-18  -9.30116894279723E-03  -9.30116894353274E-03
      0.00000000000000E+00   0.00000000000000E+00   7.35504898588924E-10   0.00000000000000E+00   7.35504898588924E-10
      4.32531863016808E-18  -3.54786299552929E-01  -3.54580978915444E-01   0.00000000000000E+00  -3.60392050846972E-11
     -1.51902490938874E-22  -6.15641830111434E-10  -6.51681035196283E-10  -3.04444241130086E-18
      2.07068043848633E-09
      0.00000000000000E+00   6.47505397313064E-14   0.00000000000000E+00   1.05249838166788E-13  -4.80834250643136E-23
     -6.48113266408495E-11  -6.47060768027308E-11  -1.28091361349579E-18  -9.28737684738911E-03  -9.28737684824244E-03
      0.00000000000000E+00   0.00000000000000E+00   8.53330766771753E-10   0.00000000000000E+00   8.53330766771753E-10
      4.33385193783580E-18  -3.59784795714411E-01  -3.59536325476698E-01   0.00000000000000E+00  -4.94182800190073E-11
     -1.52701718804382E-22  -7.39206409949970E-10  -7.88624689969130E-10  -3.05293832434001E-18
      2.07743043848633E-09
      0.00000000000000E+00   3.41662422412000E-14   0.00000000000000E+00   2.38072573214748E-13  -4.80711101344140E-23
     -3.44427702956160E-11  -3.42046977224494E-11  -1.28073512779243E-18  -9.36039632527748E-03  -9.36039632637775E-03
      0.00000000000000E+00   0.00000000000000E+00   1.10026457382132E-09   0.00000000000000E+00   1.10026457382132E-09
      4.34127872370909E-18  -3.64783669499956E-01  -3.64447782164977E-01   0.00000000000000E+00  -7.63240849163918E-11
     -1.53522675645067E-22  -9.89735791182351E-10  -1.06605987609890E-09  -3.06054359591667E-18
      2.08198668848633E-09
      0.00000000000000E+00   1.78178790182602E-14   0.00000000000000E+00   1.96873492519109E-13  -4.80618045789956E-23
     -1.80053423590778E-11  -1.78084688666067E-11  -1.28054110690711E-18  -9.43076711001309E-03  -9.43076711133057E-03
      0.00000000000000E+00   0.00000000000000E+00   1.31748091143590E-09   0.00000000000000E+00   1.31748091143590E-09
      4.34728149611182E-18  -3.69041421744997E-01  -3.68631925414182E-01   0.00000000000000E+00  -9.91130244076228E-11
     -1.54236780680059E-22  -1.20055941816156E-09  -1.29967244256933E-09  -3.06674038920471E-18
      2.08813762598633E-09
      0.00000000000000E+00   1.95629290252032E-14   0.00000000000000E+00   6.32368697226374E-15  -4.80510236545924E-23
     -1.95248855084948E-11  -1.95185618215706E-11  -1.28029206695003E-18  -9.48566512821629E-03  -9.48566512977555E-03
      0.00000000000000E+00   0.00000000000000E+00   1.55925701422930E-09   0.00000000000000E+00   1.55925701422930E-09
      4.35687238855278E-18  -3.75908860647896E-01  -3.75423722429184E-01   0.00000000000000E+00  -1.22424220221486E-10
     -1.55420410526526E-22  -1.41731423218598E-09  -1.53973845240763E-09  -3.07658032160275E-18
      2.09644139161133E-09
      0.00000000000000E+00   3.34314843435397E-14   0.00000000000000E+00  -6.64096589201701E-14  -4.80393978963035E-23
     -3.33505152099348E-11  -3.34169248689030E-11  -1.28007577750471E-18  -9.45987093344817E-03  -9.45987093517666E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72849025546200E-09   0.00000000000000E+00   1.72849025546200E-09
      4.37122536651924E-18  -3.86087329319296E-01  -3.85553246983071E-01   0.00000000000000E+00  -1.39561823263913E-10
     -1.57221778597689E-22  -1.55551150732895E-09  -1.69507333059302E-09  -3.09114958901453E-18
      2.10765147520508E-09
      0.00000000000000E+00   5.07901396757623E-14   0.00000000000000E+00  -6.41511199744783E-14  -4.80273831610430E-23
     -5.07001806467851E-11  -5.07643317668076E-11  -1.27998632741846E-18  -9.29149843272031E-03  -9.29149843451124E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79093435341305E-09   0.00000000000000E+00   1.79093435341305E-09
      4.39130189033192E-18  -4.00121627677046E-01  -3.99573335660141E-01   0.00000000000000E+00  -1.48921449918819E-10
     -1.59771462333153E-22  -1.59124857172729E-09  -1.74017002164626E-09  -3.11131556291346E-18
      2.12278508805664E-09
      0.00000000000000E+00   7.69658897799074E-14   0.00000000000000E+00  -7.81688988285228E-14  -4.80188535210155E-23
     -7.68534015876551E-11  -7.69315704865317E-11  -1.28027517153172E-18  -8.82688409829847E-03  -8.82688410008139E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78291418021459E-09   0.00000000000000E+00   1.78291418021459E-09
      4.41828382328285E-18  -4.18523727344533E-01  -4.17986206781700E-01   0.00000000000000E+00  -1.53219992713005E-10
     -1.63230008867911E-22  -1.55276261701487E-09  -1.70598260972804E-09  -3.13800865175113E-18
      2.14278508805664E-09
      0.00000000000000E+00   1.24816997865029E-13   0.00000000000000E+00  -1.19815339518370E-13  -4.80259539921993E-23
     -1.24681057881452E-10  -1.24800873221018E-10  -1.28163429937200E-18  -7.65441507444725E-03  -7.65441507621209E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76483982331067E-09   0.00000000000000E+00   1.76483982331067E-09
      4.45358061974906E-18  -4.41442897602025E-01  -4.40926154143233E-01   0.00000000000000E+00  -1.56707474470015E-10
     -1.67769447661988E-22  -1.48333147561943E-09  -1.64003895008961E-09  -3.17194632037706E-18
      2.16278508805664E-09
      0.00000000000000E+00   1.67157421717699E-13   0.00000000000000E+00  -1.14276394885839E-13  -4.80480881076774E-23
     -1.67062880882921E-10  -1.67177157277855E-10  -1.28385735173965E-18  -5.99464120261828E-03  -5.99464120435691E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73863021434179E-09   0.00000000000000E+00   1.73863021434179E-09
      4.48835322403589E-18  -4.62991290423030E-01  -4.62496155724057E-01   0.00000000000000E+00  -1.60635606768832E-10
     -1.72281907983408E-22  -1.41081745029499E-09  -1.57145305706400E-09  -3.20449587229625E-18
      2.18278508805664E-09
      0.00000000000000E+00   1.71382279629245E-13   0.00000000000000E+00  -2.15813179734112E-14  -4.80696609304071E-23
     -1.71390391495173E-10  -1.71411972813194E-10  -1.28617998261749E-18  -4.30436706764377E-03  -4.30436706931084E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66707055655958E-09   0.00000000000000E+00   1.66707055655958E-09
      4.52169463516708E-18  -4.83453801645093E-01  -4.82982547207686E-01   0.00000000000000E+00  -1.62622425004917E-10
     -1.76721098781337E-22  -1.33303615874129E-09  -1.49565858374639E-09  -3.23551465254959E-18
      2.20278508805664E-09
      0.00000000000000E+00   2.21896885093385E-13   0.00000000000000E+00  -1.44325286178507E-13  -4.81122809721750E-23
     -2.21761978231081E-10  -2.21906303517307E-10  -1.28952376101777E-18  -2.01940827885782E-03  -2.01940828053782E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68000461039814E-09   0.00000000000000E+00   1.68000461039814E-09
      4.55529472737505E-18  -5.02914484530116E-01  -5.02455062835012E-01   0.00000000000000E+00  -1.69031887233588E-10
     -1.81210520441846E-22  -1.28906641964696E-09  -1.45809830688073E-09  -3.26577096635728E-18
      2.22278508805664E-09
      0.00000000000000E+00  -7.15929726532671E-13   0.00000000000000E+00   2.44766491252950E-12  -4.77636624220045E-23
      7.13466026684598E-10   7.15913691597080E-10  -1.27417751476011E-18  -1.10285581975732E-02  -1.10285581976956E-02
      0.00000000000000E+00   0.00000000000000E+00   1.22446356488501E-10   0.00000000000000E+00   1.22446356488501E-10
      4.55774365450482E-18  -5.22685412549948E-01  -5.22421271382120E-01   0.00000000000000E+00  -8.43844979517827E-11
     -1.83404731565324E-22  -7.53975550133751E-10  -8.38360048085717E-10  -3.28356613974471E-18
      2.24278508805664E-09
      0.00000000000000E+00  -2.60343092088455E-12   0.00000000000000E+00   5.06510827342775E-12  -4.67072799792611E-23
      2.59839832113424E-09   2.60346342940762E-09  -1.22145761548135E-18  -4.17396291515005E-02  -4.17396291486002E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.90024357357889E-09   0.00000000000000E+00  -2.90024357357889E-09
      4.49973878303324E-18  -5.43694790244627E-01  -5.43788340828907E-01   0.00000000000000E+00   8.68682654040327E-11
     -1.81113154895842E-22   2.09911878767576E-10   2.96780144171428E-10  -3.27828116755189E-18
      2.25278508805664E-09
      0.00000000000000E+00  -3.80420901513576E-12   0.00000000000000E+00   6.43694635039371E-12  -4.59655279376482E-23
      3.79779463817783E-09   3.80423158452817E-09  -1.18339008826690E-18  -6.32467509390660E-02  -6.32467509343237E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.74238296325091E-09   0.00000000000000E+00  -4.74238296325091E-09
      4.45231495340073E-18  -5.54464534232306E-01  -5.54760187611791E-01   0.00000000000000E+00   1.79635892367866E-10
     -1.78714449192624E-22   7.58515486354749E-10   9.38151378722436E-10  -3.26892486513383E-18
      2.25953508805664E-09
      0.00000000000000E+00  -4.69620510289526E-12   0.00000000000000E+00   7.08170952767963E-12  -4.53665779765493E-23
      4.68916783036783E-09   4.69624953989547E-09  -1.15196760284853E-18  -8.05643144998341E-02  -8.05643144937841E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.05004927269494E-09   0.00000000000000E+00  -6.05004927269494E-09
      4.41147712081004E-18  -5.61868892815483E-01  -5.62295521240959E-01   0.00000000000000E+00   2.36216040890741E-10
     -1.76555381902222E-22   1.11758369190923E-09   1.35379973279979E-09  -3.25950951796151E-18
      2.26409133805664E-09
      0.00000000000000E+00  -5.32754582645980E-12   0.00000000000000E+00   7.41400345375519E-12  -4.49191739128676E-23
      5.32010520357363E-09   5.32751920702735E-09  -1.12811304880533E-18  -9.34508431226445E-02  -9.34508431157132E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.93134585976861E-09   0.00000000000000E+00  -6.93134585976861E-09
      4.37989617623647E-18  -5.66911932669198E-01  -5.67417348285916E-01   0.00000000000000E+00   2.68690549640823E-10
     -1.74878285191711E-22   1.33513610310057E-09   1.60382665274122E-09  -3.25178312743114E-18
      2.27024227555664E-09
      0.00000000000000E+00  -5.98726657382146E-12   0.00000000000000E+00   5.88896788270604E-12  -4.42733067564776E-23
      5.98134209007709E-09   5.98723105795975E-09  -1.09258235011801E-18  -1.12218224580836E-01  -1.12218224573081E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.75574518536408E-09   0.00000000000000E+00  -7.75574518536408E-09
      4.33219107233537E-18  -5.73704369063746E-01  -5.74261689683660E-01   0.00000000000000E+00   2.94082197350786E-10
     -1.72365707870170E-22   1.47443193005372E-09   1.76851412740434E-09  -3.23960872221736E-18
      2.27854604118164E-09
      0.00000000000000E+00  -6.73433166626748E-12   0.00000000000000E+00   4.99287121177921E-12  -4.32706025703894E-23
      6.72936170881245E-09   6.73435458002419E-09  -1.04112810844768E-18  -1.38547371453005E-01  -1.38547371444610E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.39557737049881E-09   0.00000000000000E+00  -8.39557737049881E-09
      4.26247616556419E-18  -5.82594234755472E-01  -5.83117783207886E-01   0.00000000000000E+00   3.02509722819744E-10
     -1.68810053460489E-22   1.35871306765495E-09   1.66122279047453E-09  -3.22134805711652E-18
      2.28975612477539E-09
      0.00000000000000E+00  -8.04348655042357E-12   0.00000000000000E+00   6.22710202703314E-12  -4.07275769266772E-23
      8.03729724577090E-09   8.04352434779789E-09  -9.69177514659354E-19  -1.73835438741983E-01  -1.73835438733177E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.80607045070036E-09   0.00000000000000E+00  -8.80607045070036E-09
      4.16375937967939E-18  -5.93367204399180E-01  -5.93607700898875E-01   0.00000000000000E+00   2.93845907820998E-10
     -1.64029559000217E-22   4.68700195081677E-10   7.62546102902511E-10  -3.19458186502004E-18
      2.30488973762696E-09
      0.00000000000000E+00  -1.21280057035167E-11   0.00000000000000E+00   1.36532693414997E-11  -2.73602607867965E-23
      1.21143288179724E-08   1.21279820873139E-08  -8.73621116856760E-19  -2.18319114468756E-01  -2.18319114459636E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.11979518819566E-09   0.00000000000000E+00  -9.11979518819566E-09
      4.02574393001569E-18  -6.02366916495667E-01  -6.01419698224788E-01   0.00000000000000E+00   2.82917445095330E-10
     -1.57572978217407E-22  -3.29110434421335E-09  -3.00818689911818E-09  -3.15212281315894E-18
      2.32488973762696E-09
      0.00000000000000E+00  -2.53681593298793E-11   0.00000000000000E+00   3.28759173401181E-11   3.41784843469144E-23
      2.53352412545205E-08   2.53681171718607E-08  -7.64026929804323E-19  -2.66895776589420E-01  -2.66895776579788E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.63276172958793E-09   0.00000000000000E+00  -9.63276172958793E-09
      3.83308869542394E-18  -5.91314726034177E-01  -5.86358423716744E-01   0.00000000000000E+00   3.00010603915501E-10
     -1.47755850518167E-22  -1.60353660461880E-08  -1.57353554422727E-08  -3.06906176561961E-18
      2.34488973762696E-09
      0.00000000000000E+00  -4.53863627174203E-11   0.00000000000000E+00   4.96293354294477E-11   1.29501611234913E-22
      4.53367800265537E-08   4.53864093619833E-08  -6.83367244137908E-19  -3.02223530337732E-01  -3.02223530327402E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03296945834088E-08   0.00000000000000E+00  -1.03296945834088E-08
      3.62649480375576E-18  -5.44721417925344E-01  -5.33678238900565E-01   0.00000000000000E+00   3.16483596700659E-10
     -1.35242605712195E-22  -3.53731983752751E-08  -3.50567147785746E-08  -2.94312755961785E-18
      2.36488973762696E-09
      0.00000000000000E+00  -6.17213166087277E-11   0.00000000000000E+00   4.06332834444435E-11   2.06204469755131E-22
      6.16806402928404E-08   6.17212735762850E-08  -6.32181087535845E-19  -3.25666020635801E-01  -3.25666020624841E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09602561594224E-08   0.00000000000000E+00  -1.09602561594224E-08
      3.40728968056731E-18  -4.62288759024005E-01  -4.46297492676914E-01   0.00000000000000E+00   2.95151879192699E-10
     -1.19576731269250E-22  -5.10561692960551E-08  -5.07610174168626E-08  -2.77510859303147E-18
      2.38488973762696E-09
      0.00000000000000E+00  -6.52897601834517E-11   0.00000000000000E+00   8.98109268054400E-12   2.23384068579014E-22
      6.52807373670905E-08   6.52897184597713E-08  -6.06905589457508E-19  -3.39042555689201E-01  -3.39042555677681E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15197815065447E-08   0.00000000000000E+00  -1.15197815065447E-08
      3.17689405043642E-18  -3.49138676323230E-01  -3.32198700243269E-01   0.00000000000000E+00   2.48077927693653E-10
     -1.03255571020641E-22  -5.40180148809201E-08  -5.37699369532266E-08  -2.56998846097891E-18
      2.40488973762696E-09
      0.00000000000000E+00  -5.72501311119909E-11   0.00000000000000E+00  -1.98664302500644E-11   1.87365380238899E-22
      5.72700161483263E-08   5.72501497180764E-08  -5.98881449716940E-19  -3.45802935328192E-01  -3.45802935316285E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19063991213772E-08   0.00000000000000E+00  -1.19063991213772E-08
      2.93876606800887E-18  -2.25371662828838E-01  -2.11085886350889E-01   0.00000000000000E+00   1.77174005423030E-10
     -8.66438075132604E-23  -4.55209246021221E-08  -4.53437505966992E-08  -2.33988461829193E-18
      2.42488973762696E-09
      0.00000000000000E+00  -4.98147485666184E-11   0.00000000000000E+00  -1.84474259489213E-11   1.47071767983142E-22
      4.98331487248745E-08   4.98147012989257E-08  -5.90272364582468E-19  -3.52861658414262E-01  -3.52861658402412E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18499496185308E-08   0.00000000000000E+00  -1.18499496185308E-08
      2.70176707563826E-18  -1.21953056165046E-01  -1.09991831783637E-01   0.00000000000000E+00   9.55848290466307E-11
     -7.48041064308319E-23  -3.80603365094416E-08  -3.79647516803950E-08  -2.11149471105579E-18
      2.44488973762696E-09
      0.00000000000000E+00  -4.27528985674688E-11   0.00000000000000E+00  -1.74821591133193E-11   1.22888374547469E-22
      4.27704025964578E-08   4.27529204373446E-08  -5.67818057135532E-19  -3.64762399963741E-01  -3.64762399952299E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14422552949030E-08   0.00000000000000E+00  -1.14422552949030E-08
      2.47292196974020E-18  -5.32557703845159E-02  -4.33908907048215E-02   0.00000000000000E+00   5.19259680623852E-11
     -1.68993482661167E-23  -3.13625911105038E-08  -3.13106651424414E-08  -1.90510391260466E-18
      2.44738973762696E-09
      0.00000000000000E+00  -4.05870159746409E-11   0.00000000000000E+00  -4.23938967300842E-11   1.19867725508598E-22
      4.06293574069122E-08   4.05869635101822E-08  -5.64220453622776E-19  -3.66445498726678E-01  -3.66445498715329E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13487026340434E-08   0.00000000000000E+00  -1.13487026340434E-08
      2.44455021315509E-18  -4.61075618601357E-02  -3.68956178376773E-02   0.00000000000000E+00   6.43430163504344E-11
      2.79250268917702E-25  -2.93026038924896E-08  -2.92382608761392E-08  -1.88032975953231E-18
      2.45076473762696E-09
      0.00000000000000E+00  -3.82597621785394E-11   0.00000000000000E+00  -3.42255032901855E-11   1.18095004420800E-22
      3.82940082736834E-08   3.82597827703933E-08  -5.57480589461194E-19  -3.69381887364130E-01  -3.69381887353029E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11015394496842E-08   0.00000000000000E+00  -1.11015394496842E-08
      2.40708251751241E-18  -3.88784437213847E-02  -3.03218278616680E-02   0.00000000000000E+00   4.95606425835663E-11
      2.43068791917261E-23  -2.72078039632923E-08  -2.71582433207087E-08  -1.84960192805121E-18
      2.45532098762696E-09
      0.00000000000000E+00  -3.59974426116436E-11   0.00000000000000E+00  -2.46319678633882E-11   1.19514805807017E-22
      3.60220882285402E-08   3.59974562606769E-08  -5.45965197915880E-19  -3.74194211619933E-01  -3.74194211609122E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08100949979582E-08   0.00000000000000E+00  -1.08100949979582E-08
      2.35782902217796E-18  -3.22220023713794E-02  -2.42863311299910E-02   0.00000000000000E+00   3.63477873503860E-11
      5.37093989418301E-23  -2.52237090500693E-08  -2.51873612627189E-08  -1.81186382426208E-18
      2.46147192512696E-09
      0.00000000000000E+00  -3.40824798408667E-11   0.00000000000000E+00  -1.54219463455945E-11   1.25138806417841E-22
      3.40978784426020E-08   3.40824564962565E-08  -5.28090533189390E-19  -3.81505335473906E-01  -3.81505335463358E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05487761669596E-08   0.00000000000000E+00  -1.05487761669596E-08
      2.29294415927350E-18  -2.66197639543681E-02  -1.92050996433725E-02   0.00000000000000E+00   2.49296439095539E-11
      8.76172398409295E-23  -2.35586099732065E-08  -2.35336803292969E-08  -1.76485362608411E-18
      2.46977569075196E-09
      0.00000000000000E+00  -3.26434564982992E-11   0.00000000000000E+00  -8.55414887760901E-12   1.34067966091651E-22
      3.26519925147890E-08   3.26434383659115E-08  -5.02503296214148E-19  -3.91878445588851E-01  -3.91878445578500E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03513281315760E-08   0.00000000000000E+00  -1.03513281315760E-08
      2.20698915656142E-18  -2.21605715922915E-02  -1.51370738407272E-02   0.00000000000000E+00   1.65493011714997E-11
      1.24198702014810E-22  -2.23086595355071E-08  -2.22921102343355E-08  -1.70448586034727E-18
      2.48098577434571E-09
      0.00000000000000E+00  -3.15563821887109E-11   0.00000000000000E+00  -4.75656640324512E-12   1.42228984163494E-22
      3.15611054644641E-08   3.15563488980610E-08  -4.68045204956705E-19  -4.05847321297654E-01  -4.05847321287449E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02052481378471E-08   0.00000000000000E+00  -1.02052481378471E-08
      2.09258747184120E-18  -1.86339536633098E-02  -1.19069274987526E-02   0.00000000000000E+00   1.14561313303260E-11
      1.58074747688277E-22  -2.13625568915443E-08  -2.13511007602138E-08  -1.62454226688449E-18
      2.49611938719727E-09
      0.00000000000000E+00  -3.05309356977888E-11   0.00000000000000E+00  -3.30532695619217E-12   1.41295609493815E-22
      3.05342281555486E-08   3.05309228285925E-08  -4.23626439031487E-19  -4.23994765251108E-01  -4.23994765241039E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00699406671898E-08   0.00000000000000E+00  -1.00699406671898E-08
      1.94019288834574E-18  -1.57631814044620E-02  -9.31659403967953E-03   0.00000000000000E+00   8.75826866659188E-12
      1.76634662294471E-22  -2.04697404300694E-08  -2.04609821614027E-08  -1.51656644931425E-18
      2.51611938719727E-09
      0.00000000000000E+00  -2.92899296086407E-11   0.00000000000000E+00  -3.02597662346582E-12   1.21377539840217E-22
      2.92929441196998E-08   2.92899181430765E-08  -3.69162503837595E-19  -4.46570346736937E-01  -4.46570346727027E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.90970632268018E-09   0.00000000000000E+00  -9.90970632268018E-09
      1.74199876189214E-18  -1.33697280952117E-02  -7.26364878909341E-03   0.00000000000000E+00   7.34750636207408E-12
      1.62320318755715E-22  -1.93875593267585E-08  -1.93802118203963E-08  -1.37283625805454E-18
      2.53611938719727E-09
      0.00000000000000E+00  -2.81313082487678E-11   0.00000000000000E+00  -2.82774949831543E-12   9.02469951165449E-23
      2.81342062550242E-08   2.81313785055260E-08  -3.18705416700787E-19  -4.67843241916370E-01  -4.67843241906602E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.76749582218965E-09   0.00000000000000E+00  -9.76749582218965E-09
      1.54664884544834E-18  -1.17603834477563E-02  -5.97451112803396E-03   0.00000000000000E+00   6.34534617151269E-12
      1.22643379358657E-22  -1.83702280295079E-08  -1.83638826833363E-08  -1.22794342874756E-18
      2.55611938719727E-09
      0.00000000000000E+00  -2.72008292161183E-11   0.00000000000000E+00  -2.26950706447011E-12   5.90207554051879E-23
      2.72030822741493E-08   2.72008127670848E-08  -2.71545191008451E-19  -4.88073109589344E-01  -4.88073109579705E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.63901400582496E-09   0.00000000000000E+00  -9.63901400582496E-09
      1.35386856533184E-18  -1.06608466981487E-02  -5.12768091766356E-03   0.00000000000000E+00   5.23977672127324E-12
      7.81049209926705E-23  -1.75670385379813E-08  -1.75617987612599E-08  -1.08232337432339E-18
      2.57611938719727E-09
      0.00000000000000E+00  -2.64051782576895E-11   0.00000000000000E+00  -1.93899882020308E-12   3.47095708987709E-23
      2.64071300040196E-08   2.64051910051994E-08  -2.27446305911162E-19  -5.07335177300287E-01  -5.07335177290802E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.48561849824816E-09   0.00000000000000E+00  -9.48561849824816E-09
      1.16415619536688E-18  -9.86587213827827E-03  -4.53504786862384E-03   0.00000000000000E+00   4.40737462137200E-12
      4.21830105652552E-23  -1.69239798815727E-08  -1.69195725069512E-08  -9.36709889455718E-19
      2.59611938719727E-09
      0.00000000000000E+00  -2.67663117643895E-11   0.00000000000000E+00   9.12184667079831E-13   1.94043665962306E-23
      2.67653651770412E-08   2.67662773617083E-08  -1.82486047158716E-19  -5.27439473686867E-01  -5.27439473676707E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01596254337936E-08   0.00000000000000E+00  -1.01596254337936E-08
      9.60963686691009E-19  -9.43990447077679E-03  -4.20766837419735E-03   0.00000000000000E+00   3.45454526679632E-12
      1.91993343892939E-23  -1.66101064731815E-08  -1.66066519279147E-08  -7.78477639532292E-19
      2.61611938719727E-09
      0.00000000000000E+00  -2.76747480601092E-11   0.00000000000000E+00   2.26803226894003E-12   1.11373451209824E-23
      2.76724646605953E-08   2.76747326928642E-08  -1.36381392130100E-19  -5.48597153654828E-01  -5.48597153643809E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10192930454479E-08   0.00000000000000E+00  -1.10192930454479E-08
      7.40577825782052E-19  -9.27469195095246E-03  -4.02708170774383E-03   0.00000000000000E+00   2.47010803083947E-12
      6.88923145609983E-24  -1.66579097554473E-08  -1.66554396474165E-08  -6.04196433651953E-19
      2.62611938719727E-09
      0.00000000000000E+00  -2.83699208760329E-11   0.00000000000000E+00   3.45625359076716E-12   8.40714665718621E-24
      2.83665013848221E-08   2.83699576384129E-08  -1.13242695286484E-19  -5.59445833239847E-01  -5.59445833228295E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15516158102161E-08   0.00000000000000E+00  -1.15516158102161E-08
      6.25061667679891E-19  -9.28644838526648E-03  -3.98751131371808E-03   0.00000000000000E+00   1.69501882633207E-12
      2.82874052678457E-24  -1.68200368470229E-08  -1.68183418281965E-08  -5.11818972393407E-19
      2.62949438719727E-09
      0.00000000000000E+00  -2.87125935905542E-11   0.00000000000000E+00   5.02135140615574E-12   7.64540677209196E-24
      2.87076020606877E-08   2.87126234120938E-08  -1.05429488943592E-19  -5.63148625172638E-01  -5.63148625160867E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17710569302397E-08   0.00000000000000E+00  -1.17710569302397E-08
      5.85334350540332E-19  -9.32887368229650E-03  -3.99111158040294E-03   0.00000000000000E+00   6.65821850307948E-13
      1.67092023133911E-24  -1.69422323037046E-08  -1.69415664818543E-08  -4.79904861596739E-19
      2.63405063719727E-09
      0.00000000000000E+00  -2.91361815185553E-11   0.00000000000000E+00   4.62561697797635E-12   6.88635696158097E-24
      2.91315893215853E-08   2.91362149385633E-08  -9.48335108420516E-20  -5.68194883540178E-01  -5.68194883528218E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19603407065104E-08   0.00000000000000E+00  -1.19603407065104E-08
      5.30840048196293E-19  -9.40950811833826E-03  -3.99792208646941E-03   0.00000000000000E+00  -8.93478374518410E-14
      5.41440500754687E-25  -1.71757848842157E-08  -1.71758742320531E-08  -4.36006537354242E-19
      2.64020157469727E-09
      0.00000000000000E+00  -2.94641590751234E-11   0.00000000000000E+00   2.67620875557045E-12   6.16961061396466E-24
      2.94614720771014E-08   2.94641482858570E-08  -8.06758950315921E-20  -5.74973487458864E-01  -5.74973487446833E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20313782036808E-08   0.00000000000000E+00  -1.20313782036808E-08
      4.56835792826591E-19  -9.47457790988388E-03  -3.98205137895511E-03   0.00000000000000E+00   3.28530236326424E-13
     -4.45911948712480E-25  -1.74330986124124E-08  -1.74327700821760E-08  -3.76159897794998E-19
      2.64850534032227E-09
      0.00000000000000E+00  -2.94108891275430E-11   0.00000000000000E+00  -2.76249722727927E-13   5.49453703511128E-24
      2.94111541255788E-08   2.94108778758560E-08  -6.23371533268156E-20  -5.83812208501792E-01  -5.83812208490000E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17920899327767E-08   0.00000000000000E+00  -1.17920899327767E-08
      3.58917041795892E-19  -9.46118773776642E-03  -3.91005208097912E-03   0.00000000000000E+00   1.15948125772112E-12
     -1.21130585190047E-24  -1.76199474243371E-08  -1.76187879430793E-08  -2.96579888469076E-19
      2.65971542391602E-09
      0.00000000000000E+00  -2.83903104076930E-11   0.00000000000000E+00  -4.46178671286049E-12   4.79761256185347E-24
      2.83948162966271E-08   2.83903545099142E-08  -4.04565943306466E-20  -5.94429398671076E-01  -5.94429398660380E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06960665674859E-08   0.00000000000000E+00  -1.06960665674859E-08
      2.39013241450059E-19  -9.30807959087396E-03  -3.73315517657213E-03   0.00000000000000E+00   1.64497247092926E-12
     -1.74241144362070E-24  -1.76959329148993E-08  -1.76942879424283E-08  -1.98556647119413E-19
      2.67484903676758E-09
      0.00000000000000E+00  -2.42852180334654E-11   0.00000000000000E+00  -1.33640080869189E-11   3.80585810164123E-24
      2.42986163723162E-08   2.42852523642293E-08  -2.28259034057191E-20  -6.02897143454979E-01  -6.02897143448387E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.59140096638223E-09   0.00000000000000E+00  -6.59140096638223E-09
      1.39261531075416E-19  -8.87161622285835E-03  -3.29682789093647E-03   0.00000000000000E+00   1.18235936145029E-12
     -2.11765779316979E-24  -1.76950337572084E-08  -1.76938513978470E-08  -1.16435627669696E-19
      2.69484903676758E-09
      0.00000000000000E+00  -1.12314173788968E-11   0.00000000000000E+00  -3.21781746140309E-11   1.70227560685275E-24
      1.12636111706417E-08   1.12314329960277E-08  -4.67547965508047E-20  -5.90378552097696E-01  -5.90378552104151E-01
      0.00000000000000E+00   0.00000000000000E+00   6.45505173807251E-09   0.00000000000000E+00   6.45505173807251E-09
      2.68362565836866E-19  -7.74454686056579E-03  -2.17207926675146E-03   0.00000000000000E+00  -1.10940457812801E-12
     -2.64814238828229E-24  -1.76853753295220E-08  -1.76864847341002E-08  -2.21607769286062E-19
      2.71484903676758E-09
      0.00000000000000E+00   7.70375286749293E-12   0.00000000000000E+00  -4.66769461725228E-11  -2.07002013969964E-24
     -7.65705158484469E-09  -7.70372853101721E-09  -1.46389782764153E-19  -5.42042625468933E-01  -5.42042625494317E-01
      0.00000000000000E+00   0.00000000000000E+00   2.53835555947295E-08   0.00000000000000E+00   2.53835555947295E-08
      7.76033677731456E-19  -6.10114314756970E-03  -5.30771788494951E-04   0.00000000000000E+00  -5.06031776908012E-12
     -4.71655912741911E-24  -1.76747667459433E-08  -1.76798270637124E-08  -6.29643894967304E-19
      2.73484903676758E-09
      0.00000000000000E+00   2.22147621225961E-11   0.00000000000000E+00  -3.59480316934026E-11  -1.18887854320654E-23
     -2.21788170045522E-08  -2.22147650362456E-08  -3.37920083543039E-19  -4.58066412050557E-01  -4.58066412090398E-01
      0.00000000000000E+00   0.00000000000000E+00   3.98416062835130E-08   0.00000000000000E+00   3.98416062835130E-08
      1.57286580340172E-18  -4.41030867368827E-03   1.14336390462353E-03   0.00000000000000E+00  -1.13889720083522E-11
     -1.83219803452423E-23  -1.76154522752590E-08  -1.76268412472674E-08  -1.23494571985868E-18
      2.75484903676758E-09
      0.00000000000000E+00   2.33664032824413E-11   0.00000000000000E+00  -3.21428951390975E-12  -3.56873495841245E-23
     -2.33631902302532E-08  -2.33664045197672E-08  -6.24042276497672E-19  -3.43721230678275E-01  -3.43721230719297E-01
      0.00000000000000E+00   0.00000000000000E+00   4.10218887707905E-08   0.00000000000000E+00   4.10218887707905E-08
      2.39330357881753E-18  -2.17241782859197E-03   3.39026823493093E-03   0.00000000000000E+00  -2.62566305385871E-11
     -6.36347203305063E-23  -1.76292276204846E-08  -1.76554842510232E-08  -1.76926130231986E-18
      2.77484903676758E-09
      0.00000000000000E+00   1.49122789119629E-11   0.00000000000000E+00   2.02230967745378E-11  -4.29213209429122E-23
     -1.49324615960381E-08  -1.49122384992636E-08  -9.05686044828558E-19  -2.20366977467775E-01  -2.20366977498947E-01
      0.00000000000000E+00   0.00000000000000E+00   3.11725792370880E-08   0.00000000000000E+00   3.11725792370880E-08
      3.01675516355929E-18  -9.45863151621693E-03  -4.33552747520734E-03   0.00000000000000E+00  -5.64182391348810E-11
     -8.13131360402636E-23  -1.62039224986894E-08  -1.62603407378243E-08  -2.11106911873073E-18
      2.79484903676758E-09
      0.00000000000000E+00   9.97709380285363E-12   0.00000000000000E+00   1.13833341734087E-11  -4.58374488754559E-23
     -9.98847202347931E-09  -9.97708868930595E-09  -1.10387145312956E-18  -1.18049058488634E-01  -1.18049058511515E-01
      0.00000000000000E+00   0.00000000000000E+00   2.28805402835529E-08   0.00000000000000E+00   2.28805402835529E-08
      3.47436596923035E-18  -3.88459726676356E-02  -3.47805198183984E-02   0.00000000000000E+00  -1.05558965925591E-10
     -9.43698163479499E-23  -1.27978926283213E-08  -1.29034515942470E-08  -2.37049451610078E-18
      2.79984903676758E-09
      0.00000000000000E+00   8.38762878074017E-12   0.00000000000000E+00   1.46847520009028E-11  -4.64423937260912E-23
     -8.40229935423450E-09  -8.38761460223365E-09  -1.14553276459022E-18  -9.47234033940783E-02  -9.47234034140497E-02
      0.00000000000000E+00   0.00000000000000E+00   1.99713987452188E-08   0.00000000000000E+00   1.99713987452188E-08
      3.57422296295644E-18  -4.82772046635136E-02  -4.46275080751266E-02   0.00000000000000E+00  -1.48177615840303E-10
     -9.78077838550440E-23  -1.14356065271449E-08  -1.15837841429853E-08  -2.42869019836622E-18
      2.80659903676758E-09
      0.00000000000000E+00   6.63982343168094E-12   0.00000000000000E+00   1.19196751048116E-11  -4.70990477002106E-23
     -6.65172099143336E-09  -6.63980131632860E-09  -1.18989947502678E-18  -6.89917458240056E-02  -6.89917458409364E-02
      0.00000000000000E+00   0.00000000000000E+00   1.69308097208446E-08   0.00000000000000E+00   1.69308097208446E-08
      3.68850592857214E-18  -6.35370531176166E-02  -6.02946670812451E-02   0.00000000000000E+00  -1.65431755483366E-10
     -1.02271699502710E-22  -1.01255766490324E-08  -1.02910084045159E-08  -2.49860645354536E-18
      2.81571153676758E-09
      0.00000000000000E+00   4.35527743838092E-12   0.00000000000000E+00   1.17234445568313E-11  -4.76347665494558E-23
     -4.36703123441401E-09  -4.35530778985723E-09  -1.22893005720906E-18  -4.54769378938986E-02  -4.54769379068904E-02
      0.00000000000000E+00   0.00000000000000E+00   1.29917312064030E-08   0.00000000000000E+00   1.29917312064030E-08
      3.80689307919049E-18  -8.81483370249545E-02  -8.54272592461801E-02   0.00000000000000E+00  -1.73028125463989E-10
     -1.07801271129601E-22  -8.46339529108178E-09  -8.63642341654587E-09  -2.57796302198143E-18
      2.81878700551758E-09
      0.00000000000000E+00   3.38245798187880E-12   0.00000000000000E+00   1.50149257421018E-11  -4.77513215055117E-23
     -3.39744003031915E-09  -3.38242510457709E-09  -1.23910885418266E-18  -3.92110719038321E-02  -3.92110719151119E-02
      0.00000000000000E+00   0.00000000000000E+00   1.12797514286178E-08   0.00000000000000E+00   1.12797514286178E-08
      3.84158360221697E-18  -9.70096035208378E-02  -9.45213839114965E-02   0.00000000000000E+00  -1.79937966633630E-10
     -1.09616219346075E-22  -7.71738835740655E-09  -7.89732632404029E-09  -2.60247474803431E-18
      2.82293888833008E-09
      0.00000000000000E+00   2.39668841743041E-12   0.00000000000000E+00   1.13697982553159E-11  -4.78577249307372E-23
     -2.40806170267108E-09  -2.39669190441581E-09  -1.24875619158596E-18  -3.31314875037591E-02  -3.31314875133124E-02
      0.00000000000000E+00   0.00000000000000E+00   9.55331101235877E-09   0.00000000000000E+00   9.55331101235877E-09
      3.88124783001165E-18  -1.09667482264681E-01  -1.07412636319354E-01   0.00000000000000E+00  -1.79138989228451E-10
     -1.11929684060964E-22  -6.97748011871445E-09  -7.15661910794301E-09  -2.63249163842568E-18
      2.82854393012695E-09
      0.00000000000000E+00   1.54886964826773E-12   0.00000000000000E+00   7.25235941240040E-12  -4.79449015255519E-23
     -1.55611967410735E-09  -1.54886731469500E-09  -1.25702909775960E-18  -2.77210847411689E-02  -2.77210847491709E-02
      0.00000000000000E+00   0.00000000000000E+00   8.00200812693634E-09   0.00000000000000E+00   8.00200812693634E-09
      3.92609942002206E-18  -1.27393370932179E-01  -1.25360169292565E-01   0.00000000000000E+00  -1.79675673529611E-10
     -1.14882658261371E-22  -6.27346513871164E-09  -6.45314081224136E-09  -2.66907032226245E-18
      2.83611073655274E-09
      0.00000000000000E+00   9.29744274751793E-13   0.00000000000000E+00   3.91897254871612E-12  -4.80104770255063E-23
     -9.33685845487291E-10  -9.29766872938623E-10  -1.26351924469697E-18  -2.32107548267367E-02  -2.32107548334895E-02
      0.00000000000000E+00   0.00000000000000E+00   6.75279317278440E-09   0.00000000000000E+00   6.75279317278440E-09
      3.97719649879386E-18  -1.51565020601047E-01  -1.49730348253350E-01   0.00000000000000E+00  -1.83798633956546E-10
     -1.18693473666214E-22  -5.63922766588891E-09  -5.82302629984558E-09  -2.71367725409689E-18
      2.84632592522754E-09
      0.00000000000000E+00   5.39036762670974E-13   0.00000000000000E+00   1.82734982079321E-12  -4.80562481900676E-23
     -5.40852414430528E-10  -5.39025064609783E-10  -1.26830490094294E-18  -1.95490057701284E-02  -1.95490057759037E-02
      0.00000000000000E+00   0.00000000000000E+00   5.77524876043440E-09   0.00000000000000E+00   5.77524876043440E-09
      4.03619175452563E-18  -1.83465681599528E-01  -1.81815891821475E-01   0.00000000000000E+00  -1.91534092723674E-10
     -1.23644599096824E-22  -5.04468960310090E-09  -5.23622369582470E-09  -2.76788685358269E-18
      2.86011642993853E-09
      0.00000000000000E+00   3.17507256526420E-13   0.00000000000000E+00   7.65996798514487E-13  -4.80851700922942E-23
     -3.18258886986538E-10  -3.17492890188071E-10  -1.27173877128069E-18  -1.65505790844204E-02  -1.65505790893128E-02
      0.00000000000000E+00   0.00000000000000E+00   4.89244176730828E-09   0.00000000000000E+00   4.89244176730828E-09
      4.10366099576592E-18  -2.23437531077465E-01  -2.21996087415240E-01   0.00000000000000E+00  -1.98454358476426E-10
     -1.29946132447125E-22  -4.37649451864364E-09  -4.57494887712020E-09  -2.83192222448523E-18
      2.87873361129836E-09
      0.00000000000000E+00   2.07201727140180E-13   0.00000000000000E+00   2.82638477300417E-13  -4.81023655452381E-23
     -2.07450043152654E-10  -2.07167404675401E-10  -1.27436251329327E-18  -1.40166750599837E-02  -1.40166750638377E-02
      0.00000000000000E+00   0.00000000000000E+00   3.85390462051893E-09   0.00000000000000E+00   3.85390462051893E-09
      4.17540983702961E-18  -2.68172072187373E-01  -2.67023079422963E-01   0.00000000000000E+00  -1.89259374970378E-10
     -1.37254991003529E-22  -3.45747784087313E-09  -3.64673721584365E-09  -2.90104732373634E-18
      2.89873361129836E-09
      0.00000000000000E+00   1.62289650645700E-13   0.00000000000000E+00   1.07514988462431E-13  -4.81112120978395E-23
     -1.62412552880861E-10  -1.62305037892447E-10  -1.27631846162425E-18  -1.22009155835557E-02  -1.22009155863348E-02
      0.00000000000000E+00   0.00000000000000E+00   2.77904609804407E-09   0.00000000000000E+00   2.77904609804407E-09
      4.23099075899049E-18  -3.03095292337847E-01  -3.02270821829376E-01   0.00000000000000E+00  -1.56293672925871E-10
     -1.43180411004089E-22  -2.46044738722547E-09  -2.61674106015148E-09  -2.95467229736624E-18
      2.91873361129836E-09
      0.00000000000000E+00   1.39787690029856E-13   0.00000000000000E+00   5.55089894291124E-14  -4.81143660603086E-23
     -1.39838362129960E-10  -1.39782853140579E-10  -1.27784768693183E-18  -1.09670568626549E-02  -1.09670568645551E-02
      0.00000000000000E+00   0.00000000000000E+00   1.90025168481057E-09   0.00000000000000E+00   1.90025168481057E-09
      4.26899579268670E-18  -3.26218051737111E-01  -3.25663372309068E-01   0.00000000000000E+00  -1.12245949147022E-10
     -1.47186331892166E-22  -1.64822288252288E-09  -1.76046883167005E-09  -2.99114810575487E-18
      2.93873361129836E-09
      0.00000000000000E+00   1.31154284732348E-13   0.00000000000000E+00   2.22938499919520E-14  -4.81159158911833E-23
     -1.31131649177741E-10  -1.31109355327797E-10  -1.27921874246579E-18  -1.00895759926724E-02  -1.00895759938759E-02
      0.00000000000000E+00   0.00000000000000E+00   1.20350623302882E-09   0.00000000000000E+00   1.20350623302882E-09
      4.29306591734728E-18  -3.39336833677339E-01  -3.38998952842047E-01   0.00000000000000E+00  -6.55590980973993E-11
     -1.49450919674240E-22  -1.00683777960346E-09  -1.07239687770101E-09  -3.01384717488149E-18
      2.95873361129836E-09
      0.00000000000000E+00   1.18020487311672E-13   0.00000000000000E+00   3.49113559099373E-14  -4.81129982619790E-23
     -1.18039109015281E-10  -1.18004197659419E-10  -1.28033807462810E-18  -9.52772459182875E-03  -9.52772459257459E-03
      0.00000000000000E+00   0.00000000000000E+00   7.45831825886256E-10   0.00000000000000E+00   7.45831825886256E-10
      4.30798255386501E-18  -3.45989095315004E-01  -3.45791291136030E-01   0.00000000000000E+00  -3.16573727337915E-11
     -1.50531015686071E-22  -5.96170255492836E-10  -6.27827628226778E-10  -3.02764447923690E-18
      2.96873361129836E-09
      0.00000000000000E+00   9.78146451260160E-14   0.00000000000000E+00   1.04988033733865E-13  -4.81071787566443E-23
     -9.79521162520154E-11  -9.78471282183296E-11  -1.28069864693380E-18  -9.38404977527519E-03  -9.38404977589319E-03
      0.00000000000000E+00   0.00000000000000E+00   6.17997846071896E-10   0.00000000000000E+00   6.17997846071896E-10
      4.31416253232572E-18  -3.48654529678586E-01  -3.48490652662420E-01   0.00000000000000E+00  -2.37112883526907E-11
     -1.50930393646962E-22  -4.96439429500980E-10  -5.20150717853822E-10  -3.03346388539193E-18
      2.97548361129836E-09
      0.00000000000000E+00   8.26602634867741E-14   0.00000000000000E+00   1.19032844639532E-13  -4.81013937629507E-23
     -8.28146393223231E-11  -8.26956064777317E-11  -1.28084100914478E-18  -9.34036674571298E-03  -9.34036674635383E-03
      0.00000000000000E+00   0.00000000000000E+00   6.40853847634880E-10   0.00000000000000E+00   6.40853847634880E-10
      4.31848829579726E-18  -3.50746298550818E-01  -3.50570445482672E-01   0.00000000000000E+00  -2.80346715514800E-11
     -1.51243272150095E-22  -5.30123569605543E-10  -5.58158241157174E-10  -3.03764728665248E-18
      2.98003986129836E-09
      0.00000000000000E+00   7.66903555682848E-14   0.00000000000000E+00   7.49462075373172E-14  -4.80973034699157E-23
     -7.67593932114661E-11  -7.66844470039768E-11  -1.28091032296227E-18  -9.32176450816930E-03  -9.32176450884833E-03
      0.00000000000000E+00   0.00000000000000E+00   6.79025798246588E-10   0.00000000000000E+00   6.79025798246588E-10
      4.32158210709052E-18  -3.52334369487034E-01  -3.52144594762584E-01   0.00000000000000E+00  -3.22496285659446E-11
     -1.51484549755983E-22  -5.70091722676687E-10  -6.02341351242783E-10  -3.04067178412826E-18
      2.98619079879836E-09
      0.00000000000000E+00   6.67711239498719E-14   0.00000000000000E+00   9.01700494576791E-14  -4.80906334630392E-23
     -6.68791618580639E-11  -6.67889918086543E-11  -1.28094430068610E-18  -9.31679311979286E-03  -9.31679312057506E-03
      0.00000000000000E+00   0.00000000000000E+00   7.82199031801220E-10   0.00000000000000E+00   7.82199031801220E-10
      4.32639336444769E-18  -3.55064025455311E-01  -3.54838624046574E-01   0.00000000000000E+00  -4.27446227816223E-11
     -1.51912492387534E-22  -6.72665417210565E-10  -7.15410039992339E-10  -3.04544906376159E-18
      2.99449456442336E-09
      0.00000000000000E+00   4.97798475664795E-14   0.00000000000000E+00   1.14780495976425E-13  -4.80790131772334E-23
     -4.98556691962243E-11  -4.97408887002959E-11  -1.28085152083712E-18  -9.35056863965822E-03  -9.35056864065970E-03
      0.00000000000000E+00   0.00000000000000E+00   1.00148502080712E-09   0.00000000000000E+00   1.00148502080712E-09
      4.33470946133742E-18  -3.60365955761221E-01  -3.60066088278420E-01   0.00000000000000E+00  -6.45657404316357E-11
     -1.52776226078010E-22  -8.87178391675069E-10  -9.51744132106858E-10  -3.05385794050030E-18
      3.00009960622023E-09
      0.00000000000000E+00   3.01250738040688E-14   0.00000000000000E+00   1.88684835375618E-13  -4.80687665952013E-23
     -3.03298152024574E-11  -3.01411303671299E-11  -1.28068064749154E-18  -9.41040577068349E-03  -9.41040577189908E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21559124271461E-09   0.00000000000000E+00   1.21559124271461E-09
      4.34152290106075E-18  -3.65045746802042E-01  -3.64672240965067E-01   0.00000000000000E+00  -8.71133390251587E-11
     -1.53554589743291E-22  -1.09833677332209E-09  -1.18545011234740E-09  -3.06084225356921E-18
      3.00388300943312E-09
      0.00000000000000E+00   1.95629290252032E-14   0.00000000000000E+00   1.57161574658544E-13  -4.80613456980876E-23
     -1.97022078212788E-11  -1.95450462466683E-11  -1.28052604360806E-18  -9.45982097184835E-03  -9.45982097323091E-03
      0.00000000000000E+00   0.00000000000000E+00   1.38256917107462E-09   0.00000000000000E+00   1.38256917107462E-09
      4.34675371770464E-18  -3.68756505195380E-01  -3.68327047516910E-01   0.00000000000000E+00  -1.04620832741945E-10
     -1.54181243994207E-22  -1.25840329208553E-09  -1.36302412482763E-09  -3.06622767409658E-18
      3.00899060377053E-09
      0.00000000000000E+00   2.10324448205236E-14   0.00000000000000E+00   5.31871930942384E-15  -4.80525330080453E-23
     -2.10409177540034E-11  -2.10355990347420E-11  -1.28032658043794E-18  -9.49979461923717E-03  -9.49979462081002E-03
      0.00000000000000E+00   0.00000000000000E+00   1.57285357250114E-09   0.00000000000000E+00   1.57285357250114E-09
      4.35478721570511E-18  -3.74496966244790E-01  -3.74008021888749E-01   0.00000000000000E+00  -1.23090161420262E-10
     -1.55171026258062E-22  -1.42872781204582E-09  -1.55181797346624E-09  -3.07446063526717E-18
      3.01588585612602E-09
      0.00000000000000E+00   3.21456580226344E-14   0.00000000000000E+00  -6.27597168443688E-14  -4.80426580602882E-23
     -3.20528485104529E-11  -3.21156082273454E-11  -1.28013681259407E-18  -9.48555368313727E-03  -9.48555368485824E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72097119091044E-09   0.00000000000000E+00   1.72097119091044E-09
      4.36665374636297E-18  -3.82916093210336E-01  -3.82383969971402E-01   0.00000000000000E+00  -1.37990974114587E-10
     -1.56655095988531E-22  -1.55086460856845E-09  -1.68885558268319E-09  -3.08651693376890E-18
      3.02519444680594E-09
      0.00000000000000E+00   4.61979028153860E-14   0.00000000000000E+00  -6.15542876199050E-14  -4.80318202382850E-23
     -4.61464887491838E-11  -4.62080430368517E-11  -1.28001744443946E-18  -9.37240595684634E-03  -9.37240595863703E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79069448619186E-09   0.00000000000000E+00   1.79069448619186E-09
      4.38332258836771E-18  -3.94611756740590E-01  -3.94062104699147E-01   0.00000000000000E+00  -1.47329601624188E-10
     -1.58763140566809E-22  -1.59715684153031E-09  -1.74448644315466E-09  -3.10330514392825E-18
      3.03776104422382E-09
      0.00000000000000E+00   6.49342292057214E-14   0.00000000000000E+00  -6.41178422000229E-14  -4.80217191269297E-23
     -6.48692906322268E-11  -6.49334084744748E-11  -1.28010137467636E-18  -9.07489573420439E-03  -9.07489573599722E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79282936301153E-09   0.00000000000000E+00   1.79282936301153E-09
      4.40585235321165E-18  -4.10157025780646E-01  -4.09612600742360E-01   0.00000000000000E+00  -1.52032229346023E-10
     -1.61641509996442E-22  -1.57586372519084E-09  -1.72789595453702E-09  -3.12575097853529E-18
      3.05472595073797E-09
      0.00000000000000E+00   1.01304745139902E-13   0.00000000000000E+00  -1.02994235591656E-13  -4.80201953506190E-23
     -1.01152279678643E-10  -1.01255273914282E-10  -1.28084660771854E-18  -8.31272758753974E-03  -8.31272758931252E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77277942852387E-09   0.00000000000000E+00   1.77277942852387E-09
      4.43592739048675E-18  -4.30170996718211E-01  -4.29644333024244E-01   0.00000000000000E+00  -1.55060998132080E-10
     -1.65504631247870E-22  -1.51646315647745E-09  -1.67152415460970E-09  -3.15508078276822E-18
      3.07472595073797E-09
      0.00000000000000E+00   1.51084592706382E-13   0.00000000000000E+00  -1.29591152615551E-13  -4.80369417314227E-23
     -1.50970099609485E-10  -1.51099690762149E-10  -1.28273998379766E-18  -6.83514788584109E-03  -6.83514788759825E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75715572887762E-09   0.00000000000000E+00   1.75715572887762E-09
      4.47107050506430E-18  -4.52355669790112E-01  -4.51849633008594E-01   0.00000000000000E+00  -1.58834326624803E-10
     -1.70034082117484E-22  -1.44722171149042E-09  -1.60605603811539E-09  -3.18833052126664E-18
      3.09472595073797E-09
      0.00000000000000E+00   1.72117037526905E-13   0.00000000000000E+00  -6.29610337706688E-14  -4.80596690820982E-23
     -1.72093675515961E-10  -1.72156636549780E-10  -1.28506996608628E-18  -5.12609234240543E-03  -5.12609234411083E-03
      0.00000000000000E+00   0.00000000000000E+00   1.70539478130117E-09   0.00000000000000E+00   1.70539478130117E-09
      4.50517840069033E-18  -4.73327206277190E-01  -4.72844111788284E-01   0.00000000000000E+00  -1.61737591438987E-10
     -1.74511849746438E-22  -1.37150055331220E-09  -1.53323814475136E-09  -3.22010843460405E-18
      3.11472595073797E-09
      0.00000000000000E+00   1.82771027042978E-13   0.00000000000000E+00  -3.91835072767706E-14  -4.80858124749115E-23
     -1.82683493805329E-10  -1.82722677312654E-10  -1.28762500453554E-18  -3.30723287570263E-03  -3.30723287735263E-03
      0.00000000000000E+00   0.00000000000000E+00   1.64999745685462E-09   0.00000000000000E+00   1.64999745685462E-09
      4.53817834982742E-18  -4.93289171737656E-01  -4.92826859801646E-01   0.00000000000000E+00  -1.64522313882871E-10
     -1.78941456794133E-22  -1.30275246565892E-09  -1.46727477954197E-09  -3.25055334529188E-18
      3.13472595073797E-09
      0.00000000000000E+00   8.92730845657160E-14   0.00000000000000E+00   2.32800062989227E-13  -4.80729278557997E-23
     -8.95305547494109E-11  -8.92977546864697E-11  -1.28832896770291E-18  -2.63208420303666E-03  -2.63208420447335E-03
      0.00000000000000E+00   0.00000000000000E+00   1.43668836470667E-09   0.00000000000000E+00   1.43668836470667E-09
      4.56691211712155E-18  -5.12485593696360E-01  -5.12061055126294E-01   0.00000000000000E+00  -1.58035926199271E-10
     -1.83086878353666E-22  -1.18935468382088E-09  -1.34739061002033E-09  -3.27858314941865E-18
      3.15472595073797E-09
      0.00000000000000E+00  -1.68663675407902E-12   0.00000000000000E+00   4.66595638366763E-12  -4.73335274242223E-23
      1.68198854345990E-09   1.68665449984352E-09  -1.25367424466680E-18  -2.31104350342965E-02  -2.31104350328516E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.44485569743382E-09   0.00000000000000E+00  -1.44485569743382E-09
      4.53801500317288E-18  -5.32978852024369E-01  -5.32902691507407E-01   0.00000000000000E+00   5.64839514639378E-12
     -1.82932805767305E-22  -2.47447197555932E-10  -2.41798802409722E-10  -3.28434075850608E-18
      3.17472595073797E-09
      0.00000000000000E+00  -3.45951571639591E-12   0.00000000000000E+00   4.86990194326077E-12  -4.60061477623715E-23
      3.45463300439448E-09   3.45950290633770E-09  -1.18440877788612E-18  -6.26491945423827E-02  -6.26491945381668E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.21589260397277E-09   0.00000000000000E+00  -4.21589260397277E-09
      4.45369715109342E-18  -5.54324407977886E-01  -5.54562787410822E-01   0.00000000000000E+00   1.54967395773642E-10
     -1.78806613673116E-22   6.01422301861669E-10   7.56389697635133E-10  -3.26928837320730E-18
      3.17722595073797E-09
      0.00000000000000E+00  -4.04934261874265E-12   0.00000000000000E+00   1.20056062447468E-11  -4.57916127676359E-23
      4.03731618168183E-09   4.04932178792653E-09  -1.17430568810629E-18  -6.82822557965829E-02  -6.82822557915019E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.08096523468974E-09   0.00000000000000E+00  -5.08096523468974E-09
      4.44099473800670E-18  -5.57013759455301E-01  -5.57338872123468E-01   0.00000000000000E+00   1.92560316750240E-10
     -1.78161024026839E-22   8.39083130013319E-10   1.03164344676338E-09  -3.26668904990040E-18
      3.18060095073797E-09
      0.00000000000000E+00  -4.58599141824623E-12   0.00000000000000E+00   8.44715394651863E-12  -4.54937648144273E-23
      4.57751185385682E-09   4.58595900780330E-09  -1.15892823122735E-18  -7.67572169401235E-02  -7.67572169342385E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.88506496434208E-09   0.00000000000000E+00  -5.88506496434208E-09
      4.42113264375205E-18  -5.60705381873786E-01  -5.61114774104885E-01   0.00000000000000E+00   2.28175558380510E-10
     -1.77120218416745E-22   1.07093039815902E-09   1.29910595653936E-09  -3.26220441252469E-18
      3.18515720073797E-09
      0.00000000000000E+00  -5.19473833645771E-12   0.00000000000000E+00   7.18844174102803E-12  -4.50563653058127E-23
      5.18757250185674E-09   5.19476094359772E-09  -1.13559706298530E-18  -8.94271261280305E-02  -8.94271261212726E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.75789626103955E-09   0.00000000000000E+00  -6.75789626103955E-09
      4.39034197891268E-18  -5.65748027178096E-01  -5.66240619496609E-01   0.00000000000000E+00   2.63612428282505E-10
     -1.75481199964028E-22   1.29952288915953E-09   1.56313531744186E-09  -3.25474491592738E-18
      3.18823266948797E-09
      0.00000000000000E+00  -5.61327480391241E-12   0.00000000000000E+00   7.29870066800188E-12  -4.47422083355613E-23
      5.60596109335310E-09   5.61325979402105E-09  -1.11869637167036E-18  -9.84725879272904E-02  -9.84725879199664E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.32405870084400E-09   0.00000000000000E+00  -7.32405870084400E-09
      4.36781706525507E-18  -5.69162311987639E-01  -5.69701436374050E-01   0.00000000000000E+00   2.82169779670382E-10
     -1.74286642636442E-22   1.42862912715302E-09   1.71079890682322E-09  -3.24912069358471E-18
      3.19238455230047E-09
      0.00000000000000E+00  -6.06055867411307E-12   0.00000000000000E+00   5.91842075128268E-12  -4.43002147927135E-23
      6.05465844457666E-09   6.06057686532789E-09  -1.09437905291052E-18  -1.11284252941390E-01  -1.11284252933515E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.87494621501471E-09   0.00000000000000E+00  -7.87494621501471E-09
      4.33512121141559E-18  -5.73757796725005E-01  -5.74329564539916E-01   0.00000000000000E+00   2.98082305436985E-10
     -1.72566373892876E-22   1.51628704425040E-09   1.81436934968722E-09  -3.24074215850507E-18
      3.19798959409734E-09
      0.00000000000000E+00  -6.56065326820805E-12   0.00000000000000E+00   4.97405578064630E-12  -4.36544221004288E-23
      6.55569802577341E-09   6.56067208155402E-09  -1.05980160820341E-18  -1.29109840938208E-01  -1.29109840929860E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.34809989948233E-09   0.00000000000000E+00  -8.34809989948233E-09
      4.28832976255450E-18  -5.79852351272298E-01  -5.80415649532865E-01   0.00000000000000E+00   3.05244698143557E-10
     -1.70156618514219E-22   1.48218311978447E-09   1.78742781792786E-09  -3.22852815435110E-18
      3.20555640052312E-09
      0.00000000000000E+00  -7.25619346308065E-12   0.00000000000000E+00   5.04847822688301E-12  -4.25044574950957E-23
      7.25117286292305E-09   7.25622134114989E-09  -1.01145597560109E-18  -1.53312267664898E-01  -1.53312267656199E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.69944951153583E-09   0.00000000000000E+00  -8.69944951153583E-09
      4.22250271208986E-18  -5.87686332740813E-01  -5.88141226107545E-01   0.00000000000000E+00   3.01319624284975E-10
     -1.66889223387861E-22   1.14190854610123E-09   1.44322817038603E-09  -3.21104673648876E-18
      3.21577158919793E-09
      0.00000000000000E+00  -8.74738461638205E-12   0.00000000000000E+00   7.62713265500291E-12  -3.90461024712473E-23
      8.73975286312122E-09   8.74737999577619E-09  -9.45358829159351E-19  -1.85165574113978E-01  -1.85165574105029E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.94853390777096E-09   0.00000000000000E+00  -8.94853390777096E-09
      4.13109174985909E-18  -5.96873228695940E-01  -5.96936900325411E-01   0.00000000000000E+00   2.89165064525645E-10
     -1.62555911022093E-22  -8.80111525306916E-11   2.01153911994791E-10  -3.18573292069974E-18
      3.22956209390892E-09
      0.00000000000000E+00  -1.32463990684928E-11   0.00000000000000E+00   1.64042853068965E-11  -2.29521177853459E-23
      1.32299109906914E-08   1.32463152759983E-08  -8.58876722599798E-19  -2.24974717683058E-01  -2.24974717673852E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.20646870242921E-09   0.00000000000000E+00  -9.20646870242921E-09
      4.00412989984669E-18  -6.03715073397347E-01  -6.02442894215517E-01   0.00000000000000E+00   2.80993251406945E-10
     -1.56651936123590E-22  -4.32083982497591E-09  -4.03984657356912E-09  -3.14525317724689E-18
      3.24817927526875E-09
      0.00000000000000E+00  -2.65162185449734E-11   0.00000000000000E+00   3.53726483552316E-11   3.96316018621954E-23
      2.64808676010130E-08   2.65162402493683E-08  -7.58310921968368E-19  -2.69367388269343E-01  -2.69367388259652E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.69176874642675E-09   0.00000000000000E+00  -9.69176874642675E-09
      3.82369648339691E-18  -5.91562515001571E-01  -5.86263132709024E-01   0.00000000000000E+00   3.00463920758681E-10
     -1.47416038989402E-22  -1.71249354237000E-08  -1.68244715029415E-08  -3.06538556142855E-18
      3.26817927526875E-09
      0.00000000000000E+00  -4.66819245804696E-11   0.00000000000000E+00   4.99699420384545E-11   1.35806949866642E-22
      4.66318949310625E-08   4.66818648731011E-08  -6.79490445535100E-19  -3.03920519765321E-01  -3.03920519754949E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03722092966008E-08   0.00000000000000E+00  -1.03722092966008E-08
      3.61625229746490E-18  -5.42630365118752E-01  -5.31192448776077E-01   0.00000000000000E+00   3.19120304697744E-10
     -1.34672849990386E-22  -3.66287758811980E-08  -3.63096555765004E-08  -2.93676185192980E-18
      3.28817927526875E-09
      0.00000000000000E+00  -6.25247743698192E-11   0.00000000000000E+00   3.94203116525373E-11   2.10089711350386E-22
      6.24853523473140E-08   6.25247726589667E-08  -6.29892634644857E-19  -3.26736745625377E-01  -3.26736745614383E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09939923119398E-08   0.00000000000000E+00  -1.09939923119398E-08
      3.39637245122610E-18  -4.58160409074146E-01  -4.41926601136639E-01   0.00000000000000E+00   2.94910277517239E-10
     -1.18835480351767E-22  -5.18256906245441E-08  -5.15307803470270E-08  -2.76647981658125E-18
      3.30817927526875E-09
      0.00000000000000E+00  -6.52597269543849E-11   0.00000000000000E+00   6.90982240979678E-12   2.23429257741384E-22
      6.52528554926526E-08   6.52597653150626E-08  -6.05961449655939E-19  -3.39591110116498E-01  -3.39591110104948E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15496244623818E-08   0.00000000000000E+00  -1.15496244623818E-08
      3.16537996197847E-18  -3.43445234978273E-01  -3.26524066988870E-01   0.00000000000000E+00   2.46443918378548E-10
     -1.02482997565325E-22  -5.39565847710593E-08  -5.37101408526809E-08  -2.55941851232253E-18
      3.32817927526875E-09
      0.00000000000000E+00  -5.69046112106162E-11   0.00000000000000E+00  -2.06860548483014E-11   1.85689730407354E-22
      5.69253078515202E-08   5.69046217966721E-08  -5.98397332474892E-19  -3.46175634132525E-01  -3.46175634120610E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19159097947527E-08   0.00000000000000E+00  -1.19159097947527E-08
      2.92706176608341E-18  -2.19927226890766E-01  -2.05753279636944E-01   0.00000000000000E+00   1.73418118876494E-10
     -8.58968925869599E-23  -4.51621301207958E-08  -4.49887120019194E-08  -2.32866443360852E-18
      3.34817927526875E-09
      0.00000000000000E+00  -4.95338873602377E-11   0.00000000000000E+00  -1.82880012282463E-11   1.45457323211833E-22
      4.95522091772088E-08   4.95339211759807E-08  -5.89627162024946E-19  -3.53296030986417E-01  -3.53296030974574E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18427971105727E-08   0.00000000000000E+00  -1.18427971105727E-08
      2.69020582387196E-18  -1.17634610745086E-01  -1.05759587837559E-01   0.00000000000000E+00   9.27880346843111E-11
     -7.40184004470477E-23  -3.77839121000922E-08  -3.76911240654080E-08  -2.10057866184702E-18
      3.35317927526875E-09
      0.00000000000000E+00  -4.68697470680590E-11   0.00000000000000E+00  -2.63362261954773E-11   1.34128453293257E-22
      4.68960728691805E-08   4.68697366429851E-08  -5.87765471124991E-19  -3.54930493875634E-01  -3.54930493863770E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18632685589181E-08   0.00000000000000E+00  -1.18632685589181E-08
      2.63088948107737E-18  -9.43348416219999E-02  -8.33056095006700E-02   0.00000000000000E+00   7.56263026497704E-11
     -6.78166411108158E-23  -3.50820943867168E-08  -3.50064680840671E-08  -2.04312400995238E-18
      3.35655427526875E-09
      0.00000000000000E+00  -4.51601491296781E-11   0.00000000000000E+00  -2.51185022452614E-11   1.27099863159031E-22
      4.51851842180626E-08   4.51600657158175E-08  -5.85861519821853E-19  -3.56270674503021E-01  -3.56270674491237E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17839446739228E-08   0.00000000000000E+00  -1.17839446739228E-08
      2.59111866780288E-18  -8.01654188978925E-02  -6.96498265581506E-02   0.00000000000000E+00   6.47341815602836E-11
     -5.99825329334119E-23  -3.34408552234551E-08  -3.33761210418949E-08  -2.00525714798103E-18
      3.36111052526875E-09
      0.00000000000000E+00  -4.29371391103071E-11   0.00000000000000E+00  -2.41673278446966E-11   1.20157190963768E-22
      4.29613209333428E-08   4.29371536054982E-08  -5.81383990316197E-19  -3.58743722376746E-01  -3.58743722365155E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15914554360217E-08   0.00000000000000E+00  -1.15914554360217E-08
      2.53830509897251E-18  -6.40491824089466E-02  -5.41732799114820E-02   0.00000000000000E+00   5.51412559666520E-11
     -4.27147039702509E-23  -3.14008394254431E-08  -3.13456981694765E-08  -1.95692110865631E-18
      3.36726146276875E-09
      0.00000000000000E+00  -3.99542057352811E-11   0.00000000000000E+00  -2.39887988110114E-11   1.16175917336731E-22
      3.99782128397132E-08   3.99542240409024E-08  -5.71283868966823E-19  -3.63456889451769E-01  -3.63456889440499E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12698110755504E-08   0.00000000000000E+00  -1.12698110755504E-08
      2.46898519540999E-18  -4.78376192844307E-02  -3.88001711537587E-02   0.00000000000000E+00   4.59990767991523E-11
     -8.33168892883305E-24  -2.87304120421510E-08  -2.86844129653519E-08  -1.89770132644316E-18
      3.37141334558125E-09
      0.00000000000000E+00  -3.78179889925712E-11   0.00000000000000E+00  -2.54145389712220E-11   1.15978173077337E-22
      3.78433962120279E-08   3.78179816730568E-08  -5.62404815037985E-19  -3.67316687857329E-01  -3.67316687846299E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10299176624236E-08   0.00000000000000E+00  -1.10299176624236E-08
      2.42319026984408E-18  -3.95621068045167E-02  -3.11221207336137E-02   0.00000000000000E+00   4.16202015914254E-11
      1.93554847012556E-23  -2.68296842122248E-08  -2.67880640106334E-08  -1.86078545480610E-18
      3.37701838737812E-09
      0.00000000000000E+00  -3.56375949312645E-11   0.00000000000000E+00  -1.92546386366466E-11   1.19590194439837E-22
      3.56568521620959E-08   3.56375975234594E-08  -5.47673462386607E-19  -3.73466750817117E-01  -3.73466750806368E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07489310363205E-08   0.00000000000000E+00  -1.07489310363205E-08
      2.36294206211378E-18  -3.20225490211606E-02  -2.41809848234361E-02   0.00000000000000E+00   3.14973485866001E-11
      5.43220036351877E-23  -2.49201638357255E-08  -2.48886664871388E-08  -1.81526859972717E-18
      3.38458519380390E-09
      0.00000000000000E+00  -3.37582679185241E-11   0.00000000000000E+00  -1.22750888587553E-11   1.27835739391975E-22
      3.37705442165928E-08   3.37582691277341E-08  -5.25220398283846E-19  -3.82642259874404E-01  -3.82642259863907E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04964220096705E-08   0.00000000000000E+00  -1.04964220096705E-08
      2.28351766860329E-18  -2.58404426997218E-02  -1.85114216934897E-02   0.00000000000000E+00   2.18705717798915E-11
      9.47864775930714E-23  -2.32837176898436E-08  -2.32618471180636E-08  -1.75829727031944E-18
      3.39480038247871E-09
      0.00000000000000E+00  -3.23298985654727E-11   0.00000000000000E+00  -6.88357792075018E-12   1.38617989185001E-22
      3.23367680489540E-08   3.23298844710334E-08  -4.93623661686342E-19  -3.95452055890500E-01  -3.95452055880196E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03044425114554E-08   0.00000000000000E+00  -1.03044425114554E-08
      2.17825584416010E-18  -2.10892017629749E-02  -1.41497194925525E-02   0.00000000000000E+00   1.46356064942420E-11
      1.36802873032065E-22  -2.20400775660724E-08  -2.20254419595781E-08  -1.68463218247375E-18
      3.40859088718969E-09
      0.00000000000000E+00  -3.11945139241132E-11   0.00000000000000E+00  -4.02765400966534E-12   1.45104896178392E-22
      3.11985253633984E-08   3.11944977093889E-08  -4.51832658549944E-19  -4.12435457738475E-01  -4.12435457728321E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01540969449046E-08   0.00000000000000E+00  -1.01540969449046E-08
      2.03822572240558E-18  -1.74636256971453E-02  -1.08344875323729E-02   0.00000000000000E+00   1.02799777152794E-11
      1.70298061230665E-22  -2.10506807421998E-08  -2.10404007644843E-08  -1.58639306385563E-18
      3.42720806854953E-09
      0.00000000000000E+00  -2.99986954456712E-11   0.00000000000000E+00  -3.13159125924776E-12   1.35650698894706E-22
      3.00018555691559E-08   2.99987239778968E-08  -3.98916768296516E-19  -4.34185329184551E-01  -4.34185329174553E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.99794973511961E-09   0.00000000000000E+00  -9.99794973511961E-09
      1.85209207896038E-18  -1.45851570847201E-02  -8.28356256526539E-03   0.00000000000000E+00   8.05267398506263E-12
      1.76389297942185E-22  -2.00088269167623E-08  -2.00007742427771E-08  -1.45317531066386E-18
      3.44720806854953E-09
      0.00000000000000E+00  -2.87520868275535E-11   0.00000000000000E+00  -3.04220774416269E-12   1.08864280853244E-22
      2.87551622473298E-08   2.87521200395858E-08  -3.46361432096816E-19  -4.56135159236127E-01  -4.56135159226282E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.84470610887159E-09   0.00000000000000E+00  -9.84470610887159E-09
      1.65519795678294E-18  -1.25787874597483E-02  -6.62166885619023E-03   0.00000000000000E+00   6.95426275661359E-12
      1.47563289687537E-22  -1.89143681934710E-08  -1.89074139307142E-08  -1.30883652468613E-18
      3.46720806854953E-09
      0.00000000000000E+00  -2.76952294365064E-11   0.00000000000000E+00  -2.57914500164497E-12   7.62125115617368E-23
      2.76978386887441E-08   2.76952595437425E-08  -2.97434216712371E-19  -4.76922516266197E-01  -4.76922516256486E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.71106832132900E-09   0.00000000000000E+00  -9.71106832132900E-09
      1.46097659035636E-18  -1.12248174907453E-02  -5.55857168696699E-03   0.00000000000000E+00   5.83386658146908E-12
      1.03040267663475E-22  -1.79900250889950E-08  -1.79841912224135E-08  -1.16354237364399E-18
      3.48720806854953E-09
      0.00000000000000E+00  -2.68302357014860E-11   0.00000000000000E+00  -2.10898018401853E-12   4.73307718224831E-23
      2.68323427957590E-08   2.68302338155750E-08  -2.51672431471768E-19  -4.96707689241930E-01  -4.96707689232360E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.57042471914985E-09   0.00000000000000E+00  -9.57042471914985E-09
      1.26956809597337E-18  -1.02785163409649E-02  -4.84049621502346E-03   0.00000000000000E+00   4.83863689660151E-12
      6.09421054589367E-23  -1.72646477333218E-08  -1.72598090964252E-08  -1.01789566450160E-18
      3.50720806854953E-09
      0.00000000000000E+00  -2.63418972337535E-11   0.00000000000000E+00  -1.18203096347063E-12   2.69241761068723E-23
      2.63430548133696E-08   2.63418727824061E-08  -2.07909312080661E-19  -5.16004170421768E-01  -5.16004170412146E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.62197878970355E-09   0.00000000000000E+00  -9.62197878970355E-09
      1.07712852017930E-18  -9.62048943030762E-03  -4.35257609925562E-03   0.00000000000000E+00   4.04628454889193E-12
      3.05520229833707E-23  -1.67239402772515E-08  -1.67198939927025E-08  -8.69219208098634E-19
      3.52720806854953E-09
      0.00000000000000E+00  -2.71864095923767E-11   0.00000000000000E+00   2.10557196994932E-12   1.50739492905679E-23
      2.71842698115018E-08   2.71863753834718E-08  -1.62164007113436E-19  -5.36697982360157E-01  -5.36697982349572E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05849851375070E-08   0.00000000000000E+00  -1.05849851375070E-08
      8.65428817429155E-19  -9.35215184609029E-03  -4.12157221323944E-03   0.00000000000000E+00   2.94583389348760E-12
      1.27058201607848E-23  -1.66043360798583E-08  -1.66013902459648E-08  -7.03264810315720E-19
      3.54720806854953E-09
      0.00000000000000E+00  -2.81104594934217E-11   0.00000000000000E+00   2.30950634735437E-12   9.01646849022198E-24
      2.81081877120983E-08   2.81104972184457E-08  -1.15962938941042E-19  -5.58151565844255E-01  -5.58151565832922E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13324557222698E-08   0.00000000000000E+00  -1.13324557222698E-08
      6.38779702983760E-19  -9.25897617167538E-03  -3.97273683967441E-03   0.00000000000000E+00   2.09929992317171E-12
      3.81221803068176E-24  -1.67801407960992E-08  -1.67780414961760E-08  -5.22816764042718E-19
      3.54970806854953E-09
      0.00000000000000E+00  -2.83715740813027E-11   0.00000000000000E+00   5.13137911581019E-12   8.31124308666631E-24
      2.83664475741116E-08   2.83715789532275E-08  -1.10247110859609E-19  -5.60855385446471E-01  -5.60855385434897E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15747054131341E-08   0.00000000000000E+00  -1.15747054131341E-08
      6.09842939450925E-19  -9.26321452680435E-03  -3.97104141249103E-03   0.00000000000000E+00   2.06537167256731E-12
      2.71822799509493E-24  -1.67989389117656E-08  -1.67968735400930E-08  -4.99595828591316E-19
      3.55308306854953E-09
      0.00000000000000E+00  -2.87586996486324E-11   0.00000000000000E+00   5.68663244700931E-12   7.55086675277751E-24
      2.87529693701646E-08   2.87586560026116E-08  -1.02441597188537E-19  -5.64563816732870E-01  -5.64563816721071E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17994006550057E-08   0.00000000000000E+00  -1.17994006550057E-08
      5.70019962240281E-19  -9.32555054558131E-03  -3.98221486706646E-03   0.00000000000000E+00   9.33140648063330E-14
      1.55491948629935E-24  -1.69593486616706E-08  -1.69592553476058E-08  -4.67578365051744E-19
      3.55763931854953E-09
      0.00000000000000E+00  -2.91893596213985E-11   0.00000000000000E+00   4.70927740957195E-12   6.80218120745939E-24
      2.91846719927452E-08   2.91893812701548E-08  -9.18689636931471E-20  -5.69608406597519E-01  -5.69608406585542E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19772588231997E-08   0.00000000000000E+00  -1.19772588231997E-08
      5.15448576727077E-19  -9.41460903137623E-03  -3.99160207901497E-03   0.00000000000000E+00  -3.07036476093921E-13
      4.38750781568395E-25  -1.72118154104791E-08  -1.72121224469552E-08  -4.23579613033930E-19
      3.56379025604953E-09
      0.00000000000000E+00  -2.94833546251998E-11   0.00000000000000E+00   2.40585931551597E-12   6.09488171729266E-24
      2.94809391755703E-08   2.94833450348858E-08  -7.77787514708827E-20  -5.76364817843393E-01  -5.76364817831374E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20189566736337E-08   0.00000000000000E+00  -1.20189566736337E-08
      4.41520725412348E-19  -9.47554845245402E-03  -3.97305983530511E-03   0.00000000000000E+00   3.46559057880921E-13
     -5.26457653676294E-25  -1.74647349203098E-08  -1.74643883612519E-08  -3.63741973941467E-19
      3.57209402167453E-09
      0.00000000000000E+00  -2.93582620931231E-11   0.00000000000000E+00  -7.03063806829073E-13   5.42615818112507E-24
      2.93589812653858E-08   2.93582782015790E-08  -5.96118308650112E-20  -5.85131339249384E-01  -5.85131339237660E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17236162407797E-08   0.00000000000000E+00  -1.17236162407797E-08
      3.44170563871469E-19  -9.45096449335718E-03  -3.89482729111398E-03   0.00000000000000E+00   1.22676246752543E-12
     -1.26701042970703E-24  -1.76358887232667E-08  -1.76346619607992E-08  -2.84558733006459E-19
      3.58330410526828E-09
      0.00000000000000E+00  -2.81979875279804E-11   0.00000000000000E+00  -5.07758249063978E-12   4.72712159567053E-24
      2.82030937985812E-08   2.81980162160905E-08  -3.82011106713410E-20  -5.95526596901497E-01  -5.95526596890996E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05005604195734E-08   0.00000000000000E+00  -1.05005604195734E-08
      2.26458403786829E-19  -9.28313941724141E-03  -3.70721679543770E-03   0.00000000000000E+00   1.65571441507829E-12
     -1.77747288104340E-24  -1.76991115109323E-08  -1.76974557965172E-08  -1.88257293115488E-19
      3.59843771811984E-09
      0.00000000000000E+00  -2.37422319470945E-11   0.00000000000000E+00  -1.45077902637939E-11   3.70529194930816E-24
      2.37567069211214E-08   2.37421991308576E-08  -2.20845545856663E-20  -6.03234156035090E-01  -6.03234156029041E-01
      0.00000000000000E+00   0.00000000000000E+00  -6.04895544806988E-09   0.00000000000000E+00  -6.04895544806988E-09
      1.34915853879390E-19  -8.81989167169701E-03  -3.24529467752720E-03   0.00000000000000E+00   1.09618677100648E-12
     -2.14267201961319E-24  -1.76943398695587E-08  -1.76932436827877E-08  -1.12831299293724E-19
      3.61843771811984E-09
      0.00000000000000E+00  -1.01132995481324E-11   0.00000000000000E+00  -3.35961593376391E-11   1.52239449708314E-24
      1.01469268498312E-08   1.01133306904936E-08  -5.01112269868550E-20  -5.88676156100387E-01  -5.88676156107961E-01
      0.00000000000000E+00   0.00000000000000E+00   7.57347696258125E-09   0.00000000000000E+00   7.57347696258125E-09
      2.86385393131015E-19  -7.64944499445989E-03  -2.07687527748707E-03   0.00000000000000E+00  -1.31207762913676E-12
     -2.69898001754501E-24  -1.76854955754456E-08  -1.76868076530748E-08  -2.36274166144160E-19
      3.63843771811984E-09
      0.00000000000000E+00   8.87927365901206E-12   0.00000000000000E+00  -4.68238283880634E-11  -2.40512405769409E-24
     -8.83242550265544E-09  -8.87924933104351E-09  -1.55126554701266E-19  -5.37969395367794E-01  -5.37969395394351E-01
      0.00000000000000E+00   0.00000000000000E+00   2.65568381228220E-08   0.00000000000000E+00   2.65568381228220E-08
      8.17522155587455E-19  -5.99013400094335E-03  -4.20467869098509E-04   0.00000000000000E+00  -5.36066120733685E-12
     -5.00183491044542E-24  -1.76722281305712E-08  -1.76775887917786E-08  -6.62395600886190E-19
      3.65843771811984E-09
      0.00000000000000E+00   2.27738210379783E-11   0.00000000000000E+00  -3.44412509921335E-11  -1.30208623537906E-23
     -2.27394187926870E-08  -2.27738600436792E-08  -3.52877402809732E-19  -4.51899050371046E-01  -4.51899050411443E-01
      0.00000000000000E+00   0.00000000000000E+00   4.03970927357700E-08   0.00000000000000E+00   4.03970927357700E-08
      1.62546401030285E-18  -4.29954459887171E-03   1.25299046471008E-03   0.00000000000000E+00  -1.19527505173058E-11
     -2.02375899936479E-23  -1.76112799415734E-08  -1.76232326920907E-08  -1.27258660749312E-18
      3.67843771811984E-09
      0.00000000000000E+00   2.29492444860447E-11   0.00000000000000E+00  -8.21325224155214E-13  -3.67097225472008E-23
     -2.29483759803003E-08  -2.29491973055245E-08  -6.43191179597889E-19  -3.35975145186123E-01  -3.35975145226733E-01
      0.00000000000000E+00   0.00000000000000E+00   4.06100476366308E-08   0.00000000000000E+00   4.06100476366308E-08
      2.43766496303547E-18  -2.00240478763287E-03   3.56197096858738E-03   0.00000000000000E+00  -2.76936128606574E-11
     -6.57726783112214E-23  -1.76331567182455E-08  -1.76608503311063E-08  -1.79447378343758E-18
      3.69843771811984E-09
      0.00000000000000E+00   1.45207447972472E-11   0.00000000000000E+00   2.01471852651979E-11  -4.31327872577981E-23
     -1.45409090641447E-08  -1.45207618788795E-08  -9.20170821772775E-19  -2.13358528937534E-01  -2.13358528968105E-01
      0.00000000000000E+00   0.00000000000000E+00   3.05716826417890E-08   0.00000000000000E+00   3.05716826417890E-08
      3.04909861587125E-18  -1.07381847250872E-02  -5.68106278295948E-03   0.00000000000000E+00  -5.87254015163313E-11
     -8.20830389217725E-23  -1.59921953613931E-08  -1.60509207629095E-08  -2.12892779409847E-18
      3.71843771811984E-09
      0.00000000000000E+00   9.73829748611406E-12   0.00000000000000E+00   1.09981511743317E-11  -4.59857411328120E-23
     -9.74930553076345E-09  -9.73830737958916E-09  -1.11359938168093E-18  -1.12643289417528E-01  -1.12643289439980E-01
      0.00000000000000E+00   0.00000000000000E+00   2.24516150890204E-08   0.00000000000000E+00   2.24516150890204E-08
      3.49813091765166E-18  -4.12651070509301E-02  -3.72595621863523E-02   0.00000000000000E+00  -1.09451580486649E-10
     -9.51853030239104E-23  -1.26038561289445E-08  -1.27133077094313E-08  -2.38453153597073E-18
      3.72843771811984E-09
      0.00000000000000E+00   7.14524502053396E-12   0.00000000000000E+00   1.19008279439152E-11  -4.70322360042819E-23
     -7.15717734250610E-09  -7.14527651456223E-09  -1.18438688093566E-18  -7.21823616708160E-02  -7.21823616886185E-02
      0.00000000000000E+00   0.00000000000000E+00   1.78025023200222E-08   0.00000000000000E+00   1.78025023200222E-08
      3.67615594085188E-18  -6.26865578394635E-02  -5.93287956906340E-02   0.00000000000000E+00  -1.57626951848879E-10
     -1.01823081963674E-22  -1.04995988536110E-08  -1.06572258054600E-08  -2.49176905991622E-18
      3.73518771811984E-09
      0.00000000000000E+00   5.12530371512882E-12   0.00000000000000E+00   1.40032448671284E-11  -4.75001292779508E-23
     -5.13931687211401E-09  -5.12531362724693E-09  -1.21850276904123E-18  -5.18508007261500E-02  -5.18508007404531E-02
      0.00000000000000E+00   0.00000000000000E+00   1.43031190722571E-08   0.00000000000000E+00   1.43031190722571E-08
      3.77270199458961E-18  -7.99484697472519E-02  -7.70568173025929E-02   0.00000000000000E+00  -1.74049826677920E-10
     -1.06085472021862E-22  -9.00375561833232E-09  -9.17780544501035E-09  -2.55419922554839E-18
      3.73974396811984E-09
      0.00000000000000E+00   3.73165167274181E-12   0.00000000000000E+00   1.45023734305108E-11  -4.77049606066364E-23
     -3.74613780562098E-09  -3.73163543219052E-09  -1.23517456780303E-18  -4.16620472307450E-02  -4.16620472426422E-02
      0.00000000000000E+00   0.00000000000000E+00   1.18971191387793E-08   0.00000000000000E+00   1.18971191387793E-08
      3.82690824366568E-18  -9.28038992378548E-02  -9.02311933234512E-02   0.00000000000000E+00  -1.78356468953761E-10
     -1.08810437771195E-22  -7.98712723763467E-09  -8.16548370658854E-09  -2.59173367586265E-18
      3.74281943686984E-09
      0.00000000000000E+00   2.87317891406306E-12   0.00000000000000E+00   1.33279287880128E-11  -4.78019275332307E-23
     -2.88647576176762E-09  -2.87314783297966E-09  -1.24378639573740E-18  -3.63024088198916E-02  -3.63024088302903E-02
      0.00000000000000E+00   0.00000000000000E+00   1.03986910173291E-08   0.00000000000000E+00   1.03986910173291E-08
      3.85888909293038E-18  -1.01948883380019E-01  -9.95778003134155E-02   0.00000000000000E+00  -1.79661007739496E-10
     -1.10575291577113E-22  -7.34588217660989E-09  -7.52554318434950E-09  -2.61510269719298E-18
      3.74697131968234E-09
      0.00000000000000E+00   2.03527937651879E-12   0.00000000000000E+00   9.67171748816492E-12  -4.78901561999433E-23
     -2.04493731327466E-09  -2.03526559578655E-09  -1.25193305996686E-18  -3.11016961663467E-02  -3.11016961752580E-02
      0.00000000000000E+00   0.00000000000000E+00   8.91135620278775E-09   0.00000000000000E+00   8.91135620278775E-09
      3.89588799958480E-18  -1.14844133931776E-01  -1.12677673358974E-01   0.00000000000000E+00  -1.78972655970986E-10
     -1.12836146996994E-22  -6.69711795103006E-09  -6.87609060700116E-09  -2.64395493961795E-18
      3.75257636147921E-09
      0.00000000000000E+00   1.32963626055336E-12   0.00000000000000E+00   6.03378361495122E-12  -4.79635943291772E-23
     -1.33570003180130E-09  -1.32966624818639E-09  -1.25897809102023E-18  -2.64191396879670E-02  -2.64191396955552E-02
      0.00000000000000E+00   0.00000000000000E+00   7.58821158343965E-09   0.00000000000000E+00   7.58821158343965E-09
      3.93842024267351E-18  -1.32707223436063E-01  -1.30735332286833E-01   0.00000000000000E+00  -1.80379413353841E-10
     -1.15745110796545E-22  -6.07816592189950E-09  -6.25854533525345E-09  -2.67944215165328E-18
      3.76014316790499E-09
      0.00000000000000E+00   8.17234471672573E-13   0.00000000000000E+00   3.23986474534697E-12  -4.80204052031601E-23
     -8.20483215754469E-10  -8.17243351009170E-10  -1.26461851427064E-18  -2.24201436614613E-02  -2.24201436679717E-02
      0.00000000000000E+00   0.00000000000000E+00   6.51035770549686E-09   0.00000000000000E+00   6.51035770549686E-09
      3.98768285919360E-18  -1.56872067857490E-01  -1.55078326178744E-01   0.00000000000000E+00  -1.85203034751947E-10
     -1.19523046683260E-22  -5.50791131973555E-09  -5.69311435448762E-09  -2.72306434492295E-18
      3.77035835657980E-09
      0.00000000000000E+00   4.88797691418457E-13   0.00000000000000E+00   1.53359943558053E-12  -4.80610970244247E-23
     -4.90344505363170E-10  -4.88810905927638E-10  -1.26889385362089E-18  -1.90744480948631E-02  -1.90744481004928E-02
      0.00000000000000E+00   0.00000000000000E+00   5.62968631392757E-09   0.00000000000000E+00   5.62968631392757E-09
      4.04519116707034E-18  -1.88574738730086E-01  -1.86954989673442E-01   0.00000000000000E+00  -1.93042624286624E-10
     -1.24442423413448E-22  -4.94783278371314E-09  -5.14087540799989E-09  -2.77629731344944E-18
      3.78414886129078E-09
      0.00000000000000E+00   2.97576948552387E-13   0.00000000000000E+00   6.60399577150745E-13  -4.80873355470721E-23
     -2.98264043094187E-10  -2.97603643517084E-10  -1.27205665817726E-18  -1.62581801539342E-02  -1.62581801587180E-02
      0.00000000000000E+00   0.00000000000000E+00   4.78372979277475E-09   0.00000000000000E+00   4.78372979277475E-09
      4.11116121531368E-18  -2.28023223147879E-01  -2.26609764309570E-01   0.00000000000000E+00  -1.98925642137589E-10
     -1.30681235040441E-22  -4.28720050712008E-09  -4.48612614925780E-09  -2.83910455713642E-18
      3.80276604265062E-09
      0.00000000000000E+00   2.00497061324031E-13   0.00000000000000E+00   2.48631305347601E-13  -4.81033809869311E-23
     -2.00723487912637E-10  -2.00474856607338E-10  -1.27455905266170E-18  -1.38294314052856E-02  -1.38294314090383E-02
      0.00000000000000E+00   0.00000000000000E+00   3.75269410690540E-09   0.00000000000000E+00   3.75269410690540E-09
      4.18102580208991E-18  -2.71713823715779E-01  -2.70594610540747E-01   0.00000000000000E+00  -1.87323068553749E-10
     -1.37846404507356E-22  -3.36489618174414E-09  -3.55221925029803E-09  -2.90646674942821E-18
      3.82276604265062E-09
      0.00000000000000E+00   1.59626153266681E-13   0.00000000000000E+00   9.80317204689761E-14  -4.81116440043072E-23
     -1.59702699600879E-10  -1.59604667880458E-10  -1.27646340725623E-18  -1.20759718828920E-02  -1.20759718855854E-02
      0.00000000000000E+00   0.00000000000000E+00   2.69346482428534E-09   0.00000000000000E+00   2.69346482428534E-09
      4.23489509857561E-18  -3.05527572094828E-01  -3.04729215191486E-01   0.00000000000000E+00  -1.52702496952472E-10
     -1.43598686954436E-22  -2.38115765945225E-09  -2.53386015640486E-09  -2.95843169131938E-18
      3.84276604265062E-09
      0.00000000000000E+00   1.38501863708950E-13   0.00000000000000E+00   5.22585933309457E-14  -4.81144849527738E-23
     -1.38518831309214E-10  -1.38466572715931E-10  -1.27796792879525E-18  -1.08812792241207E-02  -1.08812792259552E-02
      0.00000000000000E+00   0.00000000000000E+00   1.83451224554105E-09   0.00000000000000E+00   1.83451224554105E-09
      4.27158534348644E-18  -3.27734720764127E-01  -3.27200339737272E-01   0.00000000000000E+00  -1.08304762453884E-10
     -1.47449135524818E-22  -1.58774091037107E-09  -1.69604567282510E-09  -2.99361741469119E-18
      3.86276604265062E-09
      0.00000000000000E+00   1.30878750520726E-13   0.00000000000000E+00   1.97207243103910E-14  -4.81160484943789E-23
     -1.30855110658445E-10  -1.30835389934183E-10  -1.27933448323268E-18  -1.00264620908404E-02  -1.00264620919908E-02
      0.00000000000000E+00   0.00000000000000E+00   1.15034419396915E-09   0.00000000000000E+00   1.15034419396915E-09
      4.29459222736582E-18  -3.40067452394095E-01  -3.39746235716201E-01   0.00000000000000E+00  -6.16004593531885E-11
     -1.49573805995806E-22  -9.57908344681620E-10  -1.01950880403496E-09  -3.01525774413314E-18
      3.88276604265062E-09
      0.00000000000000E+00   1.15356989932654E-13   0.00000000000000E+00   4.12278157642959E-14  -4.81120684115857E-23
     -1.15373741687212E-10  -1.15332513871496E-10  -1.28040128572496E-18  -9.50066724613725E-03  -9.50066724686556E-03
      0.00000000000000E+00   0.00000000000000E+00   7.28312661278962E-10   0.00000000000000E+00   7.28312661278962E-10
      4.30915848059140E-18  -3.46538510668939E-01  -3.46345384677534E-01   0.00000000000000E+00  -3.05970609417071E-11
     -1.50615954753341E-22  -5.82383086465620E-10  -6.12980147407478E-10  -3.02875719486644E-18
      3.90276604265062E-09
      0.00000000000000E+00   8.55992950774149E-14   0.00000000000000E+00   8.10296595409694E-14  -4.80971317867217E-23
     -8.56670002257077E-11  -8.55859705662148E-11  -1.28088481042600E-18  -9.30167492055639E-03  -9.30167492127252E-03
      0.00000000000000E+00   0.00000000000000E+00   7.16132203455638E-10   0.00000000000000E+00   7.16132203455638E-10
      4.32348112466051E-18  -3.53773100199465E-01  -3.53574438877444E-01   0.00000000000000E+00  -3.40639201544648E-11
     -1.51742734600434E-22  -5.96482312734851E-10  -6.30546232889468E-10  -3.04259631423451E-18
      3.90526604265062E-09
      0.00000000000000E+00   9.86412477608837E-14   0.00000000000000E+00  -2.44721000260450E-13  -4.80969671447959E-23
     -9.83592686205996E-11  -9.86039896209081E-11  -1.28097795276087E-18  -9.26058345379085E-03  -9.26058345443451E-03
      0.00000000000000E+00   0.00000000000000E+00   6.43657079589465E-10   0.00000000000000E+00   6.43657079589465E-10
      4.32509026735948E-18  -3.54466329366539E-01  -3.54294606323317E-01   0.00000000000000E+00  -2.53818275747251E-11
     -1.51849385804108E-22  -5.19671262393321E-10  -5.45053089968198E-10  -3.04411231459862E-18
      3.90864104265062E-09
      0.00000000000000E+00   7.15470502846633E-14   0.00000000000000E+00   3.95375981641185E-13  -4.80920990958219E-23
     -7.19725883958924E-11  -7.15772124142993E-11  -1.28101282200774E-18  -9.25683490444054E-03  -9.25683490511932E-03
      0.00000000000000E+00   0.00000000000000E+00   6.78782804868031E-10   0.00000000000000E+00   6.78782804868031E-10
      4.32738115932591E-18  -3.55676913643975E-01  -3.55485606120690E-01   0.00000000000000E+00  -3.34447486263931E-11
     -1.52032005691036E-22  -5.73760843826862E-10  -6.07205592453407E-10  -3.04636833731818E-18
      3.91319729265062E-09
      0.00000000000000E+00   5.16167423106300E-14   0.00000000000000E+00   2.31334033395533E-13  -4.80852312028446E-23
     -5.18412737748236E-11  -5.16099397414761E-11  -1.28096968046369E-18  -9.28935209673455E-03  -9.28935209754915E-03
      0.00000000000000E+00   0.00000000000000E+00   8.14593980155400E-10   0.00000000000000E+00   8.14593980155400E-10
      4.33109265314800E-18  -3.57931033408041E-01  -3.57690641680181E-01   0.00000000000000E+00  -4.81226325132099E-11
     -1.52384252165057E-22  -7.14861407900371E-10  -7.62984040413734E-10  -3.05012297268430E-18
      3.91934823015062E-09
      0.00000000000000E+00   3.42580869784075E-14   0.00000000000000E+00   1.56118712257740E-13  -4.80746716960590E-23
     -3.44081431662937E-11  -3.42520244540840E-11  -1.28080641844846E-18  -9.36087368592270E-03  -9.36087368698376E-03
      0.00000000000000E+00   0.00000000000000E+00   1.06104690894137E-09   0.00000000000000E+00   1.06104690894137E-09
      4.33761908636946E-18  -3.62300611207363E-01  -3.61977095754129E-01   0.00000000000000E+00  -7.24306269221899E-11
     -1.53096736383088E-22  -9.54364257564934E-10  -1.02679488448728E-09  -3.05681266792101E-18
      3.92350011296312E-09
      0.00000000000000E+00   2.16753579809763E-14   0.00000000000000E+00   1.67245649690040E-13  -4.80665857477053E-23
     -2.18754532805758E-11  -2.17082076309338E-11  -1.28064505888676E-18  -9.42177665083894E-03  -9.42177665209137E-03
      0.00000000000000E+00   0.00000000000000E+00   1.25242603806125E-09   0.00000000000000E+00   1.25242603806125E-09
      4.34281901251082E-18  -3.65943924327104E-01  -3.65556154888413E-01   0.00000000000000E+00  -9.19456381030362E-11
     -1.53703372370171E-22  -1.13877219232762E-09  -1.23071783043081E-09  -3.06217395362406E-18
      3.92630263386156E-09
      0.00000000000000E+00   1.58891395369021E-14   0.00000000000000E+00   1.22441863404805E-13  -4.80610289933410E-23
     -1.60153610544701E-11  -1.58929191911133E-11  -1.28052030143345E-18  -9.46387962653992E-03  -9.46387962792698E-03
      0.00000000000000E+00   0.00000000000000E+00   1.38706657437804E-09   0.00000000000000E+00   1.38706657437804E-09
      4.34670629557304E-18  -3.68719546652133E-01  -3.68287520983667E-01   0.00000000000000E+00  -1.05670356801398E-10
     -1.54171843195185E-22  -1.26550329838549E-09  -1.37117365518704E-09  -3.06618599413959E-18
      3.93008603707445E-09
      0.00000000000000E+00   1.79097237554677E-14   0.00000000000000E+00  -4.88826529936985E-15  -4.80543223658888E-23
     -1.78394648148782E-11  -1.78443530802256E-11  -1.28036015634468E-18  -9.50287877451612E-03  -9.50287877606070E-03
      0.00000000000000E+00   0.00000000000000E+00   1.54458552929468E-09   0.00000000000000E+00   1.54458552929468E-09
      4.35255008542715E-18  -3.72909561028037E-01  -3.72428517901110E-01   0.00000000000000E+00  -1.20683275739643E-10
     -1.54891432378329E-22  -1.40605790047499E-09  -1.52674117621478E-09  -3.07218992908248E-18
      3.93519363141185E-09
      0.00000000000000E+00   2.73697316878430E-14   0.00000000000000E+00  -7.42336299577135E-14  -4.80466124315753E-23
     -2.72876239223852E-11  -2.73618575523910E-11  -1.28019426984620E-18  -9.51097625295070E-03  -9.51097625463572E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68501799259606E-09   0.00000000000000E+00   1.68501799259606E-09
      4.36115647378456E-18  -3.79039948255149E-01  -3.78517655450057E-01   0.00000000000000E+00  -1.34148724139433E-10
     -1.55964458387305E-22  -1.52350741090378E-09  -1.65765613504337E-09  -3.08096220393836E-18
      3.94208888376734E-09
      0.00000000000000E+00   3.95850817364440E-14   0.00000000000000E+00  -7.31937139402246E-14  -4.80377907634934E-23
     -3.95494282520576E-11  -3.96226219660459E-11  -1.28005798889658E-18  -9.45783210771393E-03  -9.45783210948840E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77447855672794E-09   0.00000000000000E+00   1.77447855672794E-09
      4.37339195123261E-18  -3.87671664563203E-01  -3.87125046958605E-01   0.00000000000000E+00  -1.44075961459784E-10
     -1.57504027921097E-22  -1.59077997330188E-09  -1.73485593476182E-09  -3.09333396233603E-18
      3.95139747444726E-09
      0.00000000000000E+00   5.29944133687429E-14   0.00000000000000E+00  -5.91753831481187E-14  -4.80281301423506E-23
     -5.29394085773399E-11  -5.29985839605361E-11  -1.28000409010299E-18  -9.30400476381021E-03  -9.30400476561333E-03
      0.00000000000000E+00   0.00000000000000E+00   1.80312619281455E-09   0.00000000000000E+00   1.80312619281455E-09
      4.39017651490576E-18  -3.99381446098977E-01  -3.98830016293509E-01   0.00000000000000E+00  -1.50004502959339E-10
     -1.59635519984696E-22  -1.60012310589447E-09  -1.75012760885397E-09  -3.11017242480277E-18
      3.96396407186514E-09
      0.00000000000000E+00   7.33839450288139E-14   0.00000000000000E+00  -7.21948501298816E-14  -4.80201147087538E-23
     -7.33104524766938E-11  -7.33826473268717E-11  -1.28019699866554E-18  -8.94379374140040E-03  -8.94379374319043E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79002500386203E-09   0.00000000000000E+00   1.79002500386203E-09
      4.41267103849724E-18  -4.14778842991183E-01  -4.14237963482043E-01   0.00000000000000E+00  -1.53181884680413E-10
     -1.62516051236310E-22  -1.56346047185452E-09  -1.71664235653509E-09  -3.13247403983170E-18
      3.98092897837929E-09
      0.00000000000000E+00   1.13244560976880E-13   0.00000000000000E+00  -1.15232784415953E-13  -4.80224719241168E-23
     -1.13050622963351E-10  -1.13165855747814E-10  -1.28114743977908E-18  -8.06364597460974E-03  -8.06364597638150E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77175438762334E-09   0.00000000000000E+00   1.77175438762334E-09
      4.44272868604929E-18  -4.34540099961798E-01  -4.34017511767385E-01   0.00000000000000E+00  -1.55982525406062E-10
     -1.66377636516076E-22  -1.50260600646944E-09  -1.65858853187566E-09  -3.16158124627022E-18
      4.00092897837929E-09
      0.00000000000000E+00   1.59075084843436E-13   0.00000000000000E+00  -1.21337944377916E-13  -4.80418381046342E-23
     -1.58920980140064E-10  -1.59042318084490E-10  -1.28320269523977E-18  -6.49505806638730E-03  -6.49505806813946E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75216566974339E-09   0.00000000000000E+00   1.75216566974339E-09
      4.47777199944417E-18  -4.56467532158477E-01  -4.55965569957837E-01   0.00000000000000E+00  -1.59606641818233E-10
     -1.70902618054357E-22  -1.43351670984051E-09  -1.59312335165892E-09  -3.19456930420440E-18
      4.02092897837929E-09
      0.00000000000000E+00   1.72025192789698E-13   0.00000000000000E+00  -4.30288526988793E-14  -4.80640537892103E-23
     -1.71944365181398E-10  -1.71987394034145E-10  -1.28553208172826E-18  -4.79206474039327E-03  -4.79206474208360E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69033256052501E-09   0.00000000000000E+00   1.69033256052501E-09
      4.51157865065467E-18  -4.77235643025093E-01  -4.76757240820502E-01   0.00000000000000E+00  -1.62056377921446E-10
     -1.75364807144498E-22  -1.35628878856931E-09  -1.51834516649093E-09  -3.22604656892641E-18
      4.04092897837929E-09
      0.00000000000000E+00   1.96547737624107E-13   0.00000000000000E+00  -7.59931878523222E-14  -4.80959996662365E-23
     -1.96453851613798E-10  -1.96529844801698E-10  -1.28836515621490E-18  -2.80936070512417E-03  -2.80936070678338E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65921024041789E-09   0.00000000000000E+00   1.65921024041789E-09
      4.54476285546302E-18  -4.97001917299480E-01  -4.96541052573423E-01   0.00000000000000E+00  -1.66109159830632E-10
     -1.79813714034242E-22  -1.29657123578526E-09  -1.46268039561607E-09  -3.25639769924813E-18
      4.06092897837929E-09
      0.00000000000000E+00  -1.27939718930085E-13   0.00000000000000E+00   8.38783406470817E-13  -4.79922849439285E-23
      1.27068171471339E-10   1.27906954877761E-10  -1.28473845294683E-18  -4.75746632347715E-03  -4.75746632455519E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07803635268171E-09   0.00000000000000E+00   1.07803635268171E-09
      4.56632358251666E-18  -5.16307767068461E-01  -5.15927798785306E-01   0.00000000000000E+00  -1.38389416494441E-10
     -1.83430035065777E-22  -1.06755389106479E-09  -1.20594330755942E-09  -3.28158512956982E-18
      4.08092897837929E-09
      0.00000000000000E+00  -2.03711627126294E-12   0.00000000000000E+00   5.04512303981680E-12  -4.71245200076289E-23
      2.03202686618837E-09   2.03707198922814E-09  -1.24314746491804E-18  -2.92447915970463E-02  -2.92447915950405E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.00574187590635E-09   0.00000000000000E+00  -2.00574187590635E-09
      4.52620874499853E-18  -5.37018288934357E-01  -5.37008448928947E-01   0.00000000000000E+00   3.76443967677053E-11
     -1.82440172707102E-22  -6.89745100893846E-11  -3.13301133218617E-11  -3.28306128008049E-18
      4.10092897837929E-09
      0.00000000000000E+00  -3.82248611784006E-12   0.00000000000000E+00   4.92671471815155E-12  -4.56836154203076E-23
      3.81754430834485E-09   3.82247102306295E-09  -1.16703968073117E-18  -7.22592099640473E-02  -7.22592099592952E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.75206934148181E-09   0.00000000000000E+00  -4.75206934148181E-09
      4.43116735816890E-18  -5.58485152962759E-01  -5.58778113578526E-01   0.00000000000000E+00   1.80399634020716E-10
     -1.77611092409527E-22   7.49198684398346E-10   9.29598318418885E-10  -3.26412767743772E-18
      4.10342897837929E-09
      0.00000000000000E+00  -4.43793770186769E-12   0.00000000000000E+00   1.25181062539146E-11  -4.54530739650741E-23
      4.42543326946176E-09   4.43795137571563E-09  -1.15603041852423E-18  -7.83187479871379E-02  -7.83187479815016E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.63628601225935E-09   0.00000000000000E+00  -5.63628601225935E-09
      4.41707664313825E-18  -5.61190704495354E-01  -5.61568344101984E-01   0.00000000000000E+00   2.15024520397467E-10
     -1.76884303154908E-22   9.83310116146397E-10   1.19833463654369E-09  -3.26104622461401E-18
      4.10680397837929E-09
      0.00000000000000E+00  -4.99984380410334E-12   0.00000000000000E+00   8.82865823931207E-12  -4.51343267261544E-23
      4.99101022545729E-09   4.99983888369656E-09  -1.13937771577391E-18  -8.73713359218169E-02  -8.73713359153579E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.45900074304342E-09   0.00000000000000E+00  -6.45900074304342E-09
      4.39527751563047E-18  -5.64900991844571E-01  -5.65360820992741E-01   0.00000000000000E+00   2.49521155996475E-10
     -1.75736761100481E-22   1.20964070335007E-09   1.45916185934636E-09  -3.25589979985656E-18
      4.11136022837929E-09
      0.00000000000000E+00  -5.59793673279876E-12   0.00000000000000E+00   7.07894010805773E-12  -4.46741486797182E-23
      5.59089190147060E-09   5.59797084157862E-09  -1.11446632581177E-18  -1.00698952169908E-01  -1.00698952162626E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.28119482296460E-09   0.00000000000000E+00  -7.28119482296460E-09
      4.36210257171834E-18  -5.69945691356299E-01  -5.70476128777490E-01   0.00000000000000E+00   2.80005802261541E-10
     -1.73980277974270E-22   1.40321817912468E-09   1.68322398138604E-09  -3.24763624590658E-18
      4.11751116587929E-09
      0.00000000000000E+00  -6.22744056161914E-12   0.00000000000000E+00   5.63723506560342E-12  -4.40076882348810E-23
      6.22181166651839E-09   6.22744890158395E-09  -1.07789195384768E-18  -1.19821026479013E-01  -1.19821026471002E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.01094332727062E-09   0.00000000000000E+00  -8.01094332727062E-09
      4.31282775999626E-18  -5.76696734360750E-01  -5.77258782476022E-01   0.00000000000000E+00   2.99525228189162E-10
     -1.71407509805552E-22   1.48396919749739E-09   1.78349442568638E-09  -3.23493580614858E-18
      4.12581493150429E-09
      0.00000000000000E+00  -6.98378197252313E-12   0.00000000000000E+00   5.02924565627721E-12  -4.29073475655199E-23
      6.97875257092539E-09   6.98378181658162E-09  -1.02565210855535E-18  -1.46272700201430E-01  -1.46272700192886E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.54390548483162E-09   0.00000000000000E+00  -8.54390548483162E-09
      4.24188117132806E-18  -5.85444583955736E-01  -5.85936292950741E-01   0.00000000000000E+00   3.02388579840442E-10
     -1.67833934856799E-22   1.25773508840980E-09   1.56012366825008E-09  -3.21622906277272E-18
      4.13702501509804E-09
      0.00000000000000E+00  -8.47791215741517E-12   0.00000000000000E+00   7.01797260668901E-12  -3.96955891006870E-23
      8.47086065822417E-09   8.47787863083082E-09  -9.53412620662600E-19  -1.81343918925486E-01  -1.81343918916602E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.88440395513415E-09   0.00000000000000E+00  -8.88440395513415E-09
      4.14228626031037E-18  -5.95781495653796E-01  -5.95909854714993E-01   0.00000000000000E+00   2.91397550324478E-10
     -1.63065592342736E-22   1.15127773979072E-10   4.06525324303387E-10  -3.18887363964777E-18
      4.15215862794960E-09
      0.00000000000000E+00  -1.32447458632230E-11   0.00000000000000E+00   1.58555290594031E-11  -2.28790132186249E-23
      1.32289421329110E-08   1.32447976619703E-08  -8.58675054380129E-19  -2.25061510976594E-01  -2.25061510967410E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.18439807643272E-09   0.00000000000000E+00  -9.18439807643272E-09
      4.00329313554700E-18  -6.03290204504423E-01  -6.02011551349539E-01   0.00000000000000E+00   2.82646403418095E-10
     -1.56562710898513E-22  -4.34304598895569E-09  -4.06039958553775E-09  -3.14461808116687E-18
      4.17215862794960E-09
      0.00000000000000E+00  -2.76966989523018E-11   0.00000000000000E+00   3.58501591199574E-11   4.52949971086130E-23
      2.76608481273478E-08   2.76966982864678E-08  -7.52236272783219E-19  -2.72031005453749E-01  -2.72031005444029E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.71962437436670E-09   0.00000000000000E+00  -9.71962437436670E-09
      3.80890064805967E-18  -5.88210500435688E-01  -5.82548020193223E-01   0.00000000000000E+00   3.03757743042301E-10
     -1.46470865288563E-22  -1.82808316551432E-08  -1.79770739121010E-08  -3.05666437527645E-18
      4.19215862794960E-09
      0.00000000000000E+00  -4.78953772484555E-11   0.00000000000000E+00   5.00552028620024E-11   1.41488028604101E-22
      4.78452784204986E-08   4.78953336233607E-08  -6.75425755674662E-19  -3.05751982963438E-01  -3.05751982953023E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04151578375243E-08   0.00000000000000E+00  -1.04151578375243E-08
      3.60059749130918E-18  -5.36906544545971E-01  -5.25099833178443E-01   0.00000000000000E+00   3.17153397092180E-10
     -1.33527284313123E-22  -3.77973291829286E-08  -3.74801757858366E-08  -2.92517173563452E-18
      4.21215862794960E-09
      0.00000000000000E+00  -6.30569227771996E-11   0.00000000000000E+00   3.77361682457546E-11   2.12467639223480E-22
      6.30192461205648E-08   6.30569822888107E-08  -6.27631667533896E-19  -3.27865475044616E-01  -3.27865475033584E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10320901790426E-08   0.00000000000000E+00  -1.10320901790426E-08
      3.37995568772833E-18  -4.50309578454309E-01  -4.33920041073295E-01   0.00000000000000E+00   2.90686432580142E-10
     -1.17591507746843E-22  -5.23155785423480E-08  -5.20248921097680E-08  -2.75232402019443E-18
      4.23215862794961E-09
      0.00000000000000E+00  -6.47430084628553E-11   0.00000000000000E+00   4.30192330215672E-12   2.21206025046376E-22
      6.47386599534751E-08   6.47429618767774E-08  -6.05306038715239E-19  -3.40102806531299E-01  -3.40102806519713E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15860247541874E-08   0.00000000000000E+00  -1.15860247541874E-08
      3.14823519264458E-18  -3.33997102727978E-01  -3.17250173891772E-01   0.00000000000000E+00   2.41802331441528E-10
     -1.01284815467795E-22  -5.33987394540317E-08  -5.31569371225903E-08  -2.54292915392934E-18
      4.25215862794961E-09
      0.00000000000000E+00  -5.62253275342293E-11   0.00000000000000E+00  -2.10932701164233E-11   1.82349102064370E-22
      5.62464876291533E-08   5.62253943590371E-08  -5.97995345718122E-19  -3.46596856017256E-01  -3.46596856005336E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19203118926465E-08   0.00000000000000E+00  -1.19203118926465E-08
      2.90982895479165E-18  -2.11587166501508E-01  -1.97628576243258E-01   0.00000000000000E+00   1.66395286002706E-10
     -8.47719935774518E-23  -4.44714777523931E-08  -4.43050824663905E-08  -2.31183360907353E-18
      4.27215862794961E-09
      0.00000000000000E+00  -4.90569376399191E-11   0.00000000000000E+00  -1.77860139029010E-11   1.42836554320333E-22
      4.90747333645523E-08   4.90569473506496E-08  -5.88763893392488E-19  -3.53894279793854E-01  -3.53894279782027E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18267663441851E-08   0.00000000000000E+00  -1.18267663441851E-08
      2.67329362790795E-18  -1.11285464886729E-01  -9.95556559732051E-02   0.00000000000000E+00   8.83855433333667E-11
     -7.26820247935815E-23  -3.73185665497978E-08  -3.72301810064645E-08  -2.08452973451546E-18
      4.27465862794961E-09
      0.00000000000000E+00  -4.74017117859650E-11   0.00000000000000E+00  -3.25361138543573E-11   1.36834824904297E-22
      4.74342021220515E-08   4.74016660081973E-08  -5.88101875225108E-19  -3.54598598013940E-01  -3.54598598002036E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19038728855698E-08   0.00000000000000E+00  -1.19038728855698E-08
      2.64353394569402E-18  -9.92027221773723E-02  -8.80187008000421E-02   0.00000000000000E+00   8.41735108947898E-11
     -6.96507992527505E-23  -3.55819666335216E-08  -3.54977931226269E-08  -2.05543207046891E-18
      4.27803362794961E-09
      0.00000000000000E+00  -4.57009309423560E-11   0.00000000000000E+00  -2.50830939790335E-11   1.29299884943810E-22
      4.57260549306056E-08   4.57009718366267E-08  -5.86512623783621E-19  -3.55829565854946E-01  -3.55829565843119E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18274732908873E-08   0.00000000000000E+00  -1.18274732908873E-08
      2.60361622333728E-18  -8.45021208281792E-02  -7.38298293171702E-02   0.00000000000000E+00   6.68931853024225E-11
     -6.25886109869688E-23  -3.39403917310417E-08  -3.38734985457393E-08  -2.01710359955366E-18
      4.28258987794961E-09
      0.00000000000000E+00  -4.35068520152054E-11   0.00000000000000E+00  -2.38621586887984E-11   1.21627318452331E-22
      4.35306827099721E-08   4.35068205512834E-08  -5.82557321155424E-19  -3.58125177611672E-01  -3.58125177600027E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16450895100910E-08   0.00000000000000E+00  -1.16450895100910E-08
      2.55055828425692E-18  -6.76079772922668E-02  -5.75694962266570E-02   0.00000000000000E+00   5.68638229867658E-11
     -4.73184376556623E-23  -3.19185948641793E-08  -3.18617310411926E-08  -1.96800096310150E-18
      4.28874081544961E-09
      0.00000000000000E+00  -4.05206122296399E-11   0.00000000000000E+00  -2.40175682668232E-11   1.16583466644091E-22
      4.05446220974007E-08   4.05206045291340E-08  -5.73260899595620E-19  -3.62567771795681E-01  -3.62567771784347E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13331868287243E-08   0.00000000000000E+00  -1.13331868287243E-08
      2.48084856039762E-18  -5.03376723514677E-02  -4.11417485893875E-02   0.00000000000000E+00   4.76147293023103E-11
     -1.51529818978350E-23  -2.92350324297117E-08  -2.91874177004094E-08  -1.90758766080200E-18
      4.29289269826211E-09
      0.00000000000000E+00  -3.83236861156359E-11   0.00000000000000E+00  -2.61345744461155E-11   1.15706277315402E-22
      3.83498224635932E-08   3.83236878891472E-08  -5.64878876987355E-19  -3.66259622332325E-01  -3.66259622321233E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10920908303503E-08   0.00000000000000E+00  -1.10920908303503E-08
      2.43479549912440E-18  -4.14256453546674E-02  -3.28459202609490E-02   0.00000000000000E+00   4.34515159587523E-11
      1.22857198062587E-23  -2.72750485747560E-08  -2.72315970587972E-08  -1.86991662213704E-18
      4.29849774005898E-09
      0.00000000000000E+00  -3.60215977775292E-11   0.00000000000000E+00  -2.03289878330282E-11   1.18663376113789E-22
      3.60419600459341E-08   3.60216310581012E-08  -5.50612596536909E-19  -3.72252155309497E-01  -3.72252155298698E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07986604133284E-08   0.00000000000000E+00  -1.07986604133284E-08
      2.37426855615743E-18  -3.32508494838993E-02  -2.53039596964241E-02   0.00000000000000E+00   3.32244577113848E-11
      4.78353016969815E-23  -2.52561951024843E-08  -2.52229706447729E-08  -1.82365595962052E-18
      4.30606454648476E-09
      0.00000000000000E+00  -3.39990848194823E-11   0.00000000000000E+00  -1.32139443825778E-11   1.26569444443949E-22
      3.40122565519852E-08   3.39990426076027E-08  -5.28451484353849E-19  -3.81329350291519E-01  -3.81329350280991E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05279835971936E-08   0.00000000000000E+00  -1.05279835971936E-08
      2.29460534222367E-18  -2.65644953436964E-02  -1.91695603063312E-02   0.00000000000000E+00   2.31377698283346E-11
      8.93538636758807E-23  -2.34941967802376E-08  -2.34710590104092E-08  -1.76615385786982E-18
      4.31627973515957E-09
      0.00000000000000E+00  -3.24636245028468E-11   0.00000000000000E+00  -7.40416058199640E-12   1.37566638782262E-22
      3.24709790790273E-08   3.24635749184454E-08  -4.96919924139560E-19  -3.94118412571428E-01  -3.94118412561107E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03214654164336E-08   0.00000000000000E+00  -1.03214654164336E-08
      2.18916962559433E-18  -2.14914609551459E-02  -1.45152216668312E-02   0.00000000000000E+00   1.53279990651121E-11
      1.32863551664806E-22  -2.21574375010769E-08  -2.21421095020117E-08  -1.69224970145477E-18
      4.33007023987055E-09
      0.00000000000000E+00  -3.12768068086512E-11   0.00000000000000E+00  -4.21267649957623E-12   1.44866517932651E-22
      3.12810301718039E-08   3.12768174953044E-08  -4.55007956902203E-19  -4.11142977072401E-01  -4.11142977062237E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01641674239704E-08   0.00000000000000E+00  -1.01641674239704E-08
      2.04900062685081E-18  -1.76890515545987E-02  -1.10371506754243E-02   0.00000000000000E+00   1.05731248084181E-11
      1.68395178659500E-22  -2.11232231961427E-08  -2.11126500713341E-08  -1.59399266994861E-18
      4.34868742123038E-09
      0.00000000000000E+00  -3.00684974459489E-11   0.00000000000000E+00  -3.16505008761077E-12   1.36536413232509E-22
      3.00716030922233E-08   3.00684380421358E-08  -4.01859105316358E-19  -4.32969635852733E-01  -4.32969635842726E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00063735975650E-08   0.00000000000000E+00  -1.00063735975650E-08
      1.86271015483072E-18  -1.47192077698773E-02  -8.39830313126427E-03   0.00000000000000E+00   8.15811280460803E-12
      1.76842012383462E-22  -2.00702225573757E-08  -2.00620644445709E-08  -1.46085104951436E-18
      4.36868742123039E-09
      0.00000000000000E+00  -2.88137146462197E-11   0.00000000000000E+00  -3.06188558807270E-12   1.10436117641603E-22
      2.88168205208838E-08   2.88137586352958E-08  -3.49082580562442E-19  -4.54990689206536E-01  -4.54990689196683E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.85241170744615E-09   0.00000000000000E+00  -9.85241170744615E-09
      1.66566192068179E-18  -1.26664238158273E-02  -6.69231297272562E-03   0.00000000000000E+00   7.01923004808536E-12
      1.49526800591967E-22  -1.89683661578978E-08  -1.89613469278496E-08  -1.31657934011935E-18
      4.38868742123039E-09
      0.00000000000000E+00  -2.77438153024892E-11   0.00000000000000E+00  -2.61119851042967E-12   7.78559508920802E-23
      2.77464325678449E-08   2.77438213693345E-08  -2.99975113471974E-19  -4.75834705141263E-01  -4.75834705131546E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.71778138332694E-09   0.00000000000000E+00  -9.71778138332694E-09
      1.47130629301525E-18  -1.12840329298032E-02  -5.60460216254461E-03   0.00000000000000E+00   5.89530370681160E-12
      1.05376510459559E-22  -1.80319352897146E-08  -1.80260399860076E-08  -1.17133117954328E-18
      4.40868742123039E-09
      0.00000000000000E+00  -2.68730353490247E-11   0.00000000000000E+00  -2.12300498316401E-12   4.86399811481020E-23
      2.68751819797551E-08   2.68730589747720E-08  -2.54041972778886E-19  -4.95674609816939E-01  -4.95674609807359E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.57958288774034E-09   0.00000000000000E+00  -9.57958288774034E-09
      1.27971463526045E-18  -1.03213614441432E-02  -4.87273411413793E-03   0.00000000000000E+00   4.88302127365324E-12
      6.28761701200193E-23  -1.72983591083054E-08  -1.72934760870317E-08  -1.02567266248156E-18
      4.42868742123039E-09
      0.00000000000000E+00  -2.63283042126468E-11   0.00000000000000E+00  -1.32102305029820E-12   2.77600683634975E-23
      2.63296233549988E-08   2.63283023319485E-08  -2.10308638435649E-19  -5.14934164214996E-01  -5.14934164205406E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.59006540339641E-09   0.00000000000000E+00  -9.59006540339641E-09
      1.08791332719252E-18  -9.64474842983547E-03  -4.37105599635684E-03   0.00000000000000E+00   4.09253802903287E-12
      3.18073077821006E-23  -1.67423294665812E-08  -1.67382369285522E-08  -8.77604688756870E-19
      4.44868742123039E-09
      0.00000000000000E+00  -2.71415893606195E-11   0.00000000000000E+00   2.02834324708322E-12   1.55300241305730E-23
      2.71395726435218E-08   2.71416009867689E-08  -1.64613944672181E-19  -5.35576563969482E-01  -5.35576563958940E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05416740116941E-08   0.00000000000000E+00  -1.05416740116941E-08
      8.77079846958637E-19  -9.36194654820033E-03  -4.13182808793272E-03   0.00000000000000E+00   3.00035528494539E-12
      1.33851636229431E-23  -1.66029273303598E-08  -1.65999269750748E-08  -7.12465902286455E-19
      4.45868742123039E-09
      0.00000000000000E+00  -2.77143331418456E-11   0.00000000000000E+00   2.85280976993213E-12   1.12209294280484E-23
      2.77114526479721E-08   2.77143054577420E-08  -1.41558609167464E-19  -5.46203952294124E-01  -5.46203952283013E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11111614883234E-08   0.00000000000000E+00  -1.11111614883234E-08
      7.65968232075402E-19  -9.28694458909677E-03  -4.05581134289010E-03   0.00000000000000E+00   2.55411913154145E-12
      6.90781523729857E-24  -1.66056980885502E-08  -1.66031439694187E-08  -6.24409622907939E-19
      4.46206242123039E-09
      0.00000000000000E+00  -2.79535886822712E-11   0.00000000000000E+00   3.52063032806786E-12   9.96890166617732E-24
      2.79500758890939E-08   2.79535965194219E-08  -1.33771873831579E-19  -5.49828209776236E-01  -5.49828209764900E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13359760527101E-08   0.00000000000000E+00  -1.13359760527101E-08
      7.27709312897506E-19  -9.27395454241301E-03  -4.03825975664221E-03   0.00000000000000E+00   2.31604484586952E-12
      5.02554788233184E-24  -1.66199365115574E-08  -1.66176204667116E-08  -5.93937439065927E-19
      4.46661867123039E-09
      0.00000000000000E+00  -2.82984656704855E-11   0.00000000000000E+00   3.76428118971578E-12   8.68162205420804E-24
      2.82946612830876E-08   2.82984255642773E-08  -1.23168945401111E-19  -5.54789789144563E-01  -5.54789789133003E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15599451574873E-08   0.00000000000000E+00  -1.15599451574873E-08
      6.75039312773704E-19  -9.29909029668114E-03  -4.02531540774415E-03   0.00000000000000E+00   1.21925097450088E-12
      3.11795121942396E-24  -1.67396996577647E-08  -1.67384804067902E-08  -5.51870367372594E-19
      4.47276960873039E-09
      0.00000000000000E+00  -2.87869878276923E-11   0.00000000000000E+00   3.95036318143896E-12   7.48171176350679E-24
      2.87829941750561E-08   2.87869445382375E-08  -1.08766382515920E-19  -5.61579297629636E-01  -5.61579297617826E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18105317106367E-08   0.00000000000000E+00  -1.18105317106367E-08
      6.02393470379810E-19  -9.36623320978107E-03  -4.01749225904137E-03   0.00000000000000E+00   5.94077568650240E-13
      1.35754331113794E-24  -1.69770069051692E-08  -1.69764128276005E-08  -4.93627087863889E-19
      4.47692149154289E-09
      0.00000000000000E+00  -2.91370081211902E-11   0.00000000000000E+00   4.19091546163080E-12   6.85179751975993E-24
      2.91328269269687E-08   2.91370178424303E-08  -9.90559255959198E-20  -5.66190808319953E-01  -5.66190808307980E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19732028956625E-08   0.00000000000000E+00  -1.19732028956625E-08
      5.52682135066733E-19  -9.42520739191639E-03  -4.01742120826837E-03   0.00000000000000E+00   2.42069898788364E-13
      4.32301682666752E-25  -1.71640570166669E-08  -1.71638149467681E-08  -4.53626209470815E-19
      4.47972401244132E-09
      0.00000000000000E+00  -2.93562415089046E-11   0.00000000000000E+00   3.89711734913370E-12   6.49288216560430E-24
      2.93523126961080E-08   2.93562098134572E-08  -9.25208598927101E-20  -5.69308431554707E-01  -5.69308431542647E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20599663036546E-08   0.00000000000000E+00  -1.20599663036546E-08
      5.18883827466290E-19  -9.46630177600330E-03  -4.01679106675702E-03   0.00000000000000E+00   1.10431033241484E-13
     -8.73180629790774E-26  -1.72963539408360E-08  -1.72962435098027E-08  -4.26362967573579E-19
      4.48350741565421E-09
      0.00000000000000E+00  -2.95532484702147E-11   0.00000000000000E+00   2.61631325540407E-12   6.10263974413468E-24
      2.95506204783344E-08   2.95532367915898E-08  -8.37573726368033E-20  -5.73502829243028E-01  -5.73502829230926E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.21015223656075E-08   0.00000000000000E+00  -1.21015223656075E-08
      4.73098888867383E-19  -9.50440120511619E-03  -4.00590607376431E-03   0.00000000000000E+00   3.78115846737704E-13
     -6.14732313341424E-25  -1.74520925418293E-08  -1.74517144259825E-08  -3.89341516230579E-19
      4.48861500999162E-09
      0.00000000000000E+00  -2.96155192020414E-11   0.00000000000000E+00   6.46100808407856E-13   5.68638042208432E-24
      2.96148719977692E-08   2.96155180985776E-08  -7.21592681048878E-20  -5.79076588274730E-01  -5.79076588262705E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20246870554005E-08   0.00000000000000E+00  -1.20246870554005E-08
      4.11681665354183E-19  -9.51189111561091E-03  -3.96956426063892E-03   0.00000000000000E+00   9.95414406998055E-13
     -1.10486579051886E-24  -1.75918264575839E-08  -1.75908310431769E-08  -3.39522397249296E-19
      4.49551026234711E-09
      0.00000000000000E+00  -2.93588131615464E-11   0.00000000000000E+00  -1.80012263006147E-12   5.23693275560000E-24
      2.93606441540920E-08   2.93588440314620E-08  -5.72114193155547E-20  -5.86297972533492E-01  -5.86297972521813E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16787148996247E-08   0.00000000000000E+00  -1.16787148996247E-08
      3.31153978933413E-19  -9.45855489959232E-03  -3.88809239129104E-03   0.00000000000000E+00   1.57512137871893E-12
     -1.52101692099083E-24  -1.76817042532162E-08  -1.76801291318375E-08  -2.73942559617860E-19
      4.50481885302702E-09
      0.00000000000000E+00  -2.83421837653963E-11   0.00000000000000E+00  -5.36034515571738E-12   4.70906411665921E-24
      2.83475498939845E-08   2.83421895488288E-08  -3.92259489094236E-20  -5.95031225155746E-01  -5.95031225145113E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06321703399996E-08   0.00000000000000E+00  -1.06321703399996E-08
      2.32183457199216E-19  -9.30505968668149E-03  -3.72517882619945E-03   0.00000000000000E+00   1.79632275854651E-12
     -1.84897646990430E-24  -1.77118155315875E-08  -1.77100192088289E-08  -1.92957508289792E-19
      4.51738545044491E-09
      0.00000000000000E+00  -2.50802260787337E-11   0.00000000000000E+00  -1.27857608624612E-11   3.92253256526885E-24
      2.50930142775147E-08   2.50802285166522E-08  -2.28157428766189E-20  -6.02947160981827E-01  -6.02947160974447E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.37987010730612E-09   0.00000000000000E+00  -7.37987010730612E-09
      1.39443600564406E-19  -8.94606733642899E-03  -3.36922901210191E-03   0.00000000000000E+00   1.35721227003735E-12
     -2.11479119722731E-24  -1.77017156216161E-08  -1.77003584093461E-08  -1.16627857687788E-19
      4.53435035695906E-09
      0.00000000000000E+00  -1.51820269051414E-11   0.00000000000000E+00  -2.87660315765983E-11   2.30830260313054E-24
      1.52108060166771E-08   1.51820399851005E-08  -3.09323425482824E-20  -5.98373526384399E-01  -5.98373526386908E-01
      0.00000000000000E+00   0.00000000000000E+00   2.50872163547607E-09   0.00000000000000E+00   2.50872163547607E-09
      1.82003828580275E-19  -8.06840451338273E-03  -2.49458833270851E-03   0.00000000000000E+00  -3.88856551709662E-13
     -2.46656546362313E-24  -1.76903727640249E-08  -1.76907616205767E-08  -1.51071486031993E-19
      4.55435035695906E-09
      0.00000000000000E+00   3.21934172859823E-12   0.00000000000000E+00  -4.53543860120158E-11  -9.13024020014971E-25
     -3.17401222909569E-09  -3.21936661510771E-09  -1.10516526136950E-19  -5.58981256342581E-01  -5.58981256363487E-01
      0.00000000000000E+00   0.00000000000000E+00   2.09063788944717E-08   0.00000000000000E+00   2.09063788944717E-08
      6.00131406469709E-19  -6.50150856119434E-03  -9.28873044833168E-04   0.00000000000000E+00  -3.94510374390450E-12
     -3.78009429475795E-24  -1.76830671756201E-08  -1.76870122793640E-08  -4.89614880332759E-19
      4.57435035695906E-09
      0.00000000000000E+00   1.98276255578353E-11   0.00000000000000E+00  -4.10659466957049E-11  -8.08691480776585E-24
     -1.97865136715409E-08  -1.98275796182366E-08  -2.78271411130309E-19  -4.83122681379701E-01  -4.83122681417171E-01
      0.00000000000000E+00   0.00000000000000E+00   3.74700447018902E-08   0.00000000000000E+00   3.74700447018902E-08
      1.34953230050751E-18  -4.79830560989324E-03   7.60291494533740E-04   0.00000000000000E+00  -9.38879512407657E-12
     -1.20875858553862E-23  -1.76330762885295E-08  -1.76424650836536E-08  -1.07126088937720E-18
      4.59435035695906E-09
      0.00000000000000E+00   2.48058858486949E-11   0.00000000000000E+00  -1.25957504253288E-11  -3.01243907341909E-23
     -2.47932604304080E-08  -2.48058561808334E-08  -5.44528653526724E-19  -3.75388804838973E-01  -3.75388804881410E-01
      0.00000000000000E+00   0.00000000000000E+00   4.24364161284552E-08   0.00000000000000E+00   4.24364161284552E-08
      2.19826062307661E-18  -2.81970897330486E-03   2.73512803660818E-03   0.00000000000000E+00  -2.10676881527194E-11
     -5.22466236337123E-23  -1.76094922594690E-08  -1.76305599476218E-08  -1.65373196954989E-18
      4.61435035695906E-09
      0.00000000000000E+00   1.68402836354233E-11   0.00000000000000E+00   1.90780944286145E-11  -4.19892483309183E-23
     -1.68593670739540E-08  -1.68402889795254E-08  -8.42452517969337E-19  -2.50158528706871E-01  -2.50158528740753E-01
      0.00000000000000E+00   0.00000000000000E+00   3.38821000995249E-08   0.00000000000000E+00   3.38821000995249E-08
      2.87590262506711E-18  -4.68812849444250E-03   6.81194439947594E-04   0.00000000000000E+00  -4.74980117630709E-11
     -7.82138115063193E-23  -1.69943131082364E-08  -1.70418111199996E-08  -2.03345010709777E-18
      4.63435035695906E-09
      0.00000000000000E+00   1.10158577806708E-11   0.00000000000000E+00   1.36140122096903E-11  -4.51920203507376E-23
     -1.10294745919910E-08  -1.10158605797814E-08  -1.06103654851337E-18  -1.41420945614013E-01  -1.41420945638745E-01
      0.00000000000000E+00   0.00000000000000E+00   2.47320614696607E-08   0.00000000000000E+00   2.47320614696607E-08
      3.37054385446033E-18  -2.90840684257054E-02  -2.47625448111814E-02   0.00000000000000E+00  -9.01498351559879E-11
     -9.09605823849000E-23  -1.36260510547231E-08  -1.37162008898792E-08  -2.30950730594696E-18
      4.64435035695906E-09
      0.00000000000000E+00   8.46532942841774E-12   0.00000000000000E+00   1.16765767513533E-11  -4.64406527137311E-23
     -8.47701836181161E-09  -8.46534178506030E-09  -1.14511640083204E-18  -9.49715724601206E-02  -9.49715724802798E-02
      0.00000000000000E+00   0.00000000000000E+00   2.01591854154409E-08   0.00000000000000E+00   2.01591854154409E-08
      3.57213570861473E-18  -4.76227363873961E-02  -4.39383723349012E-02   0.00000000000000E+00  -1.39094819728191E-10
     -9.77125648058622E-23  -1.15547488106524E-08  -1.16938436303806E-08  -2.42701930778270E-18
      4.65110035695906E-09
      0.00000000000000E+00   6.66636656073391E-12   0.00000000000000E+00   1.22678699453957E-11  -4.70961171562183E-23
     -6.67860333708534E-09  -6.66633546713999E-09  -1.18966197908742E-18  -6.91500285434212E-02  -6.91500285604090E-02
      0.00000000000000E+00   0.00000000000000E+00   1.69878423567164E-08   0.00000000000000E+00   1.69878423567164E-08
      3.68680364452257E-18  -6.28410047357641E-02  -5.95890100921655E-02   0.00000000000000E+00  -1.64307759021916E-10
     -1.02174556010480E-22  -1.01571991305546E-08  -1.03215068895766E-08  -2.49714166543515E-18
      4.66021285695906E-09
      0.00000000000000E+00   4.36997259633412E-12   0.00000000000000E+00   1.17872388522393E-11  -4.76337756758272E-23
     -4.38177526898643E-09  -4.36998803013424E-09  -1.22882619884172E-18  -4.55590072492464E-02  -4.55590072622705E-02
      0.00000000000000E+00   0.00000000000000E+00   1.30240995798902E-08   0.00000000000000E+00   1.30240995798902E-08
      3.80548575194432E-18  -8.74375418242348E-02  -8.47108911579356E-02   0.00000000000000E+00  -1.72617507960069E-10
     -1.07706228989785E-22  -8.48149404179581E-09  -8.65411154975599E-09  -2.57665955310260E-18
      4.66328832570906E-09
      0.00000000000000E+00   3.39357119508091E-12   0.00000000000000E+00   1.50704234028981E-11  -4.77507998975318E-23
     -3.40861698144126E-09  -3.39354655803841E-09  -1.23903914322856E-18  -3.92729427773360E-02  -3.92729427886418E-02
      0.00000000000000E+00   0.00000000000000E+00   1.13057801370801E-08   0.00000000000000E+00   1.13057801370801E-08
      3.84025632545028E-18  -9.62976216732434E-02  -9.38047053173282E-02   0.00000000000000E+00  -1.79569043225511E-10
     -1.09521598276291E-22  -7.73266453581667E-09  -7.91223357904229E-09  -2.60121718222172E-18
      4.66744020852156E-09
      0.00000000000000E+00   2.40421968588143E-12   0.00000000000000E+00   1.14117355457466E-11  -4.78576020717325E-23
     -2.41560464992260E-09  -2.40419291437690E-09  -1.24871752358528E-18  -3.31745869451912E-02  -3.31745869547644E-02
      0.00000000000000E+00   0.00000000000000E+00   9.57322195255240E-09   0.00000000000000E+00   9.57322195255240E-09
      3.88000322113533E-18  -1.08958339271327E-01  -1.06699583403509E-01   0.00000000000000E+00  -1.78790242715457E-10
     -1.11835288428406E-22  -6.99023879545978E-09  -7.16902903817535E-09  -2.63128569755005E-18
      4.67304525031843E-09
      0.00000000000000E+00   1.55318635091648E-12   0.00000000000000E+00   7.28001868581524E-12  -4.79450531544255E-23
     -1.56043521182931E-09  -1.55315519314354E-09  -1.25701429198908E-18  -2.77492855842655E-02  -2.77492855922820E-02
      0.00000000000000E+00   0.00000000000000E+00   8.01651487141916E-09   0.00000000000000E+00   8.01651487141916E-09
      3.92493612205491E-18  -1.26693463042171E-01  -1.24657041816513E-01   0.00000000000000E+00  -1.79338474190411E-10
     -1.14788233040720E-22  -6.28402120408472E-09  -6.46335967827525E-09  -2.66792183006583E-18
      4.68061205674421E-09
      0.00000000000000E+00   9.31764858970359E-13   0.00000000000000E+00   3.93354819851906E-12  -4.80107796668823E-23
     -9.35710497403754E-10  -9.31776949205283E-10  -1.26351937917947E-18  -2.32289822092243E-02  -2.32289822159879E-02
      0.00000000000000E+00   0.00000000000000E+00   6.76353519869492E-09   0.00000000000000E+00   6.76353519869492E-09
      3.97611448365739E-18  -1.50883788208934E-01  -1.49046364759271E-01   0.00000000000000E+00  -1.83479288859383E-10
     -1.18599012031500E-22  -5.64827896063008E-09  -5.83175824948959E-09  -2.71259510447792E-18
      4.69082724541902E-09
      0.00000000000000E+00   5.39771520568635E-13   0.00000000000000E+00   1.83349621669862E-12  -4.80566045730964E-23
     -5.41577346814786E-10  -5.39743850598135E-10  -1.26831200612579E-18  -1.95615120116287E-02  -1.95615120174130E-02
      0.00000000000000E+00   0.00000000000000E+00   5.78428672037603E-09   0.00000000000000E+00   5.78428672037603E-09
      4.03520206385520E-18  -1.82819060106006E-01  -1.81166649280452E-01   0.00000000000000E+00  -1.91266529821600E-10
     -1.23551200995518E-22  -5.05327633995604E-09  -5.24454286977777E-09  -2.76689005772941E-18
      4.70461775013001E-09
      0.00000000000000E+00   3.17507256526420E-13   0.00000000000000E+00   7.68384806533045E-13  -4.80854920386247E-23
     -3.18315213735920E-10  -3.17546828929435E-10  -1.27174618100744E-18  -1.65604039408226E-02  -1.65604039457245E-02
      0.00000000000000E+00   0.00000000000000E+00   4.90187080477305E-09   0.00000000000000E+00   4.90187080477305E-09
      4.10280133628107E-18  -2.22860175519474E-01  -2.21415778112101E-01   0.00000000000000E+00  -1.98344160968867E-10
     -1.29858365538193E-22  -4.38597981487469E-09  -4.58432397584368E-09  -2.83105515527363E-18
      4.72323493148984E-09
      0.00000000000000E+00   2.06926192928558E-13   0.00000000000000E+00   2.83443005881496E-13  -4.81025840227202E-23
     -2.07220889879236E-10  -2.06937446873403E-10  -1.27436520446113E-18  -1.40252721391143E-02  -1.40252721429790E-02
      0.00000000000000E+00   0.00000000000000E+00   3.86470807970638E-09   0.00000000000000E+00   3.86470807970638E-09
      4.17475130750377E-18  -2.67726500809351E-01  -2.66574031771761E-01   0.00000000000000E+00  -1.89464949244731E-10
     -1.37183503216904E-22  -3.46830568358808E-09  -3.65777063283295E-09  -2.90038610304263E-18
      4.74323493148984E-09
      0.00000000000000E+00   1.62105961171285E-13   0.00000000000000E+00   1.07404550738803E-13  -4.81113663457166E-23
     -1.62243052869726E-10  -1.62135648319035E-10  -1.27631744330586E-18  -1.22077436202217E-02  -1.22077436230107E-02
      0.00000000000000E+00   0.00000000000000E+00   2.78896946859167E-09   0.00000000000000E+00   2.78896946859167E-09
      4.23053069687560E-18  -3.02790264281329E-01  -3.01962613810049E-01   0.00000000000000E+00  -1.56724551053941E-10
     -1.43129795807814E-22  -2.47010926921863E-09  -2.62683382027271E-09  -2.95421325356974E-18
      4.76323493148984E-09
      0.00000000000000E+00   1.39695845292648E-13   0.00000000000000E+00   5.53601676357524E-14  -4.81144831917523E-23
     -1.39738531287383E-10  -1.39683171119795E-10  -1.27784446087685E-18  -1.09720689069299E-02  -1.09720689088380E-02
      0.00000000000000E+00   0.00000000000000E+00   1.90813310646765E-09   0.00000000000000E+00   1.90813310646765E-09
      4.26869335900495E-18  -3.26029363028552E-01  -3.25472168921275E-01   0.00000000000000E+00  -1.12732436053721E-10
     -1.47154889211637E-22  -1.65571749929387E-09  -1.76844993534773E-09  -2.99084889812810E-18
      4.78323493148984E-09
      0.00000000000000E+00   1.30970595257933E-13   0.00000000000000E+00   2.23813118066337E-14  -4.81159821218110E-23
     -1.31006996874653E-10  -1.30984615562894E-10  -1.27921289475073E-18  -1.00935404563327E-02  -1.00935404575427E-02
      0.00000000000000E+00   0.00000000000000E+00   1.21005583871827E-09   0.00000000000000E+00   1.21005583871827E-09
      4.29289447577932E-18  -3.39249145691340E-01  -3.38909161880680E-01   0.00000000000000E+00  -6.60590351861003E-11
     -1.49437109249702E-22  -1.01301218796918E-09  -1.07907122315543E-09  -3.01368158102858E-18
      4.80323493148984E-09
      0.00000000000000E+00   1.18204176786087E-13   0.00000000000000E+00   3.39684545109638E-14  -4.81131697850286E-23
     -1.18281013306233E-10  -1.18247044851771E-10  -1.28033697027129E-18  -9.52817329565885E-03  -9.52817329640683E-03
      0.00000000000000E+00   0.00000000000000E+00   7.47977731129318E-10   0.00000000000000E+00   7.47977731129318E-10
      4.30785403040191E-18  -3.45925769362742E-01  -3.45727365562816E-01   0.00000000000000E+00  -3.17945473359764E-11
     -1.50522070047383E-22  -5.97936138941383E-10  -6.29730686277510E-10  -3.02751706013061E-18
      4.82323493148984E-09
      0.00000000000000E+00   8.74361898215655E-14   0.00000000000000E+00   8.32683078847539E-14  -4.80987814193490E-23
     -8.75534320241627E-11  -8.74701637163260E-11  -1.28085697000086E-18  -9.31305638642323E-03  -9.31305638713088E-03
      0.00000000000000E+00   0.00000000000000E+00   7.07649208238321E-10   0.00000000000000E+00   7.07649208238321E-10
      4.32200701456667E-18  -3.52970472898053E-01  -3.52775078167534E-01   0.00000000000000E+00  -3.30198787760302E-11
     -1.51617135679532E-22  -5.87159165745853E-10  -6.20179044522034E-10  -3.04115004456581E-18
      4.84323493148984E-09
      0.00000000000000E+00   6.09849055057978E-14   0.00000000000000E+00   7.68564572344076E-14  -4.80759285521104E-23
     -6.10774869741440E-11  -6.10006305169577E-11  -1.28086351435964E-18  -9.27059006401202E-03  -9.27059006498763E-03
      0.00000000000000E+00   0.00000000000000E+00   9.75612401446449E-10   0.00000000000000E+00   9.75612401446449E-10
      4.34151926259560E-18  -3.64948138229693E-01  -3.64659971364215E-01   0.00000000000000E+00  -6.08472995971540E-11
     -1.53578290878308E-22  -8.53764471332151E-10  -9.14611770929459E-10  -3.06065574823596E-18
      4.84573493148984E-09
      0.00000000000000E+00   4.03198396341042E-14   0.00000000000000E+00   4.15554454005199E-13  -4.80710008147777E-23
     -4.07647412597127E-11  -4.03491868057556E-11  -1.28081298304426E-18  -9.29244578616001E-03  -9.29244578719362E-03
      0.00000000000000E+00   0.00000000000000E+00   1.03361205961537E-09   0.00000000000000E+00   1.03361205961537E-09
      4.34410329274464E-18  -3.66645468459529E-01  -3.66332518573784E-01   0.00000000000000E+00  -7.00940620258135E-11
     -1.53856065184319E-22  -9.23168810783825E-10  -9.93262872809792E-10  -3.06329030970037E-18
      4.84910993148984E-09
      0.00000000000000E+00   1.09295237276957E-14   0.00000000000000E+00   4.49809657565536E-13  -4.80626175176339E-23
     -1.13499161416404E-11  -1.09001064841229E-11  -1.28064599407649E-18  -9.36528454654275E-03  -9.36528454776522E-03
      0.00000000000000E+00   0.00000000000000E+00   1.22247225255581E-09   0.00000000000000E+00   1.22247225255581E-09
      4.34822913659701E-18  -3.69601143955974E-01  -3.69219406622836E-01   0.00000000000000E+00  -9.21609083303336E-11
     -1.54345025718010E-22  -1.11941123774092E-09  -1.21157214607141E-09  -3.06758314252053E-18
      4.85366618148984E-09
      0.00000000000000E+00   9.09262898354515E-15   0.00000000000000E+00   4.41497946315745E-14  -4.80536471990523E-23
     -9.15879167415867E-12  -9.11464187957515E-12  -1.28041369764759E-18  -9.44254472025160E-03  -9.44254472171428E-03
      0.00000000000000E+00   0.00000000000000E+00   1.46268659229171E-09   0.00000000000000E+00   1.46268659229171E-09
      4.35489350238314E-18  -3.74433226460581E-01  -3.73975237885551E-01   0.00000000000000E+00  -1.15048564051593E-10
     -1.55167574213056E-22  -1.33852338636055E-09  -1.45357195041230E-09  -3.07447980473556E-18
      4.85981711898984E-09
      0.00000000000000E+00   2.32367185135043E-14   0.00000000000000E+00  -9.43540585887821E-14  -4.80440940962226E-23
     -2.31341243032895E-11  -2.32284783619264E-11  -1.28018936902862E-18  -9.46869129927983E-03  -9.46869130094235E-03
      0.00000000000000E+00   0.00000000000000E+00   1.66252027365946E-09   0.00000000000000E+00   1.66252027365946E-09
      4.36511956067890E-18  -3.81758345685596E-01  -3.81241839159643E-01   0.00000000000000E+00  -1.33613698933223E-10
     -1.56449495902637E-22  -1.50567809636435E-09  -1.63929179529773E-09  -3.08493019165029E-18
      4.86812088461484E-09
      0.00000000000000E+00   4.05953738457268E-14   0.00000000000000E+00  -8.90038427885879E-14  -4.80338295660379E-23
     -4.05163502093209E-11  -4.06053540521575E-11  -1.28003532718653E-18  -9.39858404511834E-03  -9.39858404688964E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77130184746379E-09   0.00000000000000E+00   1.77130184746379E-09
      4.37982803607137E-18  -3.92135845726669E-01  -3.91590538631601E-01   0.00000000000000E+00  -1.45392649820817E-10
     -1.58310059766909E-22  -1.58530384359048E-09  -1.73069649341145E-09  -3.09979270888485E-18
      4.87933096820859E-09
      0.00000000000000E+00   5.89643212872322E-14   0.00000000000000E+00  -7.03777604901835E-14  -4.80236509523170E-23
     -5.89102120421168E-11  -5.89805898026550E-11  -1.28004126598610E-18  -9.17318493195520E-03  -9.17318493374997E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79476638056043E-09   0.00000000000000E+00   1.79476638056043E-09
      4.39994751722871E-18  -4.06099881093594E-01  -4.05552970079652E-01   0.00000000000000E+00  -1.51297495499061E-10
     -1.60877579676994E-22  -1.58448829525850E-09  -1.73578579075772E-09  -3.11990625124261E-18
      4.89446458106015E-09
      0.00000000000000E+00   8.91812398285085E-14   0.00000000000000E+00  -9.35729030814886E-14  -4.80187956572882E-23
     -8.90837871307054E-11  -8.91773600338349E-11  -1.28051933027105E-18  -8.59997674897265E-03  -8.59997675075109E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77843688575108E-09   0.00000000000000E+00   1.77843688575108E-09
      4.42686169253860E-18  -4.24235950451273E-01  -4.23703698681107E-01   0.00000000000000E+00  -1.54408068503755E-10
     -1.64333609028359E-22  -1.53485145721333E-09  -1.68925952571725E-09  -3.14634236226756E-18
      4.91446458106015E-09
      0.00000000000000E+00   1.38134484760120E-13   0.00000000000000E+00  -1.25018828071038E-13  -4.80307993021692E-23
     -1.38021264603649E-10  -1.38146283431768E-10  -1.28214947770319E-18  -7.27237432345985E-03  -7.27237432522178E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76193280373833E-09   0.00000000000000E+00   1.76193280373833E-09
      4.46210034861337E-18  -4.46797150064803E-01  -4.46285527092978E-01   0.00000000000000E+00  -1.57801255038918E-10
     -1.68869329183583E-22  -1.46598526526753E-09  -1.62378652030662E-09  -3.17995087091018E-18
      4.93446458106015E-09
      0.00000000000000E+00   1.70923055943207E-13   0.00000000000000E+00  -9.12980136807420E-14  -4.80537151239340E-23
     -1.70776091437283E-10  -1.70867389451012E-10  -1.28444992425613E-18  -5.57344361363121E-03  -5.57344361535535E-03
      0.00000000000000E+00   0.00000000000000E+00   1.72414399354712E-09   0.00000000000000E+00   1.72414399354712E-09
      4.49658322848431E-18  -4.68058311903264E-01  -4.67568903964089E-01   0.00000000000000E+00  -1.61258740493154E-10
     -1.73366895130508E-22  -1.39201786360286E-09  -1.55327660409619E-09  -3.21213330422819E-18
      4.95446458106015E-09
      0.00000000000000E+00   1.73586553322226E-13   0.00000000000000E+00  -1.83919596709832E-14  -4.80760701861214E-23
     -1.73617487274307E-10  -1.73635879234026E-10  -1.28682022344564E-18  -3.86040298044782E-03  -3.86040298210107E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65324521607144E-09   0.00000000000000E+00   1.65324521607144E-09
      4.52964813280574E-18  -4.88278010224193E-01  -4.87811812301088E-01   0.00000000000000E+00  -1.63258518915707E-10
     -1.77793468497370E-22  -1.31635081792149E-09  -1.47960933683737E-09  -3.24282790936011E-18
      4.97446458106015E-09
      0.00000000000000E+00   2.17947561393461E-13   0.00000000000000E+00  -1.28509849222277E-13  -4.81170025391614E-23
     -2.17824989133604E-10  -2.17953498982874E-10  -1.29008808369355E-18  -1.62665893171629E-03  -1.62665893337458E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65829148492529E-09   0.00000000000000E+00   1.65829148492529E-09
      4.56281396250424E-18  -5.07531260440591E-01  -5.07077434436037E-01   0.00000000000000E+00  -1.69219111491237E-10
     -1.82259034238027E-22  -1.27111887445103E-09  -1.44033798594245E-09  -3.27272587881070E-18
      4.99446458106015E-09
      0.00000000000000E+00  -1.16367282041936E-12   0.00000000000000E+00   3.61345755360025E-12  -4.75838486864867E-23
      1.16009853110037E-09   1.16371198865393E-09  -1.26582481824898E-18  -1.59706906992383E-02  -1.59706906986352E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.03155529442767E-10   0.00000000000000E+00  -6.03155529442767E-10
      4.55075085191539E-18  -5.27636725888360E-01  -5.27460122373541E-01   0.00000000000000E+00  -4.27888897941424E-11
     -1.83366065565851E-22  -5.17767569416850E-10  -5.60556459211175E-10  -3.28492603366642E-18
      5.01446458106015E-09
      0.00000000000000E+00  -2.98513764871903E-12   0.00000000000000E+00   4.94593426581219E-12  -4.64059375584525E-23
      2.98021248825784E-09   2.98515842252361E-09  -1.20567372563638E-18  -5.07159438693116E-02  -5.07159438658167E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.49486914463673E-09   0.00000000000000E+00  -3.49486914463673E-09
      4.48085346902266E-18  -5.48792882940803E-01  -5.48953530564972E-01   0.00000000000000E+00   1.18655014259562E-10
     -1.80226251408509E-22   3.91055707853797E-10   5.09710722113179E-10  -3.27517974338627E-18
      5.02446458106015E-09
      0.00000000000000E+00  -4.26141211695483E-12   0.00000000000000E+00   6.83014962697846E-12  -4.55891203407034E-23
      4.25455477151858E-09   4.26138492114551E-09  -1.16328756357006E-18  -7.43563587393053E-02  -7.43563587338932E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.41210037647341E-09   0.00000000000000E+00  -5.41210037647341E-09
      4.42673246525792E-18  -5.59641291372126E-01  -5.60003926166314E-01   0.00000000000000E+00   2.09760078593161E-10
     -1.77405835931696E-22   9.40955376735099E-10   1.15071545532808E-09  -3.26344490168786E-18
      5.02783958106015E-09
      0.00000000000000E+00  -4.84664678244119E-12   0.00000000000000E+00   9.08267791549744E-12  -4.52734586354100E-23
      4.83759345896718E-09   4.84667613688263E-09  -1.14709951986855E-18  -8.32071355967978E-02  -8.32071355905443E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.25356574711302E-09   0.00000000000000E+00  -6.25356574711302E-09
      4.40562668086141E-18  -5.63343909381169E-01  -5.63787266459408E-01   0.00000000000000E+00   2.42517173936221E-10
     -1.76293867974718E-22   1.16437243629431E-09   1.40688961023036E-09  -3.25852716099286E-18
      5.03239583106015E-09
      0.00000000000000E+00  -5.44988301642022E-12   0.00000000000000E+00   7.13742663097041E-12  -4.48211548564125E-23
      5.44276632118114E-09   5.44990374781207E-09  -1.12275259739422E-18  -9.63083426680651E-02  -9.63083426609696E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.09551330273122E-09   0.00000000000000E+00  -7.09551330273122E-09
      4.37329774837585E-18  -5.68389372024730E-01  -5.68907954908950E-01   0.00000000000000E+00   2.74705371761382E-10
     -1.74576441126572E-22   1.37090418315756E-09   1.64560955491877E-09  -3.25054515098162E-18
      5.03854676856015E-09
      0.00000000000000E+00  -6.09123481634038E-12   0.00000000000000E+00   5.73808023256463E-12  -4.41670366892232E-23
      6.08548439660440E-09   6.09122247683692E-09  -1.08674491773813E-18  -1.15249955086325E-01  -1.15249955078452E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.87331453009519E-09   0.00000000000000E+00  -7.87331453009519E-09
      4.32486948278339E-18  -5.75165481992367E-01  -5.75727083809895E-01   0.00000000000000E+00   2.97293955985311E-10
     -1.72031761885980E-22   1.48479809727311E-09   1.78209205325825E-09  -3.23812456504526E-18
      5.04685053418515E-09
      0.00000000000000E+00  -6.83591194561901E-12   0.00000000000000E+00   4.97137160134330E-12  -4.31295801350225E-23
      6.83094289897521E-09   6.83591427057651E-09  -1.03493259485660E-18  -1.41649985625915E-01  -1.41649985617452E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.46298107527786E-09   0.00000000000000E+00  -8.46298107527786E-09
      4.25459487144547E-18  -5.83997924445790E-01  -5.84510716833074E-01   0.00000000000000E+00   3.03070812965910E-10
     -1.68462719465943E-22   1.32399599173584E-09   1.62706680470158E-09  -3.21966227658887E-18
      5.05806061777890E-09
      0.00000000000000E+00  -8.21211348793659E-12   0.00000000000000E+00   6.51270316146674E-12  -4.03399840192353E-23
      8.20556242905458E-09   8.21207513221600E-09  -9.62836887385186E-19  -1.76863342953803E-01  -1.76863342944962E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.84047226068407E-09   0.00000000000000E+00  -8.84047226068407E-09
      4.15549243839498E-18  -5.94598462054913E-01  -5.94796705489311E-01   0.00000000000000E+00   2.93189498827826E-10
     -1.63683114786466E-22   3.35207629640402E-10   6.28397128468064E-10  -3.19265555100979E-18
      5.07319423063047E-09
      0.00000000000000E+00  -1.25619720868223E-11   0.00000000000000E+00   1.45092449567553E-11  -2.56415717058195E-23
      1.25474180352684E-08   1.25619272802252E-08  -8.67580266751720E-19  -2.21048363523670E-01  -2.21048363514523E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.14630561938266E-09   0.00000000000000E+00  -9.14630561938266E-09
      4.01707579012917E-18  -6.03013270180575E-01  -6.01937715452675E-01   0.00000000000000E+00   2.82997012247062E-10
     -1.57206022171949E-22  -3.69861867308947E-09  -3.41562166084257E-09  -3.14949552337745E-18
      5.09319423063047E-09
      0.00000000000000E+00  -2.62971688467335E-11   0.00000000000000E+00   3.40880451975824E-11   3.86540748310592E-23
      2.62630437321770E-08   2.62971317773746E-08  -7.59231221227746E-19  -2.68982247479288E-01  -2.68982247469620E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.66781694096161E-09   0.00000000000000E+00  -9.66781694096161E-09
      3.82371945130994E-18  -5.90354159241778E-01  -5.85116246492215E-01   0.00000000000000E+00   3.01761277852923E-10
     -1.47277202704222E-22  -1.69310761142657E-08  -1.66293148364129E-08  -3.06448823008219E-18
      5.11319423063047E-09
      0.00000000000000E+00  -4.64143808609841E-11   0.00000000000000E+00   4.98799686820625E-11   1.34492626553764E-22
      4.63644884048908E-08   4.64143683735729E-08  -6.80121550851839E-19  -3.03659559497326E-01  -3.03659559486962E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03644165126380E-08   0.00000000000000E+00  -1.03644165126380E-08
      3.61643112105717E-18  -5.41853961499415E-01  -5.30497862675294E-01   0.00000000000000E+00   3.17083549999463E-10
     -1.34589098213766E-22  -3.63670354109344E-08  -3.60499518609351E-08  -2.93630957020534E-18
      5.13319423063047E-09
      0.00000000000000E+00  -6.23007650557700E-11   0.00000000000000E+00   3.95265607468886E-11   2.09018392231118E-22
      6.22612331482921E-08   6.23007597090392E-08  -6.30301441707580E-19  -3.26565743456019E-01  -3.26565743445029E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09892389636369E-08   0.00000000000000E+00  -1.09892389636369E-08
      3.39664634178444E-18  -4.57733819673384E-01  -4.41569084342309E-01   0.00000000000000E+00   2.93617210406632E-10
     -1.18803197242937E-22  -5.16051379558088E-08  -5.13115207454022E-08  -2.76634490007686E-18
      5.15319423063047E-09
      0.00000000000000E+00  -6.51210414012015E-11   0.00000000000000E+00   7.12170095864202E-12   2.22823135026608E-22
      6.51139498006043E-08   6.51210715015631E-08  -6.06213268497864E-19  -3.39483159270753E-01  -3.39483159259207E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15463972994541E-08   0.00000000000000E+00  -1.15463972994541E-08
      3.16571839579536E-18  -3.43278192609251E-01  -3.26399702902837E-01   0.00000000000000E+00   2.45756067508386E-10
     -1.02484760026564E-22  -5.38204302696174E-08  -5.35746742021091E-08  -2.55950512729749E-18
      5.17319423063047E-09
      0.00000000000000E+00  -5.68538210709404E-11   0.00000000000000E+00  -2.04672567242080E-11   1.85504631036885E-22
      5.68742441687292E-08   5.68537769120051E-08  -5.98524463511207E-19  -3.46117316969046E-01  -3.46117316957132E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19132199232019E-08   0.00000000000000E+00  -1.19132199232019E-08
      2.92745399733132E-18  -2.19950914462732E-01  -2.05792138910588E-01   0.00000000000000E+00   1.73067854754551E-10
     -8.59186071055036E-23  -4.51136248435576E-08  -4.49405569888031E-08  -2.32892953382011E-18
      5.18319423063047E-09
      0.00000000000000E+00  -5.17658981638551E-11   0.00000000000000E+00  -2.52296691755657E-11   1.61338903706637E-22
      5.17911572596809E-08   5.17659275905055E-08  -5.96343963374581E-19  -3.48822629552409E-01  -3.48822629540422E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19873311854207E-08   0.00000000000000E+00  -1.19873311854207E-08
      2.80758068547711E-18  -1.63135985755098E-01  -1.50603371091665E-01   0.00000000000000E+00   1.16022596971057E-10
     -7.96066614166460E-23  -3.98946190020556E-08  -3.97785964050846E-08  -2.21123672210253E-18
      5.18994423063047E-09
      0.00000000000000E+00  -4.89596740632163E-11   0.00000000000000E+00  -2.06514133912100E-11   1.46094582557393E-22
      4.89803743265541E-08   4.89597229131631E-08  -5.94169044563513E-19  -3.50942503354523E-01  -3.50942503342596E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19273307996876E-08   0.00000000000000E+00  -1.19273307996876E-08
      2.72707120257922E-18  -1.28571476031105E-01  -1.16904008860397E-01   0.00000000000000E+00   8.62842445173049E-11
     -7.61344704379984E-23  -3.71186763579929E-08  -3.70323921134757E-08  -2.13290215801571E-18
      5.19450048063047E-09
      0.00000000000000E+00  -4.71601601271092E-11   0.00000000000000E+00  -1.95893401170458E-11   1.36531978907255E-22
      4.71796993399585E-08   4.71601099998416E-08  -5.92223582888634E-19  -3.52553253420223E-01  -3.52553253408357E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18660807890427E-08   0.00000000000000E+00  -1.18660807890427E-08
      2.67300637198414E-18  -1.07123073057478E-01  -9.60032596533122E-02   0.00000000000000E+00   7.23548451072807E-11
     -7.24803177750911E-23  -3.53663840559061E-08  -3.52940292107989E-08  -2.08078278909551E-18
      5.20065141813047E-09
      0.00000000000000E+00  -4.49423852577591E-11   0.00000000000000E+00  -1.78719692301164E-11   1.26038117445711E-22
      4.49602664384236E-08   4.49423944691936E-08  -5.87908234306082E-19  -3.55335586312660E-01  -3.55335586300939E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17211090925541E-08   0.00000000000000E+00  -1.17211090925541E-08
      2.60091056252516E-18  -8.18970997738484E-02  -7.14302920655497E-02   0.00000000000000E+00   5.91784794853945E-11
     -6.15485150514272E-23  -3.32804638561252E-08  -3.32212853766399E-08  -2.01300232821908E-18
      5.20895518375547E-09
      0.00000000000000E+00  -4.16155851866280E-11   0.00000000000000E+00  -1.98114346928984E-11   1.18009514500393E-22
      4.16354430619512E-08   4.16156316272584E-08  -5.77142491087693E-19  -3.60770479468058E-01  -3.60770479456636E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14214434140568E-08   0.00000000000000E+00  -1.14214434140568E-08
      2.50606957331563E-18  -5.59130098438619E-02  -4.63998953365029E-02   0.00000000000000E+00   4.81444713139783E-11
     -2.78672111255353E-23  -3.02423326845155E-08  -3.01941882132015E-08  -1.92892708222794E-18
      5.21456022555234E-09
      0.00000000000000E+00  -3.88071568122963E-11   0.00000000000000E+00  -2.47310052837160E-11   1.16307697650358E-22
      3.88319077532194E-08   3.88071767479358E-08  -5.66466689593499E-19  -3.65552183714894E-01  -3.65552183703757E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11367405484598E-08   0.00000000000000E+00  -1.11367405484598E-08
      2.44364767706056E-18  -4.30638987967777E-02  -3.43459128213399E-02   0.00000000000000E+00   4.38077181376732E-11
      7.13738024205707E-24  -2.77142439176136E-08  -2.76704361994759E-08  -1.87718098746706E-18
      5.21834362876523E-09
      0.00000000000000E+00  -3.69435352496184E-11   0.00000000000000E+00  -2.43426226782184E-11   1.17124401334155E-22
      3.69678644556790E-08   3.69435218330009E-08  -5.57618690263149E-19  -3.69323322261391E-01  -3.69323322250468E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09233262146028E-08   0.00000000000000E+00  -1.09233262146028E-08
      2.40232032956479E-18  -3.65087296909361E-02  -2.83106676687735E-02   0.00000000000000E+00   3.86877270614791E-11
      3.23396630653862E-23  -2.60588833454597E-08  -2.60201956183982E-08  -1.84470163930163E-18
      5.22345122310264E-09
      0.00000000000000E+00  -3.51000276843889E-11   0.00000000000000E+00  -1.78695893735206E-11   1.21173251154754E-22
      3.51178907583842E-08   3.51000211690108E-08  -5.43627641909511E-19  -3.75118684849611E-01  -3.75118684838929E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06825288816970E-08   0.00000000000000E+00  -1.06825288816970E-08
      2.34775830553949E-18  -3.04338852885379E-02  -2.27407690775782E-02   0.00000000000000E+00   2.91860563149121E-11
      6.34168999942550E-23  -2.44466783436284E-08  -2.44174922873135E-08  -1.80413066362998E-18
      5.23034647545813E-09
      0.00000000000000E+00  -3.35168999491427E-11   0.00000000000000E+00  -1.13464377325186E-11   1.29011950427564E-22
      3.35282338680078E-08   3.35168874302754E-08  -5.22897753163535E-19  -3.83571439297502E-01  -3.83571439287034E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04684429844578E-08   0.00000000000000E+00  -1.04684429844578E-08
      2.27557574939256E-18  -2.52585618066206E-02  -1.79967754665940E-02   0.00000000000000E+00   2.06054999235869E-11
      9.93706534460946E-23  -2.30690499457414E-08  -2.30484444458177E-08  -1.75267799622903E-18
      5.23965506613804E-09
      0.00000000000000E+00  -3.22769959968411E-11   0.00000000000000E+00  -6.55462069544557E-12   1.38964984210082E-22
      3.22835595904846E-08   3.22770049697893E-08  -4.94027902607927E-19  -3.95272597765404E-01  -3.95272597755103E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03015353231682E-08   0.00000000000000E+00  -1.03015353231682E-08
      2.17968297369450E-18  -2.10684757755458E-02  -1.41447379976773E-02   0.00000000000000E+00   1.42531434993052E-11
      1.37303543067599E-22  -2.19897227901204E-08  -2.19754696466209E-08  -1.68565507108657E-18
      5.25222166355593E-09
      0.00000000000000E+00  -3.12509065927586E-11   0.00000000000000E+00  -3.99351295698925E-12   1.45588834376125E-22
      3.12548972001805E-08   3.12509036872237E-08  -4.55806977438104E-19  -4.10798855283659E-01  -4.10798855273494E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01654961740379E-08   0.00000000000000E+00  -1.01654961740379E-08
      2.05193727572230E-18  -1.77065047758702E-02  -1.10631871292935E-02   0.00000000000000E+00   1.03241483916161E-11
      1.69170862854797E-22  -2.10957316615777E-08  -2.10854075131859E-08  -1.59613029828419E-18
      5.26918657007008E-09
      0.00000000000000E+00  -3.01596992699960E-11   0.00000000000000E+00  -3.13530067091643E-12   1.39012714727539E-22
      3.01628427198759E-08   3.01597074192051E-08  -4.07121058439602E-19  -4.30777539511955E-01  -4.30777539501933E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00223961940989E-08   0.00000000000000E+00  -1.00223961940989E-08
      1.88190826124167E-18  -1.49408246934595E-02  -8.59621294128261E-03   0.00000000000000E+00   8.20133311406177E-12
      1.78922213069095E-22  -2.01455125582205E-08  -2.01373112251063E-08  -1.47478720280207E-18
      5.28918657007008E-09
      0.00000000000000E+00  -2.89190605597967E-11   0.00000000000000E+00  -3.02662449000840E-12   1.14001670131768E-22
      2.89220880298570E-08   2.89190614053671E-08  -3.53970405491742E-19  -4.52925707739013E-01  -4.52925707729147E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.86636315969939E-09   0.00000000000000E+00  -9.86636315969939E-09
      1.68458099804768E-18  -1.28234356308546E-02  -6.82054346919989E-03   0.00000000000000E+00   7.06085683249192E-12
      1.54123465315626E-22  -1.90597591025004E-08  -1.90526982456677E-08  -1.33061059255594E-18
      5.30918657007008E-09
      0.00000000000000E+00  -2.78300575107271E-11   0.00000000000000E+00  -2.65763625593964E-12   8.13637271879739E-23
      2.78327404748584E-08   2.78300828386025E-08  -3.04558598984681E-19  -4.73868764430867E-01  -4.73868764421137E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.73013188883238E-09   0.00000000000000E+00  -9.73013188883238E-09
      1.48997836027104E-18  -1.13916495623667E-02  -5.68893225548361E-03   0.00000000000000E+00   5.99447919048759E-12
      1.10396008254047E-22  -1.81059454289608E-08  -1.80999509497702E-08  -1.18541976128636E-18
      5.32918657007008E-09
      0.00000000000000E+00  -2.69490827914325E-11   0.00000000000000E+00  -2.14807600381449E-12   5.13611033722114E-23
      2.69512008126018E-08   2.69490527365980E-08  -2.58332378695000E-19  -4.93803761111161E-01  -4.93803761101566E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.59545534378887E-09   0.00000000000000E+00  -9.59545534378887E-09
      1.29806925339526E-18  -1.03994092832306E-02  -4.93183999747088E-03   0.00000000000000E+00   4.96026544941422E-12
      6.69089704221219E-23  -1.73585576582585E-08  -1.73535973928090E-08  -1.03973687470026E-18
      5.34918657007008E-09
      0.00000000000000E+00  -2.63130579862704E-11   0.00000000000000E+00  -1.54584255394272E-12   2.94802721482834E-23
      2.63146123865765E-08   2.63130665440226E-08  -2.14628204958935E-19  -5.13010328404094E-01  -5.13010328394554E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.53963301585452E-09   0.00000000000000E+00  -9.53963301585452E-09
      1.10727659307817E-18  -9.69093720467545E-03  -4.40615575347168E-03   0.00000000000000E+00   4.17097260096907E-12
      3.43942444788170E-23  -1.67776045007691E-08  -1.67734335281681E-08  -8.92648388119233E-19
      5.36918657007008E-09
      0.00000000000000E+00  -2.70530510339514E-11   0.00000000000000E+00   1.84718326254058E-12   1.64586653472293E-23
      2.70512346689896E-08   2.70530818522522E-08  -1.69064471107043E-19  -5.33542614190114E-01  -5.33542614179658E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04560268384184E-08   0.00000000000000E+00  -1.04560268384184E-08
      8.98156056309801E-19  -9.37928678451741E-03  -4.15007345817119E-03   0.00000000000000E+00   3.10253910285077E-12
      1.47755821207576E-23  -1.66001575529366E-08  -1.65970550138338E-08  -7.29091585202758E-19
      5.38918657007008E-09
      0.00000000000000E+00  -2.79612117954594E-11   0.00000000000000E+00   2.26938597656110E-12   9.67406715076190E-24
      2.79589616625733E-08   2.79612310485499E-08  -1.22862052099621E-19  -5.54910142448285E-01  -5.54910142437051E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12342712693159E-08   0.00000000000000E+00  -1.12342712693159E-08
      6.73470630923483E-19  -9.25951978751119E-03  -3.98937504667865E-03   0.00000000000000E+00   2.23489492904642E-12
      4.76189985373876E-24  -1.67291946741631E-08  -1.67269597792341E-08  -5.50608578823862E-19
      5.39168657007008E-09
      0.00000000000000E+00  -2.82020286964176E-11   0.00000000000000E+00   4.73752706760057E-12   8.87667411780078E-24
      2.81972983225241E-08   2.82020358495917E-08  -1.17145286223296E-19  -5.57602516968321E-01  -5.57602516956839E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14820468799274E-08   0.00000000000000E+00  -1.14820468799274E-08
      6.44765513723664E-19  -9.25128232969086E-03  -3.98333368222683E-03   0.00000000000000E+00   2.58597592261084E-12
      3.53053143066786E-24  -1.67225749455874E-08  -1.67199889696647E-08  -5.27620227500369E-19
      5.39506157007008E-09
      0.00000000000000E+00  -2.85680299741896E-11   0.00000000000000E+00   5.37687896755231E-12   8.01012316238751E-24
      2.85626703987263E-08   2.85680472776939E-08  -1.09332734541183E-19  -5.61298165198763E-01  -5.61298165187051E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17125799996112E-08   0.00000000000000E+00  -1.17125799996112E-08
      6.05235556224976E-19  -9.30053651433115E-03  -3.98990174275683E-03   0.00000000000000E+00   5.08589841436605E-13
      2.21217993350443E-24  -1.68559758679240E-08  -1.68554672780825E-08  -4.95902821683793E-19
      5.39961782007008E-09
      0.00000000000000E+00  -2.90223858891552E-11   0.00000000000000E+00   4.95947791220414E-12   7.15731795064687E-24
      2.90174228178313E-08   2.90223822957435E-08  -9.87182995947008E-20  -5.66343349719498E-01  -5.66343349707576E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19215426448242E-08   0.00000000000000E+00  -1.19215426448242E-08
      5.50918027549496E-19  -9.38800624783233E-03  -4.00006144980033E-03   0.00000000000000E+00  -1.97636271444963E-13
      9.32128886585975E-25  -1.71006420146480E-08  -1.71008396509194E-08  -4.52199727954796E-19
      5.40269328882008E-09
      0.00000000000000E+00  -2.92939707770779E-11   0.00000000000000E+00   4.39972292782259E-12   6.68834254460694E-24
      2.92895581913798E-08   2.92939579143076E-08  -9.15697328217206E-20  -5.69757048654350E-01  -5.69757048642321E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20287866407725E-08   0.00000000000000E+00  -1.20287866407725E-08
      5.13923870135383E-19  -9.44375623028163E-03  -4.00403525405017E-03   0.00000000000000E+00  -2.08035930571193E-13
      2.37576783391882E-25  -1.72649632376048E-08  -1.72651712735353E-08  -4.22354137313662E-19
      5.40684517163258E-09
      0.00000000000000E+00  -2.95224804832502E-11   0.00000000000000E+00   2.76516125180605E-12   6.19717852376231E-24
      2.95196904703638E-08   2.95224556316156E-08  -8.19892624798579E-20  -5.74347217398376E-01  -5.74347217386300E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20756143605355E-08   0.00000000000000E+00  -1.20756143605355E-08
      4.63787334421497E-19  -9.49147386720804E-03  -3.99451396932192E-03   0.00000000000000E+00   2.32035106524032E-13
     -4.41866337613449E-25  -1.74470733061867E-08  -1.74468412710802E-08  -3.81798071941639E-19
      5.41245021342945E-09
      0.00000000000000E+00  -2.95692294544888E-11   0.00000000000000E+00   4.57254073606185E-13   5.69504720553014E-24
      2.95688156935084E-08   2.95692729475820E-08  -6.93553137863941E-20  -5.80426104790122E-01  -5.80426104778151E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19709067107644E-08   0.00000000000000E+00  -1.19709067107644E-08
      3.96689901961171E-19  -9.49817842887406E-03  -3.95347731657195E-03   0.00000000000000E+00   9.82997956769178E-13
     -1.04483831501295E-24  -1.75993492347746E-08  -1.75983662368178E-08  -3.27334588174776E-19
      5.42001701985523E-09
      0.00000000000000E+00  -2.92056161398842E-11   0.00000000000000E+00  -2.33556071055218E-12   5.17429333099262E-24
      2.92079463300214E-08   2.92056107693108E-08  -5.32446269665582E-20  -5.88220095513448E-01  -5.88220095501929E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15196119940538E-08   0.00000000000000E+00  -1.15196119940538E-08
      3.09523227902058E-19  -9.43034096090244E-03  -3.85802890200748E-03   0.00000000000000E+00   1.59778715842581E-12
     -1.52882360845385E-24  -1.76875965624155E-08  -1.76859987752571E-08  -2.56278600935500E-19
      5.43023220853004E-09
      0.00000000000000E+00  -2.78296901317783E-11   0.00000000000000E+00  -6.61886143716582E-12   4.56862532076640E-24
      2.78362970008711E-08   2.78296781394339E-08  -3.45642882412683E-20  -5.97295592998799E-01  -5.97295592988678E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01215017729937E-08   0.00000000000000E+00  -1.01215017729937E-08
      2.06130177618558E-19  -9.24006689328554E-03  -3.66076638406449E-03   0.00000000000000E+00   1.73907248126312E-12
     -1.88845378886526E-24  -1.77099154389215E-08  -1.77081763664403E-08  -1.71565889377289E-19
      5.44402271324103E-09
      0.00000000000000E+00  -2.33471158876277E-11   0.00000000000000E+00  -1.60175463730914E-11   3.61652151942446E-24
      2.33631675106199E-08   2.33471499642468E-08  -2.09152547177920E-20  -6.03792131657525E-01  -6.03792131651874E-01
      0.00000000000000E+00   0.00000000000000E+00  -5.65143669548273E-09   0.00000000000000E+00  -5.65143669548273E-09
      1.28194013245662E-19  -8.78148561670991E-03  -3.20611041416180E-03   0.00000000000000E+00   1.05348430908701E-12
     -2.17745425282953E-24  -1.76967667530731E-08  -1.76957132687640E-08  -1.07278758527870E-19
      5.46263989460086E-09
      0.00000000000000E+00  -1.04229081572590E-11   0.00000000000000E+00  -3.42254483713730E-11   1.56749959463307E-24
      1.04571400569290E-08   1.04229146085576E-08  -4.59119143296841E-20  -5.90745399365373E-01  -5.90745399372640E-01
      0.00000000000000E+00   0.00000000000000E+00   7.26706937594632E-09   0.00000000000000E+00   7.26706937594632E-09
      2.63486361772132E-19  -7.66947358540881E-03  -2.09590259575406E-03   0.00000000000000E+00  -1.24956987920963E-12
     -2.66506976257862E-24  -1.76887344146246E-08  -1.76899839845038E-08  -2.17574447442448E-19
      5.48263989460086E-09
      0.00000000000000E+00   8.61007673425680E-12   0.00000000000000E+00  -4.67903080367827E-11  -2.27355582438516E-24
     -8.56314533741519E-09  -8.60993564545198E-09  -1.49207204625843E-19  -5.40697525217392E-01  -5.40697525243681E-01
      0.00000000000000E+00   0.00000000000000E+00   2.62894307674379E-08   0.00000000000000E+00   2.62894307674379E-08
      7.89274977120890E-19  -6.01159654997479E-03  -4.41371707734544E-04   0.00000000000000E+00  -5.37724824284490E-12
     -4.82267733087242E-24  -1.76741178737431E-08  -1.76794951219859E-08  -6.40067772495047E-19
      5.50263989460086E-09
      0.00000000000000E+00   2.27503087852532E-11   0.00000000000000E+00  -3.50427333632017E-11  -1.24605219644880E-23
     -2.27152383750902E-08  -2.27502811084534E-08  -3.44717787114272E-19  -4.55243558111581E-01  -4.55243558151956E-01
      0.00000000000000E+00   0.00000000000000E+00   4.03752870418634E-08   0.00000000000000E+00   4.03752870418634E-08
      1.59678071795816E-18  -4.31982522470737E-03   1.23326892954671E-03   0.00000000000000E+00  -1.17012576971895E-11
     -1.91921064235399E-23  -1.76133046757128E-08  -1.76250059334100E-08  -1.25206293084389E-18
      5.52263989460086E-09
      0.00000000000000E+00   2.32871412742312E-11   0.00000000000000E+00  -1.70620961261102E-12  -3.62415519749712E-23
     -2.32854391467622E-08  -2.32871453563748E-08  -6.33790514100367E-19  -3.39781209190006E-01  -3.39781209230956E-01
      0.00000000000000E+00   0.00000000000000E+00   4.09498812654621E-08   0.00000000000000E+00   4.09498812654621E-08
      2.41577834326740E-18  -2.01981092406193E-03   3.54515949311129E-03   0.00000000000000E+00  -2.70267665914470E-11
     -6.47411865615529E-23  -1.76357091424958E-08  -1.76627359090873E-08  -1.78198782916703E-18
      5.54263989460086E-09
      0.00000000000000E+00   1.47369473086337E-11   0.00000000000000E+00   2.04527597156256E-11  -4.30370431909694E-23
     -1.47574373912084E-08  -1.47369846314929E-08  -9.13485012439038E-19  -2.16607047876556E-01  -2.16607047907456E-01
      0.00000000000000E+00   0.00000000000000E+00   3.09001945736635E-08   0.00000000000000E+00   3.09001945736635E-08
      3.03378223474067E-18  -9.98153375765048E-03  -4.88903281553892E-03   0.00000000000000E+00  -5.76517680346416E-11
     -8.17092899703327E-23  -1.61055581741359E-08  -1.61632099421706E-08  -2.12029722230163E-18
      5.56263989460086E-09
      0.00000000000000E+00   9.85576690500249E-12   0.00000000000000E+00   1.12454675045367E-11  -4.59201079167863E-23
     -9.86698998084547E-09  -9.85574451334098E-09  -1.10924947345957E-18  -1.15072664174032E-01  -1.15072664196696E-01
      0.00000000000000E+00   0.00000000000000E+00   2.26636946095807E-08   0.00000000000000E+00   2.26636946095807E-08
      3.48705612693228E-18  -3.99522824455694E-02  -3.59169189445828E-02   0.00000000000000E+00  -1.07582165654343E-10
     -9.47943755326908E-23  -1.27003679305853E-08  -1.28079500962397E-08  -2.37780665347272E-18
      5.57263989460086E-09
      0.00000000000000E+00   7.27226629209197E-12   0.00000000000000E+00   1.18496176804861E-11  -4.69872453156347E-23
     -7.28414384557095E-09  -7.27229422789051E-09  -1.18131257730331E-18  -7.39981472766306E-02  -7.39981472946594E-02
      0.00000000000000E+00   0.00000000000000E+00   1.80288258793462E-08   0.00000000000000E+00   1.80288258793462E-08
      3.66734438572575E-18  -6.11087110768304E-02  -5.77196612392847E-02   0.00000000000000E+00  -1.56112483387984E-10
     -1.01447600186657E-22  -1.06004191680676E-08  -1.07565316514557E-08  -2.48603180842243E-18
      5.57938989460086E-09
      0.00000000000000E+00   5.26444849199823E-12   0.00000000000000E+00   1.39007750067233E-11  -4.74718100839449E-23
     -5.27831845787067E-09  -5.26441768286399E-09  -1.21636891321935E-18  -5.31538105120604E-02  -5.31538105266074E-02
      0.00000000000000E+00   0.00000000000000E+00   1.45469697146590E-08   0.00000000000000E+00   1.45469697146590E-08
      3.76553643129969E-18  -7.81949837622029E-02  -7.52703291293122E-02   0.00000000000000E+00  -1.73361016614100E-10
     -1.05730409580191E-22  -9.10919101518095E-09  -9.28255203179516E-09  -2.54916751808034E-18
      5.58394614460086E-09
      0.00000000000000E+00   3.85977508114631E-12   0.00000000000000E+00   1.46018845146199E-11  -4.76861317055068E-23
     -3.87435887715837E-09  -3.85975699264379E-09  -1.23362488575350E-18  -4.26316790021003E-02  -4.26316790142241E-02
      0.00000000000000E+00   0.00000000000000E+00   1.21238490636548E-08   0.00000000000000E+00   1.21238490636548E-08
      3.82077571859597E-18  -9.09506660594031E-02  -8.83468918438705E-02   0.00000000000000E+00  -1.78025631959016E-10
     -1.08471102893506E-22  -8.08606643905160E-09  -8.26409207101072E-09  -2.58715083284247E-18
      5.58702161335086E-09
      0.00000000000000E+00   2.98421920134696E-12   0.00000000000000E+00   1.35824434495067E-11  -4.77880924889421E-23
     -2.99778997136017E-09  -2.98420752791071E-09  -1.24257837640883E-18  -3.70733145592381E-02  -3.70733145698368E-02
      0.00000000000000E+00   0.00000000000000E+00   1.05987441011538E-08   0.00000000000000E+00   1.05987441011538E-08
      3.85337182486832E-18  -1.00042620254588E-01  -9.76434982474308E-02   0.00000000000000E+00  -1.79399020855076E-10
     -1.10246111338772E-22  -7.43513755238825E-09  -7.61453657324344E-09  -2.61079344845949E-18
      5.59117349616336E-09
      0.00000000000000E+00   2.12014391369855E-12   0.00000000000000E+00   9.96905620325891E-12  -4.78810210164135E-23
     -2.13007557527553E-09  -2.12010651907232E-09  -1.25107720594640E-18  -3.16651174418586E-02  -3.16651174509285E-02
      0.00000000000000E+00   0.00000000000000E+00   9.06981823470086E-09   0.00000000000000E+00   9.06981823470086E-09
      3.89102864730947E-18  -1.12892976638119E-01  -1.10703320481787E-01   0.00000000000000E+00  -1.78629996787130E-10
     -1.12517998105426E-22  -6.77108171884170E-09  -6.94971171562895E-09  -2.63995144136307E-18
      5.59677853796023E-09
      0.00000000000000E+00   1.38474310287788E-12   0.00000000000000E+00   6.28616338685799E-12  -4.79581843962643E-23
     -1.39109733582056E-09  -1.38481117243375E-09  -1.25843097624700E-18  -2.67983428638546E-02  -2.67983428715537E-02
      0.00000000000000E+00   0.00000000000000E+00   7.69911668353531E-09   0.00000000000000E+00   7.69911668353531E-09
      3.93418251811970E-18  -1.30735570393174E-01  -1.28746111115638E-01   0.00000000000000E+00  -1.79880417791323E-10
     -1.15437045805514E-22  -6.13442509331011E-09  -6.31430551110155E-09  -2.67575154187270E-18
      5.60434534438601E-09
      0.00000000000000E+00   8.47543234951057E-13   0.00000000000000E+00   3.39736665225170E-12  -4.80175336615303E-23
     -8.50904944396379E-10  -8.47507577744175E-10  -1.26429972612441E-18  -2.26607882678546E-02  -2.26607882744360E-02
      0.00000000000000E+00   0.00000000000000E+00   6.58142831807520E-09   0.00000000000000E+00   6.58142831807520E-09
      3.98398291220773E-18  -1.54920539686058E-01  -1.53113941377697E-01   0.00000000000000E+00  -1.84576981894247E-10
     -1.19223497688877E-22  -5.54934375843664E-09  -5.73392074033101E-09  -2.71968318608333E-18
      5.61456053306082E-09
      0.00000000000000E+00   5.03125470422832E-13   0.00000000000000E+00   1.60842614653209E-12  -4.80597744957490E-23
     -5.04740979175371E-10  -5.03132553028887E-10  -1.26872037060631E-18  -1.92238826767887E-02  -1.92238826824653E-02
      0.00000000000000E+00   0.00000000000000E+00   5.67652575141851E-09   0.00000000000000E+00   5.67652575141851E-09
      4.04196969377586E-18  -1.86705578204946E-01  -1.85075584003966E-01   0.00000000000000E+00  -1.92455025168060E-10
     -1.24152968486427E-22  -4.98093817322159E-09  -5.17339319838978E-09  -2.77324932316955E-18
      5.62835103777181E-09
      0.00000000000000E+00   3.03455011733668E-13   0.00000000000000E+00   6.89872064314868E-13  -4.80868258219320E-23
     -3.04130986309943E-10  -3.03441114245676E-10  -1.27196247770055E-18  -1.63526755868048E-02  -1.63526755916262E-02
      0.00000000000000E+00   0.00000000000000E+00   4.82144417604028E-09   0.00000000000000E+00   4.82144417604028E-09
      4.10845984239930E-18  -2.26352836106810E-01  -2.24929334006400E-01   0.00000000000000E+00  -1.98761458879190E-10
     -1.30414538182223E-22  -4.31924160291522E-09  -4.51800306179454E-09  -2.83649736469875E-18
      5.64696821913164E-09
      0.00000000000000E+00   2.02425800805389E-13   0.00000000000000E+00   2.58750232168380E-13  -4.81031853180003E-23
     -2.02648555200384E-10  -2.02389804968264E-10  -1.27449931515511E-18  -1.38912993735638E-02  -1.38912993773528E-02
      0.00000000000000E+00   0.00000000000000E+00   3.78899044751153E-09   0.00000000000000E+00   3.78899044751153E-09
      4.17900016473129E-18  -2.70430046199096E-01  -2.69300000539949E-01   0.00000000000000E+00  -1.88053608715037E-10
     -1.37632556742766E-22  -3.39854703382803E-09  -3.58660064254320E-09  -2.90450084957618E-18
      5.66696821913164E-09
      0.00000000000000E+00   1.60360911164342E-13   0.00000000000000E+00   1.00773525768167E-13  -4.81116046043488E-23
     -1.60468833844218E-10  -1.60368060318498E-10  -1.27641803694496E-18  -1.21177190678498E-02  -1.21177190705741E-02
      0.00000000000000E+00   0.00000000000000E+00   2.72433019483827E-09   0.00000000000000E+00   2.72433019483827E-09
      4.23348676862806E-18  -3.04650006058649E-01  -3.03842164803733E-01   0.00000000000000E+00  -1.54026354336393E-10
     -1.43448120402425E-22  -2.40993578018334E-09  -2.56396213451988E-09  -2.95706873168310E-18
      5.68696821913164E-09
      0.00000000000000E+00   1.38869242657780E-13   0.00000000000000E+00   5.32109496477381E-14  -4.81145229109380E-23
     -1.38880264543142E-10  -1.38827053593542E-10  -1.27792915936326E-18  -1.09101162670828E-02  -1.09101162689411E-02
      0.00000000000000E+00   0.00000000000000E+00   1.85832836535034E-09   0.00000000000000E+00   1.85832836535034E-09
      4.27065333593507E-18  -3.27192303197369E-01  -3.26650531781476E-01   0.00000000000000E+00  -1.09753014101303E-10
     -1.47355423297481E-22  -1.60974829765527E-09  -1.71950131175672E-09  -2.99272417657181E-18
      5.70696821913164E-09
      0.00000000000000E+00   1.30878750520726E-13   0.00000000000000E+00   2.05365966148627E-14  -4.81160599979427E-23
     -1.30889835136458E-10  -1.30869298539891E-10  -1.27929601973155E-18  -1.00477769170909E-02  -1.00477769182605E-02
      0.00000000000000E+00   0.00000000000000E+00   1.16963226614750E-09   0.00000000000000E+00   1.16963226614750E-09
      4.29404598125802E-18  -3.39812098465969E-01  -3.39484815117803E-01   0.00000000000000E+00  -6.30483391635473E-11
     -1.49531144937816E-22  -9.75714628443945E-10  -1.03876296760764E-09  -3.01474996152647E-18
      5.72696821913164E-09
      0.00000000000000E+00   1.16275437304729E-13   0.00000000000000E+00   3.87604986509910E-14  -4.81124700536066E-23
     -1.16344839451996E-10  -1.16306078953393E-10  -1.28038194221994E-18  -9.50899989491340E-03  -9.50899989564759E-03
      0.00000000000000E+00   0.00000000000000E+00   7.34198740095330E-10   0.00000000000000E+00   7.34198740095330E-10
      4.30872995605992E-18  -3.46341435373994E-01  -3.46146761534888E-01   0.00000000000000E+00  -3.09420249023645E-11
     -1.50585736474543E-22  -5.86950636239440E-10  -6.17892661141955E-10  -3.02834801383999E-18
      5.74696821913164E-09
      0.00000000000000E+00   8.61503635006601E-14   0.00000000000000E+00   8.18611442496796E-14  -4.80977027020901E-23
     -8.62649083188524E-11  -8.61830471746508E-11  -1.28087699244881E-18  -9.30504346296990E-03  -9.30504346368299E-03
      0.00000000000000E+00   0.00000000000000E+00   7.13090502888316E-10   0.00000000000000E+00   7.13090502888316E-10
      4.32299176611769E-18  -3.53510422771127E-01  -3.53312907988355E-01   0.00000000000000E+00  -3.37017070738285E-11
     -1.51701464213452E-22  -5.93205748639615E-10  -6.26907455713595E-10  -3.04211477366888E-18
      5.76696821913164E-09
      0.00000000000000E+00   5.84132528639870E-14   0.00000000000000E+00   8.05159040191154E-14  -4.80738885666308E-23
     -5.84721742565063E-11  -5.83916583525352E-11  -1.28083267993695E-18  -9.27730061255542E-03  -9.27730061356460E-03
      0.00000000000000E+00   0.00000000000000E+00   1.00917720668512E-09   0.00000000000000E+00   1.00917720668512E-09
      4.34317531025139E-18  -3.66085775686775E-01  -3.65786210912932E-01   0.00000000000000E+00  -6.42820708961744E-11
     -1.53769393730714E-22  -8.86503477436323E-10  -9.50785548332651E-10  -3.06234263031445E-18
      5.78696821913164E-09
      0.00000000000000E+00   2.96658501180311E-14   0.00000000000000E+00   8.72113357513170E-14  -4.80406753968955E-23
     -2.97120066861166E-11  -2.96247953504133E-11  -1.28023724794750E-18  -9.33548826683935E-03  -9.33548826838416E-03
      0.00000000000000E+00   0.00000000000000E+00   1.54480499757292E-09   0.00000000000000E+00   1.54480499757292E-09
      4.37407141020285E-18  -3.87874505214777E-01  -3.87397106434833E-01   0.00000000000000E+00  -1.21364338832797E-10
     -1.57557651624786E-22  -1.39381586338946E-09  -1.51518020222242E-09  -3.09383416225535E-18
      5.80696821913164E-09
      0.00000000000000E+00   5.28107238943279E-14   0.00000000000000E+00  -4.52980397658339E-14  -4.80198847562962E-23
     -5.27527565300112E-11  -5.27980545698251E-11  -1.28013013479169E-18  -9.02222957869067E-03  -9.02222958042846E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73778631890494E-09   0.00000000000000E+00   1.73778631890494E-09
      4.40882713658095E-18  -4.12116119981440E-01  -4.11585215703786E-01   0.00000000000000E+00  -1.46976018342988E-10
     -1.61997383599239E-22  -1.53801224599196E-09  -1.68498826433511E-09  -3.12869700178925E-18
      5.82696821913164E-09
      0.00000000000000E+00   1.05070379365411E-13   0.00000000000000E+00  -1.26834526062055E-13  -4.80201366964011E-23
     -1.04900435414176E-10  -1.05027269940286E-10  -1.28108896743459E-18  -8.08265261354986E-03  -8.08265261530718E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75732146764822E-09   0.00000000000000E+00   1.75732146764822E-09
      4.44397356593391E-18  -4.35406116032268E-01  -4.34885511573356E-01   0.00000000000000E+00  -1.54885065455074E-10
     -1.66522504334829E-22  -1.49740913225265E-09  -1.65229419770789E-09  -3.16288459849932E-18
      5.84696821913164E-09
      0.00000000000000E+00   1.58248482208569E-13   0.00000000000000E+00  -1.39353926854048E-13  -4.80397392947475E-23
     -1.58138225780703E-10  -1.58277579707605E-10  -1.28313004901325E-18  -6.52323912972668E-03  -6.52323913147566E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74898030116373E-09   0.00000000000000E+00   1.74898030116373E-09
      4.47895317195719E-18  -4.57311690233144E-01  -4.56810490668112E-01   0.00000000000000E+00  -1.59740360142388E-10
     -1.71045494638258E-22  -1.43096236131371E-09  -1.59070272145627E-09  -3.19582312294394E-18
      5.86696821913164E-09
      0.00000000000000E+00   1.71749658578075E-13   0.00000000000000E+00  -4.42918903196527E-14  -4.80619330327541E-23
     -1.71692293413365E-10  -1.71736585303732E-10  -1.28545551842261E-18  -4.82343372864171E-03  -4.82343373033010E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68838807918873E-09   0.00000000000000E+00   1.68838807918873E-09
      4.51272093354096E-18  -4.78061919520388E-01  -4.77584050898719E-01   0.00000000000000E+00  -1.62238524845010E-10
     -1.75507372739237E-22  -1.35441296903968E-09  -1.51665149388486E-09  -3.22726541511835E-18
      5.88696821913164E-09
      0.00000000000000E+00   1.96088513938070E-13   0.00000000000000E+00  -7.54012988166199E-14  -4.80937325059604E-23
     -1.95995219656905E-10  -1.96070620955770E-10  -1.28828048956465E-18  -2.84658970487130E-03  -2.84658970652795E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65664562977768E-09   0.00000000000000E+00   1.65664562977768E-09
      4.54585384613652E-18  -4.97804683643761E-01  -4.97344482236178E-01   0.00000000000000E+00  -1.66204991311555E-10
     -1.79954059066987E-22  -1.29437001751027E-09  -1.46057500882201E-09  -3.25757335657187E-18
      5.90696821913164E-09
      0.00000000000000E+00  -1.81301511247658E-13   0.00000000000000E+00   9.78292216970436E-13  -4.79679391773576E-23
      1.80358836090616E-10   1.81337128307538E-10  -1.28358938246575E-18  -5.43762300914878E-03  -5.43762301013949E-03
      0.00000000000000E+00   0.00000000000000E+00   9.90701148812824E-10   0.00000000000000E+00   9.90701148812824E-10
      4.56566786911277E-18  -5.17147588778479E-01  -5.16778304073814E-01   0.00000000000000E+00  -1.33507979244591E-10
     -1.83440530489944E-22  -1.03853029787557E-09  -1.17203827712034E-09  -3.28207848664702E-18
      5.92696821913164E-09
      0.00000000000000E+00  -2.08910039252240E-12   0.00000000000000E+00   5.04819355745124E-12  -4.70827458456199E-23
      2.08407856606712E-09   2.08912675962452E-09  -1.24097421486029E-18  -3.05012137747722E-02  -3.05012137726835E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.08874006302112E-09   0.00000000000000E+00  -2.08874006302112E-09
      4.52389306785235E-18  -5.37877172259780E-01  -5.37877082678039E-01   0.00000000000000E+00   4.23174945877434E-11
     -1.82328154294336E-22  -4.27041911909520E-11  -3.86696603390859E-13  -3.28291885299206E-18
      5.94696821913164E-09
      0.00000000000000E+00  -3.87042907066239E-12   0.00000000000000E+00   4.91819960536949E-12  -4.56283196159191E-23
      3.86549856886666E-09   3.87041676847199E-09  -1.16399423495863E-18  -7.39264756848112E-02  -7.39264756799912E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.82007174975242E-09   0.00000000000000E+00  -4.82007174975242E-09
      4.42749163285730E-18  -5.59339446414085E-01  -5.59638727441728E-01   0.00000000000000E+00   1.83388476763630E-10
     -1.77415164587126E-22   7.66266504516979E-10   9.49654981280432E-10  -3.26349739789867E-18
      5.96696821913164E-09
      0.00000000000000E+00  -5.97624520535656E-12   0.00000000000000E+00   5.75233437226150E-12  -4.35838392866386E-23
      5.97046853368311E-09   5.97622086805532E-09  -1.05318471109099E-18  -1.32361088107098E-01  -1.32361088099679E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.41936885673738E-09   0.00000000000000E+00  -7.41936885673738E-09
      4.27910425572255E-18  -5.80681347125790E-01  -5.81136176541812E-01   0.00000000000000E+00   2.79498317357139E-10
     -1.69644139874903E-22   1.16364967132495E-09   1.44314798868192E-09  -3.22591954463156E-18
      5.96946821913164E-09
      0.00000000000000E+00  -6.54669286815251E-12   0.00000000000000E+00   1.16397350004221E-11  -4.32517760240652E-23
      6.53508012193650E-09   6.54671985693688E-09  -1.03823011646222E-18  -1.39930610167436E-01  -1.39930610159402E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.03459978410294E-09   0.00000000000000E+00  -8.03459978410294E-09
      4.25901775626230E-18  -5.83313337497333E-01  -5.83782265921589E-01   0.00000000000000E+00   2.79128975567518E-10
     -1.68652535929038E-22   1.20875095159998E-09   1.48787992716733E-09  -3.22078763980008E-18
      5.97284321913164E-09
      0.00000000000000E+00  -7.05505348859617E-12   0.00000000000000E+00   7.97595329136368E-12  -4.27218767144171E-23
      7.04711729929024E-09   7.05509325258156E-09  -1.01709909845596E-18  -1.50468479717518E-01  -1.50468479709042E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.47520677577618E-09   0.00000000000000E+00  -8.47520677577618E-09
      4.23041393339405E-18  -5.86812085561620E-01  -5.87259684593677E-01   0.00000000000000E+00   2.88249238360874E-10
     -1.67258399823882E-22   1.13186428483331E-09   1.42011352319402E-09  -3.21331483493809E-18
      5.97739946913164E-09
      0.00000000000000E+00  -7.67417886211210E-12   0.00000000000000E+00   7.17986691103133E-12  -4.17191676740557E-23
      7.66697540438493E-09   7.67415527129592E-09  -9.87790572219965E-19  -1.64828827259139E-01  -1.64828827250360E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.77866698391140E-09   0.00000000000000E+00  -8.77866698391140E-09
      4.19041613194861E-18  -5.91342169123669E-01  -5.91690370818007E-01   0.00000000000000E+00   2.89666958788452E-10
     -1.65345584079993E-22   8.14844753827172E-10   1.10451171261546E-09  -3.20262555972864E-18
      5.98355040663164E-09
      0.00000000000000E+00  -8.70192147146433E-12   0.00000000000000E+00   8.65007528196033E-12  -3.93441164856429E-23
      8.69328807575127E-09   8.70193815103319E-09  -9.47816129474373E-19  -1.83972962657444E-01  -1.83972962648461E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.98204711857253E-09   0.00000000000000E+00  -8.98204711857253E-09
      4.13516812150021E-18  -5.96902042796307E-01  -5.96990577817088E-01   0.00000000000000E+00   2.84465326017676E-10
     -1.62771131217718E-22  -4.35635847814535E-12   2.80108967539368E-10  -3.18735199202583E-18
      5.99185417225664E-09
      0.00000000000000E+00  -1.09173083776471E-11   0.00000000000000E+00   1.35013555194990E-11  -3.23276322834424E-23
      1.09038044121333E-08   1.09173057676528E-08  -8.94446599001126E-19  -2.08807268689491E-01  -2.08807268680340E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.15019771901485E-09   0.00000000000000E+00  -9.15019771901485E-09
      4.05918702421910E-18  -6.02737783650214E-01  -6.02181486781757E-01   0.00000000000000E+00   2.77190905404582E-10
     -1.59307152082045E-22  -2.04429895404233E-09  -1.76710804863790E-09  -3.16474042521798E-18
      6.00306425585039E-09
      0.00000000000000E+00  -1.63620480887837E-11   0.00000000000000E+00   2.42145996774842E-11  -9.39547190758501E-24
      1.63378389292930E-08   1.63620535289705E-08  -8.26186083552780E-19  -2.39537779980254E-01  -2.39537779970870E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.38393305517083E-09   0.00000000000000E+00  -9.38393305517083E-09
      3.95399235023248E-18  -6.05227558715587E-01  -6.03029844662038E-01   0.00000000000000E+00   2.77737535130410E-10
     -1.54436807518994E-22  -7.25585800892993E-09  -6.97812047379967E-09  -3.12780626667970E-18
      6.01819786870196E-09
      0.00000000000000E+00  -2.89225506598106E-11   0.00000000000000E+00   4.07255496859456E-11   5.11122792033872E-23
      2.88814288943145E-08   2.89221544440005E-08  -7.47116462605438E-19  -2.74174692677088E-01  -2.74174692667275E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.81336310952413E-09   0.00000000000000E+00  -9.81336310952413E-09
      3.80548071216114E-18  -5.92156954493439E-01  -5.86137860143308E-01   0.00000000000000E+00   3.00116223169945E-10
     -1.46781501235431E-22  -1.94089075576462E-08  -1.91087913344764E-08  -3.05836424955570E-18
      6.03819786870196E-09
      0.00000000000000E+00  -4.92804877302822E-11   0.00000000000000E+00   5.05028622795332E-11   1.48646006520362E-22
      4.92299563154335E-08   4.92804591777131E-08  -6.71987751112279E-19  -3.07192584209988E-01  -3.07192584199533E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.04553274763549E-08   0.00000000000000E+00  -1.04553274763549E-08
      3.59637416263404E-18  -5.38521890675082E-01  -5.26291505831871E-01   0.00000000000000E+00   3.24561205742395E-10
     -1.33564903794859E-22  -3.91496929071006E-08  -3.88251317013583E-08  -2.92438641152177E-18
      6.05819786870196E-09
      0.00000000000000E+00  -6.40650106127894E-11   0.00000000000000E+00   3.68084682030105E-11   2.17818452845508E-22
      6.40281958505819E-08   6.40650043187851E-08  -6.25516402830898E-19  -3.28780725976568E-01  -3.28780725965508E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10597427225593E-08   0.00000000000000E+00  -1.10597427225593E-08
      3.37517930818286E-18  -4.50024501782654E-01  -4.33326102736437E-01   0.00000000000000E+00   2.94599785518115E-10
     -1.17399485087718E-22  -5.32998613817437E-08  -5.30052615962257E-08  -2.74966290535196E-18
      6.07819786870196E-09
      0.00000000000000E+00  -6.51385837460082E-11   0.00000000000000E+00   2.77966593529684E-12   2.23531128854177E-22
      6.51357828102186E-08   6.51385624761541E-08  -6.04205224597373E-19  -3.40618970890342E-01  -3.40618970878734E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16076535563523E-08   0.00000000000000E+00  -1.16076535563523E-08
      3.14302623705581E-18  -3.32310692231655E-01  -3.15445933363869E-01   0.00000000000000E+00   2.43275091686736E-10
     -1.00969622144896E-22  -5.37741840114883E-08  -5.35309089198017E-08  -2.53882101245844E-18
      6.09819786870196E-09
      0.00000000000000E+00  -5.62498500790637E-11   0.00000000000000E+00  -2.20184286591083E-11   1.82708876226400E-22
      5.62718871239147E-08   5.62498686952558E-08  -5.97430873047846E-19  -3.46903229367915E-01  -3.46903229355983E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19316323835012E-08   0.00000000000000E+00  -1.19316323835012E-08
      2.90439358938579E-18  -2.09467418615358E-01  -1.95504677576110E-01   0.00000000000000E+00   1.65970325402794E-10
     -8.45007188836635E-23  -4.44842066371572E-08  -4.43182363117545E-08  -2.30696271633794E-18
      6.11819786870196E-09
      0.00000000000000E+00  -4.89891562238599E-11   0.00000000000000E+00  -1.80168048121873E-11   1.42610758531137E-22
      4.90071595481377E-08   4.89891427433256E-08  -5.88295274059088E-19  -3.54161831830144E-01  -3.54161831818316E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18273227023395E-08   0.00000000000000E+00  -1.18273227023395E-08
      2.66784713533900E-18  -1.09440687912645E-01  -9.77324136074045E-02   0.00000000000000E+00   8.76098443478601E-11
     -7.21658858739113E-23  -3.72494298853340E-08  -3.71618200409862E-08  -2.07955186127991E-18
      6.12319786870196E-09
      0.00000000000000E+00  -4.62541117945570E-11   0.00000000000000E+00  -2.70251151053280E-11   1.31535763044469E-22
      4.62811672412336E-08   4.62541421261284E-08  -5.86131057588404E-19  -3.55900221176373E-01  -3.55900221164542E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18306415492257E-08   0.00000000000000E+00  -1.18306415492257E-08
      2.60869392759287E-18  -8.69661659724023E-02  -7.61205940422788E-02   0.00000000000000E+00   7.26726820608751E-11
     -6.39935734618227E-23  -3.44961732589636E-08  -3.44235005769028E-08  -2.02256287000446E-18
      6.12994786870196E-09
      0.00000000000000E+00  -4.30700384450464E-11   0.00000000000000E+00  -2.33850945043085E-11   1.21165493064607E-22
      4.30934683470182E-08   4.30700832525140E-08  -5.79597662233694E-19  -3.59531474284512E-01  -3.59531474272928E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15839516558803E-08   0.00000000000000E+00  -1.15839516558803E-08
      2.53050225391568E-18  -6.28749236643563E-02  -5.29547740599043E-02   0.00000000000000E+00   5.53325977639640E-11
     -4.00423997790621E-23  -3.15414641943975E-08  -3.14861315966335E-08  -1.95090459168198E-18
      6.13906036870196E-09
      0.00000000000000E+00  -3.88842145468134E-11   0.00000000000000E+00  -2.27162672681570E-11   1.17965965050737E-22
      3.89069249640869E-08   3.88842086968189E-08  -5.62483800482264E-19  -3.67239876591309E-01  -3.67239876580181E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11284287161404E-08   0.00000000000000E+00  -1.11284287161404E-08
      2.42909444723985E-18  -4.17835178913098E-02  -3.30386406884331E-02   0.00000000000000E+00   4.22921500392528E-11
      1.34563325563201E-23  -2.77980721307179E-08  -2.77557799806787E-08  -1.86661064675758E-18
      6.14213583745196E-09
      0.00000000000000E+00  -3.71353989056449E-11   0.00000000000000E+00  -2.80190939162761E-11   1.18109465340786E-22
      3.71634189919715E-08   3.71353998980554E-08  -5.55475215679988E-19  -3.70226908424828E-01  -3.70226908413878E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09497070090162E-08   0.00000000000000E+00  -1.09497070090162E-08
      2.39541896551196E-18  -3.62620932657268E-02  -2.80118892436407E-02   0.00000000000000E+00   4.22620277726893E-11
      3.44085768837819E-23  -2.62279549168119E-08  -2.61856928890392E-08  -1.83994374983197E-18
      6.14628772026446E-09
      0.00000000000000E+00  -3.53841034565718E-11   0.00000000000000E+00  -2.09077403561320E-11   1.20691840935288E-22
      3.54049699252979E-08   3.53840621849418E-08  -5.44374701010004E-19  -3.74830316540498E-01  -3.74830316529772E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07259163042000E-08   0.00000000000000E+00  -1.07259163042000E-08
      2.35088621796024E-18  -3.09757031889344E-02  -2.32067668099351E-02   0.00000000000000E+00   3.21607988155485E-11
      6.03846190646364E-23  -2.46903066795573E-08  -2.46581458807416E-08  -1.80651151695024E-18
      6.15189276206133E-09
      0.00000000000000E+00  -3.38487349846735E-11   0.00000000000000E+00  -1.35589237899197E-11   1.26557172970690E-22
      3.38623147774680E-08   3.38487558536782E-08  -5.27792657718627E-19  -3.81600834043707E-01  -3.81600834033190E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05174482016286E-08   0.00000000000000E+00  -1.05174482016286E-08
      2.29193548119364E-18  -2.62781187479213E-02  -1.89272141718677E-02   0.00000000000000E+00   2.29884741726838E-11
      9.08312258572854E-23  -2.33542961262225E-08  -2.33313076520497E-08  -1.76414282347502E-18
      6.15945956848711E-09
      0.00000000000000E+00  -3.26263733771786E-11   0.00000000000000E+00  -7.96796430640617E-12   1.35130506226814E-22
      3.26343196804306E-08   3.26263517161244E-08  -5.04381821734675E-19  -3.91091302231086E-01  -3.91091302220735E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03507703976488E-08   0.00000000000000E+00  -1.03507703976488E-08
      2.21361320523693E-18  -2.23053335595035E-02  -1.52870436703709E-02   0.00000000000000E+00   1.60348005618251E-11
      1.24458540647811E-22  -2.22916161190375E-08  -2.22755813184756E-08  -1.70923138350225E-18
      6.16967475716192E-09
      0.00000000000000E+00  -3.16467574101231E-11   0.00000000000000E+00  -4.70167654831477E-12   1.43322643218321E-22
      3.16514654902052E-08   3.16467638136571E-08  -4.72864523684186E-19  -4.03864852954947E-01  -4.03864852944727E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02196061789070E-08   0.00000000000000E+00  -1.02196061789070E-08
      2.10921799993719E-18  -1.89959457225546E-02  -1.22449574367006E-02   0.00000000000000E+00   1.15378716167919E-11
      1.56971933198876E-22  -2.14386955063672E-08  -2.14271576347503E-08  -1.63635347625301E-18
      6.18346526187290E-09
      0.00000000000000E+00  -3.07073694379645E-11   0.00000000000000E+00  -3.32219346451565E-12   1.44310359330816E-22
      3.07107344336103E-08   3.07074122401459E-08  -4.32010340572418E-19  -4.20531898377332E-01  -4.20531898367237E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00953055600019E-08   0.00000000000000E+00  -1.00953055600019E-08
      1.96999864105314E-18  -1.62093078334086E-02  -9.71510736346316E-03   0.00000000000000E+00   8.95586802581332E-12
      1.77850734025227E-22  -2.06210625481700E-08  -2.06121066801440E-08  -1.53798830048072E-18
      6.20208244323274E-09
      0.00000000000000E+00  -2.95518707991566E-11   0.00000000000000E+00  -3.02566151138665E-12   1.28341510093343E-22
      2.95549167780653E-08   2.95518911165540E-08  -3.80559507423967E-19  -4.41799863021054E-01  -4.41799863011109E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.94449250846292E-09   0.00000000000000E+00  -9.94449250846292E-09
      1.78486022049160E-18  -1.38003547709340E-02  -7.62269764546897E-03   0.00000000000000E+00   7.53252454071431E-12
      1.70269483479758E-22  -1.96149311326319E-08  -1.96073986080910E-08  -1.40430071306763E-18
      6.22208244323274E-09
      0.00000000000000E+00  -2.83644101918005E-11   0.00000000000000E+00  -2.89808932284136E-12   9.82013628493291E-23
      2.83672843172297E-08   2.83643862279069E-08  -3.29339656655794E-19  -4.63321127551450E-01  -4.63321127541654E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.79687540437348E-09   0.00000000000000E+00  -9.79687540437348E-09
      1.58892271240413E-18  -1.20577665835621E-02  -6.20773865615831E-03   0.00000000000000E+00   6.55220255869003E-12
      1.33628321229205E-22  -1.85740630260923E-08  -1.85675108235335E-08  -1.25958305574834E-18
      6.24208244323274E-09
      0.00000000000000E+00  -2.73902130642403E-11   0.00000000000000E+00  -2.37646658925237E-12   6.58750596618157E-23
      2.73925415106921E-08   2.73901650441029E-08  -2.81517382520204E-19  -4.83761677165167E-01  -4.83761677155499E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.66813066324686E-09   0.00000000000000E+00  -9.66813066324686E-09
      1.39556009913919E-18  -1.08691619281932E-02  -5.28551189285946E-03   0.00000000000000E+00   5.45485138322416E-12
      8.81528530560797E-23  -1.77274892322393E-08  -1.77220343808560E-08  -1.11404271661899E-18
      6.26208244323274E-09
      0.00000000000000E+00  -2.65559873161843E-11   0.00000000000000E+00  -2.03358172480923E-12   3.94916398841784E-23
      2.65580426712048E-08   2.65560090894800E-08  -2.36836592861592E-19  -5.03200282982907E-01  -5.03200282973398E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.50866193083954E-09   0.00000000000000E+00  -9.50866193083954E-09
      1.20538686052240E-18  -1.00178977647517E-02  -4.64681646595094E-03   0.00000000000000E+00   4.56940402194733E-12
      4.93196271217917E-23  -1.70519165626625E-08  -1.70473471586405E-08  -9.68550267660810E-19
      6.28208244323274E-09
      0.00000000000000E+00  -2.65478131345728E-11   0.00000000000000E+00   3.49728312226486E-15   2.21343989316173E-23
      2.65478205442737E-08   2.65478240415568E-08  -1.92483679082282E-19  -5.22921114140793E-01  -5.22921114130878E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.91563690380936E-09   0.00000000000000E+00  -9.91563690380936E-09
      1.00707412244622E-18  -9.49512671787225E-03  -4.25484653142221E-03   0.00000000000000E+00   3.70844452858698E-12
      2.33328255022557E-23  -1.66358955822760E-08  -1.66321871377474E-08  -8.14590443363933E-19
      6.30208244323274E-09
      0.00000000000000E+00  -2.74716793461433E-11   0.00000000000000E+00   2.30394548806073E-12   1.25229552666224E-23
      2.74694017236397E-08   2.74717056691278E-08  -1.46507669358584E-19  -5.43901699080993E-01  -5.43901699070145E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08485558725526E-08   0.00000000000000E+00  -1.08485558725526E-08
      7.90103004995164E-19  -9.29784171838960E-03  -4.06040550314858E-03   0.00000000000000E+00   2.63691933174105E-12
      8.92818498106650E-24  -1.66257867159069E-08  -1.66231497965752E-08  -6.43595335636580E-19
      6.30458244323274E-09
      0.00000000000000E+00  -2.76595936784699E-11   0.00000000000000E+00   3.71267518296994E-12   1.13619341779245E-23
      2.76558914948305E-08   2.76596041700135E-08  -1.40816362084300E-19  -5.46543124930464E-01  -5.46543124919356E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11082338061843E-08   0.00000000000000E+00  -1.11082338061843E-08
      7.62332420479702E-19  -9.25699701016305E-03  -4.04217644312586E-03   0.00000000000000E+00   3.90577742461125E-12
      7.13969601274933E-24  -1.65552761412536E-08  -1.65513703638290E-08  -6.21516058395401E-19
      6.30795744323274E-09
      0.00000000000000E+00  -2.79098705873604E-11   0.00000000000000E+00   3.69235873447207E-12   1.00557610460095E-23
      2.79062394214100E-08   2.79099317801445E-08  -1.33046607260558E-19  -5.50162106894418E-01  -5.50162106883095E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13229796985060E-08   0.00000000000000E+00  -1.13229796985060E-08
      7.24117363997245E-19  -9.25360376116348E-03  -4.02757150784843E-03   0.00000000000000E+00   2.02138730570557E-12
      5.18115106194665E-24  -1.65889734689448E-08  -1.65869520816391E-08  -5.91070756736687E-19
      6.31251369323274E-09
      0.00000000000000E+00  -2.82708204045860E-11   0.00000000000000E+00   3.93852032112360E-12   8.73230703677487E-24
      2.82668926865676E-08   2.82708312068887E-08  -1.22463901875512E-19  -5.55117450911259E-01  -5.55117450899712E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15476834735164E-08   0.00000000000000E+00  -1.15476834735164E-08
      6.71503231171036E-19  -9.28665807495140E-03  -4.01771393667861E-03   0.00000000000000E+00   1.04409587722215E-12
      3.21469634217139E-24  -1.67241918292495E-08  -1.67231477333723E-08  -5.49039329295525E-19
      6.31866463073274E-09
      0.00000000000000E+00  -2.87721089802647E-11   0.00000000000000E+00   4.05352061889960E-12   7.50496965916663E-24
      2.87680689297884E-08   2.87721224504073E-08  -1.08083410438609E-19  -5.61900301521093E-01  -5.61900301509291E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18024636871519E-08   0.00000000000000E+00  -1.18024636871519E-08
      5.98907014685345E-19  -9.35875143006595E-03  -4.01213841263307E-03   0.00000000000000E+00   5.18361806230094E-13
      1.40742614740203E-24  -1.69701771250614E-08  -1.69696587632552E-08  -4.90823604246737E-19
      6.32281651354524E-09
      0.00000000000000E+00  -2.91275481132578E-11   0.00000000000000E+00   4.25533820248442E-12   6.86261925591282E-24
      2.91233165730232E-08   2.91275719112257E-08  -9.83860749145336E-20  -5.66507854841127E-01  -5.66507854829160E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19669600172624E-08   0.00000000000000E+00  -1.19669600172624E-08
      5.49221599071799E-19  -9.41981618271936E-03  -4.01303912939502E-03   0.00000000000000E+00   1.94279579056801E-13
      4.61025855639408E-25  -1.71608061735423E-08  -1.71606118939633E-08  -4.50835524157264E-19
      6.32561903444368E-09
      0.00000000000000E+00  -2.93489857746652E-11   0.00000000000000E+00   3.93649998583639E-12   6.49744893413950E-24
      2.93450375500842E-08   2.93489740500700E-08  -9.18594328823384E-20  -5.69622880188748E-01  -5.69622880176693E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20542690594806E-08   0.00000000000000E+00  -1.20542690594806E-08
      5.15439258117216E-19  -9.46188368260133E-03  -4.01285766624422E-03   0.00000000000000E+00   7.60141077476874E-14
     -6.90685446015733E-26  -1.72947810046982E-08  -1.72947049905904E-08  -4.23579825234878E-19
      6.32940243765657E-09
      0.00000000000000E+00  -2.95469111833474E-11   0.00000000000000E+00   2.62848412832901E-12   6.10154462022177E-24
      2.95442802477411E-08   2.95469087318695E-08  -8.31073425662363E-20  -5.73813568870009E-01  -5.73813568857914E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20955334845406E-08   0.00000000000000E+00  -1.20955334845406E-08
      4.69676977870179E-19  -9.50068588885035E-03  -4.00229758099528E-03   0.00000000000000E+00   3.57601444222414E-13
     -6.05707330224984E-25  -1.74517328487728E-08  -1.74513752473286E-08  -3.86569635303943E-19
      6.33451003199397E-09
      0.00000000000000E+00  -2.96079879335904E-11   0.00000000000000E+00   6.34332995461725E-13   5.68085651275554E-24
      2.96073208938283E-08   2.96079552268238E-08  -7.15258148062828E-20  -5.79381456565326E-01  -5.79381456553309E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.20169281149560E-08   0.00000000000000E+00  -1.20169281149560E-08
      4.08299383877259E-19  -9.50847396212048E-03  -3.96608529566546E-03   0.00000000000000E+00   9.85409294214254E-13
     -1.10271145630369E-24  -1.75920125211618E-08  -1.75910271118676E-08  -3.36773569070976E-19
      6.34140528434946E-09
      0.00000000000000E+00  -2.93466896562350E-11   0.00000000000000E+00  -1.83286558327580E-12   5.22854812429172E-24
      2.93485333756003E-08   2.93467005100171E-08  -5.66049548533155E-20  -5.86592181122357E-01  -5.86592181110691E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16663683089795E-08   0.00000000000000E+00  -1.16663683089795E-08
      3.27856830314717E-19  -9.45500413785021E-03  -3.88447761532337E-03   0.00000000000000E+00   1.56986134545890E-12
     -1.52280905711935E-24  -1.76819020623831E-08  -1.76803322010377E-08  -2.71251875461402E-19
      6.35071387502938E-09
      0.00000000000000E+00  -2.83183041337223E-11   0.00000000000000E+00  -5.42260970700722E-12   4.69889084995596E-24
      2.83237249690221E-08   2.83183023593151E-08  -3.86725926276937E-20  -5.95301771755847E-01  -5.95301771745239E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06082193271706E-08   0.00000000000000E+00  -1.06082193271706E-08
      2.29109258755314E-19  -9.30080593481862E-03  -3.72090493775276E-03   0.00000000000000E+00   1.79041261321827E-12
     -1.85205726468170E-24  -1.77118734447577E-08  -1.77100830321444E-08  -1.90436666127620E-19
      6.36328047244726E-09
      0.00000000000000E+00  -2.50259458390441E-11   0.00000000000000E+00  -1.29050481236864E-11   3.90974414372871E-24
      2.50388668282083E-08   2.50259617800846E-08  -2.23948299806751E-20  -6.03152835991766E-01  -6.03152835984440E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.32548643646620E-09   0.00000000000000E+00  -7.32548643646620E-09
      1.37052819818057E-19  -8.93980844008301E-03  -3.36293324427694E-03   0.00000000000000E+00   1.34620393183669E-12
     -2.11754394140133E-24  -1.77018215475502E-08  -1.77004753436184E-08  -1.14657989837382E-19
      6.38024537896141E-09
      0.00000000000000E+00  -1.50688741889017E-11   0.00000000000000E+00  -2.89372383223827E-11   2.28955884316108E-24
      1.50977887401236E-08   1.50688515018012E-08  -3.08552705855989E-20  -5.98405180145996E-01  -5.98405180148619E-01
      0.00000000000000E+00   0.00000000000000E+00   2.62224553744435E-09   0.00000000000000E+00   2.62224553744435E-09
      1.81538970217938E-19  -8.05803537662955E-03  -2.48411349271540E-03   0.00000000000000E+00  -4.09097349482725E-13
     -2.46936919233643E-24  -1.76906879418960E-08  -1.76910970392455E-08  -1.50683699632339E-19
      6.40024537896141E-09
      0.00000000000000E+00   3.36243582916755E-12   0.00000000000000E+00  -4.54280738841482E-11  -9.41566132990982E-25
     -3.31698299305783E-09  -3.36241106694197E-09  -1.10999869812044E-19  -5.58745938976931E-01  -5.58745938997981E-01
      0.00000000000000E+00   0.00000000000000E+00   2.10495756542498E-08   0.00000000000000E+00   2.10495756542498E-08
      6.02530483302934E-19  -6.48828998118545E-03  -9.15606465755006E-04   0.00000000000000E+00  -3.97354570142237E-12
     -3.79279362607956E-24  -1.76831910416065E-08  -1.76871645873079E-08  -4.91530613490891E-19
      6.42024537896141E-09
      0.00000000000000E+00   1.99250728240125E-11   0.00000000000000E+00  -4.09550221150701E-11  -8.15870136491097E-24
     -1.98840594970272E-08  -1.99250145191423E-08  -2.79383372676300E-19  -4.82645480548201E-01  -4.82645480585768E-01
      0.00000000000000E+00   0.00000000000000E+00   3.75672745405117E-08   0.00000000000000E+00   3.75672745405117E-08
      1.35387597411317E-18  -4.78534549631628E-03   7.73186977273260E-04   0.00000000000000E+00  -9.43263633553883E-12
     -1.21866639318950E-23  -1.76328273850337E-08  -1.76422600213693E-08  -1.07449260143687E-18
      6.44024537896141E-09
      0.00000000000000E+00   2.48060695381693E-11   0.00000000000000E+00  -1.23525803759021E-11  -3.02644557981577E-23
     -2.47936637258907E-08  -2.48060163062667E-08  -5.46232739324714E-19  -3.74714568825278E-01  -3.74714568867715E-01
      0.00000000000000E+00   0.00000000000000E+00   4.24374712298736E-08   0.00000000000000E+00   4.24374712298736E-08
      2.20262539871064E-18  -2.79955345054626E-03   2.75556403766475E-03   0.00000000000000E+00  -2.11790911972715E-11
     -5.25303854419020E-23  -1.76102758324097E-08  -1.76314549236070E-08  -1.65639265938593E-18
      6.46024537896141E-09
      0.00000000000000E+00   1.67984024352566E-11   0.00000000000000E+00   1.91806280637689E-11  -4.20122388908583E-23
     -1.68175247014807E-08  -1.67983440734169E-08  -8.43949767718571E-19  -2.49468903480009E-01  -2.49468903513837E-01
      0.00000000000000E+00   0.00000000000000E+00   3.38270566283325E-08   0.00000000000000E+00   3.38270566283325E-08
      2.87916653127729E-18  -4.75966327572699E-03   6.05532592295436E-04   0.00000000000000E+00  -4.76927832280894E-11
     -7.82756802286992E-23  -1.69810197716874E-08  -1.70287125549156E-08  -2.03521676355872E-18
      6.48024537896141E-09
      0.00000000000000E+00   1.09922536832084E-11   0.00000000000000E+00   1.35678357991258E-11  -4.52076554156371E-23
     -1.10058504900567E-08  -1.09922826542576E-08  -1.06207714457471E-18  -1.40862673872289E-01  -1.40862673896980E-01
      0.00000000000000E+00   0.00000000000000E+00   2.46905985326413E-08   0.00000000000000E+00   2.46905985326413E-08
      3.37297850193012E-18  -2.92698877257831E-02  -2.49539991067097E-02   0.00000000000000E+00  -9.04736875868295E-11
     -9.10362936510128E-23  -1.36078421907968E-08  -1.36983158783837E-08  -2.31090135735541E-18
      6.50024537896141E-09
      0.00000000000000E+00   6.93730853549612E-12   0.00000000000000E+00   9.19566390263637E-12  -4.72766792020138E-23
     -6.94646694745077E-09  -6.93727128354818E-09  -1.19940392820431E-18  -6.31894458382025E-02  -6.31894458556606E-02
      0.00000000000000E+00   0.00000000000000E+00   1.74581583575601E-08   0.00000000000000E+00   1.74581583575601E-08
      3.72214166908132E-18  -7.23102974851622E-02  -6.89955079885433E-02   0.00000000000000E+00  -1.49465766827455E-10
     -1.03911435584759E-22  -1.03714213071843E-08  -1.05208870740119E-08  -2.52273774087701E-18
      6.50274537896141E-09
      0.00000000000000E+00   5.75673628343057E-12   0.00000000000000E+00   2.21931368463499E-11  -4.74484919273403E-23
     -5.77886011096139E-09  -5.75666697411509E-09  -1.21361946393066E-18  -5.47505816334604E-02  -5.47505816487929E-02
      0.00000000000000E+00   0.00000000000000E+00   1.53325225151368E-08   0.00000000000000E+00   1.53325225151368E-08
      3.76047297536916E-18  -7.83730748227761E-02  -7.53560058523515E-02   0.00000000000000E+00  -1.78651315861902E-10
     -1.05559995318504E-22  -9.39720422515976E-09  -9.57585554102177E-09  -2.54685351143850E-18
      6.50612037896141E-09
      0.00000000000000E+00   4.46117442038120E-12   0.00000000000000E+00   1.83037630074880E-11  -4.76304691517570E-23
     -4.47946791600746E-09  -4.46116415300002E-09  -1.22843292401318E-18  -4.57958750565078E-02  -4.57958750696315E-02
      0.00000000000000E+00   0.00000000000000E+00   1.31236635886654E-08   0.00000000000000E+00   1.31236635886654E-08
      3.80476533998091E-18  -8.74299793085781E-02  -8.47006780507071E-02   0.00000000000000E+00  -1.81363931075875E-10
     -1.07670885572530E-22  -8.48113550458938E-09  -8.66249943566536E-09  -2.57633241596773E-18
      6.51067662896141E-09
      0.00000000000000E+00   3.12630300980700E-12   0.00000000000000E+00   1.40017006370149E-11  -4.77922754887047E-23
     -3.14030451007673E-09  -3.12630280943977E-09  -1.24234493820569E-18  -3.71923989494047E-02  -3.71923989602385E-02
      0.00000000000000E+00   0.00000000000000E+00   1.08337933594926E-08   0.00000000000000E+00   1.08337933594926E-08
      3.85412681097509E-18  -1.00762340282658E-01  -9.83339330365310E-02   0.00000000000000E+00  -1.79345076916683E-10
     -1.10318446507390E-22  -7.52814547313611E-09  -7.70749055005290E-09  -2.61178187276940E-18
      6.51682756646141E-09
      0.00000000000000E+00   1.94536337879262E-12   0.00000000000000E+00   9.19831034976928E-12  -4.79166919036337E-23
     -1.95455531377300E-09  -1.94535700342328E-09  -1.25386152819692E-18  -2.98173198690619E-02  -2.98173198777949E-02
      0.00000000000000E+00   0.00000000000000E+00   8.73291397735104E-09   0.00000000000000E+00   8.73291397735104E-09
      3.90784241904266E-18  -1.19888170335727E-01  -1.17749605879628E-01   0.00000000000000E+00  -1.78615470333931E-10
     -1.13640514437056E-22  -6.60894150359390E-09  -6.78755697392794E-09  -2.65398089084573E-18
      6.52513133208641E-09
      0.00000000000000E+00   1.09203392539749E-12   0.00000000000000E+00   4.92747801623444E-12  -4.80021762116327E-23
     -1.09695123367170E-09  -1.09202375565552E-09  -1.26232938209047E-18  -2.40627795668643E-02  -2.40627795739475E-02
      0.00000000000000E+00   0.00000000000000E+00   7.08321893127884E-09   0.00000000000000E+00   7.08321893127884E-09
      3.96665980891856E-18  -1.46341241664405E-01  -1.44453585860663E-01   0.00000000000000E+00  -1.82057289035723E-10
     -1.17868324077671E-22  -5.80913788658746E-09  -5.99119517562330E-09  -2.70433042682809E-18
      6.53634141568016E-09
      0.00000000000000E+00   5.83581460216625E-13   0.00000000000000E+00   2.17174826398368E-12  -4.80562562318287E-23
     -5.85748455546827E-10  -5.83576707282891E-10  -1.26807942633123E-18  -1.97409461574950E-02  -1.97409461633793E-02
      0.00000000000000E+00   0.00000000000000E+00   5.88428798307075E-09   0.00000000000000E+00   5.88428798307075E-09
      4.03262316909848E-18  -1.81410602385735E-01  -1.79740495786639E-01   0.00000000000000E+00  -1.90181601899503E-10
     -1.23320044643178E-22  -5.11052967388819E-09  -5.30071127578782E-09  -2.76454374276725E-18
      6.55147502853172E-09
      0.00000000000000E+00   3.20170753905438E-13   0.00000000000000E+00   8.32062149640614E-13  -4.80873100777259E-23
     -3.21024052886826E-10  -3.20191990737234E-10  -1.27188991720430E-18  -1.64293311791617E-02  -1.64293311840456E-02
      0.00000000000000E+00   0.00000000000000E+00   4.88395980028189E-09   0.00000000000000E+00   4.88395980028189E-09
      4.10653512589854E-18  -2.25121269990352E-01  -2.23683350120011E-01   0.00000000000000E+00  -1.97692738866229E-10
     -1.30213439940466E-22  -4.36607507067832E-09  -4.56376780954468E-09  -2.83464520869425E-18
      6.57147502853172E-09
      0.00000000000000E+00   2.02517645542596E-13   0.00000000000000E+00   2.81198009267550E-13  -4.81041826140836E-23
     -2.02860168227758E-10  -2.02578970218538E-10  -1.27462070836898E-18  -1.37925493093427E-02  -1.37925493131041E-02
      0.00000000000000E+00   0.00000000000000E+00   3.76141217855460E-09   0.00000000000000E+00   3.76141217855460E-09
      4.18176336946963E-18  -2.72076584922517E-01  -2.70955288698492E-01   0.00000000000000E+00  -1.86611536017938E-10
     -1.37905537159538E-22  -3.37222167231798E-09  -3.55883320833605E-09  -2.90714266110065E-18
      6.59147502853173E-09
      0.00000000000000E+00   1.59350619055059E-13   0.00000000000000E+00   1.03884389829480E-13  -4.81120671861583E-23
     -1.59473676059267E-10  -1.59369791669485E-10  -1.27652070822678E-18  -1.20443621147577E-02  -1.20443621174434E-02
      0.00000000000000E+00   0.00000000000000E+00   2.68564802413611E-09   0.00000000000000E+00   2.68564802413611E-09
      4.23547632995236E-18  -3.05783770002736E-01  -3.04987801980627E-01   0.00000000000000E+00  -1.52340136188361E-10
     -1.43640860461483E-22  -2.37393809627815E-09  -2.52627823246665E-09  -2.95895562172557E-18
      6.61147502853173E-09
      0.00000000000000E+00   1.37950795285705E-13   0.00000000000000E+00   5.30780828822538E-14  -4.81146447287451E-23
     -1.37988484642032E-10  -1.37935406559198E-10  -1.27801486874912E-18  -1.08584126665337E-02  -1.08584126683601E-02
      0.00000000000000E+00   0.00000000000000E+00   1.82639378591504E-09   0.00000000000000E+00   1.82639378591504E-09
      4.27200420567066E-18  -3.27886030097870E-01  -3.27354039671482E-01   0.00000000000000E+00  -1.07817182269472E-10
     -1.47472266303315E-22  -1.58064119708623E-09  -1.68845837935585E-09  -2.99398933692154E-18
      6.63147502853173E-09
      0.00000000000000E+00   1.30511371571896E-13   0.00000000000000E+00   1.91903327263516E-14  -4.81161007953866E-23
     -1.30554739174199E-10  -1.30535548841521E-10  -1.27937561069228E-18  -1.00094836658932E-02  -1.00094836670361E-02
      0.00000000000000E+00   0.00000000000000E+00   1.14284498701278E-09   0.00000000000000E+00   1.14284498701278E-09
      4.29486110541091E-18  -3.40113941573397E-01  -3.39794993295513E-01   0.00000000000000E+00  -6.10448682707945E-11
     -1.49577493479532E-22  -9.51264569900255E-10  -1.01230943817120E-09  -3.01548549471864E-18
      6.65147502853173E-09
      0.00000000000000E+00   1.14530387297786E-13   0.00000000000000E+00   4.26734791489186E-14  -4.81117916570306E-23
     -1.14539714562455E-10  -1.14497041083354E-10  -1.28042592682032E-18  -9.49283891685089E-03  -9.49283891757893E-03
      0.00000000000000E+00   0.00000000000000E+00   7.28038295987671E-10   0.00000000000000E+00   7.28038295987671E-10
      4.30942187133067E-18  -3.46605832008397E-01  -3.46412529206282E-01   0.00000000000000E+00  -3.06745650566058E-11
     -1.50621790184210E-22  -5.82866689847663E-10  -6.13541254904419E-10  -3.02899594451034E-18
      6.67147502853173E-09
      0.00000000000000E+00   8.51400713913773E-14   0.00000000000000E+00   8.00712679071122E-14  -4.80967442227323E-23
     -8.52448355499158E-11  -8.51647642820567E-11  -1.28090131055337E-18  -9.29669128239390E-03  -9.29669128311345E-03
      0.00000000000000E+00   0.00000000000000E+00   7.19546210542881E-10   0.00000000000000E+00   7.19546210542881E-10
      4.32381279554153E-18  -3.53904978842094E-01  -3.53705109089446E-01   0.00000000000000E+00  -3.44145243780684E-11
     -1.51759677884450E-22  -5.99966921882565E-10  -6.34381446260785E-10  -3.04291148498816E-18
      6.67397502853173E-09
      0.00000000000000E+00   9.79983346004310E-14   0.00000000000000E+00  -2.40233329131623E-13  -4.80965370124423E-23
     -9.77143336778943E-11  -9.79545670070740E-11  -1.28099286609438E-18  -9.25623650961497E-03  -9.25623651026325E-03
      0.00000000000000E+00   0.00000000000000E+00   6.48274331580484E-10   0.00000000000000E+00   6.48274331580484E-10
      4.32543348137048E-18  -3.54609719651025E-01  -3.54436337130328E-01   0.00000000000000E+00  -2.58823130671177E-11
     -1.51868287540676E-22  -5.24437451506029E-10  -5.50319764573299E-10  -3.04444061527609E-18
      6.67735002853173E-09
      0.00000000000000E+00   7.07204476497956E-14   0.00000000000000E+00   3.98396250591053E-13  -4.80916093121568E-23
     -7.11299765817809E-11  -7.07315803312379E-11  -1.28102493440822E-18  -9.25359009050707E-03  -9.25359009119235E-03
      0.00000000000000E+00   0.00000000000000E+00   6.85281296160585E-10   0.00000000000000E+00   6.85281296160585E-10
      4.32774630574502E-18  -3.55841654651499E-01  -3.55648033071382E-01   0.00000000000000E+00  -3.41338926867075E-11
     -1.52054564303072E-22  -5.80415823142152E-10  -6.14549715829012E-10  -3.04672137133680E-18
      6.68190627853173E-09
      0.00000000000000E+00   5.04227607269322E-14   0.00000000000000E+00   2.35089140021767E-13  -4.80846292339378E-23
     -5.06690224293056E-11  -5.04339332893319E-11  -1.28097651574819E-18  -9.28812594610881E-03  -9.28812594693347E-03
      0.00000000000000E+00   0.00000000000000E+00   8.24654968537702E-10   0.00000000000000E+00   8.24654968537702E-10
      4.33150363994542E-18  -3.58139494191803E-01  -3.57895561804986E-01   0.00000000000000E+00  -4.91782600296975E-11
     -1.52414370519999E-22  -7.25042775218501E-10  -7.74221035248351E-10  -3.05052712419723E-18
      6.68805721603173E-09
      0.00000000000000E+00   3.31559501319172E-14   0.00000000000000E+00   1.56039036039197E-13  -4.80739539873273E-23
     -3.32685022738458E-11  -3.31124632378547E-11  -1.28080637514370E-18  -9.36171268459199E-03  -9.36171268566704E-03
      0.00000000000000E+00   0.00000000000000E+00   1.07504876097475E-09   0.00000000000000E+00   1.07504876097475E-09
      4.33811619768363E-18  -3.62586195467782E-01  -3.62257909122251E-01   0.00000000000000E+00  -7.38577027915192E-11
     -1.53140585329667E-22  -9.68078594945140E-10  -1.04193629773681E-09  -3.05730982253992E-18
      6.69220909884423E-09
      0.00000000000000E+00   2.10324448205236E-14   0.00000000000000E+00   1.61873774733134E-13  -4.80658527718257E-23
     -2.11965814261723E-11  -2.10347076514873E-11  -1.28064231653523E-18  -9.42280842362134E-03  -9.42280842488851E-03
      0.00000000000000E+00   0.00000000000000E+00   1.26717369529419E-09   0.00000000000000E+00   1.26717369529419E-09
      4.34337735436957E-18  -3.66280804835311E-01  -3.65888176359940E-01   0.00000000000000E+00  -9.34206186267650E-11
     -1.53756704511974E-22  -1.15271836901604E-09  -1.24613898764296E-09  -3.06273503783434E-18
      6.69781414064110E-09
      0.00000000000000E+00   1.92873948135806E-14   0.00000000000000E+00   3.50153250665013E-14  -4.80557532380110E-23
     -1.93340128571394E-11  -1.92989975321209E-11  -1.28041302316797E-18  -9.48159634290016E-03  -9.48159634439892E-03
      0.00000000000000E+00   0.00000000000000E+00   1.49875908160651E-09   0.00000000000000E+00   1.49875908160651E-09
      4.35177796166542E-18  -3.72276089382511E-01  -3.71809944239158E-01   0.00000000000000E+00  -1.15783806466908E-10
     -1.54781688989522E-22  -1.36367627760715E-09  -1.47946008407421E-09  -3.07136493849745E-18
      6.70538094706688E-09
      0.00000000000000E+00   2.92984711692010E-14   0.00000000000000E+00  -4.83217184123037E-14  -4.80443857846929E-23
     -2.92869249212679E-11  -2.93352466397282E-11  -1.28018313301311E-18  -9.48377277146512E-03  -9.48377277315351E-03
      0.00000000000000E+00   0.00000000000000E+00   1.68839200342556E-09   0.00000000000000E+00   1.68839200342556E-09
      4.36455369712618E-18  -3.81355112439528E-01  -3.80832378608024E-01   0.00000000000000E+00  -1.34532547116346E-10
     -1.56373741376589E-22  -1.52452420966960E-09  -1.65905675678611E-09  -3.08437056411307E-18
      6.71559613574169E-09
      0.00000000000000E+00   4.42691633340279E-14   0.00000000000000E+00  -5.87773391640321E-14  -4.80321110653234E-23
     -4.42514767063309E-11  -4.43102540455429E-11  -1.28003254758764E-18  -9.37281027267287E-03  -9.37281027445461E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78173827591852E-09   0.00000000000000E+00   1.78173827591852E-09
      4.38275448978381E-18  -3.94144666913585E-01  -3.93597239075973E-01   0.00000000000000E+00  -1.46222069838438E-10
     -1.58673072398982E-22  -1.59120595203439E-09  -1.73742802187299E-09  -3.10272194219617E-18
      6.72938664045267E-09
      0.00000000000000E+00   6.48423844685139E-14   0.00000000000000E+00  -6.42092092745586E-14  -4.80210393888722E-23
     -6.48193315322569E-11  -6.48835407415795E-11  -1.28012470856949E-18  -9.04703027446842E-03  -9.04703027625767E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78924509900619E-09   0.00000000000000E+00   1.78924509900619E-09
      4.40742908275076E-18  -4.11168627050689E-01  -4.10625315808790E-01   0.00000000000000E+00  -1.51809570955003E-10
     -1.61825899071443E-22  -1.57255198730933E-09  -1.72436155826450E-09  -3.12730437418127E-18
      6.74800382181251E-09
      0.00000000000000E+00   1.05070379365411E-13   0.00000000000000E+00  -1.04777434876279E-13  -4.80207390524317E-23
     -1.05028786112846E-10  -1.05133563547770E-10  -1.28101711763162E-18  -8.16867491730904E-03  -8.16867491907804E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76900422348825E-09   0.00000000000000E+00   1.76900422348825E-09
      4.44036295520575E-18  -4.32994041070639E-01  -4.32469788977590E-01   0.00000000000000E+00  -1.55207719067699E-10
     -1.66057784167212E-22  -1.50866294087267E-09  -1.66387065994053E-09  -3.15934583757414E-18
      6.76800382181251E-09
      0.00000000000000E+00   1.55952363778380E-13   0.00000000000000E+00  -1.32826277826284E-13  -4.80393095071779E-23
     -1.55794071426614E-10  -1.55926897704489E-10  -1.28300918092413E-18  -6.63556178842962E-03  -6.63556179018317E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75354582274932E-09   0.00000000000000E+00   1.75354582274932E-09
      4.47543387166073E-18  -4.55013897768152E-01  -4.54510519194780E-01   0.00000000000000E+00  -1.59301115133317E-10
     -1.70583573996608E-22  -1.43831780991135E-09  -1.59761892504484E-09  -3.19242469073661E-18
      6.78800382181251E-09
      0.00000000000000E+00   1.72025192789698E-13   0.00000000000000E+00  -5.08111730493836E-14  -4.80617309016474E-23
     -1.71979622841230E-10  -1.72030434014328E-10  -1.28533862980436E-18  -4.93037472239552E-03  -4.93037472409135E-03
      0.00000000000000E+00   0.00000000000000E+00   1.69582730971171E-09   0.00000000000000E+00   1.69582730971171E-09
      4.50935041785497E-18  -4.75856917492061E-01  -4.75376797630000E-01   0.00000000000000E+00  -1.61949005085154E-10
     -1.75051502990650E-22  -1.36184787061208E-09  -1.52379687569741E-09  -3.22401178805062E-18
      6.80800382181251E-09
      0.00000000000000E+00   1.90302295493995E-13   0.00000000000000E+00  -5.95726303194496E-14  -4.80910939505790E-23
     -1.90279223982183E-10  -1.90338796612551E-10  -1.28804746469281E-18  -3.02122925852910E-03  -3.02122926018308E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65398311069437E-09   0.00000000000000E+00   1.65398311069437E-09
      4.54243008006886E-18  -4.95695810914531E-01  -4.95234642632237E-01   0.00000000000000E+00  -1.65428745775498E-10
     -1.79490590830270E-22  -1.29821556830606E-09  -1.46364431408174E-09  -3.25438261537605E-18
      6.82800382181251E-09
      0.00000000000000E+00  -4.45446975456505E-14   0.00000000000000E+00   6.04079150402227E-13  -4.80223047015587E-23
      4.39483674503925E-11   4.45524466007467E-11  -1.28608289274888E-18  -3.96310122562224E-03  -3.96310122683757E-03
      0.00000000000000E+00   0.00000000000000E+00   1.21532828491724E-09   0.00000000000000E+00   1.21532828491724E-09
      4.56673664576720E-18  -5.14955838020876E-01  -5.14558873933612E-01   0.00000000000000E+00  -1.45956163763464E-10
     -1.83309814174921E-22  -1.11392456775443E-09  -1.25988073151807E-09  -3.28065375301833E-18
      6.84800382181251E-09
      0.00000000000000E+00  -1.91973869711172E-12   0.00000000000000E+00   4.94468781081464E-12  -4.71967042458866E-23
      1.91481786492495E-09   1.91976255273572E-09  -1.24681146738731E-18  -2.71172697164121E-02  -2.71172697145939E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.81817560696912E-09   0.00000000000000E+00  -1.81817560696912E-09
      4.53037313362782E-18  -5.35599054151835E-01  -5.35567075579423E-01   0.00000000000000E+00   2.69646334534151E-11
     -1.82599254289959E-22  -1.28551579219728E-10  -1.01586945766495E-10  -3.28356166624051E-18
      6.85800382181251E-09
      0.00000000000000E+00  -3.08910589123795E-12   0.00000000000000E+00   6.22764184690870E-12  -4.65713080236982E-23
      3.08286358811168E-09   3.08909122995855E-09  -1.21563121624122E-18  -4.51001478500081E-02  -4.51001478463449E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.66313875214690E-09   0.00000000000000E+00  -3.66313875214690E-09
      4.49374174610635E-18  -5.46226678244350E-01  -5.46407597850552E-01   0.00000000000000E+00   1.27959477856641E-10
     -1.80913005982863E-22   4.46088044331736E-10   5.74047522188197E-10  -3.27811052986513E-18
      6.86137882181251E-09
      0.00000000000000E+00  -3.58093445898426E-12   0.00000000000000E+00   7.66988545881811E-12  -4.63263074562869E-23
      3.57331903068657E-09   3.58098891614534E-09  -1.20347637518094E-18  -5.20114090328041E-02  -5.20114090283880E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.41608736552674E-09   0.00000000000000E+00  -4.41608736552674E-09
      4.47883745124770E-18  -5.49851021150433E-01  -5.50114199387711E-01   0.00000000000000E+00   1.64922609742309E-10
     -1.80174786643914E-22   6.70175839639480E-10   8.35098449381609E-10  -3.27536107606676E-18
      6.86593507181251E-09
      0.00000000000000E+00  -4.10775587160663E-12   0.00000000000000E+00   6.26337327677647E-12  -4.59661923455556E-23
      4.10149713122237E-09   4.10776050449910E-09  -1.18474388851811E-18  -6.25341392946685E-02  -6.25341392894520E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.21648473017673E-09   0.00000000000000E+00  -5.21648473017673E-09
      4.45506984269583E-18  -5.54812739935344E-01  -5.55162139834334E-01   0.00000000000000E+00   2.02611192639066E-10
     -1.78940197728940E-22   9.06113033038362E-10   1.10872422567725E-09  -3.27032595417773E-18
      6.87208600931251E-09
      0.00000000000000E+00  -4.79989781120256E-12   0.00000000000000E+00   6.13609726826198E-12  -4.54152761651843E-23
      4.79377341660603E-09   4.79990951387425E-09  -1.15543776654558E-18  -7.87067236365698E-02  -7.87067236303427E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.22706523682971E-09   0.00000000000000E+00  -6.22706523682971E-09
      4.41676755361567E-18  -5.61602391347366E-01  -5.62052133419470E-01   0.00000000000000E+00   2.46160295308494E-10
     -1.76892192193192E-22   1.18099542764674E-09   1.42715572295506E-09  -3.26132978707009E-18
      6.87623789212501E-09
      0.00000000000000E+00  -5.33636292123172E-12   0.00000000000000E+00   6.95803460542244E-12  -4.50069864989510E-23
      5.32942040447203E-09   5.33637843907741E-09  -1.13360933739385E-18  -9.05345316141384E-02  -9.05345316071662E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.97214555045651E-09   0.00000000000000E+00  -6.97214555045651E-09
      4.38782002233848E-18  -5.66213911152535E-01  -5.66729390012489E-01   0.00000000000000E+00   2.72788045163776E-10
     -1.75343585631826E-22   1.36297906621557E-09   1.63576711137917E-09  -3.25421068494463E-18
      6.87904041302344E-09
      0.00000000000000E+00  -5.69584322266198E-12   0.00000000000000E+00   6.92089465906719E-12  -4.47179477749799E-23
      5.68888631501107E-09   5.69580720967009E-09  -1.11798394721610E-18  -9.88861308694141E-02  -9.88861308619648E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.44932781961069E-09   0.00000000000000E+00  -7.44932781961069E-09
      4.36694312544471E-18  -5.69331481591638E-01  -5.69884067547437E-01   0.00000000000000E+00   2.87261421775270E-10
     -1.74233797348576E-22   1.46625918816489E-09   1.75352060993998E-09  -3.24895917822861E-18
      6.88282381623633E-09
      0.00000000000000E+00  -6.08581597684514E-12   0.00000000000000E+00   5.69169721967911E-12  -4.43136129658261E-23
      6.08013063169063E-09   6.08582232891026E-09  -1.09570976934112E-18  -1.10620242515203E-01  -1.10620242507280E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.92254031723306E-09   0.00000000000000E+00  -7.92254031723306E-09
      4.33696896095423E-18  -5.73525695195548E-01  -5.74104504227053E-01   0.00000000000000E+00   3.00165759561156E-10
     -1.72654153669612E-22   1.53655222876152E-09   1.83671798832250E-09  -3.24125919161311E-18
      6.88793141057374E-09
      0.00000000000000E+00  -6.52960974703191E-12   0.00000000000000E+00   4.86297177780397E-12  -4.37289853422950E-23
      6.52475362725168E-09   6.52961659902943E-09  -1.06421172930364E-18  -1.26887233926748E-01  -1.26887233918404E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.34477459663044E-09   0.00000000000000E+00  -8.34477459663044E-09
      4.29434723747758E-18  -5.79098997308719E-01  -5.79671029879453E-01   0.00000000000000E+00   3.06195033833258E-10
     -1.70452374128525E-22   1.50896296376813E-09   1.81515799760122E-09  -3.23013550817395E-18
      6.89482666292923E-09
      0.00000000000000E+00  -7.13385627312023E-12   0.00000000000000E+00   4.84642730227078E-12  -4.27424301802066E-23
      7.12900914847014E-09   7.13385557577237E-09  -1.02023835823091E-18  -1.48995515548958E-01  -1.48995515540284E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.67449459525829E-09   0.00000000000000E+00  -8.67449459525829E-09
      4.23453440818692E-18  -5.86319322106690E-01  -5.86804896945261E-01   0.00000000000000E+00   3.02877231673147E-10
     -1.67465419637376E-22   1.23776178781325E-09   1.54063901948623E-09  -3.21429604995601E-18
      6.90413525360914E-09
      0.00000000000000E+00  -8.33527728053188E-12   0.00000000000000E+00   6.81073568787232E-12  -4.01373887572538E-23
      8.32849518069754E-09   8.33530591638537E-09  -9.59944427244357E-19  -1.78265119184067E-01  -1.78265119175152E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.91513217277463E-09   0.00000000000000E+00  -8.91513217277463E-09
      4.15154709193321E-18  -5.95049873735228E-01  -5.95232818682531E-01   0.00000000000000E+00   2.91539636098665E-10
     -1.63501539070275E-22   2.88286620290865E-10   5.79826256389366E-10  -3.19160266468885E-18
      6.91670185102703E-09
      0.00000000000000E+00  -1.17410638256614E-11   0.00000000000000E+00   1.37062463595277E-11  -2.89855385828045E-23
      1.17273713770848E-08   1.17410776234443E-08  -8.80026378363577E-19  -2.15419932419307E-01  -2.15419932410163E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.14374965686982E-09   0.00000000000000E+00  -9.14374965686982E-09
      4.03664127110539E-18  -6.02957836449733E-01  -6.02140033806981E-01   0.00000000000000E+00   2.80839355517646E-10
     -1.58177238316885E-22  -2.87816732209205E-09  -2.59732796657456E-09  -3.15661489274182E-18
      6.93366675754118E-09
      0.00000000000000E+00  -2.20839752168126E-11   0.00000000000000E+00   3.03017583209283E-11   1.84311872536262E-23
      2.20536941678838E-08   2.20839959262048E-08  -7.83284156179190E-19  -2.58457835347713E-01  -2.58457835338168E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.54453984489092E-09   0.00000000000000E+00  -9.54453984489092E-09
      3.87471904491627E-18  -5.98362107794430E-01  -5.94412558788301E-01   0.00000000000000E+00   2.91870728558712E-10
     -1.50212567245870E-22  -1.28313268098723E-08  -1.25394560813137E-08  -3.09143488873708E-18
      6.95366675754118E-09
      0.00000000000000E+00  -4.15332004573529E-11   0.00000000000000E+00   4.82088915496447E-11   1.11419675921724E-22
      4.14850278294404E-08   4.15332367209901E-08  -6.96620359349144E-19  -2.96332594709576E-01  -2.96332594699378E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01982132824980E-08   0.00000000000000E+00  -1.01982132824980E-08
      3.67075477926631E-18  -5.58935510384775E-01  -5.49064868085298E-01   0.00000000000000E+00   3.18501838806021E-10
     -1.38286350883542E-22  -3.16535252772981E-08  -3.13350234384922E-08  -2.97413441991717E-18
      6.97366675754118E-09
      0.00000000000000E+00  -5.94966533840870E-11   0.00000000000000E+00   4.46488119276347E-11   1.96246817184777E-22
      5.94520061655137E-08   5.94966549774415E-08  -6.39962707455742E-19  -3.21922313456024E-01  -3.21922313445178E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08454839690594E-08   0.00000000000000E+00  -1.08454839690594E-08
      3.45384509988512E-18  -4.83045455252022E-01  -4.67719049674953E-01   0.00000000000000E+00   3.05096498472483E-10
     -1.23075697910305E-22  -4.89562675068545E-08  -4.86511710083822E-08  -2.81388239242938E-18
      6.99366675754118E-09
      0.00000000000000E+00  -6.60923913419083E-11   0.00000000000000E+00   1.65029035435759E-11   2.26948965081535E-22
      6.60758188277335E-08   6.60923217312773E-08  -6.09776432058925E-19  -3.37192075315808E-01  -3.37192075304397E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14104821343012E-08   0.00000000000000E+00  -1.14104821343012E-08
      3.22563545719910E-18  -3.75285370238002E-01  -3.58058247893523E-01   0.00000000000000E+00   2.59972124196927E-10
     -1.06635773287355E-22  -5.49418117211728E-08  -5.46818395969760E-08  -2.61585902514018E-18
      7.01366675754118E-09
      0.00000000000000E+00  -5.92422434620221E-11   0.00000000000000E+00  -1.69332101261099E-11   1.96962338019495E-22
      5.92592300914677E-08   5.92422968813418E-08  -6.00029268263852E-19  -3.44599199742347E-01  -3.44599199730477E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18696964498207E-08   0.00000000000000E+00  -1.18696964498207E-08
      2.98824152820269E-18  -2.50054925010967E-01  -2.35130018682551E-01   0.00000000000000E+00   1.96097655872263E-10
     -8.99530170068596E-23  -4.75686980873934E-08  -4.73726004315212E-08  -2.38821225993883E-18
      7.03366675754118E-09
      0.00000000000000E+00  -5.11985732221242E-11   0.00000000000000E+00  -1.99527669826809E-11   1.54897795672112E-22
      5.12184937566178E-08   5.11985409896352E-08  -5.92407641571371E-19  -3.51267227577194E-01  -3.51267227565308E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18862269167923E-08   0.00000000000000E+00  -1.18862269167923E-08
      2.75051698986684E-18  -1.41337733038804E-01  -1.28951982687839E-01   0.00000000000000E+00   1.09802573858275E-10
     -7.51209671058251E-23  -3.94221166467011E-08  -3.93123140728429E-08  -2.15810934829547E-18
      7.04366675754118E-09
      0.00000000000000E+00  -4.70279037055304E-11   0.00000000000000E+00  -2.05910921869274E-11   1.33938357343166E-22
      4.70486112188605E-08   4.70280201266737E-08  -5.87804425211331E-19  -3.54898828620296E-01  -3.54898828608472E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18238790184672E-08   0.00000000000000E+00  -1.18238790184672E-08
      2.63227819968217E-18  -9.49025964974247E-02  -8.38111116723521E-02   0.00000000000000E+00   7.29759550760139E-11
     -6.13814762386743E-23  -3.52771170632825E-08  -3.52041411082066E-08  -2.04447377447084E-18
      7.05041675754118E-09
      0.00000000000000E+00  -4.39412776221970E-11   0.00000000000000E+00  -2.26350026239187E-11   1.22948442048189E-22
      4.39638808802012E-08   4.39412458775774E-08  -5.82274578649840E-19  -3.58189528664201E-01  -3.58189528652549E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16514291684797E-08   0.00000000000000E+00  -1.16514291684797E-08
      2.55363105279493E-18  -6.90948376896632E-02  -5.89214846192137E-02   0.00000000000000E+00   5.84760972532930E-11
     -4.85404260072607E-23  -3.23482928063511E-08  -3.22898167090979E-08  -1.97135647414509E-18
      7.05952925754118E-09
      0.00000000000000E+00  -3.97914568609493E-11   0.00000000000000E+00  -2.25199489622545E-11   1.17694846074694E-22
      3.98139991148828E-08   3.97914791659207E-08  -5.67014497829725E-19  -3.65281292623135E-01  -3.65281292611905E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12299222092451E-08   0.00000000000000E+00  -1.12299222092451E-08
      2.45129838666318E-18  -4.55250828002166E-02  -3.65263402032144E-02   0.00000000000000E+00   4.46831938828362E-11
      4.42197717300010E-25  -2.86062401505585E-08  -2.85615569566756E-08  -1.88428388883346E-18
      7.06260472629118E-09
      0.00000000000000E+00  -3.79578685273383E-11   0.00000000000000E+00  -2.93675200171246E-11   1.17148642633170E-22
      3.79872050302933E-08   3.79578375102763E-08  -5.60586366324933E-19  -3.68073231474289E-01  -3.68073231463238E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10511500886701E-08   0.00000000000000E+00  -1.10511500886701E-08
      2.41731091991392E-18  -3.92456981926819E-02  -3.07683384661575E-02   0.00000000000000E+00   4.53829656314717E-11
      2.17296167037313E-23  -2.69520703872373E-08  -2.69066874216058E-08  -1.85672455358898E-18
      7.06675660910368E-09
      0.00000000000000E+00  -3.60480490618450E-11   0.00000000000000E+00  -2.27960247697472E-11   1.18977934581971E-22
      3.60707873520428E-08   3.60479913272732E-08  -5.50062953666118E-19  -3.72482113308188E-01  -3.72482113297376E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08117291370815E-08   0.00000000000000E+00  -1.08117291370815E-08
      2.37242188753626E-18  -3.31546128083916E-02  -2.52035356907024E-02   0.00000000000000E+00   3.51675445417524E-11
      4.86467488888749E-23  -2.52714297347334E-08  -2.52362621901916E-08  -1.82235893387015E-18
      7.07236165090055E-09
      0.00000000000000E+00  -3.43136530444180E-11   0.00000000000000E+00  -1.53195807012843E-11   1.24345355220207E-22
      3.43289591999110E-08   3.43136396192098E-08  -5.33908091103531E-19  -3.79109324522281E-01  -3.79109324511703E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05783151918634E-08   0.00000000000000E+00  -1.05783151918634E-08
      2.31312998874535E-18  -2.77359502456267E-02  -2.02577567028613E-02   0.00000000000000E+00   2.53926630483672E-11
      8.05174951167251E-23  -2.37607170903949E-08  -2.37353244273464E-08  -1.77922189764182E-18
      7.07992845732633E-09
      0.00000000000000E+00  -3.29170619704404E-11   0.00000000000000E+00  -9.11134153231954E-12   1.33030103270737E-22
      3.29261274847950E-08   3.29170161432628E-08  -5.10672891117597E-19  -3.88543069182288E-01  -3.88543069171900E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03880929130873E-08   0.00000000000000E+00  -1.03880929130873E-08
      2.23452530053899E-18  -2.32206829238814E-02  -1.61225756760790E-02   0.00000000000000E+00   1.75530155173138E-11
      1.16240249101306E-22  -2.25464762456927E-08  -2.25289232301753E-08  -1.72385240942139E-18
      7.09014364600114E-09
      0.00000000000000E+00  -3.18294365924288E-11   0.00000000000000E+00  -5.22694108564031E-12   1.42152725876248E-22
      3.18346565637227E-08   3.18294296226372E-08  -4.79066665071264E-19  -4.01349179172079E-01  -4.01349179161837E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02422033659651E-08   0.00000000000000E+00  -1.02422033659651E-08
      2.12989926070994E-18  -1.95564925674203E-02  -1.27550734825028E-02   0.00000000000000E+00   1.23094575711040E-11
      1.51600567242560E-22  -2.15995357142433E-08  -2.15872262566720E-08  -1.65083259563867E-18
      7.10393415071213E-09
      0.00000000000000E+00  -3.08474326622060E-11   0.00000000000000E+00  -3.47544740002282E-12   1.44829922014546E-22
      3.08509439283499E-08   3.08474684809500E-08  -4.37907567175895E-19  -4.18118711654470E-01  -4.18118711644358E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01122885194144E-08   0.00000000000000E+00  -1.01122885194144E-08
      1.99044569824410E-18  -1.65573231826569E-02  -1.00243473946025E-02   0.00000000000000E+00   9.28327874891324E-12
      1.76202912289945E-22  -2.07444632402847E-08  -2.07351799615356E-08  -1.55253813106820E-18
      7.12255133207196E-09
      0.00000000000000E+00  -2.96838516865238E-11   0.00000000000000E+00  -3.04678798674085E-12   1.30720003008039E-22
      2.96868889991264E-08   2.96838422111397E-08  -3.86019390554935E-19  -4.39530232818082E-01  -4.39530232808121E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.96040853694452E-09   0.00000000000000E+00  -9.96040853694452E-09
      1.80501096609379E-18  -1.40233083522444E-02  -7.80909305590411E-03   0.00000000000000E+00   7.67093545506466E-12
      1.72514521678228E-22  -1.97311046096504E-08  -1.97234336741952E-08  -1.41899157553885E-18
      7.14255133207196E-09
      0.00000000000000E+00  -2.84769199948797E-11   0.00000000000000E+00  -2.94540338789309E-12   1.01441183276147E-22
      2.84798988634579E-08   2.84769534600701E-08  -3.34408691315094E-19  -4.61176576585717E-01  -4.61176576575906E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.81093753535523E-09   0.00000000000000E+00  -9.81093753535523E-09
      1.60879221538668E-18  -1.22064324556319E-02  -6.32536927521876E-03   0.00000000000000E+00   6.67242778648657E-12
      1.37946191127832E-22  -1.86726883525016E-08  -1.86660159247150E-08  -1.27438352407159E-18
      7.16255133207196E-09
      0.00000000000000E+00  -2.74789350803827E-11   0.00000000000000E+00  -2.43492595702628E-12   6.89112706985649E-23
      2.74813340236800E-08   2.74788990977230E-08  -2.86259169364836E-19  -4.81719806883683E-01  -4.81719806874002E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.68116163377635E-09   0.00000000000000E+00  -9.68116163377635E-09
      1.41516898271116E-18  -1.09711698931512E-02  -5.36366866458666E-03   0.00000000000000E+00   5.56524271709224E-12
      9.25529941531901E-23  -1.78033027066639E-08  -1.77977374639467E-08  -1.12890981334632E-18
      7.18255133207196E-09
      0.00000000000000E+00  -2.66355248586060E-11   0.00000000000000E+00  -2.05611176300457E-12   4.17355833919952E-23
      2.66375757273546E-08   2.66355196155916E-08  -2.41258438816381E-19  -5.01260629663052E-01  -5.01260629653525E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.52694779776840E-09   0.00000000000000E+00  -9.52694779776840E-09
      1.22463002675579E-18  -1.00928783532070E-02  -4.70250745372033E-03   0.00000000000000E+00   4.64776149685958E-12
      5.26521765516233E-23  -1.71132195793201E-08  -1.71085718178232E-08  -9.83371587939408E-19
      7.20255133207196E-09
      0.00000000000000E+00  -2.64714901579534E-11   0.00000000000000E+00  -3.82544724905919E-13   2.34732612091667E-23
      2.64718717683900E-08   2.64714892236651E-08  -1.97116732621270E-19  -5.20837027610015E-01  -5.20837027600196E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.81899207169446E-09   0.00000000000000E+00  -9.81899207169446E-09
      1.02825018532190E-18  -9.52787736503136E-03  -4.28119789452493E-03   0.00000000000000E+00   3.81729925102938E-12
      2.53528222027290E-23  -1.66563144512218E-08  -1.66524971519707E-08  -8.31133452700630E-19
      7.22255133207196E-09
      0.00000000000000E+00  -2.73892027721310E-11   0.00000000000000E+00   2.28791565256583E-12   1.32250152826967E-23
      2.73869349802702E-08   2.73892228959228E-08  -1.51183175737563E-19  -5.41743740127919E-01  -5.41743740117144E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07746354576002E-08   0.00000000000000E+00  -1.07746354576002E-08
      8.12757476169896E-19  -9.31292496299725E-03  -4.07818672935296E-03   0.00000000000000E+00   2.72084731272308E-12
      9.96255556971264E-24  -1.66173082856353E-08  -1.66145874383225E-08  -6.61574300432333E-19
      7.24255133207196E-09
      0.00000000000000E+00  -2.83638591233772E-11   0.00000000000000E+00   2.43395190159147E-12   8.15284416939164E-24
      2.83613887966537E-08   2.83638227485553E-08  -1.05019965008079E-19  -5.63320941344333E-01  -5.63320941332852E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14804744180582E-08   0.00000000000000E+00  -1.14804744180582E-08
      5.83147987808731E-19  -9.27066013215530E-03  -3.95124118582402E-03   0.00000000000000E+00   1.83975269607792E-12
      2.57348858339308E-24  -1.68851880831931E-08  -1.68833483304970E-08  -4.78128022800652E-19
      7.24505133207196E-09
      0.00000000000000E+00  -2.86438018823858E-11   0.00000000000000E+00   5.50067368044494E-12   7.56985708544719E-24
      2.86383311785483E-08   2.86438318522287E-08  -9.93162780691623E-20  -5.66037339953256E-01  -5.66037339941553E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.17025751726139E-08   0.00000000000000E+00  -1.17025751726139E-08
      5.53891549877196E-19  -9.29256957770158E-03  -3.95490497080754E-03   0.00000000000000E+00   1.27092747055890E-12
      1.66281242848810E-24  -1.69425276070850E-08  -1.69412566796145E-08  -4.54575271808033E-19
      7.24842633207196E-09
      0.00000000000000E+00  -2.90258759891691E-11   0.00000000000000E+00   5.61928639957528E-12   6.94532470373081E-24
      2.90202636090612E-08   2.90258828954608E-08  -9.15513107402430E-20  -5.69750104730296E-01  -5.69750104718399E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18964466558964E-08   0.00000000000000E+00  -1.18964466558964E-08
      5.13741042413546E-19  -9.36541939780859E-03  -3.96846428126600E-03   0.00000000000000E+00  -3.27308119121466E-13
      7.06600971298602E-25  -1.71291089314459E-08  -1.71294362395650E-08  -4.22189731673304E-19
      7.25298258207196E-09
      0.00000000000000E+00  -2.93679976352671E-11   0.00000000000000E+00   3.75748032188850E-12   6.32467499176624E-24
      2.93642813410412E-08   2.93680388213631E-08  -8.11042781108262E-20  -5.74762257971748E-01  -5.74762257959749E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19992600973970E-08   0.00000000000000E+00  -1.19992600973970E-08
      4.59069413594781E-19  -9.44260786527758E-03  -3.97024285030658E-03   0.00000000000000E+00  -2.16496981445882E-13
     -1.91867025966556E-25  -1.73685622269843E-08  -1.73687787239658E-08  -3.77965135483954E-19
      7.25913351957196E-09
      0.00000000000000E+00  -2.94714148093628E-11   0.00000000000000E+00   8.77569067213539E-13   5.72255649897110E-24
      2.94705053601963E-08   2.94713829292635E-08  -6.73387869442334E-20  -5.81394398388940E-01  -5.81394398377037E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19032394588770E-08   0.00000000000000E+00  -1.19032394588770E-08
      3.85853331635695E-19  -9.46861633733483E-03  -3.93343727463296E-03   0.00000000000000E+00   6.95682921709434E-13
     -9.50202707028594E-25  -1.75688391533084E-08  -1.75681434703867E-08  -3.18514544691462E-19
      7.26743728519696E-09
      0.00000000000000E+00  -2.90384587181665E-11   0.00000000000000E+00  -2.53539343915634E-12   5.12427870227018E-24
      2.90409869184632E-08   2.90384515250241E-08  -4.99582222763460E-20  -5.89813673205246E-01  -5.89813673193885E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13610250702064E-08   0.00000000000000E+00  -1.13610250702064E-08
      2.91514042192952E-19  -9.39834429457522E-03  -3.82873288501459E-03   0.00000000000000E+00   1.47761757976957E-12
     -1.52233458151261E-24  -1.76789040723975E-08  -1.76774264548177E-08  -2.41555819916606E-19
      7.27864736879071E-09
      0.00000000000000E+00  -2.72673248058566E-11   0.00000000000000E+00  -7.76892803398605E-12   4.43272914769975E-24
      2.72751169284043E-08   2.72673480003703E-08  -3.06832650392476E-20  -5.99177764227615E-01  -5.99177764218050E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.56430814215846E-09   0.00000000000000E+00  -9.56430814215846E-09
      1.84297348402972E-19  -9.17272248519210E-03  -3.59504004582794E-03   0.00000000000000E+00   1.62020776708808E-12
     -1.92120705646646E-24  -1.77046600659788E-08  -1.77030398582117E-08  -1.53614083363724E-19
      7.29378098164227E-09
      0.00000000000000E+00  -2.13313075953969E-11   0.00000000000000E+00  -1.93338932364326E-11   3.28407957698936E-24
      2.13506871210804E-08   2.13313532278440E-08  -2.12051185220199E-20  -6.03534364443023E-01  -6.03534364439384E-01
      0.00000000000000E+00   0.00000000000000E+00  -3.63891693718799E-09   0.00000000000000E+00  -3.63891693718799E-09
      1.29227388276575E-19  -8.59907707612071E-03  -3.02473396356324E-03   0.00000000000000E+00   6.89213771740348E-13
     -2.24337370857664E-24  -1.76931255044277E-08  -1.76924362906560E-08  -1.08022269754555E-19
      7.31378098164227E-09
      0.00000000000000E+00  -5.66323834095331E-12   0.00000000000000E+00  -3.86260557758631E-11   7.84215689320754E-25
      5.70188207663510E-09   5.66325602085924E-09  -6.57740222906668E-20  -5.80818409780988E-01  -5.80818409793014E-01
      0.00000000000000E+00   0.00000000000000E+00   1.20259572215404E-08   0.00000000000000E+00   1.20259572215404E-08
      3.69746532707383E-19  -7.27091541439671E-03  -1.69758558480267E-03   0.00000000000000E+00  -2.13454946653815E-12
     -2.93970959783167E-24  -1.76870786929330E-08  -1.76892132423996E-08  -3.03972510416716E-19
      7.33378098164227E-09
      0.00000000000000E+00   1.31281948917067E-11   0.00000000000000E+00  -4.60075054695542E-11  -3.86837890671421E-24
     -1.30818624492763E-08  -1.31278699547459E-08  -1.91672287617647E-19  -5.21205581747858E-01  -5.21205581778655E-01
      0.00000000000000E+00   0.00000000000000E+00   3.07965892915095E-08   0.00000000000000E+00   3.07965892915095E-08
      9.85678318537572E-19  -5.57189369237058E-03  -5.13287240924195E-06   0.00000000000000E+00  -6.92657109301105E-12
     -6.45328282166137E-24  -1.76617927656706E-08  -1.76687193367637E-08  -7.94006030919926E-19
      7.35378098164227E-09
      0.00000000000000E+00   2.43699907259079E-11   0.00000000000000E+00  -2.79274510438124E-11  -1.81307923889772E-23
     -2.43420363552679E-08  -2.43699638063117E-08  -4.13344025220245E-19  -4.27371967666968E-01  -4.27371967708953E-01
      0.00000000000000E+00   0.00000000000000E+00   4.19846105463102E-08   0.00000000000000E+00   4.19846105463102E-08
      1.82537052946378E-18  -3.85866924344202E-03   1.69115179964903E-03   0.00000000000000E+00  -1.44301820020907E-11
     -2.92954890560203E-23  -1.76002165579963E-08  -1.76146467399984E-08  -1.41202650424353E-18
      7.37378098164227E-09
      0.00000000000000E+00   2.09963498388011E-11   0.00000000000000E+00   7.87141001929283E-12  -3.95231822264776E-23
     -2.10041736610159E-08  -2.09963022509966E-08  -7.14980488533955E-19  -3.06293792872133E-01  -3.06293792910771E-01
      0.00000000000000E+00   0.00000000000000E+00   3.86380464141426E-08   0.00000000000000E+00   3.86380464141426E-08
      2.59813145774663E-18  -1.62665144265931E-03   3.93170039945915E-03   0.00000000000000E+00  -3.37192511341755E-11
     -7.18466192702512E-23  -1.76080249120117E-08  -1.76417441631459E-08  -1.88315096921267E-18
      7.39378098164227E-09
      0.00000000000000E+00   1.31707190050338E-11   0.00000000000000E+00   1.86185929341716E-11  -4.39213002299272E-23
     -1.31893092964906E-08  -1.31706907035565E-08  -9.72399966703840E-19  -1.87508841522983E-01  -1.87508841551388E-01
      0.00000000000000E+00   0.00000000000000E+00   2.84048000612970E-08   0.00000000000000E+00   2.84048000612970E-08
      3.16622745897257E-18  -1.59913897003930E-02  -1.11916205180122E-02   0.00000000000000E+00  -6.80454319261478E-11
     -8.51491151719100E-23  -1.51660639258143E-08  -1.52341093577405E-08  -2.19382749226873E-18
      7.41378098164227E-09
      0.00000000000000E+00   8.83316760093389E-12   0.00000000000000E+00   9.87459264601412E-12  -4.65068420858291E-23
     -8.84306556297956E-09  -8.83319097033359E-09  -1.14771765819286E-18  -9.33815400910090E-02  -9.33815401118374E-02
      0.00000000000000E+00   0.00000000000000E+00   2.08283863604633E-08   0.00000000000000E+00   2.08283863604633E-08
      3.58279518618183E-18  -5.07528868057773E-02  -4.69735944395009E-02   0.00000000000000E+00  -1.24172287906776E-10
     -9.82228420397472E-23  -1.18710231022228E-08  -1.19951953901296E-08  -2.43507752798897E-18
      7.42378098164227E-09
      0.00000000000000E+00   6.04926177143654E-12   0.00000000000000E+00   1.29018892118382E-11  -4.73641640490116E-23
     -6.06213720481796E-09  -6.04923531560617E-09  -1.20750951701407E-18  -5.84363714622991E-02  -5.84363714781896E-02
      0.00000000000000E+00   0.00000000000000E+00   1.58905916538463E-08   0.00000000000000E+00   1.58905916538463E-08
      3.74170110272029E-18  -7.44011965615620E-02  -7.13004869614868E-02   0.00000000000000E+00  -1.66912915612985E-10
     -1.04686492722477E-22  -9.67444342262707E-09  -9.84135633824015E-09  -2.53419158570623E-18
      7.42715598164227E-09
      0.00000000000000E+00   4.78713139273071E-12   0.00000000000000E+00   1.76524853186160E-11  -4.75637809468281E-23
     -4.80480169339288E-09  -4.78714920807431E-09  -1.22342468885975E-18  -4.88665719886359E-02  -4.88665720023344E-02
      0.00000000000000E+00   0.00000000000000E+00   1.36984890478247E-08   0.00000000000000E+00   1.36984890478247E-08
      3.78793350325670E-18  -8.32545215799037E-02  -8.04468193185075E-02   0.00000000000000E+00  -1.79342717490573E-10
     -1.06817060692056E-22  -8.73199712225949E-09  -8.91133983975017E-09  -2.56450881439696E-18
      7.43171223164227E-09
      0.00000000000000E+00   3.42654345573841E-12   0.00000000000000E+00   1.42282736185871E-11  -4.77476051366175E-23
     -3.44079432845393E-09  -3.42656605483539E-09  -1.23870554243992E-18  -3.94739173628001E-02  -3.94739173741652E-02
      0.00000000000000E+00   0.00000000000000E+00   1.13651587639642E-08   0.00000000000000E+00   1.13651587639642E-08
      3.83971600787502E-18  -9.63586057916770E-02  -9.38573857273424E-02   0.00000000000000E+00  -1.78798390067160E-10
     -1.09503531956269E-22  -7.75979431906146E-09  -7.93859270912873E-09  -2.60101046543509E-18
      7.43786316914227E-09
      0.00000000000000E+00   2.16459676650699E-12   0.00000000000000E+00   9.81044943548717E-12  -4.78911986152374E-23
     -2.17437577566676E-09  -2.16456532623132E-09  -1.25157021534086E-18  -3.13058843742687E-02  -3.13058843834053E-02
      0.00000000000000E+00   0.00000000000000E+00   9.13653054319148E-09   0.00000000000000E+00   9.13653054319148E-09
      3.89591423621303E-18  -1.15302529501307E-01  -1.13105864108941E-01   0.00000000000000E+00  -1.77980414939322E-10
     -1.12868337726435E-22  -6.79398480202066E-09  -6.97196521696009E-09  -2.64434402087217E-18
      7.44616693476727E-09
      0.00000000000000E+00   1.21593247589045E-12   0.00000000000000E+00   5.47292226270376E-12  -4.79893831857256E-23
     -1.22138836078545E-09  -1.21591543852279E-09  -1.26106541110565E-18  -2.49367571243372E-02  -2.49367571316721E-02
      0.00000000000000E+00   0.00000000000000E+00   7.33491662696464E-09   0.00000000000000E+00   7.33491662696464E-09
      3.95682166476226E-18  -1.41703308506359E-01  -1.39775385462192E-01   0.00000000000000E+00  -1.80925843634735E-10
     -1.17131916939474E-22  -5.93807534480681E-09  -6.11900118844166E-09  -2.69575625365661E-18
      7.45737701836102E-09
      0.00000000000000E+00   6.39514905176009E-13   0.00000000000000E+00   2.46182641266494E-12  -4.80504686013952E-23
     -6.42004744570309E-10  -6.39542918157693E-10  -1.26744034731409E-18  -2.02318314901802E-02  -2.02318314962096E-02
      0.00000000000000E+00   0.00000000000000E+00   6.02939973908092E-09   0.00000000000000E+00   6.02939973908092E-09
      4.02441173985749E-18  -1.76915126784382E-01  -1.75216933699990E-01   0.00000000000000E+00  -1.88840142500455E-10
     -1.22615363087164E-22  -5.20101667842266E-09  -5.38985682092324E-09  -2.75697139254339E-18
      7.47251063121259E-09
      0.00000000000000E+00   3.41386888200377E-13   0.00000000000000E+00   9.42104426806755E-13  -4.80849064740986E-23
     -3.42355680655561E-10  -3.41413576228802E-10  -1.27156888533362E-18  -1.67113395886278E-02  -1.67113395936115E-02
      0.00000000000000E+00   0.00000000000000E+00   4.98372647770840E-09   0.00000000000000E+00   4.98372647770840E-09
      4.09983352692921E-18  -2.21094883565197E-01  -2.19632217015958E-01   0.00000000000000E+00  -1.97176533237733E-10
     -1.29567151396486E-22  -4.44513636824175E-09  -4.64231290147961E-09  -2.82826464159558E-18
      7.49251063121259E-09
      0.00000000000000E+00   2.09314156095953E-13   0.00000000000000E+00   3.15832516307231E-13  -4.81031120853645E-23
     -2.09673074325361E-10  -2.09357241809102E-10  -1.27443220432817E-18  -1.39649961383785E-02  -1.39649961422293E-02
      0.00000000000000E+00   0.00000000000000E+00   3.85077170167992E-09   0.00000000000000E+00   3.85077170167992E-09
      4.17684896096281E-18  -2.69017726024497E-01  -2.67870411116762E-01   0.00000000000000E+00  -1.88285234693057E-10
     -1.37393709793926E-22  -3.45312922517767E-09  -3.64141445987086E-09  -2.90241675663464E-18
      7.51251063121259E-09
      0.00000000000000E+00   1.62014116434077E-13   0.00000000000000E+00   1.13604728401050E-13  -4.81115972848506E-23
     -1.62171646099206E-10  -1.62058041370853E-10  -1.27638385289418E-18  -1.21587870631759E-02  -1.21587870659361E-02
      0.00000000000000E+00   0.00000000000000E+00   2.76021547342537E-09   0.00000000000000E+00   2.76021547342537E-09
      4.23205327043131E-18  -3.03683962668635E-01  -3.02865347385709E-01   0.00000000000000E+00  -1.55474938806408E-10
     -1.43279612651906E-22  -2.44268249324806E-09  -2.59815743205461E-09  -2.95566941753713E-18
      7.53251063121258E-09
      0.00000000000000E+00   1.39236621606611E-13   0.00000000000000E+00   5.63363133553795E-14  -4.81144924440536E-23
     -1.39291892403414E-10  -1.39235556090107E-10  -1.27790258237262E-18  -1.09370289367722E-02  -1.09370289386559E-02
      0.00000000000000E+00   0.00000000000000E+00   1.88369256855390E-09   0.00000000000000E+00   1.88369256855390E-09
      4.26972712180239E-18  -3.26580973750802E-01  -3.26031339312301E-01   0.00000000000000E+00  -1.11259733334774E-10
     -1.47246461521284E-22  -1.63319727912884E-09  -1.74445701246376E-09  -2.99182453942977E-18
      7.55251063121258E-09
      0.00000000000000E+00   1.30878750520726E-13   0.00000000000000E+00   2.15242874820188E-14  -4.81159719650415E-23
     -1.30905061031349E-10  -1.30883536743915E-10  -1.27926940466700E-18  -1.00671917923938E-02  -1.00671917935830E-02
      0.00000000000000E+00   0.00000000000000E+00   1.18912288790153E-09   0.00000000000000E+00   1.18912288790153E-09
      4.29350957956042E-18  -3.39490494039602E-01  -3.39157074004030E-01   0.00000000000000E+00  -6.44901733968890E-11
     -1.49473307838283E-22  -9.93749177760529E-10  -1.05823935115757E-09  -3.01424017489342E-18
      7.57251063121258E-09
      0.00000000000000E+00   1.17010195202389E-13   0.00000000000000E+00   3.70601891892430E-14  -4.81126403968077E-23
     -1.17006862900665E-10  -1.16969802711524E-10  -1.28036834352951E-18  -9.51790370583799E-03  -9.51790370658042E-03
      0.00000000000000E+00   0.00000000000000E+00   7.42423702602182E-10   0.00000000000000E+00   7.42423702602182E-10
      4.30835805361247E-18  -3.46122772653250E-01  -3.45925716384955E-01   0.00000000000000E+00  -3.15111094435132E-11
     -1.50547766382008E-22  -5.93942790446924E-10  -6.25453899890588E-10  -3.02798971008296E-18
      7.59251063121258E-09
      0.00000000000000E+00   8.67014319239053E-14   0.00000000000000E+00   8.21419737176096E-14  -4.80980317019788E-23
     -8.67810094824840E-11  -8.66988675088145E-11  -1.28087342118712E-18  -9.30869360452487E-03  -9.30869360523748E-03
      0.00000000000000E+00   0.00000000000000E+00   7.12616837663447E-10   0.00000000000000E+00   7.12616837663447E-10
      4.32261039036573E-18  -3.53267585703969E-01  -3.53070382701801E-01   0.00000000000000E+00  -3.35674334732412E-11
     -1.51659880404927E-22  -5.92350536681321E-10  -6.25917970154714E-10  -3.04173696917861E-18
      7.59751063121258E-09
      0.00000000000000E+00   8.48645371797547E-14   0.00000000000000E+00   2.66137944962851E-14  -4.80946100823084E-23
     -8.48765129591291E-11  -8.48498991646809E-11  -1.28099114410527E-18  -9.26405825288637E-03  -9.26405825355991E-03
      0.00000000000000E+00   0.00000000000000E+00   6.73540580306371E-10   0.00000000000000E+00   6.73540580306371E-10
      4.32597809326727E-18  -3.54906529476971E-01  -3.54721056272910E-01   0.00000000000000E+00  -3.04815260087798E-11
     -1.51910823002328E-22  -5.58209155132588E-10  -5.88690681141520E-10  -3.04498694916200E-18
      7.60426063121258E-09
      0.00000000000000E+00   5.78621844407419E-14   0.00000000000000E+00   2.08378187453088E-13  -4.80852338660559E-23
     -5.80392551190336E-11  -5.78308769316286E-11  -1.28096933491250E-18  -9.28651270675826E-03  -9.28651270758311E-03
      0.00000000000000E+00   0.00000000000000E+00   8.24850572603630E-10   0.00000000000000E+00   8.24850572603630E-10
      4.33154583463234E-18  -3.58224600775138E-01  -3.57982937668724E-01   0.00000000000000E+00  -4.80484072622720E-11
     -1.52433638391527E-22  -7.18971288409625E-10  -7.67019695672050E-10  -3.05057649971984E-18
      7.61337313121258E-09
      0.00000000000000E+00   3.42580869784075E-14   0.00000000000000E+00   1.44367488205128E-13  -4.80697766141315E-23
     -3.43608781641260E-11  -3.42165106759689E-11  -1.28072876851735E-18  -9.37297163167945E-03  -9.37297163283647E-03
      0.00000000000000E+00   0.00000000000000E+00   1.15702057426780E-09   0.00000000000000E+00   1.15702057426780E-09
      4.34208918461536E-18  -3.65361116533278E-01  -3.65007349965459E-01   0.00000000000000E+00  -8.11612389453688E-11
     -1.53614450142470E-22  -1.04164282464641E-09  -1.12280406359193E-09  -3.06136041609801E-18
      7.61644859996258E-09
      0.00000000000000E+00   2.03895316600709E-14   0.00000000000000E+00   2.38322602170590E-13  -4.80634367098134E-23
     -2.06494397767422E-11  -2.04111171746197E-11  -1.28060563934420E-18  -9.41758416443565E-03  -9.41758416572967E-03
      0.00000000000000E+00   0.00000000000000E+00   1.29402543118508E-09   0.00000000000000E+00   1.29402543118508E-09
      4.34606891939067E-18  -3.68166558088976E-01  -3.67765272324540E-01   0.00000000000000E+00  -9.65799095847972E-11
     -1.54084370565484E-22  -1.17703440442574E-09  -1.27361431401069E-09  -3.06546328004647E-18
      7.62060048277508E-09
      0.00000000000000E+00   1.54299158508645E-14   0.00000000000000E+00   8.01078289332501E-14  -4.80554624003638E-23
     -1.55288400156655E-11  -1.54487321867803E-11  -1.28041986458716E-18  -9.47174876692022E-03  -9.47174876840340E-03
      0.00000000000000E+00   0.00000000000000E+00   1.48317889928446E-09   0.00000000000000E+00   1.48317889928446E-09
      4.35222690437047E-18  -3.72588636617813E-01  -3.72126187134519E-01   0.00000000000000E+00  -1.15390492982864E-10
     -1.54838984895958E-22  -1.35233967411465E-09  -1.46773016709766E-09  -3.07180703978332E-18
      7.62620552457196E-09
      0.00000000000000E+00   2.45225448344096E-14   0.00000000000000E+00  -6.13210044932594E-14  -4.80466508552008E-23
     -2.44868251519919E-11  -2.45481461565332E-11  -1.28022210376448E-18  -9.49279427798387E-03  -9.49279427964156E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65768613091327E-09   0.00000000000000E+00   1.65768613091327E-09
      4.36151830442034E-18  -3.79225782691226E-01  -3.78711215263820E-01   0.00000000000000E+00  -1.32029119657120E-10
     -1.55997373864660E-22  -1.50110886509958E-09  -1.63313798475686E-09  -3.08129620065586E-18
      7.63377233099774E-09
      0.00000000000000E+00   3.86666343643688E-14   0.00000000000000E+00  -7.72602657611839E-14  -4.80368931705600E-23
     -3.85898963537893E-11  -3.86671566195985E-11  -1.28006571852334E-18  -9.43944605152703E-03  -9.43944605329320E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76616987722165E-09   0.00000000000000E+00   1.76616987722165E-09
      4.37488256999633E-18  -3.88664237675074E-01  -3.88119937007405E-01   0.00000000000000E+00  -1.43713393974059E-10
     -1.57680855587851E-22  -1.58378932662791E-09  -1.72750272060213E-09  -3.09481685147299E-18
      7.64398751967254E-09
      0.00000000000000E+00   5.41883949524408E-14   0.00000000000000E+00  -6.36012714311639E-14  -4.80265983487077E-23
     -5.41455232452145E-11  -5.42091245166937E-11  -1.28002003079280E-18  -9.26335856255534E-03  -9.26335856435402E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79867912423543E-09   0.00000000000000E+00   1.79867912423543E-09
      4.39325641661582E-18  -4.01469755039882E-01  -4.00920107890833E-01   0.00000000000000E+00  -1.50201743975468E-10
     -1.60017588358212E-22  -1.59426825574281E-09  -1.74446999971844E-09  -3.11323638582302E-18
      7.65777802438353E-09
      0.00000000000000E+00   7.84354055752278E-14   0.00000000000000E+00  -7.97614196738956E-14  -4.80192226953039E-23
     -7.83449761786430E-11  -7.84247375983649E-11  -1.28030355121141E-18  -8.82750344030579E-03  -8.82750344209070E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78490989342660E-09   0.00000000000000E+00   1.78490989342660E-09
      4.41787122490981E-18  -4.18234392558802E-01  -4.17696713422643E-01   0.00000000000000E+00  -1.53520691291171E-10
     -1.63172966474598E-22  -1.55296446453707E-09  -1.70648515582840E-09  -3.13756767369840E-18
      7.67639520574336E-09
      0.00000000000000E+00   1.23347482069708E-13   0.00000000000000E+00  -1.20593277091419E-13  -4.80253637681658E-23
     -1.23260488690055E-10  -1.23381081967195E-10  -1.28154073883784E-18  -7.75097480881186E-03  -7.75097481057955E-03
      0.00000000000000E+00   0.00000000000000E+00   1.76769721280074E-09   0.00000000000000E+00   1.76769721280074E-09
      4.45078076450979E-18  -4.39638418856322E-01  -4.39120327604163E-01   0.00000000000000E+00  -1.56636820740113E-10
     -1.67402845273816E-22  -1.48767931009333E-09  -1.64431613083361E-09  -3.16924002567195E-18
      7.69639520574336E-09
      0.00000000000000E+00   1.65687905922378E-13   0.00000000000000E+00  -1.13816907914414E-13  -4.80469390870346E-23
     -1.65568689843722E-10  -1.65682506751684E-10  -1.28373243380386E-18  -6.10740832870829E-03  -6.10740833045107E-03
      0.00000000000000E+00   0.00000000000000E+00   1.74278345553293E-09   0.00000000000000E+00   1.74278345553293E-09
      4.48563643362045E-18  -4.61278743869887E-01  -4.60781829729265E-01   0.00000000000000E+00  -1.60369904011162E-10
     -1.71918641715987E-22  -1.41673104476996E-09  -1.57710094878129E-09  -3.20190399981659E-18
      7.71639520574336E-09
      0.00000000000000E+00   1.71474124366452E-13   0.00000000000000E+00  -2.53323573125875E-14  -4.80685962527365E-23
     -1.71420882129433E-10  -1.71446214486794E-10  -1.28605437846385E-18  -4.41514885077109E-03  -4.41514885244382E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67272399645485E-09   0.00000000000000E+00   1.67272399645485E-09
      4.51909091354954E-18  -4.81817408438619E-01  -4.81344383592650E-01   0.00000000000000E+00  -1.62436547977413E-10
     -1.76362834126117E-22  -1.33884123399037E-09  -1.50127778196796E-09  -3.23303653508569E-18
      7.73639520574336E-09
      0.00000000000000E+00   2.18131250867876E-13   0.00000000000000E+00  -1.34222145405275E-13  -4.81096126964764E-23
     -2.17972757589027E-10  -2.18106979734480E-10  -1.28932107217374E-18  -2.17482365724472E-03  -2.17482365892371E-03
      0.00000000000000E+00   0.00000000000000E+00   1.67899619746355E-09   0.00000000000000E+00   1.67899619746355E-09
      4.55267083749881E-18  -5.01352451385260E-01  -5.00892150477607E-01   0.00000000000000E+00  -1.68495754673085E-10
     -1.80847825376972E-22  -1.29239346305589E-09  -1.46088921772915E-09  -3.26334976532507E-18
      7.75639520574336E-09
      0.00000000000000E+00  -5.26086654724713E-13   0.00000000000000E+00   1.93946753447466E-12  -4.78397090276218E-23
      5.24163658413061E-10   5.26103125947488E-10  -1.27775672594873E-18  -8.91171783706448E-03  -8.91171783749392E-03
      0.00000000000000E+00   0.00000000000000E+00   4.29440096492116E-10   0.00000000000000E+00   4.29440096492116E-10
      4.56125963942866E-18  -5.20959548330337E-01  -5.20658482118414E-01   0.00000000000000E+00  -1.01859264712073E-10
     -1.83499624317590E-22  -8.53683957727290E-10  -9.55543222439547E-10  -3.28350291347992E-18
      7.76639520574336E-09
      0.00000000000000E+00  -1.83882348363189E-12   0.00000000000000E+00   6.77013194925589E-12  -4.74150332138333E-23
      1.83210675657049E-09   1.83887688851969E-09  -1.25889237708688E-18  -2.00761728175946E-02  -2.00761728159082E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.68638319627689E-09   0.00000000000000E+00  -1.68638319627689E-09
      4.54439580746589E-18  -5.31269568564240E-01  -5.31221549099422E-01   0.00000000000000E+00   2.02053914829098E-11
     -1.83241264970659E-22  -1.72699083725662E-10  -1.52493692242936E-10  -3.28550343037901E-18
      7.77314520574336E-09
      0.00000000000000E+00  -2.62097326569119E-12   0.00000000000000E+00   6.14397622755667E-12  -4.70449661796509E-23
      2.61488898206022E-09   2.62103295828773E-09  -1.24092036887744E-18  -3.05821613355032E-02  -3.05821613325654E-02
      0.00000000000000E+00   0.00000000000000E+00  -2.93780860967630E-09   0.00000000000000E+00  -2.93780860967630E-09
      4.52456559935057E-18  -5.38397809364741E-01  -5.38497660101493E-01   0.00000000000000E+00   9.02523254715008E-11
     -1.82447010416537E-22   2.26523325917212E-10   3.16775651388530E-10  -3.28364523047313E-18
      7.77770145574336E-09
      0.00000000000000E+00  -3.12290475453032E-12   0.00000000000000E+00   5.91264067749081E-12  -4.67581176213811E-23
      3.11701354398880E-09   3.12292618466625E-09  -1.22653226307198E-18  -3.88985493146149E-02  -3.88985493108877E-02
      0.00000000000000E+00   0.00000000000000E+00  -3.72719139167882E-09   0.00000000000000E+00  -3.72719139167882E-09
      4.50758358357224E-18  -5.43268915797906E-01  -5.43459356334429E-01   0.00000000000000E+00   1.32078162053114E-10
     -1.81656701917302E-22   4.72187044959613E-10   6.04265207012545E-10  -3.28105132050025E-18
      7.78385239324336E-09
      0.00000000000000E+00  -3.69289319364024E-12   0.00000000000000E+00   5.10473595603348E-12  -4.63202262215496E-23
      3.68775827458359E-09   3.69286301053958E-09  -1.20369102829828E-18  -5.19179125496561E-02  -5.19179125450499E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.60614698475615E-09   0.00000000000000E+00  -4.60614698475615E-09
      4.47925146135319E-18  -5.49928357591278E-01  -5.50216172461293E-01   0.00000000000000E+00   1.75824968661413E-10
     -1.80222173686964E-22   7.37459005555047E-10   9.13283974216279E-10  -3.27556043305490E-18
      7.79215615886836E-09
      0.00000000000000E+00  -4.49451405998753E-12   0.00000000000000E+00   5.33702155011581E-12  -4.56229075602508E-23
      4.48917011153030E-09   4.49450713308037E-09  -1.16652244430093E-18  -7.26438928259725E-02  -7.26438928201812E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.79122992280313E-09   0.00000000000000E+00  -5.79122992280313E-09
      4.43116244539374E-18  -5.59048409667602E-01  -5.59457051039784E-01   0.00000000000000E+00   2.29181984089661E-10
     -1.77661711725922E-22   1.06754080563338E-09   1.29672278972287E-09  -3.26464000109282E-18
      7.79776120066523E-09
      0.00000000000000E+00  -5.18977872064851E-12   0.00000000000000E+00   6.69975060341824E-12  -4.50855561351938E-23
      5.18311828332143E-09   5.18981803392480E-09  -1.13782148896172E-18  -8.82778806775167E-02  -8.82778806707492E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.76749608560879E-09   0.00000000000000E+00  -6.76749608560879E-09
      4.39323034697372E-18  -5.65260245116644E-01  -5.65757419762281E-01   0.00000000000000E+00   2.65886446952067E-10
     -1.75628967220472E-22   1.31179160473241E-09   1.57767805168430E-09  -3.25540885801199E-18
      7.80154460387812E-09
      0.00000000000000E+00  -5.66755504360206E-12   0.00000000000000E+00   6.82025523541961E-12  -4.46977977676812E-23
      5.66074587001946E-09   5.66756612525483E-09  -1.11684650592377E-18  -9.94986108265736E-02  -9.94986108191708E-02
      0.00000000000000E+00   0.00000000000000E+00  -7.40288934962215E-09   0.00000000000000E+00  -7.40288934962215E-09
      4.36522223162369E-18  -5.69463348041639E-01  -5.70010200768904E-01   0.00000000000000E+00   2.85636727049208E-10
     -1.74139085384956E-22   1.44968649731768E-09   1.73532322436671E-09  -3.24837572569992E-18
      7.80665219821553E-09
      0.00000000000000E+00  -6.17251740876904E-12   0.00000000000000E+00   5.47485683209357E-12  -4.41472664722331E-23
      6.16701440773338E-09   6.17248926456543E-09  -1.08653897000030E-18  -1.15400302628107E-01  -1.15400302620113E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.99352375553040E-09   0.00000000000000E+00  -7.99352375553040E-09
      4.32439455495405E-18  -5.75100617009643E-01  -5.75674488873564E-01   0.00000000000000E+00   3.00863509283060E-10
     -1.71995160848613E-22   1.52017098168194E-09   1.82103449096483E-09  -3.23785558495375E-18
      7.81354745057102E-09
      0.00000000000000E+00  -6.76592625586687E-12   0.00000000000000E+00   4.80040325712083E-12  -4.33043004293727E-23
      6.76115662151931E-09   6.76595702477638E-09  -1.04346180278659E-18  -1.37406335386167E-01  -1.37406335377697E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.46986482987825E-09   0.00000000000000E+00  -8.46986482987825E-09
      4.26599269953512E-18  -5.82499748072648E-01  -5.83036743405386E-01   0.00000000000000E+00   3.04659284206740E-10
     -1.69017511427420E-22   1.39924852089535E-09   1.70390780510192E-09  -3.22253089674853E-18
      7.82285604125094E-09
      0.00000000000000E+00  -7.75582883348960E-12   0.00000000000000E+00   5.72491133091143E-12  -4.14470108464537E-23
      7.75011815477036E-09   7.75584306610123E-09  -9.83562539674370E-19  -1.66936778418821E-01  -1.66936778410019E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.80220911815560E-09   0.00000000000000E+00  -8.80220911815560E-09
      4.18405653777519E-18  -5.91711698591125E-01  -5.92041591780542E-01   0.00000000000000E+00   2.96319437196082E-10
     -1.65025793411918E-22   7.50046614858471E-10   1.04636605205439E-09  -3.20049399810082E-18
      7.83542263866882E-09
      0.00000000000000E+00  -1.04280514625426E-11   0.00000000000000E+00   1.08614793623417E-11  -3.37272925775455E-23
      1.04171613737114E-08   1.04280228530738E-08  -9.02976665412490E-19  -2.04925352225674E-01  -2.04925352216617E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.05644018994226E-09   0.00000000000000E+00  -9.05644018994226E-09
      4.07024789986902E-18  -6.01090001258413E-01  -6.00658290334558E-01   0.00000000000000E+00   2.83517991586894E-10
     -1.59712515970852E-22  -1.65510065471825E-09  -1.37158266313151E-09  -3.16727123445653E-18
      7.85238754518297E-09
      0.00000000000000E+00  -1.91544954788413E-11   0.00000000000000E+00   2.56224547063972E-11   4.33724214494989E-24
      1.91289308010660E-08   1.91545532557724E-08  -8.02957079663179E-19  -2.49835811198796E-01  -2.49835811189368E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.42779689514871E-09   0.00000000000000E+00  -9.42779689514871E-09
      3.91030620690846E-18  -6.00791508740436E-01  -5.97727972501063E-01   0.00000000000000E+00   2.88109195653269E-10
     -1.51995952692552E-22  -1.00148655562768E-08  -9.72675636062364E-09  -3.10734912724528E-18
      7.87238754518297E-09
      0.00000000000000E+00  -3.75979290022220E-11   0.00000000000000E+00   4.57102974742921E-11   9.25465534652541E-23
      3.75521717843030E-08   3.75978820817774E-08  -7.10551046284108E-19  -2.90225341249258E-01  -2.90225341239193E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.00652680727514E-08   0.00000000000000E+00  -1.00652680727514E-08
      3.70900084545343E-18  -5.68394721732666E-01  -5.59721987270994E-01   0.00000000000000E+00   3.14973405045934E-10
     -1.40646353334889E-22  -2.78475874140718E-08  -2.75326140090260E-08  -2.99844979916932E-18
      7.89238754518297E-09
      0.00000000000000E+00  -5.66839083071065E-11   0.00000000000000E+00   4.74047781435473E-11   1.82972114045829E-22
      5.66365319118880E-08   5.66839366900317E-08  -6.48512048673059E-19  -3.17951344841662E-01  -3.17951344830930E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07318454144698E-08   0.00000000000000E+00  -1.07318454144698E-08
      3.49436393716403E-18  -4.99099597972250E-01  -4.84623643407717E-01   0.00000000000000E+00   3.09957276906589E-10
     -1.26022070741360E-22  -4.62620485524684E-08  -4.59520912755620E-08  -2.84585188849098E-18
      7.91238754518297E-09
      0.00000000000000E+00  -6.59350613070718E-11   0.00000000000000E+00   2.30948841846091E-11   2.25876506253765E-22
      6.59119091842233E-08   6.59350040684082E-08  -6.13606582811764E-19  -3.35049604117058E-01  -3.35049604105751E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13073479154063E-08   0.00000000000000E+00  -1.13073479154063E-08
      3.26821697885591E-18  -3.96913890477719E-01  -3.79703975532398E-01   0.00000000000000E+00   2.68585615554410E-10
     -1.09593558441784E-22  -5.48962417685562E-08  -5.46276561530019E-08  -2.65461039604414E-18
      7.93238754518297E-09
      0.00000000000000E+00  -6.09014186396761E-11   0.00000000000000E+00  -1.24113884845603E-11   2.04438041344433E-22
      6.09137771079796E-08   6.09013657194952E-08  -6.01245190705835E-19  -3.43455451805185E-01  -3.43455451793374E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18113352044441E-08   0.00000000000000E+00  -1.18113352044441E-08
      3.03199027476703E-18  -2.72381187103036E-01  -2.56915278253231E-01   0.00000000000000E+00   2.10470015104988E-10
     -9.30669159686586E-23  -4.93005005301560E-08  -4.90900305150511E-08  -2.43074508406119E-18
      7.95238754518297E-09
      0.00000000000000E+00  -5.24413243612792E-11   0.00000000000000E+00  -2.09786672266876E-11   1.62106092280075E-22
      5.24622814596992E-08   5.24413027924727E-08  -5.94141087331389E-19  -3.49910786991306E-01  -3.49910786979399E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19079003784544E-08   0.00000000000000E+00  -1.19079003784544E-08
      2.79383226719794E-18  -1.59405387825835E-01  -1.46634960442965E-01   0.00000000000000E+00   1.23678072695944E-10
     -7.91566887498119E-23  -4.06570804867140E-08  -4.05334024140182E-08  -2.19969117986655E-18
      7.97238754518297E-09
      0.00000000000000E+00  -4.58194106533537E-11   0.00000000000000E+00  -1.64176378779014E-11   1.28427645810194E-22
      4.58357990484567E-08   4.58193814105790E-08  -5.80068483925183E-19  -3.58949231377887E-01  -3.58949231366214E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16733772618512E-08   0.00000000000000E+00  -1.16733772618512E-08
      2.56036472196091E-18  -7.43126840209195E-02  -6.35545229907529E-02   0.00000000000000E+00   6.50127574865911E-11
     -5.25255558928695E-23  -3.42110169062143E-08  -3.41460041487278E-08  -1.98029623803573E-18
      7.97488754518296E-09
      0.00000000000000E+00  -4.38729451377146E-11   0.00000000000000E+00  -3.81415741057246E-11   1.23620737496019E-22
      4.39110648394013E-08   4.38729232652957E-08  -5.78194798218012E-19  -3.60061907022554E-01  -3.60061907010884E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16703406162258E-08   0.00000000000000E+00  -1.16703406162258E-08
      2.53118887042035E-18  -6.47107982786815E-02  -5.45649269175068E-02   0.00000000000000E+00   7.18542680003349E-11
     -4.20399201770367E-23  -3.22744369170703E-08  -3.22025826490700E-08  -1.95299407220234E-18
      7.97826254518297E-09
      0.00000000000000E+00  -4.16491085157088E-11   0.00000000000000E+00  -3.27019225649722E-11   1.18766772289636E-22
      4.16818153613271E-08   4.16491134387622E-08  -5.74096221619326E-19  -3.62124435076633E-01  -3.62124435065149E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.14836648296246E-08   0.00000000000000E+00  -1.14836648296246E-08
      2.49243150162036E-18  -5.40390995172020E-02  -4.45350395685955E-02   0.00000000000000E+00   5.75860542803671E-11
     -2.32370829561176E-23  -3.02230346634177E-08  -3.01654486091374E-08  -1.91833528000104E-18
      7.98281879518297E-09
      0.00000000000000E+00  -3.90375034132128E-11   0.00000000000000E+00  -2.83973024827752E-11   1.16205928802821E-22
      3.90658712351331E-08   3.90374739326504E-08  -5.65712602243344E-19  -3.65890402842831E-01  -3.65890402831648E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11837612494009E-08   0.00000000000000E+00  -1.11837612494009E-08
      2.44147548942778E-18  -4.32724914464163E-02  -3.44967623324525E-02   0.00000000000000E+00   4.66786491148177E-11
      6.50071952604233E-24  -2.79003913323641E-08  -2.78537126832492E-08  -1.87576288718444E-18
      7.98589426393297E-09
      0.00000000000000E+00  -3.73483868512291E-11   0.00000000000000E+00  -2.71641521148302E-11   1.16164837953800E-22
      3.73755812022610E-08   3.73484170501463E-08  -5.58811118774548E-19  -3.68847966004810E-01  -3.68847965993827E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.09831622270896E-08   0.00000000000000E+00  -1.09831622270896E-08
      2.40769711722219E-18  -3.75726193267335E-02  -2.92658432020995E-02   0.00000000000000E+00   4.16233748151033E-11
      2.73619004884770E-23  -2.64068781978721E-08  -2.63652548230570E-08  -1.84888599844764E-18
      7.99004614674547E-09
      0.00000000000000E+00  -3.56144500574882E-11   0.00000000000000E+00  -2.06935359727675E-11   1.18617897754262E-22
      3.56351836321669E-08   3.56144900961943E-08  -5.47864103874549E-19  -3.73405718070875E-01  -3.73405718060120E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07550840209396E-08   0.00000000000000E+00  -1.07550840209396E-08
      2.36304326872865E-18  -3.20212457277187E-02  -2.41889007921210E-02   0.00000000000000E+00   3.24451277030379E-11
      5.34123511875901E-23  -2.48918512029580E-08  -2.48594060752549E-08  -1.81517916485410E-18
      7.99565118854234E-09
      0.00000000000000E+00  -3.40451908775604E-11   0.00000000000000E+00  -1.38553602531312E-11   1.24433103974517E-22
      3.40590029267845E-08   3.40451475665315E-08  -5.31414936764078E-19  -3.80135881901687E-01  -3.80135881891146E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05415035916907E-08   0.00000000000000E+00  -1.05415035916907E-08
      2.30395770049532E-18  -2.70314623333838E-02  -1.96262618833769E-02   0.00000000000000E+00   2.36605427297825E-11
      8.43606319257162E-23  -2.35273045175709E-08  -2.35036439748410E-08  -1.77254276373124E-18
      8.00321799496812E-09
      0.00000000000000E+00  -3.27680898066898E-11   0.00000000000000E+00  -8.32493579484084E-12   1.33215084241225E-22
      3.27763893975981E-08   3.27680644618034E-08  -5.08045995653813E-19  -3.89615450280638E-01  -3.89615450270270E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03677391553496E-08   0.00000000000000E+00  -1.03677391553496E-08
      2.22550702523380E-18  -2.28045733847693E-02  -1.57469820087424E-02   0.00000000000000E+00   1.66325260322643E-11
      1.18985323357846E-22  -2.24169578324861E-08  -2.24003253064537E-08  -1.71746102957999E-18
      8.01343318364293E-09
      0.00000000000000E+00  -3.17451231236723E-11   0.00000000000000E+00  -4.91197995026213E-12   1.42046212015194E-22
      3.17500055833868E-08   3.17450936034366E-08  -4.76447970373545E-19  -4.02417803684594E-01  -4.02417803674363E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02310549814796E-08   0.00000000000000E+00  -1.02310549814796E-08
      2.12099486825568E-18  -1.93110651354423E-02  -1.25327043860624E-02   0.00000000000000E+00   1.19064493575824E-11
      1.53093394064250E-22  -2.15259450713148E-08  -2.15140386219570E-08  -1.64454689788214E-18
      8.02722368835391E-09
      0.00000000000000E+00  -3.07866314461746E-11   0.00000000000000E+00  -3.39056768704543E-12   1.44120654843463E-22
      3.07900596603866E-08   3.07866690926997E-08  -4.35400563872649E-19  -4.19149062311911E-01  -4.19149062301806E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01045031251038E-08   0.00000000000000E+00  -1.01045031251038E-08
      1.98164867030676E-18  -1.64071981253639E-02  -9.89092486938616E-03   0.00000000000000E+00   9.13282804074867E-12
      1.76195601395651E-22  -2.06912987956368E-08  -2.06821659675959E-08  -1.54624810643411E-18
      8.04584086971374E-09
      0.00000000000000E+00  -2.96273671731412E-11   0.00000000000000E+00  -3.03559265411321E-12   1.29360728577178E-22
      2.96303374292101E-08   2.96273018365561E-08  -3.83686114506024E-19  -4.40502674233784E-01  -4.40502674223831E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.95334306408559E-09   0.00000000000000E+00  -9.95334306408559E-09
      1.79634547734606E-18  -1.39272960090998E-02  -7.72866834731346E-03   0.00000000000000E+00   7.61372247871439E-12
      1.71025425534559E-22  -1.96815724949494E-08  -1.96739587724705E-08  -1.41265936284004E-18
      8.06584086971374E-09
      0.00000000000000E+00  -2.84285178183713E-11   0.00000000000000E+00  -2.92568402851869E-12   9.98381950920761E-23
      2.84314134509342E-08   2.84284877669058E-08  -3.32235257590876E-19  -4.62097230702460E-01  -4.62097230692655E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.80475033491244E-09   0.00000000000000E+00  -9.80475033491244E-09
      1.60025047064781E-18  -1.21422284884685E-02  -6.27448567497286E-03   0.00000000000000E+00   6.62333507432205E-12
      1.35753304843614E-22  -1.86303607670678E-08  -1.86237374319933E-08  -1.26801521305693E-18
      8.08584086971374E-09
      0.00000000000000E+00  -2.74406358249672E-11   0.00000000000000E+00  -2.40985039332637E-12   6.74836164192779E-23
      2.74430661218823E-08   2.74406562714891E-08  -2.84221901173002E-19  -4.82597392709560E-01  -4.82597392699885E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.67552833833135E-09   0.00000000000000E+00  -9.67552833833135E-09
      1.40673990388118E-18  -1.09270502358034E-02  -5.32982304423531E-03   0.00000000000000E+00   5.51886051325876E-12
      9.04626706358791E-23  -1.77706467936710E-08  -1.77651279331577E-08  -1.12251800270818E-18
      8.10584086971374E-09
      0.00000000000000E+00  -2.66009912374160E-11   0.00000000000000E+00  -2.04698991488071E-12   4.07040703298456E-23
      2.66030602352034E-08   2.66010132452885E-08  -2.39357117970867E-19  -5.02094497071039E-01  -5.02094497061520E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.51896899646639E-09   0.00000000000000E+00  -9.51896899646639E-09
      1.21636052395186E-18  -1.00603673816141E-02  -4.67835432780405E-03   0.00000000000000E+00   4.61465149918890E-12
      5.11107459112691E-23  -1.70866589003214E-08  -1.70820442488222E-08  -9.77003405980987E-19
      8.12584086971374E-09
      0.00000000000000E+00  -2.65040950396620E-11   0.00000000000000E+00  -2.17005860312413E-13   2.28642074553348E-23
      2.65043495627797E-08   2.65041325569195E-08  -1.95121730315368E-19  -5.21733920905866E-01  -5.21733920896005E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.86081547633183E-09   0.00000000000000E+00  -9.86081547633183E-09
      1.01914421442522E-18  -9.51349133205983E-03  -4.26970407466286E-03   0.00000000000000E+00   3.77206606588324E-12
      2.44301150197914E-23  -1.66470891466536E-08  -1.66433170805876E-08  -8.24022484109851E-19
      8.14584086971374E-09
      0.00000000000000E+00  -2.74254814433279E-11   0.00000000000000E+00   2.29710236412096E-12   1.29078746229281E-23
      2.74231429865647E-08   2.74254400889288E-08  -1.49165794863970E-19  -5.42674204643143E-01  -5.42674204632336E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08072778021063E-08   0.00000000000000E+00  -1.08072778021063E-08
      8.02998658383093E-19  -9.30637393532834E-03  -4.07050927055679E-03   0.00000000000000E+00   2.68412035896629E-12
      9.49315727842638E-24  -1.66208464071816E-08  -1.66181622868226E-08  -6.53832863519124E-19
      8.16584086971374E-09
      0.00000000000000E+00  -2.84103325604043E-11   0.00000000000000E+00   2.45929454073238E-12   8.00847185989375E-24
      2.84078700991000E-08   2.84103293936408E-08  -1.03019945694222E-19  -5.64269398219379E-01  -5.64269398207874E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15050251208789E-08   0.00000000000000E+00  -1.15050251208789E-08
      5.72898155965514E-19  -9.27404834051891E-03  -3.94771164131657E-03   0.00000000000000E+00   1.78803406663854E-12
      2.36727160281886E-24  -1.69070923068284E-08  -1.69053042727618E-08  -4.69878210271292E-19
      8.17584086971374E-09
      0.00000000000000E+00  -2.91194657763836E-11   0.00000000000000E+00   3.52481804873834E-12   6.48713340223158E-24
      2.91159383514864E-08   2.91194631695351E-08  -8.02483843323728E-20  -5.75158348075357E-01  -5.75158348063514E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18429863451009E-08   0.00000000000000E+00  -1.18429863451009E-08
      4.54468292514505E-19  -9.37974397852654E-03  -3.93646067188998E-03   0.00000000000000E+00   5.49041808384744E-13
      1.43560304891825E-25  -1.72770258662426E-08  -1.72764768244342E-08  -3.74219908182133E-19
      8.18934086971374E-09
      0.00000000000000E+00  -2.89321025124802E-11   0.00000000000000E+00  -6.48105838839099E-13   5.32012745322454E-24
      2.89327244636806E-08   2.89320763578417E-08  -5.17677450949038E-20  -5.88924339886245E-01  -5.88924339874904E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13403519837267E-08   0.00000000000000E+00  -1.13403519837267E-08
      3.01373540734194E-19  -9.36284493517734E-03  -3.82023572855009E-03   0.00000000000000E+00   1.00333988064811E-12
     -1.21817939653696E-24  -1.75927277139956E-08  -1.75917243741149E-08  -2.49605795639290E-19
      8.20756586971374E-09
      0.00000000000000E+00  -2.54376857959454E-11   0.00000000000000E+00  -9.43830109377555E-12   4.10755712862568E-24
      2.54470924434944E-08   2.54376541424006E-08  -2.64369333177314E-20  -6.01173256573871E-01  -6.01173256566110E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.76065396533549E-09   0.00000000000000E+00  -7.76065396533549E-09
      1.59935622215955E-19  -8.98147177869998E-03  -3.41199306682929E-03   0.00000000000000E+00   1.17366320788133E-12
     -1.95665783652658E-24  -1.76781738402730E-08  -1.76770001770651E-08  -1.33498688898223E-19
      8.22756586971374E-09
      0.00000000000000E+00  -1.38901388315803E-11   0.00000000000000E+00  -2.84661044303006E-11   2.14388593256375E-24
      1.39185786158879E-08   1.38901125114576E-08  -4.06837681330702E-20  -5.93501889523908E-01  -5.93501889527699E-01
      0.00000000000000E+00   0.00000000000000E+00   3.79180983764484E-09   0.00000000000000E+00   3.79180983764484E-09
      2.35771818968852E-19  -7.97211815003663E-03  -2.40108712273731E-03   0.00000000000000E+00  -6.63438106784502E-13
     -2.51875117162306E-24  -1.76812589109957E-08  -1.76819223491024E-08  -1.95088050835781E-19
      8.24756586971374E-09
      0.00000000000000E+00   4.69666432658130E-12   0.00000000000000E+00  -4.58089321625419E-11  -1.30865215522336E-24
     -4.65088792427368E-09  -4.69669685643623E-09  -1.27226251267172E-19  -5.51078450950128E-01  -5.51078450972507E-01
      0.00000000000000E+00   0.00000000000000E+00   2.23796950273418E-08   0.00000000000000E+00   2.23796950273418E-08
      6.83365719515688E-19  -6.37946627435811E-03  -8.08095921484029E-04   0.00000000000000E+00  -4.35666039438190E-12
     -4.15009456031363E-24  -1.76786415105113E-08  -1.76829981709056E-08  -5.56139468248516E-19
      8.26756586971374E-09
      0.00000000000000E+00   2.05655980212978E-11   0.00000000000000E+00  -3.92431865025558E-11  -9.49315571359634E-24
     -2.05263379591652E-08  -2.05655811456677E-08  -3.03643115453779E-19  -4.72385458613448E-01  -4.72385458651649E-01
      0.00000000000000E+00   0.00000000000000E+00   3.82010846271598E-08   0.00000000000000E+00   3.82010846271598E-08
      1.44738741205888E-18  -4.68303148495190E-03   8.73365410134689E-04   0.00000000000000E+00  -1.01509044206959E-11
     -1.44475090745144E-23  -1.76253525770715E-08  -1.76355034814922E-08  -1.14374429660511E-18
      8.28756586971374E-09
      0.00000000000000E+00   2.41129173064641E-11   0.00000000000000E+00  -9.08771719001137E-12  -3.26663243000968E-23
     -2.41038675484590E-08  -2.41129552656490E-08  -5.77786604045115E-19  -3.62224806264171E-01  -3.62224806305921E-01
      0.00000000000000E+00   0.00000000000000E+00   4.17499333609616E-08   0.00000000000000E+00   4.17499333609616E-08
      2.28238607927812E-18  -2.62044725691580E-03   2.93641013726920E-03   0.00000000000000E+00  -2.30424083455260E-11
     -5.74767323182909E-23  -1.76139356869669E-08  -1.76369780953125E-08  -1.70459947523300E-18
      8.30756586971374E-09
      0.00000000000000E+00   1.59311125818060E-11   0.00000000000000E+00   1.95853247681550E-11  -4.24022809099222E-23
     -1.59507063021366E-08  -1.59311209773685E-08  -8.69158351484430E-19  -2.37733136228512E-01  -2.37733136261173E-01
      0.00000000000000E+00   0.00000000000000E+00   3.26610773288442E-08   0.00000000000000E+00   3.26610773288442E-08
      2.93560762585500E-18  -6.64441418385503E-03  -1.37334785574278E-03   0.00000000000000E+00  -5.10282963320650E-11
     -7.95227879048226E-23  -1.66789280551437E-08  -1.67299563514758E-08  -2.06644927437057E-18
      8.32756586971374E-09
      0.00000000000000E+00   1.05666451709887E-11   0.00000000000000E+00   1.24643842764736E-11  -4.54606916420095E-23
     -1.05791331963083E-08  -1.05666688120318E-08  -1.07900560183985E-18  -1.31695153730805E-01  -1.31695153754741E-01
      0.00000000000000E+00   0.00000000000000E+00   2.39354131122618E-08   0.00000000000000E+00   2.39354131122618E-08
      3.41431588810024E-18  -3.31894138431112E-02  -2.89773625587756E-02   0.00000000000000E+00  -9.63317898028352E-11
     -9.23728720732063E-23  -1.32724125104271E-08  -1.33687443002300E-08  -2.33531028626039E-18
      8.34756586971374E-09
      0.00000000000000E+00   6.50380137587659E-12   0.00000000000000E+00   9.23484600616163E-12  -4.73924650175235E-23
     -6.51302013857632E-09  -6.50378529257021E-09  -1.20765307615499E-18  -5.82204347989212E-02  -5.82204348156079E-02
      0.00000000000000E+00   0.00000000000000E+00   1.66867241200330E-08   0.00000000000000E+00   1.66867241200330E-08
      3.74805037050090E-18  -7.79949593904942E-02  -7.47866453534677E-02   0.00000000000000E+00  -1.54035470609724E-10
     -1.05129220096588E-22  -1.00289033568529E-08  -1.01829388274627E-08  -2.54039729434590E-18
      8.35006586971374E-09
      0.00000000000000E+00   5.30825843164622E-12   0.00000000000000E+00   2.25296995925482E-11  -4.75443421561024E-23
     -5.33075705298338E-09  -5.30822735339088E-09  -1.22074558883062E-18  -5.03982700538924E-02  -5.03982700684364E-02
      0.00000000000000E+00   0.00000000000000E+00   1.45440083868204E-08   0.00000000000000E+00   1.45440083868204E-08
      3.78441039146795E-18  -8.42632209568042E-02  -8.13532983564038E-02   0.00000000000000E+00  -1.81209048185333E-10
     -1.06754269157672E-22  -9.05457198524429E-09  -9.23578103342973E-09  -2.56366480263732E-18
      8.35344086971374E-09
      0.00000000000000E+00   4.02114628441994E-12   0.00000000000000E+00   1.82437052857612E-11  -4.77009504941566E-23
     -4.03937997827160E-09  -4.02113627298589E-09  -1.23407260595008E-18  -4.22878102925613E-02  -4.22878103049097E-02
      0.00000000000000E+00   0.00000000000000E+00   1.23483995082024E-08   0.00000000000000E+00   1.23483995082024E-08
      3.82608623980813E-18  -9.35769527977229E-02  -9.09532737011110E-02   0.00000000000000E+00  -1.82593492009269E-10
     -1.08826161918080E-22  -8.14466974320740E-09  -8.32726323521678E-09  -2.59201363385805E-18
      8.35799711971374E-09
      0.00000000000000E+00   2.75754638991878E-12   0.00000000000000E+00   1.32914651378619E-11  -4.78373923096026E-23
     -2.77087291025234E-09  -2.75758144511453E-09  -1.24630423617141E-18  -3.46606421783318E-02  -3.46606421885013E-02
      0.00000000000000E+00   0.00000000000000E+00   1.01694555856838E-08   0.00000000000000E+00   1.01694555856838E-08
      3.87242082182040E-18  -1.07168326104221E-01  -1.04833057974218E-01   0.00000000000000E+00  -1.80249660287210E-10
     -1.11424113133811E-22  -7.23162448028139E-09  -7.41187414056871E-09  -2.62611658564899E-18
      8.36414805721374E-09
      0.00000000000000E+00   1.69609676201140E-12   0.00000000000000E+00   8.28285611257140E-12  -4.79416680166355E-23
     -1.70434631931582E-09  -1.69606346320330E-09  -1.25628829110053E-18  -2.81917672119762E-02  -2.81917672202342E-02
      0.00000000000000E+00   0.00000000000000E+00   8.25802078100192E-09   0.00000000000000E+00   8.25802078100192E-09
      3.92321539151805E-18  -1.26463750356714E-01  -1.24396264779725E-01   0.00000000000000E+00  -1.79935801583081E-10
     -1.14697518304074E-22  -6.38202151621554E-09  -6.56195731779874E-09  -2.66692710041752E-18
      8.37245182283874E-09
      0.00000000000000E+00   9.58124298548919E-13   0.00000000000000E+00   4.26368100595673E-12  -4.80143317587759E-23
     -9.62389621438883E-10  -9.58125940432974E-10  -1.26364659323104E-18  -2.31049601778736E-02  -2.31049601846665E-02
      0.00000000000000E+00   0.00000000000000E+00   6.79289813136412E-09   0.00000000000000E+00   6.79289813136412E-09
      3.97962202551539E-18  -1.52909176295743E-01  -1.51070803853592E-01   0.00000000000000E+00  -1.83974251434038E-10
     -1.18886205155036E-22  -5.65079793949705E-09  -5.83477219093121E-09  -2.71597543228436E-18
      8.38366190643249E-09
      0.00000000000000E+00   5.24617138929393E-13   0.00000000000000E+00   1.85103249846465E-12  -4.80614221463062E-23
     -5.26462519751911E-10  -5.24611487253495E-10  -1.26873925027193E-18  -1.91911692736397E-02  -1.91911692793499E-02
      0.00000000000000E+00   0.00000000000000E+00   5.71015012728357E-09   0.00000000000000E+00   5.71015012728357E-09
      4.04363328577511E-18  -1.87712135641724E-01  -1.86078315661539E-01   0.00000000000000E+00  -1.92148073439142E-10
     -1.24298540161674E-22  -4.99339056659077E-09  -5.18553864003004E-09  -2.77489403550318E-18
      8.39879551928405E-09
      0.00000000000000E+00   2.98311706450047E-13   0.00000000000000E+00   7.14394550205085E-13  -4.80892070276491E-23
     -2.99035595570502E-10  -2.98321201020345E-10  -1.27222311109814E-18  -1.61024767342530E-02  -1.61024767390065E-02
      0.00000000000000E+00   0.00000000000000E+00   4.75349120047497E-09   0.00000000000000E+00   4.75349120047497E-09
      4.11557078129640E-18  -2.30697268081450E-01  -2.29293563432449E-01   0.00000000000000E+00  -1.98217876913725E-10
     -1.31106636324046E-22  -4.25695212254084E-09  -4.45516999945470E-09  -2.84334767019826E-18
      8.41879551928405E-09
      0.00000000000000E+00   1.95904824463655E-13   0.00000000000000E+00   2.44539476439375E-13  -4.81049421811533E-23
     -1.96194771272834E-10  -1.95950231796443E-10  -1.27482550894121E-18  -1.35857761780865E-02  -1.35857761817259E-02
      0.00000000000000E+00   0.00000000000000E+00   3.63944162272846E-09   0.00000000000000E+00   3.63944162272846E-09
      4.18835961375097E-18  -2.76253589912992E-01  -2.75168634237828E-01   0.00000000000000E+00  -1.83991788762297E-10
     -1.38604746864491E-22  -3.25949960216962E-09  -3.44349139093205E-09  -2.91353410480976E-18
      8.43879551928405E-09
      0.00000000000000E+00   1.56687121676041E-13   0.00000000000000E+00   9.43879216381180E-14  -4.81122848034089E-23
     -1.56823988975789E-10  -1.56729601054199E-10  -1.27667559679611E-18  -1.19052899242498E-02  -1.19052899268339E-02
      0.00000000000000E+00   0.00000000000000E+00   2.58409880141970E-09   0.00000000000000E+00   2.58409880141970E-09
      4.24004158977937E-18  -3.08621657205601E-01  -3.07856852893979E-01   0.00000000000000E+00  -1.47843323222369E-10
     -1.44129331156109E-22  -2.27952587714302E-09  -2.42736920036554E-09  -2.96336599298325E-18
      8.45879551928405E-09
      0.00000000000000E+00   1.36756813702007E-13   0.00000000000000E+00   4.96509076189864E-14  -4.81146150187392E-23
     -1.36790428870781E-10  -1.36740777963210E-10  -1.27814780172065E-18  -1.07619512800504E-02  -1.07619512817985E-02
      0.00000000000000E+00   0.00000000000000E+00   1.74802278120581E-09   0.00000000000000E+00   1.74802278120581E-09
      4.27500204540348E-18  -3.29617857490249E-01  -3.29110183780632E-01   0.00000000000000E+00  -1.02956794251547E-10
     -1.47771970919928E-22  -1.50832520899086E-09  -1.61128200324255E-09  -2.99685424368283E-18
      8.47879551928405E-09
      0.00000000000000E+00   1.30327682097480E-13   0.00000000000000E+00   1.67871313567699E-14  -4.81161113019531E-23
     -1.30326030013378E-10  -1.30309242882069E-10  -1.27950519561976E-18  -9.93875967805634E-03  -9.93875967913661E-03
      0.00000000000000E+00   0.00000000000000E+00   1.08027253000506E-09   0.00000000000000E+00   1.08027253000506E-09
      4.29660749600358E-18  -3.40916768174818E-01  -3.40617464156359E-01   0.00000000000000E+00  -5.63203411798576E-11
     -1.49711316958703E-22  -8.93642945942899E-10  -9.49963287122906E-10  -3.01710230038383E-18
      8.49879551928405E-09
      0.00000000000000E+00   1.11040287283900E-13   0.00000000000000E+00   5.11683922110008E-14  -4.81104211421324E-23
     -1.11091879660613E-10  -1.11040711268450E-10  -1.28048755082620E-18  -9.46626859306413E-03  -9.46626859377641E-03
      0.00000000000000E+00   0.00000000000000E+00   7.12274755968893E-10   0.00000000000000E+00   7.12274755968893E-10
      4.31085299112296E-18  -3.47279313934109E-01  -3.47089888902798E-01   0.00000000000000E+00  -2.98655834988848E-11
     -1.50725522806350E-22  -5.71368461201438E-10  -6.01234044700474E-10  -3.03036544029676E-18
      8.51879551928405E-09
      0.00000000000000E+00   8.32113319100192E-14   0.00000000000000E+00   7.67171886050738E-14  -4.80948337503106E-23
     -8.32754703456756E-11  -8.31987531571186E-11  -1.28092501778874E-18  -9.28556970753049E-03  -9.28556970826217E-03
      0.00000000000000E+00   0.00000000000000E+00   7.31677561240210E-10   0.00000000000000E+00   7.31677561240210E-10
      4.32548654234776E-18  -3.54826368655723E-01  -3.54622056984742E-01   0.00000000000000E+00  -3.57931704434615E-11
     -1.51905690789803E-22  -6.12685637639511E-10  -6.48478808083125E-10  -3.04456152455903E-18
      8.52004551928405E-09
      0.00000000000000E+00   1.08744168853712E-13   0.00000000000000E+00  -9.63228393790688E-13  -4.80963795587519E-23
     -1.07805475019611E-10  -1.08768703413450E-10  -1.28098435951239E-18  -9.25598555051210E-03  -9.25598555118135E-03
      0.00000000000000E+00   0.00000000000000E+00   6.69246945500995E-10   0.00000000000000E+00   6.69246945500995E-10
      4.32632310102964E-18  -3.55164448415775E-01  -3.54987865732448E-01   0.00000000000000E+00  -2.51210635762912E-11
     -1.51959704301745E-22  -5.35357178510265E-10  -5.60478242086708E-10  -3.04533874151725E-18
      8.52173301928405E-09
      0.00000000000000E+00   8.81709477192257E-14   0.00000000000000E+00   5.64898466327846E-13  -4.80937140359388E-23
     -8.86979776257232E-11  -8.81330791594434E-11  -1.28102972500326E-18  -9.23952990545415E-03  -9.23952990610175E-03
      0.00000000000000E+00   0.00000000000000E+00   6.47603927237443E-10   0.00000000000000E+00   6.47603927237443E-10
      4.32741593265686E-18  -3.55681651954796E-01  -3.55505385477433E-01   0.00000000000000E+00  -2.82957192327021E-11
     -1.52037839537014E-22  -5.31175128845238E-10  -5.59470848078092E-10  -3.04638620765360E-18
      8.52401114428405E-09
      0.00000000000000E+00   6.36484028848160E-14   0.00000000000000E+00   5.41580801058201E-13  -4.80898106700088E-23
     -6.41932232485314E-11  -6.36516424475212E-11  -1.28103536050354E-18  -9.24693810401220E-03  -9.24693810470286E-03
      0.00000000000000E+00   0.00000000000000E+00   6.90664046131328E-10   0.00000000000000E+00   6.90664046131328E-10
      4.32898935168695E-18  -3.56552823799275E-01  -3.56355275157054E-01   0.00000000000000E+00  -3.58510160455102E-11
     -1.52168840846440E-22  -5.91161387638653E-10  -6.27012403684315E-10  -3.04795399118341E-18
      8.52708661303405E-09
      0.00000000000000E+00   4.62897475525935E-14   0.00000000000000E+00   2.97328515803376E-13  -4.80846992345245E-23
     -4.65461167290480E-11  -4.62487882132928E-11  -1.28098979664548E-18  -9.27936966593430E-03  -9.27936966673464E-03
      0.00000000000000E+00   0.00000000000000E+00   8.00339797731705E-10   0.00000000000000E+00   8.00339797731705E-10
      4.33145077172425E-18  -3.58070644676382E-01  -3.57833054860056E-01   0.00000000000000E+00  -4.77680855870907E-11
     -1.52403850825183E-22  -7.06322923930789E-10  -7.54091009518032E-10  -3.05046097507878E-18
      8.53123849584655E-09
      0.00000000000000E+00   3.25130369714645E-14   0.00000000000000E+00   1.81356280618315E-13  -4.80773221847310E-23
     -3.26855620431987E-11  -3.25042057626284E-11  -1.28087198184132E-18  -9.33873185610718E-03  -9.33873185709204E-03
      0.00000000000000E+00   0.00000000000000E+00   9.84864153476715E-10   0.00000000000000E+00   9.84864153476715E-10
      4.33553981227572E-18  -3.60793539829379E-01  -3.60493477748265E-01   0.00000000000000E+00  -6.59403575067546E-11
     -1.52841309414444E-22  -8.86419590207218E-10  -9.52359947714125E-10  -3.05466783043440E-18
      8.53684353764342E-09
      0.00000000000000E+00   2.24101158786365E-14   0.00000000000000E+00   1.08014633797555E-13  -4.80669042276942E-23
     -2.24917455876434E-11  -2.23837309538940E-11  -1.28065787679788E-18  -9.41926000069479E-03  -9.41926000194027E-03
      0.00000000000000E+00   0.00000000000000E+00   1.24548293067802E-09   0.00000000000000E+00   1.24548293067802E-09
      4.34252079615947E-18  -3.65673256570498E-01  -3.65287887801068E-01   0.00000000000000E+00  -9.09687291333896E-11
     -1.53652998511636E-22  -1.13213047059054E-09  -1.22309919972408E-09  -3.06186291936159E-18
      8.54062694085631E-09
      0.00000000000000E+00   1.77260342810527E-14   0.00000000000000E+00   7.95523552359938E-14  -4.80597252212594E-23
     -1.78446418859922E-11  -1.77650895308043E-11  -1.28049672383330E-18  -9.46938626348608E-03  -9.46938626490269E-03
      0.00000000000000E+00   0.00000000000000E+00   1.41661434413971E-09   0.00000000000000E+00   1.41661434413971E-09
      4.34788041942051E-18  -3.69492327997813E-01  -3.69051582209810E-01   0.00000000000000E+00  -1.08077336542668E-10
     -1.54300099998933E-22  -1.29077191806587E-09  -1.39884925460870E-09  -3.06738369558722E-18
      8.54573453519372E-09
      0.00000000000000E+00   2.19508921925989E-14   0.00000000000000E+00  -2.13528086448071E-14  -4.80511556638119E-23
     -2.19269040246961E-11  -2.19482568333890E-11  -1.28030218752665E-18  -9.50364275381691E-03  -9.50364275541515E-03
      0.00000000000000E+00   0.00000000000000E+00   1.59824988024483E-09   0.00000000000000E+00   1.59824988024483E-09
      4.35604363145860E-18  -3.75324530890880E-01  -3.74827872013413E-01   0.00000000000000E+00  -1.25542732667333E-10
     -1.55308944916095E-22  -1.45075889074387E-09  -1.57630162341136E-09  -3.07574144393195E-18
      8.55262978754921E-09
      0.00000000000000E+00   3.35233290807473E-14   0.00000000000000E+00  -6.70676761001353E-14  -4.80415070616320E-23
     -3.35006782488584E-11  -3.35677459250066E-11  -1.28012279789655E-18  -9.48146918510047E-03  -9.48146918683446E-03
      0.00000000000000E+00   0.00000000000000E+00   1.73398829675096E-09   0.00000000000000E+00   1.73398829675096E-09
      4.36799991834617E-18  -3.83798284742151E-01  -3.83262517487397E-01   0.00000000000000E+00  -1.39367219137859E-10
     -1.56806284217244E-22  -1.56105333168795E-09  -1.70042055082597E-09  -3.08787712044962E-18
      8.56193837822912E-09
      0.00000000000000E+00   4.74837291362913E-14   0.00000000000000E+00  -6.10638986688596E-14  -4.80308993676608E-23
     -4.74524804687192E-11  -4.75135443674360E-11  -1.28001606583239E-18  -9.36022187869889E-03  -9.36022188049331E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79441628125870E-09   0.00000000000000E+00   1.79441628125870E-09
      4.38470340501779E-18  -3.95505648737334E-01  -3.94955235297016E-01   0.00000000000000E+00  -1.47937952842700E-10
     -1.58920472106392E-22  -1.59896478404833E-09  -1.74690273689119E-09  -3.10468733918539E-18
      8.57450497564701E-09
      0.00000000000000E+00   6.64955897382494E-14   0.00000000000000E+00  -6.53292206767669E-14  -4.80211804506667E-23
     -6.64085433334955E-11  -6.64738725542202E-11  -1.28011996407744E-18  -9.05111353884002E-03  -9.05111354063274E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79271553060571E-09   0.00000000000000E+00   1.79271553060571E-09
      4.40723173937570E-18  -4.11027658964706E-01  -4.10483755111124E-01   0.00000000000000E+00  -1.52280002411609E-10
     -1.61799997473099E-22  -1.57396165563972E-09  -1.72624165805149E-09  -3.12711177529826E-18
      8.59146988216116E-09
      0.00000000000000E+00   1.03509018832883E-13   0.00000000000000E+00  -1.05463032682619E-13  -4.80203978665814E-23
     -1.03398241389795E-10  -1.03503704422526E-10  -1.28090404631024E-18  -8.26655134051663E-03  -8.26655134228936E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77273495961067E-09   0.00000000000000E+00   1.77273495961067E-09
      4.43730602223985E-18  -4.30995738754956E-01  -4.30469797458297E-01   0.00000000000000E+00  -1.55238070172544E-10
     -1.65663064916816E-22  -1.51399318501535E-09  -1.66923125518806E-09  -3.15640197592962E-18
      8.61146988216116E-09
      0.00000000000000E+00   1.52737797976117E-13   0.00000000000000E+00  -1.28438171770676E-13  -4.80377071073294E-23
     -1.52623887788046E-10  -1.52752325959865E-10  -1.28283116885432E-18  -6.76985662237130E-03  -6.76985662412778E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75648807419006E-09   0.00000000000000E+00   1.75648807419006E-09
      4.47243578372366E-18  -4.53131972098833E-01  -4.52626666345814E-01   0.00000000000000E+00  -1.58983013673159E-10
     -1.70191918731510E-22  -1.44475273455689E-09  -1.60373574823022E-09  -3.18960461486934E-18
      8.63146988216116E-09
      0.00000000000000E+00   1.72208882264113E-13   0.00000000000000E+00  -5.89420876928736E-14  -4.80603505762093E-23
     -1.72110786754261E-10  -1.72169728842002E-10  -1.28516205805610E-18  -5.06134191157382E-03  -5.06134191327645E-03
      0.00000000000000E+00   0.00000000000000E+00   1.70262791328034E-09   0.00000000000000E+00   1.70262791328034E-09
      4.50648834198927E-18  -4.74065056648085E-01  -4.73582838031940E-01   0.00000000000000E+00  -1.61791622507376E-10
     -1.74666723740018E-22  -1.36866656193081E-09  -1.53045818443836E-09  -3.22132628393316E-18
      8.65146988216116E-09
      0.00000000000000E+00   1.84883455998751E-13   0.00000000000000E+00  -4.47428859381626E-14  -4.80873889983427E-23
     -1.84799380123353E-10  -1.84844123009339E-10  -1.28776002316600E-18  -3.21735543130475E-03  -3.21735543295571E-03
      0.00000000000000E+00   0.00000000000000E+00   1.65095945585190E-09   0.00000000000000E+00   1.65095945585190E-09
      4.53950753110630E-18  -4.93990644579483E-01  -4.93528697896015E-01   0.00000000000000E+00  -1.64767350370784E-10
     -1.79098695888327E-22  -1.30134798247156E-09  -1.46611533284253E-09  -3.25174750794030E-18
      8.67146988216115E-09
      0.00000000000000E+00   5.66682028570440E-14   0.00000000000000E+00   3.23984095542296E-13  -4.80608577080767E-23
     -5.69879274874109E-11  -5.66639433919167E-11  -1.28781346800051E-18  -2.93678368780948E-03  -2.93678368919180E-03
      0.00000000000000E+00   0.00000000000000E+00   1.38232774816824E-09   0.00000000000000E+00   1.38232774816824E-09
      4.56715408606967E-18  -5.13197519483688E-01  -5.12779827040254E-01   0.00000000000000E+00  -1.55102718277825E-10
     -1.83164216891490E-22  -1.17056108649827E-09  -1.32566380477627E-09  -3.27934061806916E-18
      8.69146988216115E-09
      0.00000000000000E+00  -1.75496923856142E-12   0.00000000000000E+00   4.76409338495969E-12  -4.72956877201583E-23
      1.75021933979954E-09   1.75498343318446E-09  -1.25180415412586E-18  -2.42046405383831E-02  -2.42046405368286E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.55449163426730E-09   0.00000000000000E+00  -1.55449163426730E-09
      4.53606425338432E-18  -5.33736177308645E-01  -5.33673032971000E-01   0.00000000000000E+00   1.19325265022023E-11
     -1.82846307953854E-22  -2.12424325419214E-10  -2.00491798917194E-10  -3.28426009925846E-18
      8.71146988216115E-09
      0.00000000000000E+00  -3.52720528771786E-12   0.00000000000000E+00   4.87363493187463E-12  -4.59470283265835E-23
      3.52230370560760E-09   3.52717734053943E-09  -1.18125294082451E-18  -6.44050534055584E-02  -6.44050534012414E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.31701517271795E-09   0.00000000000000E+00  -4.31701517271795E-09
      4.44972394992996E-18  -5.55106105723934E-01  -5.55355025198200E-01   0.00000000000000E+00   1.59861319233477E-10
     -1.78585614717945E-22   6.29976512945197E-10   7.89837832178495E-10  -3.26847100910546E-18
      8.71396988216115E-09
      0.00000000000000E+00  -4.12226734008542E-12   0.00000000000000E+00   1.21116587711669E-11  -4.57293955616554E-23
      4.11019485901344E-09   4.12230651778456E-09  -1.17097798617249E-18  -7.01204896831956E-02  -7.01204896780089E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.18665441796815E-09   0.00000000000000E+00  -5.18665441796815E-09
      4.43675731388504E-18  -5.57798852071372E-01  -5.58134270325123E-01   0.00000000000000E+00   1.96974749308069E-10
     -1.77924220517637E-22   8.67373150876094E-10   1.06434790018399E-09  -3.26577932771256E-18
      8.71734488216115E-09
      0.00000000000000E+00  -4.66516158171911E-12   0.00000000000000E+00   8.54148876054277E-12  -4.54273377469964E-23
      4.65666334943964E-09   4.66520483820014E-09  -1.15535273251568E-18  -7.87104871120269E-02  -7.87104871060299E-02
      0.00000000000000E+00   0.00000000000000E+00  -5.99695937871636E-09   0.00000000000000E+00  -5.99695937871636E-09
      4.41651757598187E-18  -5.61494957671110E-01  -5.61914638006119E-01   0.00000000000000E+00   2.32520824182832E-10
     -1.76861972473507E-22   1.09923371633350E-09   1.33175454051616E-09  -3.26116484346619E-18
      8.72190113216115E-09
      0.00000000000000E+00  -5.27381665519339E-12   0.00000000000000E+00   7.18817776667445E-12  -4.49852173991903E-23
      5.26660935342926E-09   5.27379753119589E-09  -1.13170301787384E-18  -9.15181744880669E-02  -9.15181744812031E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.86375579011453E-09   0.00000000000000E+00  -6.86375579011453E-09
      4.38524458866316E-18  -5.66540033461228E-01  -5.67041078507464E-01   0.00000000000000E+00   2.67171637887495E-10
     -1.75198050685246E-22   1.32278662103146E-09   1.58995825891878E-09  -3.25354157078933E-18
      8.72497660091115E-09
      0.00000000000000E+00  -5.68776088578772E-12   0.00000000000000E+00   7.22620771961140E-12  -4.46684328982969E-23
      5.68052633855536E-09   5.68775254627493E-09  -1.11461129513606E-18  -1.00638943059202E-01  -1.00638943051785E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.41753910652005E-09   0.00000000000000E+00  -7.41753910652005E-09
      4.36243217893916E-18  -5.69953109435480E-01  -5.70498217920663E-01   0.00000000000000E+00   2.84744490006240E-10
     -1.73990423115266E-22   1.44504207023938E-09   1.72978656024544E-09  -3.24782088380309E-18
      8.72912848372365E-09
      0.00000000000000E+00  -6.12797271122339E-12   0.00000000000000E+00   5.83167196029889E-12  -4.42227116009319E-23
      6.12215880607119E-09   6.12799047803145E-09  -1.09009141647872E-18  -1.13517681842335E-01  -1.13517681834387E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.94787987614259E-09   0.00000000000000E+00  -7.94787987614259E-09
      4.32943351308559E-18  -5.74541368018226E-01  -5.75114876966365E-01   0.00000000000000E+00   2.99392949351557E-10
     -1.72259400095177E-22   1.52049644875999E-09   1.81988939811137E-09  -3.23934209660687E-18
      8.73473352552053E-09
      0.00000000000000E+00  -6.62503642899053E-12   0.00000000000000E+00   4.94179852662700E-12  -4.35657272210149E-23
      6.62006476263668E-09   6.62500656116326E-09  -1.05533240827414E-18  -1.31380694580155E-01  -1.31380694571759E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.39687432675366E-09   0.00000000000000E+00  -8.39687432675366E-09
      4.28236868152102E-18  -5.80615667085718E-01  -5.81174065669475E-01   0.00000000000000E+00   3.05261897208650E-10
     -1.69845074234476E-22   1.46660586838154E-09   1.77186776559002E-09  -3.22703627324689E-18
      8.74230033194631E-09
      0.00000000000000E+00  -7.33664945287444E-12   0.00000000000000E+00   5.14683857538093E-12  -4.23610023408364E-23
      7.33150867718959E-09   7.33665551576493E-09  -1.00686206320684E-18  -1.55570245205413E-01  -1.55570245196685E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.72803811370485E-09   0.00000000000000E+00  -8.72803811370485E-09
      4.21632530663778E-18  -5.88398918577980E-01  -5.88837482337270E-01   0.00000000000000E+00   3.00468003711609E-10
     -1.66580982356284E-22   1.09091459422878E-09   1.39138259794022E-09  -3.20946324343094E-18
      8.75251552062111E-09
      0.00000000000000E+00  -8.89837736435123E-12   0.00000000000000E+00   7.96096816307523E-12  -3.86321742612381E-23
      8.89043514774397E-09   8.89839611590700E-09  -9.40753108821766E-19  -1.87335588833673E-01  -1.87335588824707E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.96631897161938E-09   0.00000000000000E+00  -8.96631897161938E-09
      4.12473266662421E-18  -5.97445882618840E-01  -5.97467589228707E-01   0.00000000000000E+00   2.88191645089653E-10
     -1.62253755063341E-22  -2.20268789377255E-10   6.79228557122355E-11  -3.18397955780244E-18
      8.76630602533210E-09
      0.00000000000000E+00  -1.36020218909603E-11   0.00000000000000E+00   1.71302850214769E-11  -2.14476238414560E-23
      1.35849484759515E-08   1.36020787609730E-08  -8.54543795813882E-19  -2.26920364451252E-01  -2.26920364442028E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.22464282082826E-09   0.00000000000000E+00  -9.22464282082826E-09
      3.99752018634641E-18  -6.03856440386005E-01  -6.02477923707078E-01   0.00000000000000E+00   2.80845518208135E-10
     -1.56336988754640E-22  -4.65828145835271E-09  -4.37743594014473E-09  -3.14297639053252E-18
      8.78492320669193E-09
      0.00000000000000E+00  -2.72071665029856E-11   0.00000000000000E+00   3.62589602726648E-11   4.29978199858901E-23
      2.71709229181719E-08   2.72071818784446E-08  -7.54863866021027E-19  -2.70867468143625E-01  -2.70867468133907E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.71701354439244E-09   0.00000000000000E+00  -9.71701354439244E-09
      3.81661678291452E-18  -5.90591425491192E-01  -5.85082338038868E-01   0.00000000000000E+00   3.01458449813554E-10
     -1.47026621448823E-22  -1.77916267838656E-08  -1.74901683340522E-08  -3.06175291689349E-18
      8.80492320669193E-09
      0.00000000000000E+00  -4.74186112176112E-11   0.00000000000000E+00   5.00890819426680E-11   1.39452207442048E-22
      4.73685480371332E-08   4.74186371190760E-08  -6.77177837878258E-19  -3.04947698003328E-01  -3.04947697992931E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03972336775072E-08   0.00000000000000E+00  -1.03972336775072E-08
      3.60867210936437E-18  -5.40274399240874E-01  -5.28612243348173E-01   0.00000000000000E+00   3.19206026956528E-10
     -1.34157435037148E-22  -3.73406094685252E-08  -3.70214034415688E-08  -2.93149427148612E-18
      8.82492320669193E-09
      0.00000000000000E+00  -6.29098793529303E-11   0.00000000000000E+00   3.85517449255933E-11   2.12064068087521E-22
      6.28713176127267E-08   6.29098693576525E-08  -6.28576412947354E-19  -3.27373534400428E-01  -3.27373534389413E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10150764740482E-08   0.00000000000000E+00  -1.10150764740482E-08
      3.38837057988341E-18  -4.54585093578431E-01  -4.38236577040673E-01   0.00000000000000E+00   2.93498393796800E-10
     -1.18243328398046E-22  -5.21882912774008E-08  -5.18947928836042E-08  -2.75979416693606E-18
      8.84492320669193E-09
      0.00000000000000E+00  -6.50873343826464E-11   0.00000000000000E+00   5.52390516491309E-12   2.22910614236961E-22
      6.50818109445319E-08   6.50873348496971E-08  -6.05513065745649E-19  -3.39892682809805E-01  -3.39892682798236E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15691561131197E-08   0.00000000000000E+00  -1.15691561131197E-08
      3.15698745762101E-18  -3.38946889343725E-01  -3.22086175689835E-01   0.00000000000000E+00   2.44529679085411E-10
     -1.01897064201434E-22  -5.37627084156627E-08  -5.35181787365773E-08  -2.55147439187536E-18
      8.86492320669193E-09
      0.00000000000000E+00  -5.65972987199198E-11   0.00000000000000E+00  -2.10233138509128E-11   1.83965854614056E-22
      5.66182980168094E-08   5.65972747029587E-08  -5.98150797508282E-19  -3.46401979501784E-01  -3.46401979489864E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19198526385878E-08   0.00000000000000E+00  -1.19198526385878E-08
      2.91859040484926E-18  -2.15851220914978E-01  -2.01775335151240E-01   0.00000000000000E+00   1.70168447869935E-10
     -8.01590592688946E-23  -4.48475905122407E-08  -4.46774220643708E-08  -2.32043960734098E-18
      8.88492320669193E-09
      0.00000000000000E+00  -4.93083166856561E-11   0.00000000000000E+00  -1.80853777849946E-11   1.44236006097829E-22
      4.93264251845810E-08   4.93083398067962E-08  -5.89190996105158E-19  -3.53595070671614E-01  -3.53595070659778E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18358404949136E-08   0.00000000000000E+00  -1.18358404949136E-08
      2.68187359495099E-18  -1.14490590864865E-01  -1.02684442468552E-01   0.00000000000000E+00   9.06502275633531E-11
     -7.27187001887947E-23  -3.75631495394459E-08  -3.74724993118826E-08  -2.09268259884583E-18
      8.90492320669193E-09
      0.00000000000000E+00  -4.20596544910264E-11   0.00000000000000E+00  -1.79391168505276E-11   1.22608823077706E-22
      4.20776342683644E-08   4.20596951515140E-08  -5.64413074882993E-19  -3.66274865773691E-01  -3.66274865762311E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13801623331598E-08   0.00000000000000E+00  -1.13801623331598E-08
      2.45427034828779E-18  -4.96887085988534E-02  -4.00226709658188E-02   0.00000000000000E+00   4.96808381763053E-11
     -7.14771472351495E-24  -3.07292136565306E-08  -3.06795328183543E-08  -1.88985727340480E-18
      8.92492320669193E-09
      0.00000000000000E+00  -3.49374624995316E-11   0.00000000000000E+00  -1.75796884728015E-11   1.31299260303568E-22
      3.49550570903432E-08   3.49374774018705E-08  -5.11948108058298E-19  -3.88127268793941E-01  -3.88127268783342E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05995143569961E-08   0.00000000000000E+00  -1.05995143569961E-08
      2.24228006114787E-18  -2.56427360687345E-02  -1.79746678598595E-02   0.00000000000000E+00   2.90996612035670E-11
      1.01859591473668E-22  -2.43670627060780E-08  -2.43379630448743E-08  -1.73033195308957E-18
      8.94492320669193E-09
      0.00000000000000E+00  -3.16599830522810E-11   0.00000000000000E+00  -8.07624393763843E-12   1.39595551397603E-22
      3.16680473637653E-08   3.16599711198278E-08  -4.52281095876137E-19  -4.12367743712266E-01  -4.12367743702074E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01911646093455E-08   0.00000000000000E+00  -1.01911646093455E-08
      2.03845676896096E-18  -1.78738433479943E-02  -1.11097306209561E-02   0.00000000000000E+00   1.45466277252350E-11
      1.60701935363607E-22  -2.14833531382078E-08  -2.14688065104824E-08  -1.58617567308482E-18
      8.96492320669193E-09
      0.00000000000000E+00  -3.00131150694128E-11   0.00000000000000E+00  -4.03540519972214E-12   1.29158904720350E-22
      3.00171544826023E-08   3.00131190774027E-08  -3.95584008892932E-19  -4.35642555526860E-01  -4.35642555516869E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.99188602587480E-09   0.00000000000000E+00  -9.99188602587480E-09
      1.83861904844346E-18  -1.45043315273312E-02  -8.19629102338519E-03   0.00000000000000E+00   8.89623086226769E-12
      1.67603873395374E-22  -2.00301292823904E-08  -2.00212330515280E-08  -1.44303503955053E-18
      8.98492320669193E-09
      0.00000000000000E+00  -2.87097464037008E-11   0.00000000000000E+00  -3.18474681306381E-12   1.02982535434925E-22
      2.87129315626871E-08   2.87097468158741E-08  -3.43146819108234E-19  -4.57534222690366E-01  -4.57534222680532E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.83467171321609E-09   0.00000000000000E+00  -9.83467171321609E-09
      1.64192561417914E-18  -1.24975797076221E-02  -6.55064973646104E-03   0.00000000000000E+00   7.05200586595588E-12
      1.39073276614171E-22  -1.88821271085242E-08  -1.88750751026581E-08  -1.29877879507091E-18
      9.00492320669193E-09
      0.00000000000000E+00  -2.76550014416096E-11   0.00000000000000E+00  -2.57459105825425E-12   7.17130017896830E-23
      2.76575459224816E-08   2.76549713314234E-08  -2.94337720274460E-19  -4.78273347650486E-01  -4.78273347640784E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.70143182298130E-09   0.00000000000000E+00  -9.70143182298130E-09
      1.44789697771952E-18  -1.11654539856450E-02  -5.50886527939264E-03   0.00000000000000E+00   5.80186431397922E-12
      9.62973748022880E-23  -1.79593413727562E-08  -1.79535395084421E-08  -1.15355925744506E-18
      9.02492320669193E-09
      0.00000000000000E+00  -2.67923038250193E-11   0.00000000000000E+00  -2.10336397139174E-12   4.43737345003730E-23
      2.67944082650138E-08   2.67923049010424E-08  -2.48725201493747E-19  -4.98005195692318E-01  -4.98005195682758E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.55950206807464E-09   0.00000000000000E+00  -9.55950206807464E-09
      1.25670693635802E-18  -1.02339914516997E-02  -4.80447990760858E-03   0.00000000000000E+00   4.80521762926595E-12
      5.64406074973938E-23  -1.72376080505971E-08  -1.72328028329678E-08  -1.00798173486428E-18
      9.04492320669193E-09
      0.00000000000000E+00  -2.63720223075576E-11   0.00000000000000E+00  -1.01426902646324E-12   2.52639174744614E-23
      2.63730254844405E-08   2.63720112154141E-08  -2.04887311302693E-19  -5.17358481019405E-01  -5.17358481009740E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.66425602939770E-09   0.00000000000000E+00  -9.66425602939770E-09
      1.06342181577007E-18  -9.59620421736659E-03  -4.33211523614979E-03   0.00000000000000E+00   4.00184951172783E-12
      2.80085283198355E-23  -1.67117570355282E-08  -1.67077551860164E-08  -8.58534504467375E-19
      9.06492320669193E-09
      0.00000000000000E+00  -2.72359139057316E-11   0.00000000000000E+00   2.15368463904228E-12   1.42563464074082E-23
      2.72337345599581E-08   2.72358882445972E-08  -1.59112062099786E-19  -5.38098232052085E-01  -5.38098232041455E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.06295035610995E-08   0.00000000000000E+00  -1.06295035610995E-08
      8.50831744548079E-19  -9.34078018742813E-03  -4.10862680050080E-03   0.00000000000000E+00   2.89495990398028E-12
      1.14718325462554E-23  -1.66092796434018E-08  -1.66063846834978E-08  -6.91719682448294E-19
      9.07492320669192E-09
      0.00000000000000E+00  -2.78076473948485E-11   0.00000000000000E+00   2.84856901121052E-12   1.04132917273966E-23
      2.78047795505424E-08   2.78076281195536E-08  -1.36066781434491E-19  -5.48753769892818E-01  -5.48753769881635E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11825948888320E-08   0.00000000000000E+00  -1.11825948888320E-08
      7.39005795659759E-19  -9.27460998732408E-03  -4.03657983463460E-03   0.00000000000000E+00   2.46083130345601E-12
      5.72422591752833E-24  -1.66274940620249E-08  -1.66250332307215E-08  -6.02939014225268E-19
      9.08842320669193E-09
      0.00000000000000E+00  -2.86016451480075E-11   0.00000000000000E+00   2.93272338610011E-12   7.59215413892982E-24
      2.85987295813334E-08   2.86016623047195E-08  -1.04717596422786E-19  -5.63479160204373E-01  -5.63479160192717E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16565700716133E-08   0.00000000000000E+00  -1.16565700716133E-08
      5.81642099692979E-19  -9.31624038364261E-03  -3.97736764666048E-03   0.00000000000000E+00   1.32688085156553E-12
      1.64677643585372E-24  -1.69464191139578E-08  -1.69450922331062E-08  -4.76924503270194E-19
      9.10664820669192E-09
      0.00000000000000E+00  -2.90947595420747E-11   0.00000000000000E+00   1.36548091769351E-12   5.76767288291930E-24
      2.90933972926440E-08   2.90947627735617E-08  -6.42990955932943E-20  -5.82843716816404E-01  -5.82843716804757E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16466711246692E-08   0.00000000000000E+00  -1.16466711246692E-08
      3.69381518445883E-19  -9.37440981353759E-03  -3.87705532604382E-03   0.00000000000000E+00   9.41433105422324E-13
     -7.25521312894420E-25  -1.74490330819978E-08  -1.74480916488924E-08  -3.05082422852588E-19
      9.12664820669192E-09
      0.00000000000000E+00  -2.67488612643201E-11   0.00000000000000E+00  -5.75884632981848E-12   4.45044534069964E-24
      2.67545877284374E-08   2.67488288821076E-08  -3.12682954184056E-20  -5.98859551191889E-01  -5.98859551182790E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.09879461152681E-09   0.00000000000000E+00  -9.09879461152681E-09
      1.87405626215347E-19  -9.10713817649105E-03  -3.54615730763053E-03   0.00000000000000E+00   1.16954512236124E-12
     -1.78219477759138E-24  -1.76512038157032E-08  -1.76500342705808E-08  -1.56137330796941E-19
      9.14664820669192E-09
      0.00000000000000E+00  -1.73619617427620E-11   0.00000000000000E+00  -2.31378517245361E-11   2.70561336546121E-24
      1.73851415945828E-08   1.73620037428582E-08  -3.29071299246065E-20  -5.97522215594573E-01  -5.97522215594887E-01
      0.00000000000000E+00   0.00000000000000E+00   3.14004997115477E-10   0.00000000000000E+00   3.14004997115477E-10
      1.93685726157656E-19  -8.26641701828948E-03  -2.69724938744918E-03   0.00000000000000E+00  -1.00884676121277E-13
     -2.36427919749282E-24  -1.76759078552975E-08  -1.76760087399737E-08  -1.60778596233049E-19
      9.16664820669192E-09
      0.00000000000000E+00   2.64145464208847E-13   0.00000000000000E+00  -4.34388021800777E-11  -3.30010232554978E-25
     -2.20772166620375E-10  -2.64210968800453E-10  -1.01013028771264E-19  -5.63629943384508E-01  -5.63629943402458E-01
      0.00000000000000E+00   0.00000000000000E+00   1.79499027161047E-08   0.00000000000000E+00   1.79499027161047E-08
      5.52683780479751E-19  -6.77325601795470E-03  -1.20103677671448E-03   0.00000000000000E+00  -3.39039103593425E-12
     -3.52701151412080E-24  -1.76823013562684E-08  -1.76856917473044E-08  -4.51670751708487E-19
      9.18664820669192E-09
      0.00000000000000E+00   1.77099614520413E-11   0.00000000000000E+00  -4.30990556115494E-11  -6.68937817443219E-24
     -1.76668916077306E-08  -1.77099906633422E-08  -2.55750739856557E-19  -4.92859973265865E-01  -4.92859973301224E-01
      0.00000000000000E+00   0.00000000000000E+00   3.53597716069834E-08   0.00000000000000E+00   3.53597716069834E-08
      1.25987921261942E-18  -5.06763579536555E-03   4.93266741226242E-04   0.00000000000000E+00  -8.50920620401083E-12
     -1.02261545216044E-23  -1.76412717374372E-08  -1.76497809436412E-08  -1.00412847276286E-18
      9.20664820669192E-09
      0.00000000000000E+00   2.46608630086442E-11   0.00000000000000E+00  -1.74277870100215E-11  -2.69680957860754E-23
     -2.46434533390299E-08  -2.46608811260399E-08  -5.09239632640962E-19  -3.89335418589047E-01  -3.89335418631326E-01
      0.00000000000000E+00   0.00000000000000E+00   4.22786034892386E-08   0.00000000000000E+00   4.22786034892386E-08
      2.10545128240419E-18  -3.21750443146087E-03   2.33328727451975E-03   0.00000000000000E+00  -1.89565435608665E-11
     -4.61883541269194E-23  -1.75987658196378E-08  -1.76177223631987E-08  -1.59621164976323E-18
      9.22664820669192E-09
      0.00000000000000E+00   1.77449542969174E-11   0.00000000000000E+00   1.65187032660336E-11  -4.14793141103631E-23
     -1.77614644559729E-08  -1.77449457527069E-08  -8.10219826941937E-19  -2.64827715452619E-01  -2.64827715487644E-01
      0.00000000000000E+00   0.00000000000000E+00   3.50248707802497E-08   0.00000000000000E+00   3.50248707802497E-08
      2.80594869800919E-18  -3.43540643456267E-03   2.00894125796156E-03   0.00000000000000E+00  -4.34852169277826E-11
     -7.67842546678755E-23  -1.72364398106150E-08  -1.72799250275429E-08  -1.99572887106725E-18
      9.24664820669192E-09
      0.00000000000000E+00   1.15184321826703E-11   0.00000000000000E+00   1.46248456840934E-11  -4.48536410443292E-23
     -1.15330203053855E-08  -1.15183954597014E-08  -1.03842416673739E-18  -1.53446476101156E-01  -1.53446476126768E-01
      0.00000000000000E+00   0.00000000000000E+00   2.56119530721946E-08   0.00000000000000E+00   2.56119530721946E-08
      3.31818775945308E-18  -2.53999017802232E-02  -2.09594850204985E-02   0.00000000000000E+00  -8.35564408667622E-11
     -8.93693735047846E-23  -1.40100011716263E-08  -1.40935576124932E-08  -2.27976359271569E-18
      9.26664820669192E-09
      0.00000000000000E+00   7.49012200874822E-12   0.00000000000000E+00   9.11285724954715E-12  -4.70934840082766E-23
     -7.49925610889923E-09  -7.49014325164973E-09  -1.18682715587302E-18  -7.06484279820640E-02  -7.06484280004957E-02
      0.00000000000000E+00   0.00000000000000E+00   1.84317430447884E-08   0.00000000000000E+00   1.84317430447884E-08
      3.68682262034884E-18  -6.61075924216520E-02  -6.26602512673580E-02   0.00000000000000E+00  -1.43301741112770E-10
     -1.02376505318944E-22  -1.07982980520257E-08  -1.09415997931385E-08  -2.49999546447583E-18
      9.27664820669192E-09
      0.00000000000000E+00   4.48909522049228E-12   0.00000000000000E+00   1.41167987382516E-11  -4.76749553345376E-23
     -4.50324603737189E-09  -4.48912923863369E-09  -1.23099577811228E-18  -4.41219876593686E-02  -4.41219876725434E-02
      0.00000000000000E+00   0.00000000000000E+00   1.31748040370754E-08   0.00000000000000E+00   1.31748040370754E-08
      3.81857066071960E-18  -9.27041147721043E-02  -8.99675216082292E-02   0.00000000000000E+00  -1.74310336367551E-10
     -1.08504538424561E-22  -8.51136446207406E-09  -8.68567479844172E-09  -2.58757488260732E-18
      9.28002320669192E-09
      0.00000000000000E+00   3.31283967107549E-12   0.00000000000000E+00   1.66255477390025E-11  -4.77934921681994E-23
     -3.32949172342977E-09  -3.31286617569082E-09  -1.24193092745186E-18  -3.73853657616849E-02  -3.73853657728008E-02
      0.00000000000000E+00   0.00000000000000E+00   1.11159128537733E-08   0.00000000000000E+00   1.11159128537733E-08
      3.85608686660108E-18  -1.02424315613294E-01  -9.99658009023039E-02   0.00000000000000E+00  -1.82256810817078E-10
     -1.10499363681595E-22  -7.62078986726526E-09  -7.80304667808245E-09  -2.61415593914922E-18
      9.28457945669192E-09
      0.00000000000000E+00   2.21428476933626E-12   0.00000000000000E+00   1.15907759454690E-11  -4.78954092651901E-23
     -2.22589286260905E-09  -2.21430208666363E-09  -1.25168711197645E-18  -3.12056942153996E-02  -3.12056942245917E-02
      0.00000000000000E+00   0.00000000000000E+00   9.19213899924942E-09   0.00000000000000E+00   9.19213899924942E-09
      3.89796854991641E-18  -1.16386640283583E-01  -1.14188123159980E-01   0.00000000000000E+00  -1.80881586382644E-10
     -1.13017313145257E-22  -6.79695532620333E-09  -6.97783691258609E-09  -2.64628143793996E-18
      9.29073039419192E-09
      0.00000000000000E+00   1.35305666854128E-12   0.00000000000000E+00   6.73307185289946E-12  -4.79741262909183E-23
     -1.35978793419971E-09  -1.35305486234685E-09  -1.25956289994878E-18  -2.59880995027835E-02  -2.59880995103829E-02
      0.00000000000000E+00   0.00000000000000E+00   7.59930921917616E-09   0.00000000000000E+00   7.59930921917616E-09
      3.94471142596674E-18  -1.35891577020766E-01  -1.33923558787060E-01   0.00000000000000E+00  -1.81660431709005E-10
     -1.16219010949640E-22  -6.06459392512029E-09  -6.24625435682941E-09  -2.68514852601796E-18
      9.29903415981692E-09
      0.00000000000000E+00   7.80863955738392E-13   0.00000000000000E+00   3.30651933178359E-12  -4.80308039954189E-23
     -7.84194701640353E-10  -7.80888182308617E-10  -1.26545290869788E-18  -2.17877518482047E-02  -2.17877518546038E-02
      0.00000000000000E+00   0.00000000000000E+00   6.39908341625769E-09   0.00000000000000E+00   6.39908341625769E-09
      3.99784791487017E-18  -1.62280502745229E-01  -1.60510366003663E-01   0.00000000000000E+00  -1.86640215111809E-10
     -1.20350901519934E-22  -5.43155501883709E-09  -5.61819523394902E-09  -2.73239500617228E-18
      9.31024424341067E-09
      0.00000000000000E+00   4.46916491251825E-13   0.00000000000000E+00   1.42447874576077E-12  -4.80689779656769E-23
     -4.48364880277494E-10  -4.46940401531781E-10  -1.26967996700986E-18  -1.84143726170583E-02  -1.84143726225264E-02
      0.00000000000000E+00   0.00000000000000E+00   5.46815960648291E-09   0.00000000000000E+00   5.46815960648291E-09
      4.05914644116281E-18  -1.96644196702077E-01  -1.95062147678014E-01   0.00000000000000E+00  -1.94691852623108E-10
     -1.25700536258459E-22  -4.82652735232769E-09  -5.02121920495092E-09  -2.78946647415295E-18
      9.32537785626223E-09
      0.00000000000000E+00   2.69013235280846E-13   0.00000000000000E+00   5.61188545593210E-13  -4.80923926851402E-23
     -2.69533465023303E-10  -2.68972276477758E-10  -1.27272566044978E-18  -1.56289609935363E-02  -1.56289609981005E-02
      0.00000000000000E+00   0.00000000000000E+00   4.56428751098484E-09   0.00000000000000E+00   4.56428751098484E-09
      4.12822060129727E-18  -2.38503195128313E-01  -2.37149855001183E-01   0.00000000000000E+00  -1.98343833458517E-10
     -1.32370293442107E-22  -4.09697140104847E-09  -4.29531523450712E-09  -2.85549494084750E-18
      9.34537785626223E-09
      0.00000000000000E+00   1.86444816531279E-13   0.00000000000000E+00   1.96437503979300E-13  -4.81063787104611E-23
     -1.86668200291711E-10  -1.86471762787780E-10  -1.27514416686747E-18  -1.32845078879387E-02  -1.32845078914026E-02
      0.00000000000000E+00   0.00000000000000E+00   3.46397682488852E-09   0.00000000000000E+00   3.46397682488852E-09
      4.19750013779504E-18  -2.82016396408181E-01  -2.80983737757473E-01   0.00000000000000E+00  -1.79666397976143E-10
     -1.39578401210634E-22  -3.09783866412441E-09  -3.27750506210069E-09  -2.92235597092757E-18
      9.36537785626223E-09
      0.00000000000000E+00   1.52554108501702E-13   0.00000000000000E+00   8.17117938261228E-14  -4.81128193447656E-23
     -1.52696068999672E-10  -1.52614357205894E-10  -1.27691586608997E-18  -1.17036620950414E-02  -1.17036620974829E-02
      0.00000000000000E+00   0.00000000000000E+00   2.44148321346690E-09   0.00000000000000E+00   2.44148321346690E-09
      4.24632980206438E-18  -3.12500632042169E-01  -3.11779465753172E-01   0.00000000000000E+00  -1.41213166072271E-10
     -1.44800745119631E-22  -2.14765569018863E-09  -2.28886885626105E-09  -2.96941393597441E-18
      9.38537785626223E-09
      0.00000000000000E+00   1.34919918957857E-13   0.00000000000000E+00   4.41019824951366E-14  -4.81147823046240E-23
     -1.35004859529364E-10  -1.34960757546917E-10  -1.27835505722738E-18  -1.06213628666163E-02  -1.06213628682538E-02
      0.00000000000000E+00   0.00000000000000E+00   1.63758550094155E-09   0.00000000000000E+00   1.63758550094155E-09
      4.27908151208322E-18  -3.31932870392364E-01  -3.31459432456087E-01   0.00000000000000E+00  -9.58997590494103E-11
     -1.48173865133244E-22  -1.40672498434508E-09  -1.50262474339464E-09  -3.00072645485584E-18
      9.40537785626223E-09
      0.00000000000000E+00   1.29592924199820E-13   0.00000000000000E+00   1.42663968520403E-14  -4.81161619966628E-23
     -1.29583402189508E-10  -1.29569135792704E-10  -1.27969922809856E-18  -9.83798298663200E-03  -9.83798298762702E-03
      0.00000000000000E+00   0.00000000000000E+00   9.95021871315001E-10   0.00000000000000E+00   9.95021871315001E-10
      4.29898194950952E-18  -3.41976235602552E-01  -3.41703559510682E-01   0.00000000000000E+00  -4.98484277560155E-11
     -1.49887324859155E-22  -8.15604307766073E-10  -8.65452735522238E-10  -3.01928272141096E-18
      9.42537785626223E-09
      0.00000000000000E+00   1.05713292525863E-13   0.00000000000000E+00   6.32161840522498E-14  -4.81083760762204E-23
     -1.05810036954285E-10  -1.05746820770281E-10  -1.28057737558368E-18  -9.42945731677460E-03  -9.42945731747190E-03
      0.00000000000000E+00   0.00000000000000E+00   6.97300034041801E-10   0.00000000000000E+00   6.97300034041801E-10
      4.31292795019035E-18  -3.48279047059828E-01  -3.48092672238178E-01   0.00000000000000E+00  -2.93722265636230E-11
     -1.50880572341263E-22  -5.62180986707837E-10  -5.91553213271610E-10  -3.03235057460667E-18
      9.44537785626223E-09
      0.00000000000000E+00   8.01804555821709E-14   0.00000000000000E+00   7.15609909439442E-14  -4.80919608620086E-23
     -8.02625961945702E-11  -8.01910352036743E-11  -1.28095677964970E-18  -9.27044754257157E-03  -9.27044754332668E-03
      0.00000000000000E+00   0.00000000000000E+00   7.55110686939678E-10   0.00000000000000E+00   7.55110686939678E-10
      4.32803016392914E-18  -3.56278591109220E-01  -3.56065948242739E-01   0.00000000000000E+00  -3.83221214330214E-11
     -1.52139003138133E-22  -6.36597530302808E-10  -6.74919651735981E-10  -3.04707338427944E-18
      9.45537785626223E-09
      0.00000000000000E+00   5.55660660105537E-14   0.00000000000000E+00   1.33721467207920E-13  -4.80787747515570E-23
     -5.56993822411920E-11  -5.55656607740322E-11  -1.28090417617051E-18  -9.29075670897145E-03  -9.29075670990587E-03
      0.00000000000000E+00   0.00000000000000E+00   9.34415776003153E-10   0.00000000000000E+00   9.34415776003153E-10
      4.33737432168917E-18  -3.62046682239885E-01  -3.61769782958884E-01   0.00000000000000E+00  -5.80206093475895E-11
     -1.53072202071183E-22  -8.20829505881566E-10  -8.78850115229309E-10  -3.05647014551866E-18
      9.46887785626223E-09
      0.00000000000000E+00   2.72778869506354E-14   0.00000000000000E+00   1.20525992858935E-13  -4.80549026745948E-23
     -2.73843882193937E-11  -2.72638622265828E-11  -1.28046145957754E-18  -9.39694601490230E-03  -9.39694601630424E-03
      0.00000000000000E+00   0.00000000000000E+00   1.40194105541833E-09   0.00000000000000E+00   1.40194105541833E-09
      4.35630052593732E-18  -3.75305736761708E-01  -3.74872608271476E-01   0.00000000000000E+00  -1.05765859653487E-10
     -1.55328291185795E-22  -1.26891133353789E-09  -1.37467719319153E-09  -3.07583906635978E-18
      9.47343410626223E-09
      0.00000000000000E+00   2.10324448205236E-14   0.00000000000000E+00   8.55179223545704E-14  -4.80466048344272E-23
     -2.11458330991991E-11  -2.10603151768926E-11  -1.28028507782960E-18  -9.43213486539659E-03  -9.43213486696236E-03
      0.00000000000000E+00   0.00000000000000E+00   1.56576848140964E-09   0.00000000000000E+00   1.56576848140964E-09
      4.36343455858075E-18  -3.80414944957066E-01  -3.79928240408118E-01   0.00000000000000E+00  -1.24946256510540E-10
     -1.56215367930175E-22  -1.41976190972230E-09  -1.54470816623299E-09  -3.08314948075115E-18
      9.47958504376223E-09
      0.00000000000000E+00   3.06761422273139E-14   0.00000000000000E+00  -6.01344763190217E-14  -4.80377035070661E-23
     -3.06554794211885E-11  -3.07156138975556E-11  -1.28010882170331E-18  -9.42361439887997E-03  -9.42361440059380E-03
      0.00000000000000E+00   0.00000000000000E+00   1.71382426360715E-09   0.00000000000000E+00   1.71382426360715E-09
      4.37397618451217E-18  -3.87925166064561E-01  -3.87394853062782E-01   0.00000000000000E+00  -1.40099403677461E-10
     -1.57547596977131E-22  -1.54300924603202E-09  -1.68310864970964E-09  -3.09386736280887E-18
      9.48788880938723E-09
      0.00000000000000E+00   4.80347975595365E-14   0.00000000000000E+00  -8.98364074012944E-14  -4.80286488783357E-23
     -4.79230500033592E-11  -4.80128864108086E-11  -1.28001895551864E-18  -9.31332039475125E-03  -9.31332039653572E-03
      0.00000000000000E+00   0.00000000000000E+00   1.78446339478568E-09   0.00000000000000E+00   1.78446339478568E-09
      4.38879395030887E-18  -3.98317848005405E-01  -3.97770727487677E-01   0.00000000000000E+00  -1.48714005301967E-10
     -1.59433400168752E-22  -1.58773650307282E-09  -1.73645050837495E-09  -3.10877499479023E-18
      9.49909889298098E-09
      0.00000000000000E+00   6.87917081684375E-14   0.00000000000000E+00  -8.28150047876144E-14  -4.80206942816529E-23
     -6.87112528686249E-11  -6.87940678734605E-11  -1.28013826689954E-18  -9.02250979841776E-03  -9.02250980020808E-03
      0.00000000000000E+00   0.00000000000000E+00   1.79032712248754E-09   0.00000000000000E+00   1.79032712248754E-09
      4.40886366701211E-18  -4.12121032001415E-01  -4.11578611408175E-01   0.00000000000000E+00  -1.52818689216983E-10
     -1.62003922219865E-22  -1.56871436539693E-09  -1.72153305461407E-09  -3.12872540011258E-18
      9.51423250583254E-09
      0.00000000000000E+00   1.04060087256128E-13   0.00000000000000E+00  -1.12720347284877E-13  -4.80202566632636E-23
     -1.03915312886787E-10  -1.04028033234120E-10  -1.28084498076248E-18  -8.31774755425231E-03  -8.31774755602811E-03
      0.00000000000000E+00   0.00000000000000E+00   1.77579429040190E-09   0.00000000000000E+00   1.77579429040190E-09
      4.43573785030707E-18  -4.29961427042009E-01  -4.29434686728326E-01   0.00000000000000E+00  -1.55542885187522E-10
     -1.65456649396419E-22  -1.51622337198004E-09  -1.67176625716773E-09  -3.15489286954459E-18
      9.53423250583254E-09
      0.00000000000000E+00   1.50900903231966E-13   0.00000000000000E+00  -1.22209625328980E-13  -4.80367293713195E-23
     -1.50755889132616E-10  -1.50878098757993E-10  -1.28273390967704E-18  -6.84257580403254E-03  -6.84257580579085E-03
      0.00000000000000E+00   0.00000000000000E+00   1.75831805528210E-09   0.00000000000000E+00   1.75831805528210E-09
      4.47090421141271E-18  -4.52169585450445E-01  -4.51663112621148E-01   0.00000000000000E+00  -1.58884232232906E-10
     -1.69988736416541E-22  -1.44855572429113E-09  -1.60743995652421E-09  -3.18817030173567E-18
      9.55423250583254E-09
      0.00000000000000E+00   1.72208882264113E-13   0.00000000000000E+00  -6.37052929420344E-14  -4.80595016055426E-23
     -1.72177955690705E-10  -1.72241660983695E-10  -1.28506558532163E-18  -5.13226522475258E-03  -5.13226522645902E-03
      0.00000000000000E+00   0.00000000000000E+00   1.70644581987812E-09   0.00000000000000E+00   1.70644581987812E-09
      4.50503312781027E-18  -4.73154113191556E-01  -4.72670714334735E-01   0.00000000000000E+00  -1.61748885602812E-10
     -1.74468003911196E-22  -1.37245527329144E-09  -1.53420415889443E-09  -3.21996754248864E-18
      9.57423250583254E-09
      0.00000000000000E+00   1.82219958619733E-13   0.00000000000000E+00  -3.76774426859749E-14  -4.80854313162725E-23
     -1.82194180061118E-10  -1.82231857503852E-10  -1.28761083365691E-18  -3.31920362937093E-03  -3.31920363102081E-03
      0.00000000000000E+00   0.00000000000000E+00   1.64987834964099E-09   0.00000000000000E+00   1.64987834964099E-09
      4.53803069480309E-18  -4.93126192196363E-01  -4.92663763154269E-01   0.00000000000000E+00  -1.64465430578074E-10
     -1.78897216026191E-22  -1.30318106155876E-09  -1.46764649213701E-09  -3.25041986114618E-18
      9.59423250583254E-09
      0.00000000000000E+00   1.08652324116504E-13   0.00000000000000E+00   1.80643738630457E-13  -4.80805868465455E-23
     -1.08815812334309E-10  -1.08635168595726E-10  -1.28870058397099E-18  -2.41042380335163E-03  -2.41042380481979E-03
      0.00000000000000E+00   0.00000000000000E+00   1.46816049730035E-09   0.00000000000000E+00   1.46816049730035E-09
      4.56739390474910E-18  -5.12306138920095E-01  -5.11877776666984E-01   0.00000000000000E+00  -1.59783466637515E-10
     -1.83089053033238E-22  -1.19974186206708E-09  -1.35952532870478E-09  -3.27869332077811E-18
      9.61423250583254E-09
      0.00000000000000E+00  -1.64971516972160E-12   0.00000000000000E+00   4.61710602332856E-12  -4.73549823292035E-23
      1.64510480375203E-09   1.64972190977531E-09  -1.25477827226382E-18  -2.24626390467615E-02  -2.24626390453753E-02
      0.00000000000000E+00   0.00000000000000E+00  -1.38615813219239E-09   0.00000000000000E+00  -1.38615813219239E-09
      4.53967074210525E-18  -5.32766024898997E-01  -5.32683006067173E-01   0.00000000000000E+00   2.33360346288155E-12
     -1.83021596946768E-22  -2.65897381045574E-10  -2.63563777582876E-10  -3.28489246984143E-18
      9.63423250583254E-09
      0.00000000000000E+00  -3.42654345573841E-12   0.00000000000000E+00   4.87733887004118E-12  -4.60376571123137E-23
      3.42168313687503E-09   3.42656047574503E-09  -1.18613730890859E-18  -6.16843847166356E-02  -6.16843847124683E-02
      0.00000000000000E+00   0.00000000000000E+00  -4.16729048114907E-09   0.00000000000000E+00  -4.16729048114907E-09
      4.45632493248227E-18  -5.54093658535147E-01  -5.54327103377645E-01   0.00000000000000E+00   1.52761406650206E-10
     -1.78957501436005E-22   5.87968598754108E-10   7.40730005404135E-10  -3.27018762357369E-18
      9.64423250583254E-09
      0.00000000000000E+00  -4.79043780327018E-12   0.00000000000000E+00   7.28065092946810E-12  -4.51226156462264E-23
      4.78312764995691E-09   4.79040830088633E-09  -1.13889711538163E-18  -8.76175290867906E-02  -8.76175290806336E-02
      0.00000000000000E+00   0.00000000000000E+00  -6.15704788502969E-09   0.00000000000000E+00  -6.15704788502969E-09
      4.39475445363198E-18  -5.65019880960655E-01  -5.65450558318009E-01   0.00000000000000E+00   2.40120436542839E-10
     -1.75699103097090E-22   1.12651914760061E-09   1.36663958414328E-09  -3.25585733825034E-18
      9.65098250583254E-09
      0.00000000000000E+00  -5.69703720424568E-12   0.00000000000000E+00   7.20419025417947E-12  -4.44290447154311E-23
      5.68987590146251E-09   5.69708009171665E-09  -1.10161875174292E-18  -1.07462302449034E-01  -1.07462302441668E-01
      0.00000000000000E+00   0.00000000000000E+00  -7.36655614101432E-09   0.00000000000000E+00  -7.36655614101432E-09
      4.34503019968013E-18  -5.72446706545802E-01  -5.72972817350200E-01   0.00000000000000E+00   2.81289738400464E-10
     -1.73076380125801E-22   1.38818631089719E-09   1.66947604929748E-09  -3.24341144793720E-18
      9.66009500583254E-09
      0.00000000000000E+00  -6.59665640519340E-12   0.00000000000000E+00   5.43178847030161E-12  -4.33622919059189E-23
      6.59121884145008E-09   6.59665062992034E-09  -1.04602285806901E-18  -1.36059194607795E-01  -1.36059194599545E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.25036886138559E-09   0.00000000000000E+00  -8.25036886138559E-09
      4.26984871343075E-18  -5.82222802050259E-01  -5.82743982254053E-01   0.00000000000000E+00   3.00163661120463E-10
     -1.69219881399508E-22   1.35355457034495E-09   1.65371823146524E-09  -3.22382585536174E-18
      9.67239688083254E-09
      0.00000000000000E+00  -8.06001860312093E-12   0.00000000000000E+00   6.33668412251769E-12  -4.05954751424260E-23
      8.05371325168367E-09   8.06004993580615E-09  -9.67386826386896E-19  -1.74674083611887E-01  -1.74674083603115E-01
      0.00000000000000E+00   0.00000000000000E+00  -8.77205582828572E-09   0.00000000000000E+00  -8.77205582828572E-09
      4.16193597913816E-18  -5.93987485072479E-01  -5.94212062544286E-01   0.00000000000000E+00   2.94155377012607E-10
     -1.63976307229179E-22   4.17850515467101E-10   7.12005892479543E-10  -3.19454915275127E-18
      9.68900441208254E-09
      0.00000000000000E+00  -1.28603756380095E-11   0.00000000000000E+00   1.45895148076881E-11  -2.43093560716925E-23
      1.28458167177393E-08   1.28604062325469E-08  -8.63338477503737E-19  -2.22955407389456E-01  -2.22955407380319E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.13715922853870E-09   0.00000000000000E+00  -9.13715922853870E-09
      4.01019032171398E-18  -6.02779832564331E-01  -6.01607379221185E-01   0.00000000000000E+00   2.84531068614206E-10
     -1.56829990168089E-22  -4.00777807262219E-09  -3.72324700400814E-09  -3.14685184421024E-18
      9.70900441208254E-09
      0.00000000000000E+00  -2.69435721072000E-11   0.00000000000000E+00   3.49490339516070E-11   4.17939819282826E-23
      2.69086207828668E-08   2.69435698168185E-08  -7.55902481827098E-19  -2.70430591865080E-01  -2.70430591855390E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.69028993544210E-09   0.00000000000000E+00  -9.69028993544210E-09
      3.81638452300513E-18  -5.89002716456574E-01  -5.83568244197214E-01   0.00000000000000E+00   3.02191938296722E-10
     -1.46835256238153E-22  -1.75554718196729E-08  -1.72532798813763E-08  -3.06048204117803E-18
      9.72900441208254E-09
      0.00000000000000E+00  -4.71006447373987E-11   0.00000000000000E+00   4.99828620800850E-11   1.37999115988782E-22
      4.70506823122526E-08   4.71006651743328E-08  -6.77885690222509E-19  -3.04654242609941E-01  -3.04654242599552E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03885523470038E-08   0.00000000000000E+00  -1.03885523470038E-08
      3.60861347606506E-18  -5.39190222419522E-01  -5.27625502422743E-01   0.00000000000000E+00   3.16621445119872E-10
     -1.34032275913977E-22  -3.70287342724487E-08  -3.67121128273290E-08  -2.93072778584255E-18
      9.74900441208254E-09
      0.00000000000000E+00  -6.26381107755332E-11   0.00000000000000E+00   3.86645401174612E-11   2.11022518827882E-22
      6.25994648749004E-08   6.26381294150181E-08  -6.29039538288489E-19  -3.27180508517012E-01  -3.27180508506002E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10099986440322E-08   0.00000000000000E+00  -1.10099986440322E-08
      3.38841350318441E-18  -4.53900027740975E-01  -4.37635515721310E-01   0.00000000000000E+00   2.91818229973343E-10
     -1.18182315228028E-22  -5.19199490009592E-08  -5.16281307709860E-08  -2.75937396489592E-18
      9.76900441208254E-09
      0.00000000000000E+00  -6.49052062687638E-11   0.00000000000000E+00   5.74926910921371E-12   2.21922605138900E-22
      6.48995364008615E-08   6.49052856699710E-08  -6.05810535320600E-19  -3.39767394563630E-01  -3.39767394552064E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.15659074149111E-08   0.00000000000000E+00  -1.15659074149111E-08
      3.15709535488619E-18  -3.38557295032214E-01  -3.21752911933817E-01   0.00000000000000E+00   2.43583535979607E-10
     -1.01879159034077E-22  -5.35829617910394E-08  -5.33393782550599E-08  -2.55128481956559E-18
      9.78900441208254E-09
      0.00000000000000E+00  -5.65218941906724E-11   0.00000000000000E+00  -2.07576767502823E-11   1.84054391382061E-22
      5.65426346389040E-08   5.65218769621539E-08  -5.98298468007534E-19  -3.46336970190480E-01  -3.46336970178564E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.19166641955218E-08   0.00000000000000E+00  -1.19166641955218E-08
      2.91876207097575E-18  -2.15720199875601E-01  -2.01667063844219E-01   0.00000000000000E+00   1.69599082810681E-10
     -8.53672081785936E-23  -4.47748118494427E-08  -4.46052127666322E-08  -2.32046360296822E-18
      9.80900441208254E-09
      0.00000000000000E+00  -4.92826001592379E-11   0.00000000000000E+00  -1.79614593841355E-11   1.44274711183320E-22
      4.93005910340048E-08   4.92826295746208E-08  -5.89260176953444E-19  -3.53561357044709E-01  -3.53561357032875E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18340960845212E-08   0.00000000000000E+00  -1.18340960845212E-08
      2.68208014928533E-18  -1.14474217842961E-01  -1.02675620133305E-01   0.00000000000000E+00   9.04704947948296E-11
     -7.33856561449293E-23  -3.75390039848944E-08  -3.74485334900996E-08  -2.09281997233189E-18
      9.81400441208254E-09
      0.00000000000000E+00  -4.66117552012431E-11   0.00000000000000E+00  -2.63965731194071E-11   1.33103550804181E-22
      4.66381949090298E-08   4.66117983359105E-08  -5.87266370284366E-19  -3.55242708377110E-01  -3.55242708365261E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.18492576865886E-08   0.00000000000000E+00  -1.18492576865886E-08
      2.62283386085239E-18  -9.15106918705651E-02  -8.05583078578466E-02   0.00000000000000E+00   7.42752908232215E-11
     -6.65053322305601E-23  -3.48368159401447E-08  -3.47625406493215E-08  -2.03556749056802E-18
      9.82075441208254E-09
      0.00000000000000E+00  -4.35524070048604E-11   0.00000000000000E+00  -2.24747180080397E-11   1.22150637652820E-22
      4.35749423869084E-08   4.35524676689005E-08  -5.81323675327712E-19  -3.58678851757128E-01  -3.58678851745502E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.16257447365961E-08   0.00000000000000E+00  -1.16257447365961E-08
      2.54436008388037E-18  -6.64468281215157E-02  -5.63878688983603E-02   0.00000000000000E+00   5.64891155047844E-11
     -4.54197803337428E-23  -3.19832120478092E-08  -3.19267229323044E-08  -1.96303640855265E-18
      9.82986691208254E-09
      0.00000000000000E+00  -3.93982695409639E-11   0.00000000000000E+00  -2.25442871838471E-11   1.17732039603781E-22
      3.94208007062818E-08   3.93982564190981E-08  -5.65276983389896E-19  -3.66034314718384E-01  -3.66034314707197E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.11876066068048E-08   0.00000000000000E+00  -1.11876066068048E-08
      2.44241301867586E-18  -4.39289295094736E-02  -3.50407417957097E-02   0.00000000000000E+00   4.35957814779688E-11
      5.74657725583307E-24  -2.82542455937712E-08  -2.82106498122933E-08  -1.87713603528596E-18
      9.83294238083254E-09
      0.00000000000000E+00  -3.76005924996010E-11   0.00000000000000E+00  -2.87943647301246E-11   1.17461356051767E-22
      3.76294003419111E-08   3.76006059771811E-08  -5.58599604516879E-19  -3.68910449425845E-01  -3.68910449414837E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10084004821418E-08   0.00000000000000E+00  -1.10084004821418E-08
      2.40855702700555E-18  -3.79722234700614E-02  -2.95939441281483E-02   0.00000000000000E+00   4.40489747305907E-11
      2.68726432701546E-23  -2.66362544697692E-08  -2.65922054950386E-08  -1.84995742248867E-18
      9.83709426364504E-09
      0.00000000000000E+00  -3.57575441580576E-11   0.00000000000000E+00  -2.20002924681511E-11   1.19621438941467E-22
      3.57795365611694E-08   3.57575362687013E-08  -5.47825161467193E-19  -3.73404400427341E-01  -3.73404400416566E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.07753043717248E-08   0.00000000000000E+00  -1.07753043717248E-08
      2.36381922598512E-18  -3.22251675566755E-02  -2.43541250503631E-02   0.00000000000000E+00   3.38926927442346E-11
      5.34189812025352E-23  -2.50161245897208E-08  -2.49822318969765E-08  -1.81599406451793E-18
      9.84269930544191E-09
      0.00000000000000E+00  -3.41081045225476E-11   0.00000000000000E+00  -1.45687543048331E-11   1.25235052801676E-22
      3.41226315456082E-08   3.41080627913034E-08  -5.31480815974739E-19  -3.80095717856087E-01  -3.80095717845535E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.05523942570299E-08   0.00000000000000E+00  -1.05523942570299E-08
      2.30467261511737E-18  -2.71156678610212E-02  -1.96940765436907E-02   0.00000000000000E+00   2.43691400270504E-11
      8.47788744752057E-23  -2.35800376743009E-08  -2.35556685342738E-08  -1.77319179914263E-18
      9.85026611186769E-09
      0.00000000000000E+00  -3.27864587541313E-11   0.00000000000000E+00  -8.61899898834117E-12   1.33916302239399E-22
      3.27950740027140E-08   3.27864550037258E-08  -5.08162713306639E-19  -3.89556892427158E-01  -3.89556892416786E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.03722590249104E-08   0.00000000000000E+00  -1.03722590249104E-08
      2.22618773887781E-18  -2.28325947188891E-02  -1.57706332807226E-02   0.00000000000000E+00   1.69051223248299E-11
      1.19670148114256E-22  -2.24311011011405E-08  -2.24141959788155E-08  -1.71802502557117E-18
      9.86048130054250E-09
      0.00000000000000E+00  -3.17453068131468E-11   0.00000000000000E+00  -5.00109008340036E-12   1.42694770391306E-22
      3.17502951896846E-08   3.17452940996013E-08  -4.76586566629769E-19  -4.02352201980736E-01  -4.02352201970504E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.02327133699126E-08   0.00000000000000E+00  -1.02327133699126E-08
      2.12165864114895E-18  -1.93189755528485E-02  -1.25410741800954E-02   0.00000000000000E+00   1.19828981721198E-11
      1.53909958093042E-22  -2.15245636278607E-08  -2.15125807296884E-08  -1.64507207451919E-18
      9.87427180525348E-09
      0.00000000000000E+00  -3.07805696935189E-11   0.00000000000000E+00  -3.41334464237493E-12   1.44706496409383E-22
      3.07839967129421E-08   3.07805833682999E-08  -4.35550013228407E-19  -4.19080790830487E-01  -4.19080790820382E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.01051578964078E-08   0.00000000000000E+00  -1.01051578964078E-08
      1.98230341357328E-18  -1.64084523747963E-02  -9.89430285012141E-03   0.00000000000000E+00   9.14994704828602E-12
      1.77029258676605E-22  -2.06845754189406E-08  -2.06754254718922E-08  -1.54675340034488E-18
      9.89288898661331E-09
      0.00000000000000E+00  -2.96187337678437E-11   0.00000000000000E+00  -3.04236607426914E-12   1.29841541957448E-22
      2.96217191651956E-08   2.96186767991214E-08  -3.83840971884557E-19  -4.40433642112573E-01  -4.40433642102620E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.95367515428297E-09   0.00000000000000E+00  -9.95367515428297E-09
      1.79699403802915E-18  -1.39256184128709E-02  -7.72981287046297E-03   0.00000000000000E+00   7.61847914071275E-12
      1.71761603470964E-22  -1.96726201239795E-08  -1.96650016448386E-08  -1.41315306614459E-18
      9.91288898661331E-09
      0.00000000000000E+00  -2.84206191709715E-11   0.00000000000000E+00  -2.92377596255998E-12   1.00195515716673E-22
      2.84235607141734E-08   2.84206369382109E-08  -3.32388890493445E-19  -4.62029501242413E-01  -4.62029501232608E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.80517218874860E-09   0.00000000000000E+00  -9.80517218874860E-09
      1.60089059425418E-18  -1.21401046309757E-02  -6.27496828949089E-03   0.00000000000000E+00   6.62163188555993E-12
      1.36318603909938E-22  -1.86220863813479E-08  -1.86154647494622E-08  -1.26850170376073E-18
      9.93288898661331E-09
      0.00000000000000E+00  -2.74346659170487E-11   0.00000000000000E+00  -2.40523240676642E-12   6.77237319239054E-23
      2.74370759989815E-08   2.74346707665748E-08  -2.84370390635396E-19  -4.82531966256894E-01  -4.82531966247218E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.67602231146261E-09   0.00000000000000E+00  -9.67602231146261E-09
      1.40737014802492E-18  -1.09253749342131E-02  -5.33018923229126E-03   0.00000000000000E+00   5.51504228698563E-12
      9.08466464952782E-23  -1.77641634973993E-08  -1.77586484551122E-08  -1.12299975738953E-18
      9.95288898661331E-09
      0.00000000000000E+00  -2.65957560873951E-11   0.00000000000000E+00  -2.04525627787305E-12   4.08472646920276E-23
      2.65977672736012E-08   2.65957220173234E-08  -2.39501140196840E-19  -5.02030489213747E-01  -5.02030489204228E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.51892847357699E-09   0.00000000000000E+00  -9.51892847357699E-09
      1.21699157855338E-18  -1.00589200932799E-02  -4.67856138160307E-03   0.00000000000000E+00   4.61230807990914E-12
      5.13403590308611E-23  -1.70814058518264E-08  -1.70767935437464E-08  -9.77490438356543E-19
      9.97288898661331E-09
      0.00000000000000E+00  -2.65120855317991E-11   0.00000000000000E+00  -1.84223187899843E-13   2.29421452573643E-23
      2.65123090393651E-08   2.65121248161772E-08  -1.95215209061900E-19  -5.21692140721418E-01  -5.21692140711548E-01
      0.00000000000000E+00   0.00000000000000E+00  -9.87056009835434E-09   0.00000000000000E+00  -9.87056009835434E-09
      1.01958037658630E-18  -9.51433623666717E-03  -4.27110110063985E-03   0.00000000000000E+00   3.76670078333396E-12
      2.45503072250029E-23  -1.66453314186061E-08  -1.66415647178228E-08  -8.24365167524395E-19
      9.99288898661331E-09
      0.00000000000000E+00  -2.74342066933627E-11   0.00000000000000E+00   2.29906730469157E-12   1.29433017075772E-23
      2.74318866474596E-08   2.74341857147643E-08  -1.49221617444885E-19  -5.42648861859000E-01  -5.42648861848185E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.08152542128201E-08   0.00000000000000E+00  -1.08152542128201E-08
      8.03275292329894E-19  -9.30790152052467E-03  -4.07179450279235E-03   0.00000000000000E+00   2.68025059920133E-12
      9.54518746730377E-24  -1.66216117525435E-08  -1.66189315019443E-08  -6.54053674885010E-19
      9.99466673995998E-09
      0.00000000000000E+00  -2.75713308860135E-11   0.00000000000000E+00   3.79595678926544E-12   1.20523127620729E-23
      2.75674963033934E-08   2.75712922601826E-08  -1.45186125342521E-19  -5.44518348394584E-01  -5.44518348383556E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.10284004814426E-08   0.00000000000000E+00  -1.10284004814426E-08
      7.83669516465567E-19  -9.26922243238815E-03  -4.05707362143661E-03   0.00000000000000E+00   4.57814015180472E-12
      8.15872930417081E-24  -1.65474699188912E-08  -1.65428917787394E-08  -6.38483391123045E-19
      9.99706670697799E-09
      0.00000000000000E+00  -2.77450092840729E-11   0.00000000000000E+00   3.60708300642396E-12   1.09760930331495E-23
      2.77413829981590E-08   2.77449900811654E-08  -1.39681730473008E-19  -5.47074313682222E-01  -5.47074313671014E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.12080883709401E-08   0.00000000000000E+00  -1.12080883709401E-08
      7.56770474040396E-19  -9.25370367732799E-03  -4.04344126666227E-03   0.00000000000000E+00   2.68435548301433E-12
      6.53431513198909E-24  -1.65395860657087E-08  -1.65369017102257E-08  -6.17088743567388E-19
      1.00000000000000E-08
      0.00000000000000E+00  -2.79695696665453E-11   0.00000000000000E+00   3.80653292977000E-12   9.88456937759072E-24
      2.79657401766823E-08   2.79695467096121E-08  -1.32902448322925E-19  -5.50233130777799E-01  -5.50233130766427E-01
      0.00000000000000E+00   0.00000000000000E+00  -1.13726388509650E-08   0.00000000000000E+00  -1.13726388509650E-08
      7.23411191857014E-19  -9.26268399542201E-03  -4.03351478882224E-03   0.00000000000000E+00   1.53029454299057E-12
      4.90406607242128E-24  -1.65984381531899E-08  -1.65969078586469E-08  -5.90508743534089E-19
}
